/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.helpers;

import com.sap.engine.lib.xml.parser.helpers.CharArray;

public class Reference {
    public static final int RX = 1;
    public static final int RD = 2;
    public static final int RENT = 3;
    public static final int RPE = 4;
    public static final CharArray PREDEF_LT = new CharArray("lt");
    public static final CharArray PREDEF_GT = new CharArray("gt");
    public static final CharArray PREDEF_APOS = new CharArray("apos");
    public static final CharArray PREDEF_QUOT = new CharArray("quot");
    public static final CharArray PREDEF_AMP = new CharArray("amp");
    public static final CharArray caNoname = new CharArray("noname");
    int num;
    String resolvedValue;
    String resolvedName;
    private int type;
    CharArray name = null;
    boolean bCont;

    public static boolean isChar(int ch) {
        return ch == 9 || ch == 10 || ch == 13 || ch >= 32 && ch <= 55295 || ch >= 57344 && ch <= 65533 || ch >= 65536 && ch < 0x10FFFF;
    }

    public char getChar() throws Exception {
        return (char)this.getCharAsInt();
    }

    public int getCharAsInt() throws Exception {
        switch (this.type) {
            case 1: 
            case 2: {
                return this.num;
            }
            case 3: 
            case 4: {
                if (this.name.equals(PREDEF_LT)) {
                    return 60;
                }
                if (this.name.equals(PREDEF_GT)) {
                    return 62;
                }
                if (this.name.equals(PREDEF_APOS)) {
                    return 39;
                }
                if (this.name.equals(PREDEF_QUOT)) {
                    return 34;
                }
                if (this.name.equals(PREDEF_AMP)) {
                    return 38;
                }
                throw new Exception("XMLParser: Cannot get reference by char...");
            }
        }
        throw new Exception("XMLParser: Bad REference type...");
    }

    public CharArray getName() {
        return this.name;
    }

    public String resolve() {
        return this.resolvedName;
    }

    public boolean hasCont() {
        return this.bCont;
    }

    public int getType() {
        return this.type;
    }

    public String restore() {
        switch (this.type) {
            case 2: {
                return "&#" + Integer.toString(this.num, 10) + ";";
            }
            case 1: {
                return "&#x" + Integer.toString(this.num, 16) + ";";
            }
            case 3: {
                return "&" + this.name + ";";
            }
            case 4: {
                return "%" + this.name + ";";
            }
        }
        return "";
    }

    public Reference reuse(int type, CharArray value) {
        this.type = type;
        switch (type) {
            case 1: {
                this.num = Integer.parseInt(value.toString(), 16);
                this.resolvedValue = "" + (char)this.num;
                this.name = caNoname;
                break;
            }
            case 2: {
                this.num = Integer.parseInt(value.toString(), 10);
                this.resolvedValue = "" + (char)this.num;
                this.name = caNoname;
                break;
            }
            case 3: 
            case 4: {
                this.name = value.copy();
                break;
            }
        }
        return this;
    }

    public boolean isPredefined() {
        return this.name.equals(PREDEF_LT) || this.name.equals(PREDEF_GT) || this.name.equals(PREDEF_APOS) || this.name.equals(PREDEF_QUOT) || this.name.equals(PREDEF_AMP);
    }
}

