/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.helpers;

import com.sap.engine.lib.xml.Symbols;
import com.sap.engine.lib.xml.parser.pool.CharArrayPool;
import com.sap.engine.lib.xml.util.Convert;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;

public final class CharArray {
    public static final char[] EMPTYDATA = new char[0];
    public static final CharArray EMPTY = new CharArray(EMPTYDATA).setStatic();
    private CharArrayPool pool = null;
    private boolean isStatic = false;
    private char[] data = null;
    private int offset = 0;
    private int size;
    private char[] orgdata = null;
    private int ext = 10;
    private boolean hashReady = false;
    private int hash = 0;
    private int faSize;
    private int faDataLength;
    private String strRpr = null;
    private int strHash = 0;
    private boolean uniqueHash = false;

    public CharArray() {
        this.size = 0;
        this.ext = 16;
        this.data = EMPTYDATA;
        this.orgdata = EMPTYDATA;
    }

    public CharArray(char[] buf) {
        int l;
        this.size = this.ext = (l = buf.length);
        this.data = new char[l];
        this.orgdata = this.data;
        System.arraycopy(buf, 0, this.data, 0, l);
    }

    public CharArray(String str) {
        this.size = 0;
        this.ext = 16;
        if (str != null && str.length() > 0) {
            this.data = new char[str.length()];
            this.orgdata = this.data;
            this.append(str);
        } else {
            this.data = EMPTYDATA;
            this.orgdata = EMPTYDATA;
        }
    }

    public CharArray(CharArray ca) {
        this.ext = 16;
        if (ca != null) {
            this.size = ca.size;
            this.data = new char[this.size];
            this.orgdata = this.data;
            System.arraycopy(ca.data, 0, this.data, 0, this.size);
        } else {
            this.size = 0;
            this.data = EMPTYDATA;
            this.orgdata = EMPTYDATA;
        }
    }

    public CharArray(int ext) {
        this.size = 0;
        this.ext = ext;
        this.data = EMPTYDATA;
        this.orgdata = EMPTYDATA;
    }

    public CharArray(int ext, int initSize) {
        this.size = 0;
        this.ext = ext;
        this.data = new char[initSize];
        this.orgdata = this.data;
    }

    public CharArray reuse() {
        this.clear();
        return this;
    }

    public CharArray set(CharArray cr) {
        this.clear();
        return this.append(cr);
    }

    public CharArray set(String str) {
        this.clear();
        return this.append(str);
    }

    public CharArray set(StringBuffer b) {
        this.clear();
        int l = b.length();
        if (this.data.length < l) {
            this.data = new char[l + 100];
        }
        b.getChars(0, l, this.data, 0);
        this.offset = 0;
        this.size = l;
        this.hashReady = false;
        return this;
    }

    public CharArray setNullTerminated(char[] s, int p) {
        this.clear();
        int i = p;
        while (s[i] != '\u0000') {
            this.append(s[i]);
            ++i;
        }
        this.size = i - p;
        return this;
    }

    public CharArray append(CharArray cr) {
        if (cr == null) {
            return this;
        }
        this.hashReady = false;
        this.assertDataLen(cr.size);
        System.arraycopy(cr.data, cr.offset, this.data, this.size, cr.size);
        this.resizeWithLen(cr.size);
        return this;
    }

    public CharArray append(String str) {
        if (str == null) {
            return this;
        }
        this.hashReady = false;
        int l = str.length();
        this.assertDataLen(l);
        str.getChars(0, l, this.data, this.offset + this.size);
        this.resizeWithLen(l);
        return this;
    }

    public CharArray set(byte[] array, int offset, int length) {
        this.assertDataLen(length);
        int i = 0;
        int j = offset;
        while (i < length) {
            this.data[i] = (char)array[j];
            ++i;
            ++j;
        }
        this.size = length;
        return this;
    }

    public void appendInteger(int num) {
        this.hashReady = false;
        this.assertDataLen(4);
        Convert.writeIntToCharArr(this.data, this.offset + this.size, num);
        this.resizeWithLen(4);
    }

    public void startFastAppend() {
        this.faSize = this.offset + this.size;
        this.faDataLength = this.data.length;
    }

    public void fastAppend(char ch) {
        if (this.faSize == this.faDataLength) {
            this.resizeDefault();
            this.faDataLength = this.data.length;
        }
        this.data[this.faSize++] = ch;
    }

    public void endFastAppend() {
        this.size = this.faSize - this.offset;
        this.hashReady = false;
    }

    public CharArray append(char ch) {
        this.hashReady = false;
        if (this.offset + this.size == this.data.length) {
            this.resizeDefault();
        }
        this.data[this.offset + this.size++] = ch;
        return this;
    }

    public CharArray setStatic() {
        this.isStatic = true;
        return this;
    }

    public boolean getStatic() {
        return this.isStatic;
    }

    public char charAt(int index) {
        return this.data[index + this.offset];
    }

    public void setCharAt(int index, char ch) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        this.hashReady = false;
        if (index >= this.size) {
            this.resizeDefault(index + 1);
        }
        this.data[this.offset + index] = ch;
    }

    public char[] getData() {
        return this.data;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int value) {
        this.hashReady = false;
        this.size = value;
    }

    public void clear() {
        this.size = 0;
        this.offset = 0;
        this.ext = this.data.length / 10;
        this.ext = this.ext < 10 ? 10 : this.data.length;
        this.data = this.orgdata;
        this.hashReady = false;
        this.strRpr = null;
    }

    public void clear(int start, int end) {
        if (start < 0 || end < 0 || start >= this.size || end > this.size || start > end - 1) {
            throw new IllegalArgumentException("Illegal arguments start or end!");
        }
        char[] newData = new char[this.size + this.offset - (end - start)];
        System.arraycopy(this.data, 0, newData, 0, start + this.offset);
        System.arraycopy(this.data, end + this.offset, newData, start + this.offset, this.size - end);
        this.data = newData;
        this.size -= end - start;
    }

    public String getStringFast() {
        this.strRpr = new String(this.data, this.offset, this.size);
        return this.strRpr;
    }

    public String getString() {
        int newHash = this.hashCode();
        if (this.strHash != newHash || this.strRpr == null) {
            this.strHash = newHash;
            this.hash = newHash;
            this.hashReady = true;
            this.strRpr = new String(this.data, this.offset, this.size);
        }
        return this.strRpr;
    }

    public String toString() {
        return this.getString();
    }

    public char[] getChars() {
        char[] r = new char[this.size];
        System.arraycopy(this.data, this.offset, r, 0, this.size);
        return r;
    }

    public byte[] getBytes() {
        byte[] r = new byte[this.size];
        for (int i = this.offset; i < this.size; ++i) {
            r[i] = (byte)this.data[i + this.offset];
        }
        return r;
    }

    public void getChars(char[] c) {
        System.arraycopy(this.data, this.offset, c, 0, this.size);
    }

    public void getChars(char[] c, int start) {
        System.arraycopy(this.data, this.offset, c, start, this.size);
    }

    public void assertDataLen(int len) {
        if (this.data.length < len + this.size + this.offset) {
            if (this.data.length + this.ext > len + this.size + this.offset) {
                this.resizeDefault();
            } else {
                this.resizeDefault(10 + len - this.data.length + this.size - this.offset);
            }
        }
    }

    public void resizeDefault() {
        this.resizeDefault(this.ext);
        this.ext *= 2;
    }

    public void resizeDefault(int e) {
        char[] data1 = new char[this.data.length + e];
        System.arraycopy(this.data, 0, data1, 0, this.data.length);
        this.data = data1;
        this.orgdata = data1;
    }

    public void resizeWithLen(int len) {
        this.size += len;
    }

    public void bufferHash() {
        this.hashReady = false;
        this.hash = this.hashCode();
        this.hashReady = true;
    }

    public void clearHashReady() {
        this.hashReady = false;
    }

    public int hashCode() {
        int i;
        if (this.hashReady) {
            return this.hash;
        }
        this.uniqueHash = false;
        int h = 0;
        int end = this.offset + this.size;
        if (this.size < 5) {
            for (i = this.offset; i < end; ++i) {
                if (this.data[i] >= '\u00ff') {
                    this.uniqueHash = false;
                    break;
                }
                h = (h << 8) + this.data[i];
            }
            this.uniqueHash = true;
        }
        if (!this.uniqueHash) {
            for (i = this.offset; i < end; ++i) {
                h = (h << 5) - h + this.data[i];
            }
        }
        return h;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof CharArray) {
            return this.equalsCharArray((CharArray)anObject);
        }
        if (anObject instanceof String) {
            String aa = (String)anObject;
            if (this.getSize() != aa.length()) {
                return false;
            }
            int s = this.getSize();
            for (int i = 0; i < s; ++i) {
                if (this.charAt(i) == aa.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equalsCharArray(CharArray other) {
        if (this == other) {
            return true;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.size < 5) {
            this.bufferHash();
            other.bufferHash();
            if (this.hashReady && other.hashReady && this.uniqueHash && other.uniqueHash && this.hash == other.hash) {
                return true;
            }
        }
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        int n = this.size;
        char[] otherData = other.data;
        int i = this.offset;
        int j = other.offset;
        while (n-- > 0) {
            if (this.data[i++] == otherData[j++]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(char[] c, int start) {
        int end = this.offset + this.size;
        int j = start;
        int i = this.offset;
        while (i < end) {
            if (this.data[i] != c[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return c[j] == '\u0000';
    }

    public boolean equalsIgnoreCase(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof String) {
            String s = (String)anObject;
            if (this.size != s.length()) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (Character.toLowerCase(this.data[this.offset + i]) == Character.toLowerCase(s.charAt(i))) continue;
                return false;
            }
            return true;
        }
        if (anObject instanceof CharArray) {
            if (this.size != ((CharArray)anObject).size) {
                return false;
            }
            int n = this.size;
            char[] v2 = ((CharArray)anObject).data;
            int v2off = ((CharArray)anObject).offset;
            int i = 0;
            while (n-- != 0) {
                if (Character.toLowerCase(this.data[i + this.offset]) != Character.toLowerCase(v2[i + v2off])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isWhitespace() {
        int end = this.offset + this.size;
        for (int i = this.offset; i < end; ++i) {
            if (Symbols.isWhitespace(this.data[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isName() {
        if (this.size == 0 || !Symbols.isInitialNameChar(this.data[this.offset])) {
            return false;
        }
        int end = this.offset + this.size;
        for (int i = this.offset + 1; i < end; ++i) {
            if (Symbols.isNameChar(this.data[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isNmtoken() {
        if (this.size == 0) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (Symbols.isNameChar(this.data[i + this.offset])) continue;
            return false;
        }
        return true;
    }

    public boolean isNmtokens() {
        if (this.size == 0) {
            return false;
        }
        boolean atLeastOneNmtoken = false;
        for (int i = 0; i < this.size; ++i) {
            if (Symbols.isNameChar(this.data[i + this.offset])) {
                atLeastOneNmtoken = true;
                continue;
            }
            if (Symbols.isWhitespace(this.data[i + this.offset])) continue;
            return false;
        }
        return atLeastOneNmtoken;
    }

    public int indexOf(CharArray ca) {
        int l = this.size - ca.size + 1;
        for (int i = 0; i < l; ++i) {
            boolean flag = false;
            for (int j = 0; j < ca.size; ++j) {
                if (this.data[i + j + this.offset] == ca.data[j + ca.offset]) continue;
                flag = true;
            }
            if (flag) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(String ca) {
        int l = this.size - ca.length();
        block0: for (int i = 0; i < l; ++i) {
            for (int j = 0; j < ca.length(); ++j) {
                if (this.data[i + j + this.offset] != ca.charAt(j)) continue block0;
            }
            return i;
        }
        return -1;
    }

    public int indexOf(char ch) {
        int end = this.offset + this.size;
        for (int i = this.offset; i < end; ++i) {
            if (this.data[i] != ch) continue;
            return i - this.offset;
        }
        return -1;
    }

    public int lastIndexOf(char ch) {
        int end = this.offset + this.size;
        for (int i = end - 1; i >= 0; --i) {
            if (this.data[i] != ch) continue;
            return i - this.offset;
        }
        return -1;
    }

    public int indexOfColon() {
        int end = this.offset + this.size;
        for (int i = this.offset; i < end; ++i) {
            if (this.data[i] != ':') continue;
            return i - this.offset;
        }
        return -1;
    }

    public void trim() {
        this.hashReady = false;
        while (this.size > 0 && Symbols.isWhitespace(this.data[this.offset])) {
            ++this.offset;
            --this.size;
        }
        while (this.size > 0 && Symbols.isWhitespace(this.data[this.offset + this.size - 1])) {
            --this.size;
        }
        if (this.size == 0) {
            this.clear();
        }
    }

    public void trimNo13() {
        this.hashReady = false;
        while (this.size > 0 && Symbols.isWhitespaceNo13(this.data[this.offset])) {
            ++this.offset;
            --this.size;
        }
        while (this.size > 0 && Symbols.isWhitespaceNo13(this.data[this.offset + this.size - 1])) {
            --this.size;
        }
        if (this.size == 0) {
            this.clear();
        }
    }

    public boolean equalsTrimIgnoreCase(String s) {
        int last = this.offset + this.size - 1;
        while (this.offset < this.offset + this.size && Symbols.isWhitespace(this.data[this.offset])) {
            ++this.offset;
        }
        while (this.offset <= last && Symbols.isWhitespace(this.data[last])) {
            --last;
        }
        int totlen = last - this.offset;
        if (totlen != s.length()) {
            return false;
        }
        for (int i = 0; i < totlen; ++i) {
            if (Character.toLowerCase(s.charAt(i)) == Character.toLowerCase(this.data[i + this.offset])) continue;
            return false;
        }
        return true;
    }

    public static boolean areDistinct(Vector v) {
        HashSet<CharArray> h = new HashSet<CharArray>(3 * v.size());
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            CharArray ca = (CharArray)e.nextElement();
            if (h.contains(ca)) {
                return false;
            }
            h.add(ca);
        }
        return true;
    }

    public void setLength(int i) {
        this.setSize(i);
    }

    public int length() {
        return this.size;
    }

    public CharArray append(char[] newdata, int offset, int len) {
        if (newdata == null) {
            return this;
        }
        if (offset < newdata.length && len > 0) {
            this.hashReady = false;
            this.assertDataLen(len);
            try {
                System.arraycopy(newdata, offset, this.data, this.size, len);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println(offset + "   " + len + "    " + newdata.length);
                e.printStackTrace();
            }
            this.resizeWithLen(len);
        }
        return this;
    }

    public void substring(CharArray src, int b, int e) {
        this.hashReady = false;
        this.data = src.data;
        this.offset = src.offset + b;
        this.size = e - b;
    }

    public void substring(CharArray src, int b) {
        this.hashReady = false;
        this.data = src.data;
        this.offset = src.offset + b;
        this.size = src.size - b;
    }

    public void setPool(CharArrayPool pool) {
        this.pool = pool;
    }

    public void set(char[] buf) {
        this.clear();
        if (buf != null) {
            this.append(buf, 0, buf.length);
        }
    }

    public void set(char[] buf, int start, int len) {
        this.clear();
        if (buf != null) {
            this.append(buf, start, len);
        }
    }

    public void set(CharArray ch, int b, int e) {
        this.clear();
        e = e < ch.getSize() ? e : ch.getSize();
        this.append(ch.getData(), b + ch.offset, e - b);
    }

    public CharArray replace(char a, char b) {
        this.hashReady = false;
        int end = this.offset + this.size;
        for (int i = this.offset; i < end; ++i) {
            if (this.data[i] != a) continue;
            this.data[i] = b;
        }
        return this;
    }

    public CharArray replace(CharArray chars, int start, int end) {
        this.hashReady = false;
        this.clear(start, end);
        this.insert(start, chars);
        return this;
    }

    public boolean startsWith(CharArray a) {
        char[] aData = a.getData();
        int aSize = a.getSize();
        int aOffset = a.getOffset();
        if (aSize == 0 && this.size > 0) {
            return false;
        }
        if (this.size == 0 && aSize > 0) {
            return false;
        }
        if (this.size < aSize) {
            return false;
        }
        aSize = this.size < aSize ? this.size : aSize;
        int end = this.offset + aSize;
        int i = this.offset;
        int j = aOffset;
        while (i < end) {
            if (this.data[i++] == aData[j++]) continue;
            return false;
        }
        return true;
    }

    public int compareTo(String a) {
        int aLength = a.length();
        aLength = this.size < aLength ? this.size : aLength;
        int end = this.offset + aLength;
        for (int i = this.offset; i < end; ++i) {
            if (this.data[i] - a.charAt(i) == 0) continue;
            return this.data[i] - a.charAt(i);
        }
        if (this.size > aLength) {
            return this.data[end];
        }
        if (a.length() > aLength) {
            return -a.charAt(end);
        }
        return 0;
    }

    public int compareToIgnoreCase(CharArray a) {
        int aSize = a.getSize();
        char[] aData = a.getData();
        int aOffset = a.getOffset();
        int minLen = this.size < aSize ? this.size : aSize;
        int end = this.offset + minLen;
        int i = this.offset;
        int j = aOffset;
        while (i < end) {
            if (Character.toLowerCase(this.data[i]) != Character.toLowerCase(aData[j])) {
                return Character.toLowerCase(this.data[i]) - Character.toLowerCase(aData[j]);
            }
            ++i;
            ++j;
        }
        if (this.size > minLen) {
            return this.data[this.offset + minLen];
        }
        if (aSize > minLen) {
            return -aData[aOffset + minLen];
        }
        return 0;
    }

    public int compareTo(CharArray a) {
        int aSize = a.size;
        char[] aData = a.data;
        int aOffset = a.offset;
        int minLen = this.size < aSize ? this.size : aSize;
        for (int i = 0; i < minLen; ++i) {
            int r = this.data[this.offset + i] - aData[aOffset + i];
            if (r == 0) continue;
            return r;
        }
        if (this.size > minLen) {
            return this.data[this.offset + minLen];
        }
        if (aSize > minLen) {
            return -aData[aOffset + minLen];
        }
        return 0;
    }

    public CharArray toUpperCase(CharArray buf) {
        buf.clear();
        buf.assertDataLen(this.size);
        char[] d = buf.getData();
        int end = this.offset + this.size;
        for (int i = this.offset; i < end; ++i) {
            d[i] = Character.toUpperCase(this.data[i]);
        }
        buf.size = this.size;
        return buf;
    }

    public CharArray toUpperCase() {
        int end = this.offset + this.size;
        for (int i = this.offset; i < end; ++i) {
            this.data[i] = Character.toUpperCase(this.data[i]);
        }
        return this;
    }

    public CharArray toLowerCase() {
        int end = this.offset + this.size;
        for (int i = this.offset; i < end; ++i) {
            this.data[i] = Character.toLowerCase(this.data[i]);
        }
        return this;
    }

    public CharArray copy() {
        return (this.pool == null ? new CharArray(this.ext, this.size) : this.pool.getObject()).set(this);
    }

    public CharArray normalizeSpace() {
        this.hashReady = false;
        while (this.size > 0 && Symbols.isWhitespace(this.data[this.offset])) {
            ++this.offset;
            --this.size;
        }
        if (this.size == 0) {
            return this;
        }
        int j = this.offset;
        boolean flag = true;
        int end = this.offset + this.size;
        for (int i = this.offset; i < end; ++i) {
            if (Symbols.isWhitespace(this.data[i])) {
                if (flag) continue;
                flag = true;
                this.data[j++] = 32;
                continue;
            }
            this.data[j++] = this.data[i];
            flag = false;
        }
        if (this.data[j - 1] == ' ') {
            --j;
        }
        this.size = j - this.offset;
        return this;
    }

    public void parseNS(CharArray prefix, CharArray localName) {
        int p = this.indexOfColon();
        if (p != -1) {
            prefix.substring(this, 0, p);
            localName.substring(this, p + 1, this.size);
        } else {
            prefix.clear();
            localName.substring(this, 0, this.size);
        }
    }

    public void insert(int p, CharArray x) {
        if (p < 0 || p > this.size || x == null) {
            throw new IllegalArgumentException();
        }
        this.assertDataLen(this.size + x.size);
        System.arraycopy(this.data, this.offset + p, this.data, this.offset + x.size + p, this.size - p);
        System.arraycopy(x.data, x.offset, this.data, this.offset + p, x.size);
        this.size += x.size;
    }

    public void insert(int p, String x) {
        if (p < 0 || p > this.size || x == null) {
            throw new IllegalArgumentException();
        }
        this.assertDataLen(this.size + x.length());
        System.arraycopy(this.data, this.offset + p, this.data, this.offset + x.length() + p, this.size - p);
        x.getChars(0, x.length(), this.data, this.offset + p);
        this.size += x.length();
    }

    public void appendEscaped(char[] caData, int caOffset, int caLength) {
        int caEnd = caOffset + caLength;
        block7: for (int i = caOffset; i < caEnd; ++i) {
            char ch = caData[i];
            if (ch > '\u0100' || ch < ' ' && ch != '\r' && ch != '\t' && ch != '\n') {
                this.append("&#x");
                this.append(Integer.toHexString(ch));
                this.append(';');
                continue;
            }
            switch (ch) {
                case '\'': {
                    this.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    this.append("&quot;");
                    continue block7;
                }
                case '&': {
                    this.append("&amp;");
                    continue block7;
                }
                case '<': {
                    this.append("&lt;");
                    continue block7;
                }
                case '>': {
                    this.append("&gt;");
                    continue block7;
                }
                default: {
                    this.append(ch);
                }
            }
        }
    }

    public void appendEscapedNo13(char[] caData, int caOffset, int caLength) {
        int caEnd = caOffset + caLength;
        block7: for (int i = caOffset; i < caEnd; ++i) {
            char ch = caData[i];
            if (ch > '\u0100' || ch < ' ' && ch != '\t' && ch != '\n') {
                this.append("&#x");
                this.append(Integer.toHexString(ch));
                this.append(';');
                continue;
            }
            switch (ch) {
                case '\'': {
                    this.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    this.append("&quot;");
                    continue block7;
                }
                case '&': {
                    this.append("&amp;");
                    continue block7;
                }
                case '<': {
                    this.append("&lt;");
                    continue block7;
                }
                case '>': {
                    this.append("&gt;");
                    continue block7;
                }
                default: {
                    this.append(ch);
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        CharArray chars = new CharArray("asdfghjkl");
        chars.replace(new CharArray("&&&"), 0, 8);
        System.out.println(chars.toString());
    }
}

