/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.helpers;

import com.sap.engine.lib.xml.parser.ParserEOFException;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.handlers.EncodingHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Entity;
import com.sap.engine.lib.xml.parser.helpers.IXMLStream;
import com.sap.engine.lib.xml.parser.readers.EncodedDataReader;
import com.sap.engine.lib.xml.util.CharArrayInputStream;
import com.sap.engine.lib.xml.util.ReaderInputStream;
import com.sap.engine.lib.xsl.xpath.IntVector;
import com.sap.engine.lib.xsl.xslt.pool.ObjectPool;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Random;
import java.util.Vector;
import org.xml.sax.InputSource;

public final class AdvancedXMLStreamReader
implements IXMLStream {
    public static final int BOM_NOBM_UTF8 = 1;
    public static final int BOM_NOBM_UTF16LE = 2;
    public static final int BOM_BM_UTF8 = 3;
    public static final int BOM_BM_UTF16LE = 4;
    public static final int BOM_BM_UCS4LE = 5;
    public static final int BOM_EBCDIC = 6;
    public static final int BOM_BM_UTF16BE = 7;
    public static final int BOM_NOBM_UTF16BE = 8;
    public static final int BOM_UNKNOWN = -1;
    public static final int BOM_NOBOM = 0;
    private Vector sourceStack = new Vector();
    private int sourcePtr = -1;
    private int _pk_b;
    private boolean sourceChanged = false;
    private ObjectPool encodedDataReaderPool = new ObjectPool(class$com$sap$engine$lib$xml$parser$readers$EncodedDataReader == null ? (class$com$sap$engine$lib$xml$parser$readers$EncodedDataReader = AdvancedXMLStreamReader.class$("com.sap.engine.lib.xml.parser.readers.EncodedDataReader")) : class$com$sap$engine$lib$xml$parser$readers$EncodedDataReader, 15, 10);
    private int _cs_ptr = -20;
    private EncodedDataReader _cs_src = null;
    public XMLParser xmlParser = null;
    private int currentSID = 0;
    private IntVector finishedSid = new IntVector();
    private boolean insertSpaces = false;
    private boolean insertTrailingSpace = false;
    private boolean insertLeadingSpace = false;
    private boolean utf16beDetected = false;
    private int lowSurrogate = -1;
    private Random rand = new Random();
    static /* synthetic */ Class class$com$sap$engine$lib$xml$parser$readers$EncodedDataReader;

    public AdvancedXMLStreamReader(XMLParser xmlParser) {
        this.xmlParser = xmlParser;
    }

    public AdvancedXMLStreamReader reuse(XMLParser xmlParser) {
        this.xmlParser = xmlParser;
        this.sourceStack.clear();
        this.sourcePtr = -1;
        this.sourceChanged = false;
        this._cs_ptr = -20;
        this._cs_src = null;
        this.currentSID = 0;
        this.finishedSid.clear();
        this.insertSpaces = false;
        this.insertTrailingSpace = false;
        this.insertLeadingSpace = false;
        return this;
    }

    private EncodedDataReader getCurrentSource() {
        if (this.sourcePtr == this._cs_ptr) {
            return this._cs_src;
        }
        this._cs_src = (EncodedDataReader)this.sourceStack.get(this.sourcePtr);
        this._cs_ptr = this.sourcePtr;
        return this._cs_src;
    }

    public boolean getLiteral() {
        return (this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource()).getLiteral();
    }

    public void setLiteral(boolean value) {
        (this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource()).setLiteral(true);
    }

    public int getRow() {
        return (this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource()).getRow();
    }

    public int getCol() {
        return (this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource()).getCol();
    }

    public char getLastChar() {
        return (char)this._pk_b;
    }

    public void setLastChar(int value) {
        this._pk_b = value;
    }

    public int loadLastChar() throws Exception {
        return this.read();
    }

    private void reset(char[] oldChars, int length) {
        (this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource()).reset(oldChars, length);
    }

    public char read() throws Exception {
        if (this.lowSurrogate != -1) {
            char c = (char)this.lowSurrogate;
            this.lowSurrogate = -1;
            return c;
        }
        do {
            if (this.sourceChanged) {
                this.sourceChanged = false;
                this._pk_b = (this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource()).getLastChar();
                continue;
            }
            this._pk_b = (this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource()).read();
        } while (this.sourceChanged);
        if (this._pk_b >= 65536 && this._pk_b <= 0x10FFFF) {
            this.lowSurrogate = (this._pk_b - 65536) % 1024 + 56320;
            this._pk_b = (char)((this._pk_b - 65536) / 1024 + 55296);
        }
        return (char)this._pk_b;
    }

    public boolean scanByte(char b) throws Exception {
        if (this.getLastChar() == b) {
            this.loadLastChar();
            return true;
        }
        return false;
    }

    public boolean scanChars(char[] b) throws Exception {
        int l = b.length;
        for (int i = 0; i < l; ++i) {
            if (b[i] != (char)this._pk_b) {
                return false;
            }
            this.read();
        }
        return true;
    }

    public boolean scanString(String b) throws Exception {
        int l = b.length();
        for (int i = 0; i < l; ++i) {
            if (b.charAt(i) != this._pk_b) {
                return false;
            }
            this.read();
        }
        return true;
    }

    private void addSource(EncodedDataReader src) throws ParserException {
        for (int i = 0; i < this.sourceStack.size(); ++i) {
            if (!((EncodedDataReader)this.sourceStack.get(i)).getID().equals(src.getID())) continue;
            throw new ParserException("XMLError: You cannot read the same entity 2 times (recursion!!!)", this.getID(), this.getRow(), this.getCol());
        }
        if (this.sourcePtr > -1) {
            this.getCurrentSource().setLastChar(this.getLastChar());
            src.setLiteral((this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource()).getLiteral());
        }
        src.setSID(this.currentSID++);
        this.sourceStack.add(src);
        ++this.sourcePtr;
    }

    public void addInputFromFile(CharArray fname, CharArray id) throws FileNotFoundException, Exception {
        InputStream in = null;
        try {
            URL url = new URL(fname.toString());
            in = url.openStream();
        }
        catch (Exception e) {
            in = new FileInputStream(fname.toString());
        }
        this.addInputFromInputStream(in, id);
    }

    public void addInputFromCharArray(CharArray src, CharArray id) throws Exception {
        CharArrayInputStream cain = new CharArrayInputStream(src);
        this.addInputFromInputStream(cain, id);
    }

    public void addInputSource(InputSource src) throws Exception {
        String systemId = src.getSystemId();
        if (systemId == null) {
            systemId = Integer.toString(this.rand.nextInt());
        }
        this.addInputSource(src, new CharArray(systemId));
    }

    public void addInputSource(InputSource src, CharArray id) throws Exception {
        if (src.getCharacterStream() != null) {
            this.addInputFromReader(src.getCharacterStream(), id);
        } else if (src.getByteStream() != null) {
            this.addInputFromInputStream(src.getByteStream(), id);
        } else if (src.getSystemId() != null) {
            this.addInputFromFile(new CharArray(src.getSystemId()), id);
        }
    }

    public void addInputFromInputStream(InputStream is, CharArray id) throws Exception {
        this.addSource(((EncodedDataReader)this.encodedDataReaderPool.getObject()).reuse(this, is, id));
        this.setReadRaw(true);
        this.read();
        int bom = this.checkBOM();
        switch (bom) {
            case 0: 
            case 1: 
            case 3: {
                this.setEncoding(EncodingHandler.UTF8);
                break;
            }
            case 2: 
            case 4: {
                this.setEncoding(EncodingHandler.UTF16);
                break;
            }
            case 7: 
            case 8: {
                this.utf16beDetected = true;
                this.setEncoding(EncodingHandler.UTF16BE);
                break;
            }
            case 6: {
                this.setEncoding(EncodingHandler.CP1047);
                this.setLastChar(60);
                break;
            }
            default: {
                throw new ParserException("Unknown Byte-Order-Mark. XML MUST begin either with WhiteSpace or with '<?xml', and not: '" + this.getLastChar() + this.read() + this.read() + "'", this.getID(), 1, 1);
            }
        }
        this.setReadRaw(false);
        if (bom != 0 && bom != 6) {
            this.read();
        }
    }

    public void addInputFromEntity(Entity ent) throws Exception {
        if (ent.isInternal()) {
            this.addInputFromCharArray(ent.getValue(), ent.getName());
        } else if (this.xmlParser != null) {
            if (!this.xmlParser.getExternalGeneralEntities()) {
                this.xmlParser.docHandler.onCustomEvent(1003, ent.getName());
            } else {
                InputSource isource = null;
                if (this.xmlParser.getEntityResolver() != null) {
                    URL url = this.xmlParser.urlLoader.loadAndPush(ent.getSys().toString());
                    isource = this.xmlParser.getEntityResolver().resolveEntity(ent.getPub().toString(), ent.getSys().toString());
                    if (isource == null) {
                        InputStream urlStream = null;
                        try {
                            urlStream = url.openStream();
                        }
                        catch (IOException ioe) {
                            String systemId = url.toString();
                            if (systemId.startsWith("http://localhost/")) {
                                String resourceName;
                                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                                urlStream = loader.getResourceAsStream(resourceName = systemId.substring(17));
                                if (urlStream == null) {
                                    throw new IOException("Failed to load resource from the context classloader of the current thread! Loading from classloader was caused by: " + ioe.toString());
                                }
                            }
                            throw ioe;
                        }
                        isource = new InputSource(urlStream);
                        isource.setSystemId(url.toString());
                    }
                } else {
                    URL external = this.xmlParser.urlLoader.loadAndPush(ent.getSys().toString());
                    isource = this.xmlParser.urlLoader.resolveEntity(ent.getPub().toString(), ent.getSys().toString());
                }
                this.addInputSource(isource, ent.getSys());
            }
        } else {
            this.addInputFromFile(ent.getSys(), ent.getName());
        }
        this.getCurrentSource().setName(ent.getName());
    }

    public void addInputFromReader(Reader reader, CharArray id) throws Exception {
        this.addInputFromInputStream(new ReaderInputStream(reader), id);
    }

    public void onEncodedDataReaderEOF() throws Exception {
        EncodedDataReader finishingEncodedDataReader;
        EncodedDataReader encodedDataReader = finishingEncodedDataReader = this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource();
        if (this.xmlParser != null) {
            this.xmlParser.onEncodedDataReaderEOF(finishingEncodedDataReader);
        }
        this.finishedSid.add(finishingEncodedDataReader.getSID());
        if (this.sourcePtr == 0) {
            this.encodedDataReaderPool.releaseObject(finishingEncodedDataReader);
            if (this.xmlParser != null) {
                this.xmlParser.onDocumentEOF();
            }
        } else {
            do {
                InputStream streamToClose;
                if ((streamToClose = finishingEncodedDataReader.getInputStream()) != null && this.xmlParser != null && this.xmlParser.getCloseStreams()) {
                    streamToClose.close();
                }
                this.encodedDataReaderPool.releaseObject(this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource());
                this.sourceStack.removeElementAt(this.sourcePtr);
                --this.sourcePtr;
                this.sourceChanged = true;
            } while (this.sourcePtr >= 0 && (this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource()).isFinished());
            if (this.sourcePtr < 0) {
                throw new ParserEOFException("End of EncodedDataReader: " + (this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource()).getID() + " reached.");
            }
        }
    }

    public int getPtr() {
        return this.sourcePtr;
    }

    public boolean isFinished(int sid) {
        return this.finishedSid.contains(sid);
    }

    public void clearFinished(int sid) {
        this.finishedSid.removeElement(sid);
    }

    public int getSourceID() {
        return this.getCurrentSource().getSID();
    }

    public void insertSpaces() {
        this.insertLeadingSpace = true;
        this.insertTrailingSpace = false;
        this.insertSpaces = true;
    }

    public void setEncoding(CharArray enc) throws ParserException {
        if (this.utf16beDetected && enc.toLowerCase().equals("utf-16")) {
            this.getCurrentSource().setEncoding(new CharArray("utf-16be"));
        } else {
            this.getCurrentSource().setEncoding(enc);
        }
    }

    public void setReadRaw(boolean value) {
        this.getCurrentSource().setReadRaw(value);
    }

    protected int checkBOM() throws Exception {
        char b = this.getLastChar();
        if (b == '<') {
            char[] oldChars = new char[4];
            int length = 0;
            oldChars[length++] = b;
            b = this.read();
            oldChars[length++] = b;
            if (b == '\u0000') {
                b = this.read();
                oldChars[length++] = b;
                if (b == '?') {
                    b = this.read();
                    oldChars[length++] = b;
                    if (b == '\u0000') {
                        this.reset(oldChars, length);
                        return 2;
                    }
                }
            }
            this.reset(oldChars, length);
            this.read();
            return 0;
        }
        if (b == '\u00ef') {
            b = this.read();
            if (b == '\u00bb' && (b = this.read()) == '\u00bf') {
                return 3;
            }
        } else if (b == '\u00ff') {
            b = this.read();
            if (b == '\u00fe') {
                return 4;
            }
        } else if (b == '\u00fe') {
            b = this.read();
            if (b == '\u00ff') {
                return 7;
            }
        } else {
            if (b == '\u0000') {
                char[] oldChars = new char[4];
                int length = 0;
                oldChars[length++] = b;
                b = this.read();
                oldChars[length++] = b;
                if (b == '<') {
                    b = this.read();
                    oldChars[length++] = b;
                    if (b == '\u0000') {
                        b = this.read();
                        oldChars[length++] = b;
                        if (b == '?') {
                            this.reset(oldChars, length);
                            return 8;
                        }
                    }
                }
                this.reset(oldChars, length);
                this.read();
                return 0;
            }
            if (b == 'L') {
                return 6;
            }
            return 0;
        }
        return -1;
    }

    public CharArray getID() {
        return this.getCurrentSource().getID();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

