/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.handlers;

import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.handlers.CompactHandler;
import com.sap.engine.lib.xml.parser.handlers.SimpleAttr;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Entity;
import com.sap.engine.lib.xml.parser.helpers.Reference;
import com.sap.engine.lib.xml.util.NamespaceContainer;

public class NormalizeDocHandler
implements DocHandler {
    private CompactHandler handler = null;
    private NamespaceContainer uriContainer = new NamespaceContainer();
    private int attributeCount = 0;
    private int bufferIncrease = 8;
    private SimpleAttr[] attributeBuffer = new SimpleAttr[this.attributeCount + this.bufferIncrease];
    private CharArray uri = null;
    private CharArray localName = new CharArray(20);
    private CharArray charBuffer = new CharArray(20);
    private boolean clearCharBuffer = true;

    private void clearAttributeBuffer(CharArray uri, CharArray localName) {
        this.attributeCount = 0;
        this.localName.set(localName);
        this.uri = uri;
    }

    private void addAttribute(String uri, CharArray localName, CharArray value) {
        int length = this.attributeBuffer.length;
        if (this.attributeCount + 1 > length) {
            SimpleAttr[] perm = new SimpleAttr[length + this.bufferIncrease];
            System.arraycopy(this.attributeBuffer, 0, perm, 0, length);
            this.attributeBuffer = perm;
            perm = null;
        }
        if (this.attributeBuffer[this.attributeCount] == null) {
            this.attributeBuffer[this.attributeCount] = new SimpleAttr();
        }
        this.attributeBuffer[this.attributeCount].uri = uri;
        this.attributeBuffer[this.attributeCount].localName = localName.toString();
        this.attributeBuffer[this.attributeCount].value = value.toString();
        ++this.attributeCount;
    }

    public void setCompactHandler(CompactHandler handler) {
        this.handler = handler;
        handler.setOwner(this);
    }

    public CompactHandler getCompactHandler() {
        return this.handler;
    }

    public void onXMLDecl(String version, String encoding, String ssdecl) throws Exception {
    }

    public void startElementStart(CharArray uri, CharArray localName, CharArray qname) throws Exception {
        if (!this.clearCharBuffer && this.handler != null) {
            this.handler.charData(this.charBuffer);
            this.clearCharBuffer = true;
        }
        this.clearAttributeBuffer(uri.copy(), localName);
    }

    public void addAttribute(CharArray uri, CharArray prefix, CharArray localName, CharArray qname, String type, CharArray value) throws Exception {
        this.addAttribute(uri.toString(), localName, value);
    }

    public void startElementEnd(boolean isEmpty) throws Exception {
        if (this.handler != null) {
            this.handler.startElement(this.uri, this.localName, this.attributeBuffer, this.attributeCount);
        }
    }

    public void endElement(CharArray uri, CharArray localName, CharArray qname, boolean isEmpty) throws Exception {
        if (!this.clearCharBuffer && this.handler != null) {
            this.handler.charData(this.charBuffer);
            this.clearCharBuffer = true;
        }
        if (this.handler != null) {
            this.handler.endElement(uri, localName);
        }
    }

    public void startDocument() throws Exception {
        if (this.handler != null) {
            this.handler.startDocument();
        }
    }

    public void endDocument() throws Exception {
        if (this.handler != null) {
            this.handler.endDocument();
        }
    }

    public void charData(CharArray carr, boolean bDisableOutputEscaping) throws Exception {
        if (this.clearCharBuffer) {
            this.clearCharBuffer = false;
            this.charBuffer.set(carr);
            return;
        }
        this.charBuffer.append(carr);
    }

    public void onPI(CharArray target, CharArray data) throws Exception {
    }

    public void onComment(CharArray text) throws Exception {
    }

    public void onCDSect(CharArray text) throws Exception {
        if (this.clearCharBuffer) {
            this.clearCharBuffer = false;
            this.charBuffer.set(text);
            return;
        }
        this.charBuffer.append(text);
    }

    public void onDTDElement(CharArray name, CharArray model) throws Exception {
    }

    public void onDTDAttListStart(CharArray name) throws Exception {
    }

    public void onDTDAttListItem(CharArray name, CharArray attname, String type, String defDecl, CharArray vAttValue, String note) throws Exception {
    }

    public void onDTDAttListEnd() throws Exception {
    }

    public void onDTDEntity(Entity entity) throws Exception {
    }

    public void onDTDNotation(CharArray name, CharArray pub, CharArray sys) throws Exception {
    }

    public void startDTD(CharArray name, CharArray pub, CharArray sys) throws Exception {
    }

    public void endDTD() throws Exception {
    }

    public void onContentReference(Reference ref) throws Exception {
    }

    public void startPrefixMapping(CharArray prefix, CharArray uri) throws Exception {
        if (prefix == null) {
            prefix = CharArray.EMPTY;
        }
        this.uriContainer.mapPrefix(prefix.toString(), uri.toString());
    }

    public void endPrefixMapping(CharArray prefix) throws Exception {
        if (prefix == null) {
            prefix = CharArray.EMPTY;
        }
        this.uriContainer.demapPrefix(prefix.toString());
    }

    public String getPrefixURI(CharArray prefix) {
        if (prefix == null) {
            prefix = CharArray.EMPTY;
        }
        return this.uriContainer.getPrefixURI(prefix.toString());
    }

    public NamespaceContainer getNamespaceContainer() {
        return this.uriContainer;
    }

    public void onWarning(String s) {
    }

    public void onStartContentEntity(CharArray name, boolean isExpanding) throws Exception {
    }

    public void onEndContentEntity(CharArray name) throws Exception {
    }

    public void onCustomEvent(int eventId, Object obj) throws Exception {
    }
}

