/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.handlers;

import com.sap.engine.lib.xml.parser.handlers.EmptyDocHandler;
import com.sap.engine.lib.xml.parser.helpers.Attribute;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class CannonicalDocHandler
extends EmptyDocHandler {
    public RandomAccessFile out = null;

    public CannonicalDocHandler(String filename) throws FileNotFoundException {
        File fp = new File(filename);
        fp.delete();
        this.out = new RandomAccessFile(filename, "rw");
    }

    public String makeDataChar(String str) {
        String ret = "";
        block9: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '&': {
                    ret = ret + "&amp;";
                    continue block9;
                }
                case '<': {
                    ret = ret + "&lt;";
                    continue block9;
                }
                case '>': {
                    ret = ret + "&gt;";
                    continue block9;
                }
                case '\"': {
                    ret = ret + "&quot;";
                    continue block9;
                }
                case '\t': {
                    ret = ret + "&#9;";
                    continue block9;
                }
                case '\n': {
                    ret = ret + "&#10;";
                    continue block9;
                }
                case '\r': {
                    ret = ret + "&#13;";
                    continue block9;
                }
                default: {
                    ret = ret + ch;
                }
            }
        }
        return ret;
    }

    public void callEmptyElementTag(CharArray sName, Vector attList) throws Exception {
        this.startElement(sName, attList);
        this.endElement(sName);
    }

    public void startElement(CharArray sName, Vector attList) throws Exception {
        this.out.writeBytes("<" + sName);
        for (int i = 0; i < attList.size(); ++i) {
            Attribute at = (Attribute)attList.get(i);
            this.out.writeBytes(" " + at.getQNameStr() + "=\"" + this.makeDataChar(at.getValueStr()) + "\"");
        }
        this.out.writeBytes(">");
    }

    public void endElement(CharArray sName) throws Exception {
        this.out.writeBytes("</" + sName + ">");
    }

    public void endDocument() throws Exception {
        this.out.close();
    }

    public void charData(CharArray data) throws Exception {
        this.out.writeBytes(this.makeDataChar(data.toString()));
    }

    public void onPI(CharArray target, CharArray data) throws Exception {
        this.out.writeBytes("<?" + target + " " + data + "?>");
    }

    public void onCDSect(CharArray text) throws Exception {
        this.charData(text);
    }
}

