/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser;

import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.validator.Validator;
import com.sap.engine.lib.xml.parser.ActiveXMLParser;
import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.NestedSAXParseException;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.dtd.ValidationException;
import com.sap.engine.lib.xml.parser.handlers.SAXDocHandler;
import com.sap.engine.lib.xml.util.NestedIOException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.LocatorImpl;

public class SAXParser
implements XMLReader,
Parser {
    private ContentHandler contentHandler = null;
    private DocumentHandler documentHandler = null;
    private ErrorHandler errorHandler = null;
    private DTDHandler dtdHandler = null;
    private DeclHandler declHandler = null;
    private LexicalHandler lexicalHandler = null;
    private Locale locale = null;
    private boolean forceSchema = false;
    private Validator schemaValidator = null;
    private boolean apacheUseSchema = false;
    private boolean apacheValidationDynamic = false;
    private String noNamespaceSchemaLocation = null;
    private String[] schemaLocations = new String[0];
    private String[] schemaNamespaces = new String[0];
    private Schema schema;
    private SAXDocHandler saxHandler = null;
    private XMLParser xmlParser = null;

    public SAXParser() throws ParserException {
        this.xmlParser = new XMLParser();
    }

    public SAXParser(XMLParser p) {
        this.xmlParser = p;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.xmlParser.getFeature(name);
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://apache.org/xml/features/validation/schema")) {
            this.apacheUseSchema = value;
            return;
        }
        if (name.equals("http://apache.org/xml/features/validation/dynamic")) {
            this.apacheValidationDynamic = value;
        }
        this.xmlParser.setFeature(name, value);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/declaration-handler")) {
            return this.declHandler;
        }
        if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            return this.lexicalHandler;
        }
        if (name.equals("http://xml.org/sax/properties/xml-string")) {
            throw new SAXNotSupportedException("");
        }
        throw new SAXNotRecognizedException("");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/declaration-handler")) {
            this.declHandler = (DeclHandler)value;
            return;
        }
        if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            this.lexicalHandler = (LexicalHandler)value;
            return;
        }
        if (name.equals("http://xml.org/sax/properties/xml-string")) {
            throw new SAXNotSupportedException("");
        }
        if (name.equals("http://inqmy.org/sax/properties/proxy-host")) {
            this.xmlParser.setProxyURL((String)value);
            return;
        }
        if (name.equals("http://inqmy.org/sax/properties/proxy-port")) {
            this.xmlParser.setProxyPort((Integer)value);
            return;
        }
        if (name.equals("http://inqmy.org/sax/properties/alternative-dtd")) {
            this.xmlParser.setAlternativeDTD((String)value);
            return;
        }
        if (name.equals("http://apache.org/xml/properties/schema/external-schemaLocation")) {
            this.schema = null;
            if (this.fillExternalSchemaLocations(value.toString())) {
                this.forceSchema = true;
                return;
            }
            this.schemaNamespaces = new String[0];
            this.schemaLocations = new String[0];
            throw new IllegalArgumentException("Incorrect proerty value - number of tokens not even!");
        }
        if (name.equals("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation")) {
            this.schema = null;
            this.forceSchema = true;
            this.noNamespaceSchemaLocation = value.toString();
            return;
        }
        if (name.equals("http://apache.org/xml/properties/schema/schemaObject")) {
            this.schema = (Schema)value;
            return;
        }
        if (name.equals("http://sap.com/xml/max-references")) {
            this.xmlParser.setMaximumProcessingReferences(value);
            return;
        }
        if (value == null) {
            this.xmlParser.setProperty(name, null);
            return;
        }
        this.xmlParser.setProperty(name, value.toString());
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public DeclHandler getDeclHandler() {
        return this.declHandler;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.xmlParser.setEntityResolver(resolver);
    }

    public EntityResolver getEntityResolver() {
        return this.xmlParser.getEntityResolver();
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
        if (this.saxHandler != null) {
            this.saxHandler.setDTDHandler(this.dtdHandler);
        }
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
        if (this.saxHandler != null) {
            this.saxHandler.setContentHandler(handler);
        }
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.documentHandler = handler;
        if (this.saxHandler != null) {
            this.saxHandler.setDocumentHandler(handler);
        }
    }

    public DocumentHandler getDocumentHandler() {
        return this.documentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        String sysId = input.getSystemId();
        String pubId = input.getPublicId();
        this.xmlParser.setSystemId(sysId);
        this.xmlParser.setPublicId(pubId);
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(this.xmlParser);
        }
        if (this.documentHandler != null) {
            this.documentHandler.setDocumentLocator(this.xmlParser);
        }
        try {
            this.saxHandler = new SAXDocHandler();
            this.saxHandler.setLexicalHandler(this.lexicalHandler);
            this.saxHandler.setDocumentHandler(this.documentHandler);
            this.saxHandler.setDeclHandler(this.declHandler);
            this.saxHandler.setContentHandler(this.contentHandler);
            this.saxHandler.setDTDHandler(this.dtdHandler);
            this.saxHandler.setErrorHandler(this.errorHandler);
            if (!this.forceSchema && this.apacheUseSchema) {
                input = this.scanXMLForSchemaReference(input, this.xmlParser);
            }
            if (this.getFeature("http://xml.org/sax/features/validation")) {
                if (!this.apacheUseSchema || this.apacheValidationDynamic && !this.forceSchema) {
                    this.xmlParser.parse(input, (DocHandler)this.saxHandler);
                } else {
                    this.setFeature("http://xml.org/sax/features/validation", false);
                    this.schemaValidator = new Validator();
                    this.schemaValidator.setParser(this.xmlParser);
                    this.schemaValidator.setDocHandler(this.saxHandler);
                    this.schemaValidator.setExternalSchemas(this.schemaNamespaces, this.schemaLocations);
                    this.schemaValidator.setExternalNoNamespaceSchema(this.noNamespaceSchemaLocation);
                    this.schemaValidator.setSchema(this.schema);
                    boolean result = this.schemaValidator.validate(input);
                    if (!result) {
                        throw new ParserException(this.schemaValidator.getErrors()[0], -1, -1);
                    }
                }
            } else if (this.apacheUseSchema && (this.forceSchema || !this.apacheValidationDynamic)) {
                this.setFeature("http://xml.org/sax/features/validation", false);
                this.schemaValidator = new Validator();
                this.schemaValidator.setParser(this.xmlParser);
                this.schemaValidator.setDocHandler(this.saxHandler);
                this.schemaValidator.setExternalSchemas(this.schemaNamespaces, this.schemaLocations);
                this.schemaValidator.setExternalNoNamespaceSchema(this.noNamespaceSchemaLocation);
                this.schemaValidator.setSchema(this.schema);
                boolean result = this.schemaValidator.validate(input);
                if (!result) {
                    throw new ParserException(this.schemaValidator.getErrors()[0], -1, -1);
                }
            } else {
                this.xmlParser.parse(input, (DocHandler)this.saxHandler);
            }
        }
        catch (ParserException e) {
            LocatorImpl loc = new LocatorImpl();
            loc.setPublicId(input.getPublicId());
            loc.setSystemId(e.getSourceID());
            loc.setLineNumber(e.getRow());
            loc.setColumnNumber(e.getCol());
            if (this.contentHandler != null) {
                this.contentHandler.setDocumentLocator(loc);
            }
            if (this.documentHandler != null) {
                this.documentHandler.setDocumentLocator(loc);
            }
            if (this.errorHandler != null) {
                if (e instanceof ValidationException) {
                    this.errorHandler.error(new NestedSAXParseException("Validation Error: " + e, loc, e));
                }
                this.errorHandler.fatalError(new NestedSAXParseException("Fatal Error: " + e, loc, e));
                throw new NestedSAXParseException(e.toString(), loc, e);
            }
            throw new NestedSAXParseException(e.getMessage(), loc, e);
        }
        catch (SAXException e) {
            if (this.errorHandler != null) {
                this.errorHandler.fatalError(new NestedSAXParseException("Fatal Error: " + e, this.xmlParser, e));
            }
            throw e;
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.fatalError(new NestedSAXParseException("Fatal Error: " + e, this.xmlParser, e));
            }
            throw e;
        }
        catch (Exception e) {
            if (this.errorHandler != null) {
                this.errorHandler.fatalError(new NestedSAXParseException("Fatal Error: " + e, this.xmlParser, e));
            }
            throw new NestedSAXParseException("Generic Exception: ", e);
        }
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private boolean fillExternalSchemaLocations(String locator) throws IllegalArgumentException {
        StringTokenizer tok = new StringTokenizer(locator);
        boolean even = true;
        while (tok.hasMoreTokens()) {
            String[] temp;
            String t = tok.nextToken();
            if (even) {
                temp = new String[this.schemaNamespaces.length + 1];
                System.arraycopy(this.schemaNamespaces, 0, temp, 0, this.schemaNamespaces.length);
                temp[temp.length - 1] = t;
                this.schemaNamespaces = temp;
                even = false;
                continue;
            }
            temp = new String[this.schemaLocations.length + 1];
            System.arraycopy(this.schemaLocations, 0, temp, 0, this.schemaLocations.length);
            temp[temp.length - 1] = t;
            this.schemaLocations = temp;
            even = true;
        }
        return even;
    }

    private InputSource scanXMLForSchemaReference(InputSource is, XMLParser parser) throws ParserException, IOException, SAXNotRecognizedException, SAXNotSupportedException {
        int markAllowance = 10000;
        Reader r = is.getCharacterStream();
        InputStream inputStream = is.getByteStream();
        ActiveXMLParser aparser = null;
        BufferedReader reader = null;
        BufferedInputStream inStr = null;
        if (r != null) {
            reader = new BufferedReader(r);
            aparser = new ActiveXMLParser(reader);
        }
        if (inputStream != null) {
            inStr = new BufferedInputStream(inputStream);
            aparser = new ActiveXMLParser(inStr);
        }
        if (reader != null || inStr != null) {
            boolean validation = this.getFeature("http://xml.org/sax/features/validation");
            parser.setValidation(false);
            aparser.setParser(parser);
            if (reader != null) {
                reader.mark(markAllowance);
            } else {
                inStr.mark(markAllowance);
            }
            aparser.begin();
            int i = -1;
            while ((i = aparser.next()) != 1) {
            }
            parser.setValidation(validation);
            try {
                if (reader != null) {
                    reader.reset();
                } else {
                    inStr.reset();
                }
            }
            catch (IOException e) {
                throw new NestedIOException("Start tag of root element ends after the" + markAllowance + "'th byte.  You have to specify the schema manually (e.g. through a property).", e);
            }
            this.getAttribs(aparser);
            return inStr != null ? new InputSource(inStr) : new InputSource(reader);
        }
        aparser = new ActiveXMLParser(is);
        boolean validation = this.getFeature("http://xml.org/sax/features/validation");
        parser.setValidation(false);
        aparser.setParser(parser);
        aparser.begin();
        int i = -1;
        while ((i = aparser.next()) != 1) {
        }
        parser.setValidation(validation);
        this.getAttribs(aparser);
        return is;
    }

    private void getAttribs(ActiveXMLParser aparser) {
        Attributes attrs = aparser.getAttributes();
        int size = attrs.getLength();
        for (int j = 0; j < size; ++j) {
            if ("schemaLocation".equals(attrs.getLocalName(j)) && "http://www.w3.org/2001/XMLSchema-instance".equals(attrs.getURI(j))) {
                this.fillExternalSchemaLocations(attrs.getValue(j));
                this.forceSchema = true;
            }
            if (!"noNamespaceSchemaLocation".equals(attrs.getLocalName(j)) || !"http://www.w3.org/2001/XMLSchema-instance".equals(attrs.getURI(j)) || this.noNamespaceSchemaLocation != null) continue;
            this.noNamespaceSchemaLocation = attrs.getValue(j);
            this.forceSchema = true;
        }
    }
}

