/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ParserException
extends Exception {
    public static final String WRAPPING = " -> ";
    public static final String TRACE_SEPARATOR = "\t----------------------------------------";
    private int row;
    private int col;
    private String sourceID;
    private Throwable cause;
    protected String msg;

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public String getSourceID() {
        return this.sourceID;
    }

    public ParserException(Throwable cause) {
        super(cause.toString());
        this.cause = cause;
        this.row = -1;
        this.col = -1;
        this.msg = null;
    }

    public ParserException(String msg, Throwable cause) {
        super(msg);
        this.cause = cause;
        this.row = -1;
        this.col = -1;
        this.msg = msg;
    }

    public ParserException(String s, int row, int col) {
        super(s);
        this.row = row;
        this.col = col - 1;
        this.msg = s;
    }

    public ParserException(String msg, CharArray sourceID, int row, int col) {
        super(msg);
        this.row = row;
        this.col = col - 1;
        this.msg = msg;
        this.sourceID = sourceID.toString();
    }

    public String getMessage() {
        if (this.sourceID != null) {
            return this.msg + " (" + this.sourceID + ", row:" + this.row + ", col:" + this.col + ")";
        }
        return this.msg + " (row:" + this.row + ", col:" + this.col + ")";
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream out) {
        this.printStackTrace(new PrintWriter(out, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter out) {
        if (this.cause == null) {
            super.printStackTrace(out);
        } else {
            PrintWriter printWriter = out;
            synchronized (printWriter) {
                out.print(this.toFullString() + WRAPPING);
                this.cause.printStackTrace(out);
                out.println(TRACE_SEPARATOR);
                out.print(this.trace());
                out.flush();
            }
        }
    }

    private final String toFullString() {
        StringBuffer buf = new StringBuffer("com.sap.engine.lib.xml.parser.ParserException");
        if (this.msg != null) {
            buf.append(": ");
            buf.append(this.msg);
        }
        if (this.sourceID != null || this.row > -1 && this.col > -1) {
            buf.append('(');
        }
        if (this.sourceID != null) {
            buf.append(this.sourceID);
        }
        if (this.row > -1 && this.col > -1) {
            if (this.sourceID != null) {
                buf.append(", ");
            }
            buf.append("row:");
            buf.append(this.row);
            buf.append(", col:");
            buf.append(this.col);
        }
        if (this.sourceID != null || this.row > -1 && this.col > -1) {
            buf.append(')');
        }
        return buf.toString();
    }

    private String trace() {
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        super.printStackTrace(pw);
        pw.flush();
        String s = w.toString();
        int p = s.indexOf("\tat");
        if (p != -1) {
            s = s.substring(p);
        }
        return s;
    }

    public String toString() {
        String str = this.toFullString();
        if (this.cause != null) {
            str = str + WRAPPING + this.cause.toString();
        }
        return str;
    }
}

