/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser;

import com.sap.engine.lib.xml.dom.DOMDocHandler1;
import com.sap.engine.lib.xml.dom.DocumentImpl;
import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.NestedSAXParseException;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.dtd.ValidationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.LocatorImpl;

public class DOMParser {
    private XMLParser xmlParser = null;
    private ErrorHandler errorHandler = null;
    private Document document = null;
    private boolean isIgnoringComments = false;
    private Class documentClass = null;

    public DOMParser() throws Exception {
        this.xmlParser = new XMLParser();
        this.xmlParser.setWellformed(true);
        try {
            this.documentClass = Class.forName("com.sap.engine.lib.xml.dom.DocumentImpl");
        }
        catch (NoClassDefFoundError e) {
            try {
                this.documentClass = new DocumentImpl().getClass();
            }
            catch (Throwable t) {
                System.out.println("DOMParser: could not load DocumentImpl, and get it's Class");
                t.printStackTrace();
            }
        }
    }

    public DOMParser(XMLParser p) {
        this.xmlParser = p;
    }

    public void setIgnoringComments(boolean b) {
        this.isIgnoringComments = b;
    }

    public Document parse(String systemId) throws IOException, SAXException {
        return this.parse(new InputSource(systemId));
    }

    public Document parse(InputSource input) throws SAXException, IOException {
        try {
            DOMDocHandler1 domdoc = null;
            domdoc = this.document == null ? new DOMDocHandler1((DocumentImpl)this.documentClass.newInstance()) : new DOMDocHandler1(this.document);
            domdoc.setErrorHandler(this.errorHandler);
            domdoc.setIgnoringComments(this.isIgnoringComments);
            domdoc.setXMLValidator(this.xmlParser.getXMLValidator());
            this.xmlParser.parse(input, (DocHandler)domdoc);
            this.document = domdoc.getDocument();
            if (this.document instanceof DocumentImpl) {
                ((DocumentImpl)this.document).normalize();
            } else {
                try {
                    this.document.normalize();
                }
                catch (NoSuchMethodError e) {
                    // empty catch block
                }
            }
            Document result = this.document;
            this.document = null;
            return result;
        }
        catch (Exception e) {
            Locator loc = new LocatorImpl();
            if (e instanceof ParserException) {
                ((LocatorImpl)loc).setSystemId(((ParserException)e).getSourceID());
                ((LocatorImpl)loc).setLineNumber(((ParserException)e).getRow());
                ((LocatorImpl)loc).setColumnNumber(((ParserException)e).getCol());
                if (loc.getSystemId() == null || loc.getSystemId().equals(":main:")) {
                    ((LocatorImpl)loc).setSystemId(this.xmlParser.getSystemId());
                }
            } else {
                loc = this.xmlParser;
            }
            if (this.errorHandler != null) {
                if (!(e instanceof ValidationException)) {
                    this.errorHandler.fatalError(new NestedSAXParseException("Fatal Error: " + e, loc, e));
                    if (e instanceof UnsupportedEncodingException) {
                        throw new NestedSAXParseException(e.toString(), loc, e);
                    }
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new NestedSAXParseException(e.toString(), loc, e);
                }
                this.errorHandler.error(new NestedSAXParseException("Validation Error: " + e, loc, e));
                return null;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new NestedSAXParseException(e.toString(), loc, e);
        }
    }

    public Document parse(InputStream in) throws SAXException, IOException {
        return this.parse(new InputSource(in));
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException {
        if (name.equals("http://xml.org/sax/features/validation")) {
            return this.xmlParser.getValidation();
        }
        if (name.equals("http://xml.org/sax/features/external-general-entities")) {
            throw new SAXNotRecognizedException("");
        }
        if (name.equals("http://xml.org/sax/features/external-parameter-entities")) {
            throw new SAXNotRecognizedException("");
        }
        if (name.equals("http://xml.org/sax/features/namespaces")) {
            return this.xmlParser.getNamespaces();
        }
        if (name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return this.xmlParser.getNamespacePrefixes();
        }
        if (name.equals("http://xml.org/sax/features/string-interning")) {
            throw new SAXNotRecognizedException("");
        }
        if (name.equals("http://inqmy.org/dom/features/trim-white-spaces")) {
            return this.xmlParser.getDOMTrimWhiteSpaces();
        }
        if (name.equals("http://inqmy.com/dom/exanding-references")) {
            return this.xmlParser.getExpandingReferences();
        }
        if (name.equals("http://sap.com/xml/features/scan-only-root")) {
            return this.xmlParser.getScanOnlyRoot();
        }
        try {
            return this.xmlParser.getFeature(name);
        }
        catch (SAXNotSupportedException e) {
            throw new SAXNotRecognizedException(e.toString());
        }
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException {
        if (name.equals("http://xml.org/sax/features/validation")) {
            this.xmlParser.setValidation(value);
        } else {
            if (name.equals("http://xml.org/sax/features/external-general-entities")) {
                throw new SAXNotRecognizedException("");
            }
            if (name.equals("http://xml.org/sax/features/external-parameter-entities")) {
                throw new SAXNotRecognizedException("");
            }
            if (name.equals("http://xml.org/sax/features/namespaces")) {
                this.xmlParser.setNamespaces(value);
            } else if (name.equals("http://xml.org/sax/features/namespace-prefixes")) {
                this.xmlParser.setNamespacePrefixes(value);
            } else {
                if (name.equals("http://xml.org/sax/features/string-interning")) {
                    throw new SAXNotRecognizedException("");
                }
                if (name.equals("http://inqmy.org/sax/features/use-proxy")) {
                    this.xmlParser.setUseProxy(value);
                } else if (name.equals("http://inqmy.org/sax/features/read-dtd")) {
                    this.xmlParser.setReadDTD(value);
                } else if (name.equals("http://inqmy.org/dom/features/trim-white-spaces")) {
                    this.xmlParser.setDOMTrimWhiteSpaces(value);
                } else if (name.equals("http://inqmy.org/xml/features/close-streams")) {
                    this.xmlParser.setCloseStreams(value);
                } else if (name.equals("http://inqmy.com/dom/exanding-references")) {
                    this.xmlParser.setExpandingReferences(value);
                } else if (name.equals("http://sap.com/xml/features/scan-only-root")) {
                    this.xmlParser.setScanOnlyRoot(value);
                } else {
                    try {
                        this.xmlParser.setFeature(name, value);
                    }
                    catch (SAXNotSupportedException e) {
                        throw new SAXNotRecognizedException(e.toString());
                    }
                }
            }
        }
    }

    public Object getProperty(String name) throws SAXNotRecognizedException {
        throw new SAXNotRecognizedException("");
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException {
        block10: {
            try {
                if (name.equals("http://inqmy.org/sax/properties/proxy-host")) {
                    this.xmlParser.setProxyURL((String)value);
                    break block10;
                }
                if (name.equals("http://inqmy.org/sax/properties/proxy-port")) {
                    this.xmlParser.setProxyPort((Integer)value);
                    break block10;
                }
                if (name.equals("http://inqmy.org/sax/properties/alternative-dtd")) {
                    this.xmlParser.setAlternativeDTD((String)value);
                    break block10;
                }
                if (name.equals("http://inqmy.org/dom/document-class-name-string")) {
                    this.setDocumentClassName((String)value);
                    break block10;
                }
                if (name.equals("http://sap.com/xml/max-references")) {
                    this.xmlParser.setMaximumProcessingReferences(value);
                    break block10;
                }
                if (name.indexOf("/features/") > -1) {
                    this.setFeature(name, (Boolean)value);
                    break block10;
                }
                try {
                    this.xmlParser.setProperty(name, value.toString());
                }
                catch (SAXNotSupportedException e) {
                    throw new SAXNotRecognizedException(e.toString());
                }
            }
            catch (SAXException e) {
                throw new SAXNotRecognizedException(e.toString());
            }
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.xmlParser.setEntityResolver(resolver);
    }

    public EntityResolver getEntityResolver() {
        return this.xmlParser.getEntityResolver();
    }

    public void setDocumentClassName(String name) throws SAXException {
        try {
            Object docClass = Class.forName(name).newInstance();
            if (!(docClass instanceof DocumentImpl)) {
                throw new ClassCastException("The class must extend com.sap.engine.lib.xml.dom.DocumentImpl");
            }
            this.documentClass = Class.forName(name);
        }
        catch (Exception e) {
            throw new NestedSAXParseException(e);
        }
    }

    public Class getDocumentClass() {
        return this.documentClass;
    }

    public Document getDocument() {
        System.out.println("This method cannot be used any more due to MemoryLeaking! Use parse(...) instead.");
        throw new RuntimeException("This method cannot be used any more due to MemoryLeaking! Use parse(...) instead.");
    }

    public void setDocument(Document doc) {
        this.document = doc;
        if (doc != null && this.document.getDocumentElement() != null) {
            this.document.removeChild(this.document.getDocumentElement());
        }
    }
}

