/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser;

import com.sap.engine.lib.xml.SystemProperties;
import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.Features;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.URLLoaderBase;
import com.sap.engine.lib.xml.parser.dtd.XMLValidator;
import com.sap.engine.lib.xml.parser.handlers.INamespaceHandler;
import com.sap.engine.lib.xml.parser.handlers.NamespaceHandlerEx;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.IXMLStream;
import com.sap.engine.lib.xml.util.ReaderInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class AbstractXMLParser
implements Locator {
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    protected XMLValidator xmlValidator = new XMLValidator(this);
    protected String systemId = null;
    protected String publicId = null;
    protected IXMLStream is = null;
    public URLLoaderBase urlLoader = new URLLoaderBase();
    protected boolean bValidation = false;
    protected boolean bDynamicValidation = false;
    protected boolean bNamespaces = true;
    protected boolean bWellformed = true;
    protected boolean bNamespacePrefixes = true;
    protected boolean alternativeDTD = false;
    protected boolean bDOMTrimWhiteSpaces = false;
    protected INamespaceHandler namespaceHandler = null;
    protected boolean bCloseStreams = true;
    protected boolean bUseAlternativeDTD = false;
    protected CharArray caAlternativeDTD = new CharArray();
    protected boolean bScanContentOnly = false;
    protected boolean bActiveParse = false;
    protected boolean bExpandingReferences = true;
    protected boolean bHTMLMode = false;
    protected HashSet HTML_OPEN_TAGS = null;
    protected boolean bExternalGeneralEntities = true;
    protected boolean bReadDTD = true;
    public static int id = 0;
    public boolean bSoapProcessing = false;
    public boolean bScanOnlyRoot = false;

    public AbstractXMLParser() {
        try {
            this.loadProperties();
        }
        catch (ParserException parserException) {
            // empty catch block
        }
    }

    protected abstract void parse0(InputStream var1, String var2, DocHandler var3) throws Exception;

    public abstract void init() throws ParserException;

    public abstract void onDocumentEOF() throws ParserException;

    public final void activeParse(InputSource source, DocHandler handler) throws Exception {
        this.setActiveParse(true);
        this.parse(source, handler);
    }

    public void finalizeActiveParse() {
        if (!this.bSoapProcessing) {
            this.urlLoader.init();
        }
        this.setActiveParse(false);
    }

    private final void parseAndCatchException(InputStream inputStream, String sourceId, DocHandler docHandler) throws Exception {
        try {
            this.parse0(inputStream, sourceId, docHandler);
        }
        catch (Exception e) {
            this.urlLoader.init();
            throw e;
        }
        finally {
            if (!this.bActiveParse) {
                this.urlLoader.init();
            }
        }
    }

    public final void parse(InputStream inputStream, String systemId, DocHandler docHandler) throws Exception {
        this.parseAndCatchException(inputStream, systemId, docHandler);
    }

    public final void parse(Reader reader, String systemId, DocHandler docHandler) throws Exception {
        this.parseAndCatchException(new ReaderInputStream(reader), systemId, docHandler);
    }

    public final void parse(InputStream inputStream, DocHandler docHandler) throws Exception {
        this.parseAndCatchException(inputStream, ":main:", docHandler);
    }

    public final void parse(Reader reader, DocHandler docHandler) throws Exception {
        this.parseAndCatchException(new ReaderInputStream(reader), ":main:", docHandler);
    }

    public final void parse(String s, DocHandler docHandler) throws Exception {
        s.replace('\\', '/');
        InputStream is = this.urlLoader.loadAndPush(s).openStream();
        docHandler.onCustomEvent(1001, this.urlLoader.peek());
        this.parseAndCatchException(is, s, docHandler);
        if (!this.bActiveParse) {
            is.close();
        }
    }

    public final void parse(InputSource input, DocHandler handler) throws Exception {
        Reader reader = input.getCharacterStream();
        InputStream inputStream = input.getByteStream();
        this.systemId = input.getSystemId();
        this.publicId = input.getPublicId();
        if (reader != null) {
            if (this.systemId != null && this.systemId.length() > 0) {
                try {
                    this.urlLoader.push(new URL(this.systemId));
                }
                catch (Exception e) {
                    this.urlLoader.push(new URL("http://localhost/"));
                }
            }
            if (this.systemId == null) {
                this.systemId = ":main:";
            }
            this.parse(reader, this.systemId, handler);
        } else if (inputStream != null) {
            if (this.systemId != null && this.systemId.length() > 0) {
                try {
                    this.urlLoader.push(new URL(this.systemId));
                }
                catch (Exception e) {
                    this.urlLoader.push(new URL("http://localhost/"));
                }
            }
            if (this.systemId == null) {
                this.systemId = ":main:";
            }
            this.parse(inputStream, this.systemId, handler);
        } else {
            this.parse(this.systemId, handler);
        }
    }

    public final void loadProperties() throws ParserException {
        String s = null;
        try {
            s = SystemProperties.getProperty(HTTP_PROXY_HOST);
        }
        catch (SecurityException se) {
            s = "proxy";
        }
        if (s != null) {
            this.setUseProxy(true);
            this.setProxyURL(s);
        }
        try {
            s = SystemProperties.getProperty(HTTP_PROXY_PORT);
        }
        catch (SecurityException se) {
            s = "8080";
        }
        if (s != null) {
            this.setUseProxy(true);
            try {
                this.setProxyPort(Integer.parseInt(s));
            }
            catch (NumberFormatException e) {
                this.setProxyPort(8080);
            }
        }
        String propertiesFile = null;
        try {
            propertiesFile = SystemProperties.getProperty("xmlparser.properties.file");
        }
        catch (Exception e) {
            return;
        }
        if (propertiesFile == null) {
            return;
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(propertiesFile));
            this.setProperties(properties);
        }
        catch (Exception e) {
            throw new ParserException("Unable to load properties file, '" + propertiesFile + "'", 0, 0);
        }
        if (this.getUseCaches() && this.getCacheDir() == null) {
            throw new ParserException("XMLParser: 'xmlparser.use-cache = 1' property detected, but no 'xmlparser.cache-dir'", 0, 0);
        }
        if (this.getUseProxy()) {
            if (this.getProxyURL() == null) {
                throw new ParserException("XMLParser: 'xmlparser.use-proxy = 1' system property detected, but no 'xmlparser.proxy-host'", 0, 0);
            }
            if (this.getProxyPort() == -1) {
                throw new ParserException("XMLParser: 'xmlparser.use-proxy = 1' system property detected, but no 'xmlparser.proxy-port'", 0, 0);
            }
        }
    }

    public final void setProperties(Properties p) throws SAXNotRecognizedException, SAXNotSupportedException {
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            this.setProperty(k, p.getProperty(k));
        }
    }

    public final void setProperty(String key, String value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (Features.RECOGNIZED.contains(key)) {
            this.setFeature(key, AbstractXMLParser.propertyValueToBoolean(key, value));
        } else if (key.equals("xmlparser.use-proxy")) {
            this.setUseProxy(AbstractXMLParser.propertyValueToBoolean(key, value));
        } else if (key.equals("xmlparser.proxy-host")) {
            this.setProxyURL(value);
        } else if (key.equals("xmlparser.proxy-port")) {
            this.setProxyPort(Integer.parseInt(value));
        } else if (key.equals("xmlparser.cache-dir")) {
            this.setCacheDir(value);
        } else if (key.equals("xmlparser.use-cache")) {
            this.setUseCaches(AbstractXMLParser.propertyValueToBoolean(key, value));
        } else if (key.equals("xmlparser.alternate-dtd")) {
            this.setAlternativeDTD(value);
        } else if (key.equals("xmlparser.use-alternate-dtd")) {
            this.setUseAlternativeDTD(AbstractXMLParser.propertyValueToBoolean(key, value));
        } else {
            throw new SAXNotRecognizedException("Unable to set property '" + key + "'");
        }
    }

    public final void setFeature(String key, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!Features.RECOGNIZED.contains(key)) {
            throw new SAXNotRecognizedException(key);
        }
        if (!Features.SUPPORTED.contains(key)) {
            throw new SAXNotSupportedException(key);
        }
        if (key.startsWith("http://inqmy.com/dtd-validation/")) {
            this.xmlValidator.setFeature(key, value);
            return;
        }
        if (key.equals("http://xml.org/sax/features/validation")) {
            this.setValidation(value);
        } else if (key.equals("http://xml.org/sax/features/namespaces")) {
            this.setNamespaces(value);
        } else if (key.equals("http://xml.org/sax/features/namespace-prefixes")) {
            this.setNamespacePrefixes(value);
        } else if (key.equals("http://xml.org/sax/features/external-general-entities")) {
            this.setExternalGeneralEntities(value);
        } else if (key.equals("http://sap.com/xml/soap-input")) {
            this.setSoapProcessing(value);
        } else if (key.equals("http://inqmy.org/sax/features/read-dtd")) {
            this.setReadDTD(value);
        } else if (key.equals("http://apache.org/xml/features/validation/dynamic")) {
            this.setDynamicValidation(value);
        } else if (key.equals("http://sap.com/xml/html-mode")) {
            this.setHTMLMode(value);
        } else {
            throw new SAXNotRecognizedException("Unable to set feature '" + key + "'");
        }
    }

    public final boolean getFeature(String key) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!Features.RECOGNIZED.contains(key)) {
            throw new SAXNotRecognizedException(key);
        }
        if (!Features.SUPPORTED.contains(key)) {
            throw new SAXNotSupportedException(key);
        }
        if (key.startsWith("http://inqmy.com/dtd-validation/")) {
            return this.xmlValidator.getFeature(key);
        }
        if (key.equals("http://xml.org/sax/features/validation")) {
            return this.getValidation();
        }
        if (key.equals("http://xml.org/sax/features/namespaces")) {
            return this.getNamespaces();
        }
        if (key.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return this.getNamespacePrefixes();
        }
        if (key.equals("http://xml.org/sax/features/external-general-entities")) {
            return this.getExternalGeneralEntities();
        }
        if (key.equals("http://sap.com/xml/soap-input")) {
            return this.getSoapProcessing();
        }
        if (key.equals("http://sap.com/xml/html-mode")) {
            return this.getHTMLMode();
        }
        throw new RuntimeException("Unable to get feature '" + key + "'");
    }

    private static final boolean propertyValueToBoolean(String key, String value) {
        if (value != null && Features.POSITIVE_ANSWERS.contains(value)) {
            return true;
        }
        if (value != null && Features.NEGATIVE_ANSWERS.contains(value)) {
            return false;
        }
        throw new IllegalArgumentException("The property value for the key '" + key + "' must be in " + Features.POSITIVE_ANSWERS + "U" + Features.NEGATIVE_ANSWERS + " but it is '" + value + "'");
    }

    public final void setProxyPort(int value) {
        this.urlLoader.setProxyPort(value);
    }

    public final int getProxyPort() {
        return this.urlLoader.getProxyPort();
    }

    public final void setProxyURL(String value) {
        this.urlLoader.setProxyHost(value);
    }

    public final String getProxyURL() {
        return this.urlLoader.getProxyHost();
    }

    public final void setUseProxy(boolean value) {
        this.urlLoader.setUseProxy(value);
    }

    public final boolean getUseProxy() {
        return this.urlLoader.getUseProxy();
    }

    public final void setUseAlternativeDTD(boolean value) {
        this.bUseAlternativeDTD = value;
    }

    public final boolean getUseAlternativeDTD() {
        return this.bUseAlternativeDTD;
    }

    public final void setCacheDir(String value) {
        this.urlLoader.setCacheDir(value);
    }

    public final String getCacheDir() {
        return this.urlLoader.getCacheDir();
    }

    public final void setUseCaches(boolean value) {
        this.urlLoader.setUseCache(value);
    }

    public final boolean getUseCaches() {
        return this.urlLoader.getUseCache();
    }

    public final void setValidation(boolean b) {
        this.bValidation = b;
    }

    public final void setDynamicValidation(boolean b) {
        this.bDynamicValidation = b;
    }

    public final boolean getValidation() {
        return this.bValidation;
    }

    public final boolean getNamespaces() {
        return this.bNamespaces;
    }

    public final void setNamespaces(boolean bNamespaces) {
        this.bNamespaces = bNamespaces;
    }

    public final void setWellformed(boolean bWellformed) {
        this.bWellformed = bWellformed;
    }

    public final boolean getWellformed() {
        return this.bWellformed;
    }

    public final boolean getNamespacePrefixes() {
        return this.bNamespacePrefixes;
    }

    public final void setNamespacePrefixes(boolean b) {
        this.bNamespacePrefixes = b;
    }

    protected void setXMLValidator(XMLValidator x) {
        this.xmlValidator = x;
    }

    public final XMLValidator getXMLValidator() {
        return this.xmlValidator;
    }

    public final boolean getDOMTrimWhiteSpaces() {
        return this.bDOMTrimWhiteSpaces;
    }

    public final void setDOMTrimWhiteSpaces(boolean v) {
        this.bDOMTrimWhiteSpaces = v;
    }

    public final void setAlternativeDTD(String value) {
        this.caAlternativeDTD.clear();
        this.caAlternativeDTD.set(value);
        this.alternativeDTD = true;
    }

    public abstract void onWarning(String var1) throws Exception;

    public boolean getCloseStreams() {
        return this.bCloseStreams;
    }

    public void setCloseStreams(boolean bCloseStreams) {
        this.bCloseStreams = bCloseStreams;
    }

    public void setScanContentOnly(boolean value) {
        this.bScanContentOnly = value;
    }

    public boolean getScanContentOnly() {
        return this.bScanContentOnly;
    }

    public boolean getActiveParse() {
        return this.bActiveParse;
    }

    public void setActiveParse(boolean value) {
        this.bActiveParse = value;
    }

    public void setExpandingReferences(boolean value) {
        this.bExpandingReferences = value;
    }

    public boolean getExpandingReferences() {
        return this.bExpandingReferences;
    }

    public boolean getHTMLMode() {
        return this.bHTMLMode;
    }

    public void setHTMLMode(boolean bHTMLMode) {
        this.bHTMLMode = bHTMLMode;
        this.getHTMLOpenTags();
        this.bWellformed = !bHTMLMode;
        this.setExpandingReferences(false);
    }

    public HashSet getHTMLOpenTags() {
        if (this.HTML_OPEN_TAGS == null) {
            this.HTML_OPEN_TAGS = new HashSet();
        }
        return this.HTML_OPEN_TAGS;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        if (this.is == null) {
            return 0;
        }
        return this.is.getRow();
    }

    public int getColumnNumber() {
        if (this.is == null) {
            return 0;
        }
        return this.is.getCol() - 1;
    }

    void setPublicId(String id) {
        this.publicId = id;
    }

    void setSystemId(String id) {
        this.systemId = id;
    }

    public boolean getExternalGeneralEntities() {
        return this.bExternalGeneralEntities;
    }

    public void setExternalGeneralEntities(boolean bExternalGeneralEntities) {
        this.bExternalGeneralEntities = bExternalGeneralEntities;
    }

    public boolean getSoapProcessing() {
        return this.bSoapProcessing;
    }

    public void setSoapProcessing(boolean bSoapProcessing) {
        this.bSoapProcessing = bSoapProcessing;
        if (bSoapProcessing) {
            this.namespaceHandler = new NamespaceHandlerEx(null);
        }
    }

    public boolean getScanOnlyRoot() {
        return this.bScanOnlyRoot;
    }

    public void setScanOnlyRoot(boolean bScanOnlyRoot) {
        this.bScanOnlyRoot = bScanOnlyRoot;
    }

    public void setReadDTD(boolean value) {
        this.bReadDTD = value;
    }

    public INamespaceHandler getNamespaceHandler() {
        return this.namespaceHandler;
    }
}

