/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.names;

public final class EditDistance {
    private int[] d = new int[1024];
    private int la;
    private int lb;
    private int la1;
    private int lb1;

    private int index(int i, int j) {
        return i * this.lb1 + j;
    }

    public void printTable() {
        for (int i = 0; i <= this.la; ++i) {
            for (int j = 0; j <= this.lb; ++j) {
                System.out.print(" " + this.d[this.index(i, j)]);
            }
            System.out.println();
        }
        System.out.println();
    }

    public int between(String a, String b) {
        int i;
        this.la = a.length();
        this.lb = b.length();
        if (this.la == 0) {
            return this.lb;
        }
        if (this.lb == 0) {
            return this.la;
        }
        this.la1 = this.la + 1;
        this.lb1 = this.lb + 1;
        int l = this.la1 * this.lb1;
        if (this.d.length < l) {
            this.d = new int[l];
        }
        for (i = 1; i <= this.la; ++i) {
            this.d[this.index((int)i, (int)0)] = 1;
        }
        for (int j = 1; j <= this.lb; ++j) {
            this.d[this.index((int)0, (int)j)] = 1;
        }
        this.d[this.index((int)0, (int)0)] = 0;
        for (i = 1; i <= this.la; ++i) {
            char cha = a.charAt(i - 1);
            for (int j = 1; j <= this.lb; ++j) {
                char chb = b.charAt(j - 1);
                int x = Math.min(this.d[this.index(i - 1, j)], this.d[this.index(i, j - 1)]) + 1;
                this.d[this.index((int)i, (int)j)] = x = Math.min(x, this.d[this.index(i - 1, j - 1)] + (cha == chb ? 0 : 1));
            }
        }
        return this.d[this.index(this.la, this.lb)];
    }

    public static String getMostProbable(String misspelt, String[] dictionary, int delta) {
        try {
            EditDistance editDistance = new EditDistance();
            int indexOfMostProbable = -1;
            int distanceToMostProbable = Integer.MAX_VALUE;
            for (int i = 0; i < dictionary.length; ++i) {
                int d = editDistance.between(misspelt, dictionary[i]);
                if (d >= distanceToMostProbable) continue;
                indexOfMostProbable = i;
                distanceToMostProbable = d;
            }
            return indexOfMostProbable != -1 && distanceToMostProbable <= delta ? dictionary[indexOfMostProbable] : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        String a = "alabala";
        String b = "cabala";
        EditDistance ed = new EditDistance();
        System.out.println("Distance between '" + a + "' and '" + b + "' = " + ed.between(a, b));
        ed.printTable();
    }
}

