/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.dom.xpath;

import com.sap.engine.lib.xml.dom.NodeListImpl;
import com.sap.engine.lib.xml.dom.xpath.XPathException;
import com.sap.engine.lib.xml.dom.xpath.XPathSetIteratorImpl;
import com.sap.engine.lib.xml.dom.xpath.XPathSetSnapshotImpl;
import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xpath.functions.XFDump;
import com.sap.engine.lib.xsl.xpath.xobjects.XBoolean;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XNumber;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XString;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPathResultImpl {
    public static final short ANY_TYPE = 0;
    public static final short NUMBER_TYPE = 1;
    public static final short STRING_TYPE = 2;
    public static final short BOOLEAN_TYPE = 3;
    public static final short NODE_SET_TYPE = 4;
    public static final short SINGLE_NODE_TYPE = 5;
    private int type = -1;
    private XObject xo = null;
    private XNodeSet set = null;
    private Throwable anXPathException = null;
    private Document owner = null;

    XPathResultImpl(XObject xo) {
        this.xo = xo;
    }

    public XPathResultImpl() {
    }

    void reuse(XObject xo) {
        this.type = -1;
        this.xo = null;
        this.set = null;
        this.anXPathException = null;
        this.xo = xo;
    }

    public void setOwnerDocument(Document owner) {
        this.owner = owner;
    }

    public Node getOwnerDocument() {
        return this.owner;
    }

    public short getResultType() {
        int t = this.xo.getType();
        switch (t) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return ((XNodeSet)this.xo).size() == 1 ? (short)5 : 4;
            }
        }
        throw new RuntimeException("Bad type of an XObject.");
    }

    public double getNumberValue() throws XPathException {
        if (this.xo instanceof XNumber) {
            return ((XNumber)this.xo).getValue();
        }
        throw new XPathException(2, "TYPE_ERR: not a number");
    }

    public String getStringValue() throws XPathException {
        if (this.xo instanceof XString) {
            return ((XString)this.xo).getValue().toString();
        }
        throw new XPathException(2, "TYPE_ERR: not a string");
    }

    public boolean getBooleanValue() throws XPathException {
        if (this.xo instanceof XBoolean) {
            return ((XBoolean)this.xo).getValue();
        }
        throw new XPathException(2, "TYPE_ERR: not a boolean");
    }

    public Node getSingleNodeValue() throws XPathException {
        if (this.xo instanceof XNodeSet) {
            if (((XNodeSet)this.xo).size() < 1) {
                return null;
            }
            DTM dtm = ((XNodeSet)this.xo).dtm;
            dtm.initializeDOM();
            return dtm.domtree[((XNodeSet)this.xo).getKth(1)];
        }
        throw new XPathException(2, "TYPE_ERR: not a nodeset");
    }

    public XPathSetIteratorImpl getSetIterator(boolean ordered) throws XPathException, DOMException {
        if (this.xo instanceof XNodeSet) {
            XPathSetIteratorImpl xpsi = new XPathSetIteratorImpl((XNodeSet)this.xo);
            xpsi.setOwnerDocument(this.owner);
            return xpsi;
        }
        throw new XPathException(2, "TYPE_ERR: not a nodeset");
    }

    public XPathSetSnapshotImpl getSetSnapshot(boolean ordered) throws XPathException, DOMException {
        if (this.xo instanceof XNodeSet) {
            DTM dtm = ((XNodeSet)this.xo).dtm;
            dtm.initializeDOM();
            NodeListImpl nli = new NodeListImpl();
            int size = ((XNodeSet)this.xo).size();
            for (int i = 1; i < size + 1; ++i) {
                nli.add(dtm.domtree[((XNodeSet)this.xo).getKth(i)]);
            }
            return new XPathSetSnapshotImpl(nli);
        }
        throw new XPathException(2, "TYPE_ERR: not a nodeset");
    }

    public String toString() {
        try {
            switch (this.xo.getType()) {
                case 1: {
                    return this.xo.toXString().toString();
                }
                case 2: {
                    return this.xo.toString();
                }
                case 3: {
                    return this.xo.toXString().toString();
                }
                case 4: {
                    return XFDump.toString(((XNodeSet)this.xo).dtm, this.xo);
                }
            }
            return "???";
        }
        catch (com.sap.engine.lib.xsl.xpath.XPathException e) {
            e.printStackTrace();
            return "???";
        }
    }
}

