/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.dom.xpath;

import com.sap.engine.lib.xml.dom.xpath.XPathException;
import com.sap.engine.lib.xml.dom.xpath.XPathNSResolverImpl;
import com.sap.engine.lib.xml.dom.xpath.XPathResultImpl;
import com.sap.engine.lib.xml.parser.handlers.NamespaceHandler;
import com.sap.engine.lib.xml.util.DOMToDocHandler;
import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xpath.DTMFactory;
import com.sap.engine.lib.xsl.xpath.ETBuilder;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathProcessor;
import com.sap.engine.lib.xsl.xslt.NamespaceManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XPathExpressionImpl {
    private String expression = null;
    protected XPathProcessor xpp = null;
    protected XPathContext xpc = null;
    protected ETBuilder builder = new ETBuilder();
    protected DTM dtm = new DTM();
    protected DTMFactory dtmfact = new DTMFactory();
    protected DOMToDocHandler dtdh = new DOMToDocHandler();
    protected NamespaceHandler nshandler = null;
    protected NamespaceManager nsmanager = null;

    XPathExpressionImpl(String expression, XPathNSResolverImpl resolver) {
        this.expression = expression;
    }

    public XPathResultImpl evaluate(Node contextNode, short type, XPathResultImpl result) throws XPathException, DOMException {
        try {
            Document owner = contextNode instanceof Document ? (Document)contextNode : contextNode.getOwnerDocument();
            int[] ancestry = XPathExpressionImpl.getAncestry(contextNode);
            this.nshandler = new NamespaceHandler(null);
            this.nsmanager = new NamespaceManager();
            this.builder.setNamespaceStuff(this.nsmanager, this.nshandler);
            this.dtmfact.initialize(this.dtm, new NamespaceManager());
            this.dtdh.process(owner, this.dtmfact);
            this.xpp = new XPathProcessor(this.dtm);
            this.xpc = this.dtm.getInitialContext();
            this.xpc.node = XPathExpressionImpl.getNodeFromAncestry(this.dtm, ancestry);
            result.reuse(this.xpp.process(this.builder.process(this.expression), this.xpc));
            result.setOwnerDocument(owner);
            return result;
        }
        catch (com.sap.engine.lib.xsl.xpath.XPathException e) {
            e.printStackTrace();
            throw new XPathException(1, e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XPathException(1, e.toString());
        }
    }

    static int[] getAncestry(DTM dtm, int i) {
        int count = 0;
        if (dtm.parent[i] < 0) {
            return new int[]{0};
        }
        if (dtm.nodeType[i] == 2) {
            int parentEl = dtm.parent[i];
            int[] attributes = new int[dtm.getAttributesAndNSEndIndex(parentEl) - dtm.getAttributesStartIndex(parentEl) + 1];
            dtm.getAttributeAndNSNodes(parentEl, attributes, 0);
            for (int j = 0; j < attributes.length; ++j) {
                ++count;
                if (attributes[j] != i) continue;
                count = -count;
                break;
            }
        } else {
            int temp = i;
            while (dtm.previousSibling[temp] >= 0) {
                temp = dtm.previousSibling[temp];
                ++count;
            }
        }
        int[] upperBranch = XPathExpressionImpl.getAncestry(dtm, dtm.parent[i]);
        int[] result = new int[upperBranch.length + 1];
        System.arraycopy(upperBranch, 0, result, 0, upperBranch.length);
        result[result.length - 1] = count;
        return result;
    }

    static int[] getAncestry(Node n) {
        Node parent = n.getParentNode();
        if (parent == null) {
            return new int[]{0};
        }
        int count = 0;
        Node temp = n;
        while (temp.getPreviousSibling() != null) {
            temp = temp.getPreviousSibling();
            ++count;
        }
        int[] upperBranch = XPathExpressionImpl.getAncestry(parent);
        int[] result = new int[upperBranch.length + 1];
        System.arraycopy(upperBranch, 0, result, 0, upperBranch.length);
        result[result.length - 1] = count;
        return result;
    }

    static int getNodeFromAncestry(DTM dtm, int[] ancestry) {
        int i;
        int rootNode = 0;
        int depth = ancestry.length;
        int next = rootNode;
        for (i = 0; i < depth - 1; ++i) {
            for (int j = 0; j < ancestry[i]; ++j) {
                next = dtm.nextSibling[next];
            }
            next = dtm.firstChild[next];
        }
        if (ancestry.length > 0) {
            for (i = 0; i < ancestry[ancestry.length - 1]; ++i) {
                next = dtm.nextSibling[next];
            }
        }
        return next;
    }

    static Node getNodeFromAncestry(Document doc, int[] ancestry) {
        Document rootNode = doc;
        int depth = ancestry.length;
        Node next = rootNode;
        for (int i = 0; i < depth - 1; ++i) {
            for (int j = 0; j < ancestry[i]; ++j) {
                next = next.getNextSibling();
            }
            if (i >= depth - 2) continue;
            next = next.getFirstChild();
        }
        if (ancestry[ancestry.length - 1] >= 0) {
            next = next.getFirstChild();
            for (int j = 0; j < ancestry[ancestry.length - 1]; ++j) {
                next = next.getNextSibling();
            }
            return next;
        }
        NamedNodeMap map = next.getAttributes();
        return map.item(-ancestry[ancestry.length - 1] - 1);
    }
}

