/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.dom;

import com.sap.engine.lib.xml.dom.CharacterDataImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextImpl
extends CharacterDataImpl
implements Text {
    public TextImpl() {
    }

    protected TextImpl(Document owner) {
        this.setOwnerDocument(owner);
    }

    public Node cloneNode(boolean deep) {
        TextImpl result = new TextImpl(this.getOwnerDocument());
        result.init(this.data, null);
        result.setOwnerDocument(this.getOwnerDocument());
        return result;
    }

    public String getNodeName() {
        return "#text";
    }

    public short getNodeType() {
        return 3;
    }

    public Text splitText(int offset) {
        if (offset < 0 || offset > this.data.length()) {
            throw new DOMException(1, "Offset given to split text is out of bounds.");
        }
        TextImpl other = new TextImpl();
        other.init(this.data.substring(offset), null);
        this.data = this.data.substring(0, offset);
        if (this.parent != null) {
            this.parent.insertBefore(other, this.getNextSibling());
        }
        return other;
    }

    public static boolean isWhiteSpaceChar(char ch) {
        return ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t';
    }

    public void trimWhiteSpace() {
        int e;
        int b;
        if (this.data == null) {
            return;
        }
        for (b = 0; b < this.data.length() && TextImpl.isWhiteSpaceChar(this.data.charAt(b)); ++b) {
        }
        for (e = this.data.length() - 1; e > 0 && e > b && TextImpl.isWhiteSpaceChar(this.data.charAt(e)); --e) {
        }
        this.data = this.data.substring(b, e + 1);
    }

    public static boolean isWhiteSpace(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (TextImpl.isWhiteSpaceChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isWhiteSpace() {
        if (this.data == null) {
            return false;
        }
        for (int i = 0; i < this.data.length(); ++i) {
            if (TextImpl.isWhiteSpaceChar(this.data.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getNodeValue();
    }
}

