/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.dom;

import com.sap.engine.lib.xml.dom.AttrImpl;
import com.sap.engine.lib.xml.dom.Base;
import java.io.Serializable;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class NamedNodeMapImpl
implements NamedNodeMap,
Serializable {
    private Node[] a = new Node[16];
    private int na;

    protected NamedNodeMapImpl() {
    }

    protected NamedNodeMapImpl init() {
        this.na = 0;
        return this;
    }

    public int getLength() {
        return this.na;
    }

    public Node getNamedItem(String name) {
        int p = this.find(name);
        return p == -1 ? null : this.a[p];
    }

    public Node getNamedItemNS(String namespaceURI, String localName) {
        int p = this.findNS(namespaceURI, localName);
        return p == -1 ? null : this.a[p];
    }

    public Node item(int index) {
        if (index < 0 || index >= this.na) {
            return null;
        }
        return this.a[index];
    }

    public Node removeNamedItem(String name) {
        int p = this.find(name);
        if (p == -1) {
            throw new DOMException(8, "There is no named item '" + name + "' in this NamedNodeMap.");
        }
        Node r = this.a[p];
        --this.na;
        this.a[p] = this.a[this.na];
        return r;
    }

    public Node removeNamedItemNS(String namespaceURI, String localName) {
        int p = this.findNS(namespaceURI, localName);
        if (p == -1) {
            throw new DOMException(8, "There is no named item with local name '" + localName + "' in this NamedNodeMap.");
        }
        Node r = this.a[p];
        --this.na;
        this.a[p] = this.a[this.na];
        return r;
    }

    public Node setNamedItem(Node arg) {
        if (arg.getNodeType() == 2 && ((AttrImpl)arg).getOwnerElement() != null) {
            throw new DOMException(10, "The attribute already belongs to another element.");
        }
        int p = this.find(arg.getNodeName());
        if (p == -1) {
            this.ensure();
            this.a[this.na] = arg;
            ++this.na;
            return null;
        }
        Node r = this.a[p];
        this.a[p] = arg;
        return r;
    }

    public Node setNamedItemNS(Node arg) {
        if (arg.getNodeType() == 2 && ((AttrImpl)arg).getOwnerElement() != null) {
            throw new DOMException(10, "The attribute already belongs to another element.");
        }
        int p = this.findNS(arg.getNamespaceURI(), arg.getLocalName());
        if (p == -1) {
            this.ensure();
            this.a[this.na] = arg;
            ++this.na;
            return null;
        }
        Node r = this.a[p];
        this.a[p] = arg;
        return r;
    }

    private int find(String name) {
        for (int i = 0; i < this.na; ++i) {
            if (!this.a[i].getNodeName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private int findNS(String uri, String local) {
        for (int i = 0; i < this.na; ++i) {
            if (!Base.areNamespaceURIEqual(this.a[i].getNamespaceURI(), uri) || !this.a[i].getLocalName().equals(local)) continue;
            return i;
        }
        return -1;
    }

    private void ensure() {
        if (this.na == this.a.length) {
            Node[] old = this.a;
            this.a = new Node[this.na * 2];
            System.arraycopy(old, 0, this.a, 0, this.na);
        }
    }

    protected NamedNodeMapImpl cloneDeep() {
        NamedNodeMapImpl r = new NamedNodeMapImpl();
        r.na = this.na;
        r.a = new Node[this.na];
        for (int i = 0; i < this.na; ++i) {
            r.a[i] = this.a[i].cloneNode(true);
        }
        return r;
    }
}

