/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.dom;

import com.sap.engine.lib.xml.Symbols;
import com.sap.engine.lib.xml.SystemProperties;
import com.sap.engine.lib.xml.dom.AttrImpl;
import com.sap.engine.lib.xml.dom.Base;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.dom.DocumentTypeImpl;
import com.sap.engine.lib.xml.dom.NodeImpl;
import java.io.Serializable;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementImpl
extends NodeImpl
implements Element,
NodeList {
    private static final int INITIAL_N_ATTRIBUTES = 4;
    private NodeImpl parent;
    private String name;
    private String prefix;
    private String uri;
    private String local;
    private AttrImpl[] attributes = null;
    private int nAttributes;
    private NamedNodeMapImplForAttributes map = null;
    static /* synthetic */ Class class$javax$xml$parsers$DocumentBuilderFactory;
    static /* synthetic */ Class class$com$sap$engine$lib$jaxp$DocumentBuilderFactoryImpl;

    public ElementImpl() {
    }

    protected ElementImpl(Document owner) {
        this.setOwnerDocument(owner);
    }

    protected void updateDefaultAttributesFromDTD(DocumentTypeImpl dtd) {
        int i = 0;
        while (i < this.nAttributes) {
            if (this.attributes[i].isDefaultAttribute()) {
                --this.nAttributes;
                this.attributes[i] = this.attributes[this.nAttributes];
                continue;
            }
            this.attributes[i].setOverriden(null);
            ++i;
        }
        if (dtd == null) {
            return;
        }
        String[][] a = dtd.getDefaultAttributes(this.name);
        if (a == null) {
            return;
        }
        String[] aQNames = a[0];
        String[] aValues = a[1];
        for (i = 0; i < aQNames.length; ++i) {
            AttrImpl attrImpl = new AttrImpl(this.getOwnerDocument()).init(DOM.qnameToURI(aQNames[i], this), aQNames[i], true, aValues[i], this, false, false);
            attrImpl.setDefaultAttribute(true);
            boolean becomesOverridden = false;
            for (int j = 0; j < this.nAttributes; ++j) {
                if (!this.attributes[j].getNodeName().equals(aQNames[i])) continue;
                this.attributes[j].setOverriden(attrImpl);
                becomesOverridden = true;
                break;
            }
            if (becomesOverridden) continue;
            if (this.attributes == null) {
                this.attributes = new AttrImpl[4];
            }
            this.ensureAttributes();
            this.attributes[this.nAttributes] = attrImpl;
            ++this.nAttributes;
        }
    }

    private void checkQualifiedName(String namespaceURI, String qualifiedName, boolean useNS) {
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if (qualifiedName == null) {
            throw new IllegalArgumentException();
        }
        if (!Symbols.isName(qualifiedName)) {
            throw new DOMException(5, "'" + qualifiedName + "' is not a valid name.");
        }
        if (!useNS) {
            return;
        }
        int indexOfColon = qualifiedName.indexOf(58);
        if (indexOfColon != qualifiedName.lastIndexOf(58)) {
            throw new DOMException(14, "More than one ':' in qualified name, '" + qualifiedName + "'");
        }
        if (indexOfColon != -1) {
            String prefix = qualifiedName.substring(0, indexOfColon);
            if (prefix.equals("xml") && !namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
                throw new DOMException(14, "Prefix is 'xml', but URI is not 'http://www.w3.org/XML/1998/namespace' in the qualified name, '" + qualifiedName + "'");
            }
            if (namespaceURI.length() == 0) {
                throw new DOMException(14, "There is a prefix, but the URI is null");
            }
        }
    }

    public final ElementImpl init(String uri, String qname, boolean useNS, NodeImpl parent, boolean doCheck) {
        super.init();
        if (doCheck) {
            this.checkQualifiedName(uri, qname, useNS);
        }
        this.parent = parent;
        this.name = qname;
        if (useNS) {
            this.prefix = DOM.qnameToPrefix(qname);
            if (this.prefix != null && this.prefix.length() == 0) {
                this.prefix = null;
            }
            this.local = DOM.qnameToLocalName(qname);
            this.uri = uri;
        } else {
            this.prefix = null;
            this.local = null;
            this.uri = null;
        }
        this.nAttributes = 0;
        return this;
    }

    public final ElementImpl init(String name, NodeImpl parent) {
        return this.init(null, name, false, parent, true);
    }

    public final ElementImpl init(String uri, String qname, NodeImpl parent) {
        return this.init(uri, qname, true, parent, true);
    }

    public String getAttribute(String name) {
        Attr attr = this.getAttributeNode(name);
        return attr == null ? "" : attr.getValue();
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        Attr attr = this.getAttributeNodeNS(namespaceURI, localName);
        return attr == null ? "" : attr.getValue();
    }

    public Attr getAttributeNode(String name) {
        for (int i = 0; i < this.nAttributes; ++i) {
            if (!this.attributes[i].getName().equals(name)) continue;
            return this.attributes[i];
        }
        return null;
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        for (int i = 0; i < this.nAttributes; ++i) {
            AttrImpl attr = this.attributes[i];
            String attrLocalName = attr.getLocalName();
            if (attrLocalName == null || !attrLocalName.equals(localName) || !ElementImpl.areNamespaceURIEqual(attr.getNamespaceURI(), namespaceURI)) continue;
            return attr;
        }
        return null;
    }

    public String getTagName() {
        return this.name;
    }

    public boolean hasAttribute(String name) {
        Attr attr = this.getAttributeNode(name);
        return attr != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        Attr attr = this.getAttributeNodeNS(namespaceURI, localName);
        return attr != null;
    }

    public void removeAttribute(String name) {
        Attr attr = this.getAttributeNode(name);
        if (attr != null) {
            this.removeAttributeNode(attr);
        }
    }

    public void removeAttributeNS(String namespaceURI, String localName) {
        Attr attr = this.getAttributeNodeNS(namespaceURI, localName);
        if (attr != null) {
            this.removeAttributeNode(attr);
        }
    }

    public Attr removeAttributeNode(Attr oldAttr) {
        AttrImpl oldAttr1 = (AttrImpl)oldAttr;
        if (oldAttr1.isDefaultAttribute()) {
            return oldAttr;
        }
        for (int i = 0; i < this.nAttributes; ++i) {
            if (this.attributes[i] != oldAttr) continue;
            if (oldAttr1.getOverridden() == null) {
                oldAttr1.setOwner(null);
                --this.nAttributes;
                this.attributes[i] = this.attributes[this.nAttributes];
                return oldAttr;
            }
            oldAttr1.setOwner(null);
            this.attributes[i] = oldAttr1.getOverridden();
            return oldAttr1;
        }
        throw new DOMException(8, "Attempt to remove an attribute from an element which is not its owner.");
    }

    public void setAttribute(String name, String value) {
        AttrImpl attr = (AttrImpl)this.getAttributeNode(name);
        if (attr != null) {
            if (attr.isDefaultAttribute()) {
                if (attr.getValue().equals(value)) {
                    return;
                }
            } else {
                attr.setNodeValue(value);
                return;
            }
        }
        attr = new AttrImpl(this.getOwnerDocument()).init(name, this, value);
        this.setAttributeNode(attr);
    }

    public void setAttributeNS(String namespaceURI, String qname, String value) {
        AttrImpl attr = (AttrImpl)this.getAttributeNodeNS(namespaceURI, qname);
        if (attr != null) {
            if (attr.isDefaultAttribute()) {
                if (attr.getValue().equals(value)) {
                    return;
                }
            } else {
                attr.setNodeValue(value);
                return;
            }
        }
        attr = new AttrImpl(this.getOwnerDocument()).init(namespaceURI, qname, this, value);
        this.setAttributeNodeNS(attr);
    }

    private AttrImpl replaceAttr(int index, AttrImpl x) {
        AttrImpl y = this.attributes[index];
        if (y.isDefaultAttribute()) {
            x.setOverriden(y);
            this.attributes[index] = x;
            return null;
        }
        AttrImpl yOverridden = y.getOverridden();
        y.setOverriden(null);
        y.setOwner(null);
        x.setOverriden(yOverridden);
        x.setOwner(this);
        this.attributes[index] = x;
        return y;
    }

    public Attr setAttributeNode(Attr newAt) {
        if (newAt == null) {
            throw new IllegalArgumentException("A null attribute cannot be set.");
        }
        AttrImpl newAttr1 = (AttrImpl)newAt;
        Element oe = newAttr1.getOwnerElement();
        if (oe != null && oe != this) {
            throw new DOMException(10, "The attribute node being set already belongs to another element.");
        }
        ElementImpl.checkCompatibleOwnerDocuments(newAttr1, this);
        String newAttrName = newAttr1.getNodeName();
        for (int i = 0; i < this.nAttributes; ++i) {
            if (!newAttrName.equals(this.attributes[i].getNodeName())) continue;
            return this.replaceAttr(i, newAttr1);
        }
        this.ensureAttributes();
        this.attributes[this.nAttributes] = newAttr1;
        newAttr1.setOwner(this);
        ++this.nAttributes;
        return null;
    }

    public Attr setAttributeNodeNS(Attr newAt) {
        if (newAt == null) {
            throw new IllegalArgumentException("A null attribute cannot be set.");
        }
        AttrImpl newAttr1 = (AttrImpl)newAt;
        Element oe = newAttr1.getOwnerElement();
        if (oe != null && oe != this) {
            throw new DOMException(10, "The attribute node being set already belongs to another element.");
        }
        ElementImpl.checkCompatibleOwnerDocuments(newAttr1, this);
        String newAttrUri = newAttr1.getNamespaceURI();
        newAttrUri = newAttrUri == null ? "" : newAttrUri;
        String newAttrLocal = newAttr1.getLocalName();
        for (int i = 0; i < this.nAttributes; ++i) {
            String uri = this.attributes[i].getNamespaceURI();
            String string = uri = uri == null ? "" : uri;
            if (!uri.equals(newAttrUri) || !this.attributes[i].getLocalName().equals(newAttrLocal)) continue;
            return this.replaceAttr(i, newAttr1);
        }
        this.ensureAttributes();
        this.attributes[this.nAttributes] = newAttr1;
        newAttr1.setOwner(this);
        ++this.nAttributes;
        return null;
    }

    private void ensureAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttrImpl[4];
        }
        if (this.attributes.length == this.nAttributes) {
            AttrImpl[] old = this.attributes;
            this.attributes = new AttrImpl[2 * this.nAttributes];
            System.arraycopy(old, 0, this.attributes, 0, this.nAttributes);
        }
    }

    public void setPrefix(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (!Symbols.isName(prefix)) {
            throw new DOMException(5, "'" + prefix + "' is not a valid prefix.");
        }
        if (prefix.indexOf(58) != -1 || prefix.equals("xml") && !"http://www.w3.org/XML/1998/namespace".equals(this.uri) || prefix.equals("xmlns") && !"http://www.w3.org/2000/xmlns/".equals(this.uri)) {
            throw new DOMException(14, "'" + prefix + "' is not a valid prefix.");
        }
        if (this.uri == null || this.uri.length() == 0) {
            throw new DOMException(14, "Can't set a prefix to an element whose uri is null");
        }
        this.prefix = prefix;
    }

    public void setNodeValue(String value) {
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeName() {
        return this.name;
    }

    public Node cloneNode(boolean deep) {
        ElementImpl r = new ElementImpl(this.getOwnerDocument());
        this.ensureAttributes();
        super.transferData(this, r, deep);
        r.parent = null;
        r.nAttributes = this.nAttributes;
        r.attributes = new AttrImpl[this.attributes.length];
        r.map = null;
        if (deep) {
            for (int i = 0; i < this.nAttributes; ++i) {
                r.attributes[i] = (AttrImpl)this.attributes[i].cloneNode(true);
                r.attributes[i].setOwner(r);
            }
        } else {
            System.arraycopy(this.attributes, 0, r.attributes, 0, this.nAttributes);
        }
        r.name = this.name;
        r.prefix = this.prefix;
        r.uri = this.uri;
        r.local = this.local;
        r.setOwnerDocument(this.getOwnerDocument());
        return r;
    }

    public NamedNodeMap getAttributes() {
        if (this.map == null) {
            this.map = new NamedNodeMapImplForAttributes();
        }
        return this.map;
    }

    public String getLocalName() {
        return this.local;
    }

    public String getNamespaceURI() {
        if (this.uri != null && this.uri.length() == 0) {
            return null;
        }
        return this.uri;
    }

    public Node getParentNode() {
        return this.parent;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean hasAttributes() {
        return this.nAttributes != 0;
    }

    protected void setParent(NodeImpl parent) {
        this.parent = parent;
    }

    public String toString() {
        return ElementImpl.serializeNode(this);
    }

    public static void main(String[] args) throws Exception {
        SystemProperties.setProperty((class$javax$xml$parsers$DocumentBuilderFactory == null ? (class$javax$xml$parsers$DocumentBuilderFactory = ElementImpl.class$("javax.xml.parsers.DocumentBuilderFactory")) : class$javax$xml$parsers$DocumentBuilderFactory).getName(), (class$com$sap$engine$lib$jaxp$DocumentBuilderFactoryImpl == null ? (class$com$sap$engine$lib$jaxp$DocumentBuilderFactoryImpl = ElementImpl.class$("com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl")) : class$com$sap$engine$lib$jaxp$DocumentBuilderFactoryImpl).getName());
        Document d = (Document)DOM.parseXMLFromAString("<!DOCTYPE a [<!ELEMENT a EMPTY><!ATTLIST a x CDATA '123'>]><a/>");
        Element a = d.getDocumentElement();
        System.out.println(a.getAttribute("x"));
        a.setAttribute("x", "567");
        System.out.println(a.getAttribute("x"));
        a.removeAttribute("x");
        System.out.println(a.getAttribute("x"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class NamedNodeMapImplForAttributes
    implements NamedNodeMap,
    Serializable {
        private NamedNodeMapImplForAttributes() {
        }

        public int getLength() {
            return ElementImpl.this.nAttributes;
        }

        public Node getNamedItem(String name) {
            return ElementImpl.this.getAttributeNode(name);
        }

        public Node getNamedItemNS(String namespaceURI, String localName) {
            return ElementImpl.this.getAttributeNodeNS(namespaceURI, localName);
        }

        public Node item(int index) {
            if (index < 0 || index >= ElementImpl.this.nAttributes) {
                return null;
            }
            return ElementImpl.this.attributes[index];
        }

        public Node removeNamedItem(String name) {
            Attr r = ElementImpl.this.getAttributeNode(name);
            if (r == null) {
                throw new DOMException(8, "There is no named item '" + name + "' in this NamedNodeMap.");
            }
            ElementImpl.this.removeAttributeNode(r);
            return r;
        }

        public Node removeNamedItemNS(String namespaceURI, String localName) {
            Attr r = ElementImpl.this.getAttributeNodeNS(namespaceURI, localName);
            if (r == null) {
                throw new DOMException(8, "There is no named item '" + ElementImpl.this.name + "' in this NamedNodeMap.");
            }
            ElementImpl.this.removeAttributeNode(r);
            return r;
        }

        public Node setNamedItem(Node arg) {
            Base.checkCompatibleOwnerDocuments(ElementImpl.this, arg);
            return ElementImpl.this.setAttributeNode((Attr)arg);
        }

        public Node setNamedItemNS(Node arg) {
            Base.checkCompatibleOwnerDocuments(ElementImpl.this, arg);
            return ElementImpl.this.setAttributeNodeNS((Attr)arg);
        }
    }
}

