/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.dom;

import com.sap.engine.lib.xml.Symbols;
import com.sap.engine.lib.xml.dom.AttrImpl;
import com.sap.engine.lib.xml.dom.DocumentImpl;
import com.sap.engine.lib.xml.dom.DocumentTypeImpl;
import com.sap.engine.lib.xml.dom.ElementImpl;
import com.sap.engine.lib.xml.dom.EntityImpl;
import com.sap.engine.lib.xml.dom.NotationImpl;
import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.dtd.XMLValidator;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Entity;
import com.sap.engine.lib.xml.parser.helpers.Reference;
import java.net.URL;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public final class DOMDocHandler1
implements DocHandler {
    private DocumentImpl documentImpl;
    private Document document;
    private Node root;
    private Node currentNode;
    private ErrorHandler errorHandler;
    private Element element;
    private DocumentType dtd;
    private boolean isInDTD;
    private boolean firstElementReached;
    private boolean isIgnoringComments = false;
    private XMLValidator xmlValidator = null;
    private boolean useCreateMethods = false;
    private boolean optionTrimWhiteSpace;
    private boolean isAttributeSpecified = true;
    private Hashtable chdhash = new Hashtable();
    private Hashtable qnhash = new Hashtable();
    private Hashtable urihash = new Hashtable();
    private static final int chdmaxsize = 100;
    private static final int qnmaxsize = 100;
    private static final int urimaxsize = 100;
    private int chdcursize = 0;
    private int qncursize = 0;
    private int uricursize = 0;
    private Object tmp = null;
    private CharArray tmp2 = null;
    private String tmps = null;
    static /* synthetic */ Class class$com$sap$engine$lib$xml$dom$DocumentImpl;

    public DOMDocHandler1() {
        this.documentImpl = new DocumentImpl().init(null, null);
        this.document = this.documentImpl;
        this.useCreateMethods = false;
        this.root = this.document;
    }

    public DOMDocHandler1(Document document) {
        if (document instanceof DocumentImpl) {
            this.documentImpl = (DocumentImpl)document;
            this.document = this.documentImpl;
            this.useCreateMethods = document.getClass() != (class$com$sap$engine$lib$xml$dom$DocumentImpl == null ? (class$com$sap$engine$lib$xml$dom$DocumentImpl = DOMDocHandler1.class$("com.sap.engine.lib.xml.dom.DocumentImpl")) : class$com$sap$engine$lib$xml$dom$DocumentImpl);
        } else {
            this.document = document;
        }
        this.root = document;
    }

    public DOMDocHandler1(Node node) {
        if (node.getNodeType() == 9) {
            Document document = (Document)node;
            if (document instanceof DocumentImpl) {
                this.documentImpl = (DocumentImpl)document;
                this.document = this.documentImpl;
                this.useCreateMethods = document.getClass() != (class$com$sap$engine$lib$xml$dom$DocumentImpl == null ? (class$com$sap$engine$lib$xml$dom$DocumentImpl = DOMDocHandler1.class$("com.sap.engine.lib.xml.dom.DocumentImpl")) : class$com$sap$engine$lib$xml$dom$DocumentImpl);
            } else {
                this.document = document;
            }
            this.root = document;
            return;
        }
        this.document = node.getOwnerDocument();
        if (this.document == null) {
            this.document = new DocumentImpl().init(null, null);
            this.useCreateMethods = false;
        } else {
            this.useCreateMethods = this.document.getClass() != (class$com$sap$engine$lib$xml$dom$DocumentImpl == null ? (class$com$sap$engine$lib$xml$dom$DocumentImpl = DOMDocHandler1.class$("com.sap.engine.lib.xml.dom.DocumentImpl")) : class$com$sap$engine$lib$xml$dom$DocumentImpl);
            this.useCreateMethods = this.document.getClass() != (class$com$sap$engine$lib$xml$dom$DocumentImpl == null ? (class$com$sap$engine$lib$xml$dom$DocumentImpl = DOMDocHandler1.class$("com.sap.engine.lib.xml.dom.DocumentImpl")) : class$com$sap$engine$lib$xml$dom$DocumentImpl);
        }
        this.root = node;
    }

    public void setIgnoringComments(boolean b) {
        this.isIgnoringComments = b;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setXMLValidator(XMLValidator inst) {
        this.xmlValidator = inst;
    }

    public void onXMLDecl(String v, String e, String s) {
    }

    public void startDocument() throws Exception {
        this.chdhash = new Hashtable();
        this.qnhash = new Hashtable();
        this.urihash = new Hashtable();
        this.currentNode = this.root == null ? this.document : this.root;
        this.isInDTD = false;
        this.firstElementReached = false;
    }

    public void startElementStart(CharArray uri, CharArray localName, CharArray qname) throws Exception {
        if (uri == null) {
            uri = CharArray.EMPTY;
        }
        String qnstring = this.getQn(qname);
        String uristring = this.getUri(uri);
        this.element = this.useCreateMethods ? this.document.createElementNS(uristring, qnstring) : new ElementImpl(this.document).init(uristring, qnstring, true, null, false);
        if (!this.firstElementReached) {
            this.currentNode = this.root;
            this.firstElementReached = true;
        }
    }

    public String getChd(CharArray item) {
        item.bufferHash();
        this.tmp = this.chdhash.get(item);
        item.clearHashReady();
        if (this.tmp == null && this.chdcursize < 100) {
            this.tmp2 = item.copy();
            this.tmps = this.tmp2.getString();
            this.tmp2.bufferHash();
            this.chdhash.put(this.tmp2, this.tmps);
            ++this.chdcursize;
            return this.tmps;
        }
        if (this.chdcursize == 100) {
            return item.getString();
        }
        return (String)this.tmp;
    }

    public String getQn(CharArray item) {
        item.bufferHash();
        this.tmp = this.qnhash.get(item);
        item.clearHashReady();
        if (this.tmp == null && this.qncursize < 100) {
            this.tmp2 = item.copy();
            this.tmps = this.tmp2.getString();
            this.tmp2.bufferHash();
            this.qnhash.put(this.tmp2, this.tmps);
            ++this.qncursize;
            return this.tmps;
        }
        if (this.qncursize == 100) {
            return item.getString();
        }
        return (String)this.tmp;
    }

    public String getUri(CharArray item) {
        item.bufferHash();
        this.tmp = this.urihash.get(item);
        item.clearHashReady();
        if (this.tmp == null && this.uricursize < 100) {
            this.tmp2 = item.copy();
            this.tmps = this.tmp2.getString();
            this.tmp2.bufferHash();
            this.urihash.put(this.tmp2, this.tmps);
            ++this.uricursize;
            return this.tmps;
        }
        if (this.uricursize == 100) {
            return item.getString();
        }
        return (String)this.tmp;
    }

    public void addAttribute(CharArray suri, CharArray prefix, CharArray localName, CharArray qnameCA, String type, CharArray valueCA) throws Exception {
        Attr attr;
        String qname = this.getQn(qnameCA);
        String value = this.getUri(valueCA);
        if (suri == null) {
            suri = CharArray.EMPTY;
        }
        String uri = this.getUri(suri);
        if (!this.isAttributeSpecified && qname.startsWith("xml:")) {
            this.isAttributeSpecified = true;
            return;
        }
        if (qname.startsWith("xmlns")) {
            uri = "http://www.w3.org/2000/xmlns/";
        }
        if (this.useCreateMethods) {
            attr = this.document.createAttributeNS(uri, qname);
            attr.setNodeValue(valueCA.toString());
        } else {
            attr = new AttrImpl(this.document).init(uri, qname, true, value, null, false, this.isAttributeSpecified);
        }
        try {
            this.element.setAttributeNodeNS(attr);
        }
        catch (NoSuchMethodError e) {
            this.element.setAttributeNode(attr);
        }
        this.isAttributeSpecified = true;
    }

    public void startElementEnd(boolean isEmpty) throws Exception {
        this.currentNode = this.currentNode.appendChild(this.element);
    }

    public void endElement(CharArray uri, CharArray localName, CharArray qname, boolean isEmpty) throws Exception {
        this.currentNode = this.currentNode.getParentNode();
    }

    public void endDocument() {
        if (this.documentImpl != null) {
            this.documentImpl.updateDTDForAllElements();
        }
        this.currentNode = null;
    }

    public void charData(CharArray data, boolean bDisableOutputEscaping) {
        if (this.optionTrimWhiteSpace && this.xmlValidator != null && this.xmlValidator.getElementContentSpec(this.currentNode.getNodeName()) == 4 && DOMDocHandler1.isWhitespace(data)) {
            return;
        }
        String s = this.getChd(data);
        Text text = this.document.createTextNode(s);
        this.currentNode.appendChild(text);
    }

    public void onPI(CharArray targetCA, CharArray dataCA) {
        String target = targetCA.getString();
        String data = dataCA.getString();
        ProcessingInstruction pi = this.document.createProcessingInstruction(target, data);
        this.currentNode.appendChild(pi);
    }

    public void onComment(CharArray text) {
        if (this.isIgnoringComments) {
            return;
        }
        if (this.isInDTD) {
            return;
        }
        Comment comment = this.document.createComment(text.getString());
        this.currentNode.appendChild(comment);
    }

    public void onCDSect(CharArray text) {
        CDATASection cd = this.document.createCDATASection(text.getString());
        this.currentNode.appendChild(cd);
    }

    public void startDTD(CharArray nameCA, CharArray pubCA, CharArray sysCA) {
        String name = nameCA.getString();
        String publicId = pubCA.getString();
        String systemId = sysCA.getString();
        publicId = "".equals(publicId) ? null : publicId;
        String string = systemId = "".equals(systemId) ? null : systemId;
        if (this.documentImpl != null) {
            this.dtd = new DocumentTypeImpl().init(name, publicId, systemId, this.documentImpl);
            this.documentImpl.setDTD(this.dtd);
        } else {
            this.dtd = this.document.getImplementation().createDocumentType(name, publicId, systemId);
            this.documentImpl.appendChild(this.dtd);
        }
        this.isInDTD = true;
    }

    public void onDTDEntity(Entity ent) {
        if (!ent.isPE()) {
            String name = ent.getName().getString();
            String publicId = ent.getPub().getString();
            String systemId = ent.getSys().getString();
            CharArray notationNameCA = ent.getNote();
            String notationName = notationNameCA == null ? "" : notationNameCA.getString();
            publicId = publicId.length() == 0 ? null : publicId;
            systemId = systemId.length() == 0 ? null : systemId;
            notationName = notationName.length() == 0 ? null : notationName;
            String value = "";
            if (ent.isInternal()) {
                try {
                    value = ent.getValue().toString();
                }
                catch (Exception e) {
                    value = "";
                }
            }
            EntityImpl entity = new EntityImpl().init(name, publicId, systemId, value, this.document);
            entity.setNotationName(notationName);
            this.dtd.getEntities().setNamedItem(entity);
        }
    }

    public void onDTDNotation(CharArray nameCA, CharArray pubCA, CharArray sysCA) {
        String name = nameCA.getString();
        String publicId = pubCA.getString();
        String systemId = sysCA.getString();
        publicId = publicId.equals("") ? null : publicId;
        systemId = systemId.equals("") ? null : systemId;
        NotationImpl notation = new NotationImpl().init(name, publicId, systemId);
        this.dtd.getNotations().setNamedItem(notation);
    }

    public void onDTDElement(CharArray name, CharArray model) {
    }

    public void onDTDAttListItem(CharArray elementName, CharArray attributeName, String type, String defaultDeclaration, CharArray vAttValue, String note) {
        if (this.documentImpl != null) {
            String attValue;
            if ("ID".equals(type)) {
                this.documentImpl.addIdAttribute(elementName.getString(), attributeName.getString());
            }
            if ((attValue = vAttValue.getString()).length() != 0) {
                this.documentImpl.addDefaultAttribute(elementName.getString(), attributeName.getString(), vAttValue.getString());
            }
        }
    }

    public void onDTDAttListStart(CharArray name) {
    }

    public void onDTDAttListEnd() {
    }

    public void endDTD() {
        this.isInDTD = false;
    }

    public void onContentReference(Reference ref) {
    }

    public void startPrefixMapping(CharArray prefix, CharArray uri) {
    }

    public void endPrefixMapping(CharArray prefix) {
    }

    public void setDOMTrimWhiteSpaces(boolean value) {
        this.optionTrimWhiteSpace = value;
    }

    public void onWarning(String warning) throws Exception {
        if (this.errorHandler != null) {
            this.errorHandler.warning(new SAXParseException(warning, null));
        }
    }

    public void setErrorHandler(ErrorHandler e) {
        this.errorHandler = e;
    }

    public static boolean isWhitespace(CharArray c) {
        for (int i = 0; i < c.length(); ++i) {
            if (Symbols.isWhitespace(c.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void onStartContentEntity(CharArray name, boolean isExpanding) {
        if (!isExpanding) {
            this.currentNode.appendChild(this.document.createEntityReference(name.toString()));
        }
    }

    public void onEndContentEntity(CharArray name) {
    }

    public void onCustomEvent(int eventId, Object obj) throws Exception {
        switch (eventId) {
            case 1000: {
                this.isAttributeSpecified = false;
                break;
            }
            case 1001: {
                if (this.documentImpl == null) break;
                this.documentImpl.setLocation((URL)obj);
                break;
            }
            case 1002: {
                if (this.documentImpl == null) break;
                this.documentImpl.setNamespaceAwareness(Boolean.TRUE.equals(obj) ? 1 : 0);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

