/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml;

public final class Symbols {
    private static int[] basechars = null;

    public static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t';
    }

    public static boolean isWhitespaceNo13(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\t';
    }

    public static boolean isNameChar(char ch) {
        return Symbols.isLetter(ch) || Symbols.isDigit(ch) || ch == '.' || ch == '-' || ch == '_' || ch == ':' || Symbols.isCombiningChar(ch) || Symbols.isExtender(ch);
    }

    public static boolean isInitialNameChar(char ch) {
        return Symbols.isLetter(ch) || ch == '_' || ch == ':';
    }

    public static boolean isLetterOrDigitAndSpace(char ch) {
        return Symbols.isWhitespace(ch) || Symbols.isLetter(ch) || Symbols.isDigit(ch);
    }

    public static boolean isLetterOrDigit(char ch) {
        return Symbols.isLetter(ch) || Symbols.isDigit(ch);
    }

    public static boolean isChar(char ch) {
        return ch == '\t' || ch == '\n' || ch == '\r' || ch != '&' && ch >= ' ' && ch <= '\ud7ff' || ch >= '\ue000' && ch <= '\ufffd' || ch >= '\u10000' && ch <= '\u10ffff';
    }

    public static boolean isValidChar(char ch) {
        return ch >= ' ' && ch <= '\ud7ff' || ch == '\r' || ch == '\n' || ch == '\t' || ch >= '\ue000' && ch <= '\ufffd' || ch >= '\u10000' && ch <= '\u10ffff';
    }

    public static boolean isLetter(char ch) {
        return Symbols.isBaseChar(ch) || Symbols.isIdeographic(ch);
    }

    public static boolean isBase(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '\u00c0' && ch <= '\u00d6' || ch >= '\u00d8' && ch <= '\u00f6' || ch >= '\u00f8' && ch <= '\u00ff' || ch >= '\u0100' && ch <= '\u0131' || ch >= '\u0134' && ch <= '\u013e' || ch >= '\u0141' && ch <= '\u0148' || ch >= '\u014a' && ch <= '\u017e' || ch >= '\u0180' && ch <= '\u01c3' || ch >= '\u01cd' && ch <= '\u01f0' || ch >= '\u01f4' && ch <= '\u01f5' || ch >= '\u01fa' && ch <= '\u0217' || ch >= '\u0250' && ch <= '\u02a8' || ch >= '\u02bb' && ch <= '\u02c1' || ch == '\u0386' || ch >= '\u0388' && ch <= '\u038a' || ch == '\u038c' || ch >= '\u038e' && ch <= '\u03a1' || ch >= '\u03a3' && ch <= '\u03ce' || ch >= '\u03d0' && ch <= '\u03d6' || ch == '\u03da' || ch == '\u03dc' || ch == '\u03de' || ch == '\u03e0' || ch >= '\u03e2' && ch <= '\u03f3' || ch >= '\u0401' && ch <= '\u040c' || ch >= '\u040e' && ch <= '\u044f' || ch >= '\u0451' && ch <= '\u045c' || ch >= '\u045e' && ch <= '\u0481' || ch >= '\u0490' && ch <= '\u04c4' || ch >= '\u04c7' && ch <= '\u04c8' || ch >= '\u04cb' && ch <= '\u04cc' || ch >= '\u04d0' && ch <= '\u04eb' || ch >= '\u04ee' && ch <= '\u04f5' || ch >= '\u04f8' && ch <= '\u04f9' || ch >= '\u0531' && ch <= '\u0556' || ch == '\u0559' || ch >= '\u0561' && ch <= '\u0586' || ch >= '\u05d0' && ch <= '\u05ea' || ch >= '\u05f0' && ch <= '\u05f2' || ch >= '\u0621' && ch <= '\u063a' || ch >= '\u0641' && ch <= '\u064a' || ch >= '\u0671' && ch <= '\u06b7' || ch >= '\u06ba' && ch <= '\u06be' || ch >= '\u06c0' && ch <= '\u06ce' || ch >= '\u06d0' && ch <= '\u06d3' || ch == '\u06d5' || ch >= '\u06e5' && ch <= '\u06e6' || ch >= '\u0905' && ch <= '\u0939' || ch == '\u093d' || ch >= '\u0958' && ch <= '\u0961' || ch >= '\u0985' && ch <= '\u098c' || ch >= '\u098f' && ch <= '\u0990' || ch >= '\u0993' && ch <= '\u09a8' || ch >= '\u09aa' && ch <= '\u09b0' || ch == '\u09b2' || ch >= '\u09b6' && ch <= '\u09b9' || ch >= '\u09dc' && ch <= '\u09dd' || ch >= '\u09df' && ch <= '\u09e1' || ch >= '\u09f0' && ch <= '\u09f1' || ch >= '\u0a05' && ch <= '\u0a0a' || ch >= '\u0a0f' && ch <= '\u0a10' || ch >= '\u0a13' && ch <= '\u0a28' || ch >= '\u0a2a' && ch <= '\u0a30' || ch >= '\u0a32' && ch <= '\u0a33' || ch >= '\u0a35' && ch <= '\u0a36' || ch >= '\u0a38' && ch <= '\u0a39' || ch >= '\u0a59' && ch <= '\u0a5c' || ch == '\u0a5e' || ch >= '\u0a72' && ch <= '\u0a74' || ch >= '\u0a85' && ch <= '\u0a8b' || ch == '\u0a8d' || ch >= '\u0a8f' && ch <= '\u0a91' || ch >= '\u0a93' && ch <= '\u0aa8' || ch >= '\u0aaa' && ch <= '\u0ab0' || ch >= '\u0ab2' && ch <= '\u0ab3' || ch >= '\u0ab5' && ch <= '\u0ab9' || ch == '\u0abd' || ch == '\u0ae0' || ch >= '\u0b05' && ch <= '\u0b0c' || ch >= '\u0b0f' && ch <= '\u0b10' || ch >= '\u0b13' && ch <= '\u0b28' || ch >= '\u0b2a' && ch <= '\u0b30' || ch >= '\u0b32' && ch <= '\u0b33' || ch >= '\u0b36' && ch <= '\u0b39' || ch == '\u0b3d' || ch >= '\u0b5c' && ch <= '\u0b5d' || ch >= '\u0b5f' && ch <= '\u0b61' || ch >= '\u0b85' && ch <= '\u0b8a' || ch >= '\u0b8e' && ch <= '\u0b90' || ch >= '\u0b92' && ch <= '\u0b95' || ch >= '\u0b99' && ch <= '\u0b9a' || ch == '\u0b9c' || ch >= '\u0b9e' && ch <= '\u0b9f' || ch >= '\u0ba3' && ch <= '\u0ba4' || ch >= '\u0ba8' && ch <= '\u0baa' || ch >= '\u0bae' && ch <= '\u0bb5' || ch >= '\u0bb7' && ch <= '\u0bb9' || ch >= '\u0c05' && ch <= '\u0c0c' || ch >= '\u0c0e' && ch <= '\u0c10' || ch >= '\u0c12' && ch <= '\u0c28' || ch >= '\u0c2a' && ch <= '\u0c33' || ch >= '\u0c35' && ch <= '\u0c39' || ch >= '\u0c60' && ch <= '\u0c61' || ch >= '\u0c85' && ch <= '\u0c8c' || ch >= '\u0c8e' && ch <= '\u0c90' || ch >= '\u0c92' && ch <= '\u0ca8' || ch >= '\u0caa' && ch <= '\u0cb3' || ch >= '\u0cb5' && ch <= '\u0cb9' || ch == '\u0cde' || ch >= '\u0ce0' && ch <= '\u0ce1' || ch >= '\u0d05' && ch <= '\u0d0c' || ch >= '\u0d0e' && ch <= '\u0d10' || ch >= '\u0d12' && ch <= '\u0d28' || ch >= '\u0d2a' && ch <= '\u0d39' || ch >= '\u0d60' && ch <= '\u0d61' || ch >= '\u0e01' && ch <= '\u0e2e' || ch == '\u0e30' || ch >= '\u0e32' && ch <= '\u0e33' || ch >= '\u0e40' && ch <= '\u0e45' || ch >= '\u0e81' && ch <= '\u0e82' || ch == '\u0e84' || ch >= '\u0e87' && ch <= '\u0e88' || ch == '\u0e8a' || ch == '\u0e8d' || ch >= '\u0e94' && ch <= '\u0e97' || ch >= '\u0e99' && ch <= '\u0e9f' || ch >= '\u0ea1' && ch <= '\u0ea3' || ch == '\u0ea5' || ch == '\u0ea7' || ch >= '\u0eaa' && ch <= '\u0eab' || ch >= '\u0ead' && ch <= '\u0eae' || ch == '\u0eb0' || ch >= '\u0eb2' && ch <= '\u0eb3' || ch == '\u0ebd' || ch >= '\u0ec0' && ch <= '\u0ec4' || ch >= '\u0f40' && ch <= '\u0f47' || ch >= '\u0f49' && ch <= '\u0f69' || ch >= '\u10a0' && ch <= '\u10c5' || ch >= '\u10d0' && ch <= '\u10f6' || ch == '\u1100' || ch >= '\u1102' && ch <= '\u1103' || ch >= '\u1105' && ch <= '\u1107' || ch == '\u1109' || ch >= '\u110b' && ch <= '\u110c' || ch >= '\u110e' && ch <= '\u1112' || ch == '\u113c' || ch == '\u113e' || ch == '\u1140' || ch == '\u114c' || ch == '\u114e' || ch == '\u1150' || ch >= '\u1154' && ch <= '\u1155' || ch == '\u1159' || ch >= '\u115f' && ch <= '\u1161' || ch == '\u1163' || ch == '\u1165' || ch == '\u1167' || ch == '\u1169' || ch >= '\u116d' && ch <= '\u116e' || ch >= '\u1172' && ch <= '\u1173' || ch == '\u1175' || ch == '\u119e' || ch == '\u11a8' || ch == '\u11ab' || ch >= '\u11ae' && ch <= '\u11af' || ch >= '\u11b7' && ch <= '\u11b8' || ch == '\u11ba' || ch >= '\u11bc' && ch <= '\u11c2' || ch == '\u11eb' || ch == '\u11f0' || ch == '\u11f9' || ch >= '\u1e00' && ch <= '\u1e9b' || ch >= '\u1ea0' && ch <= '\u1ef9' || ch >= '\u1f00' && ch <= '\u1f15' || ch >= '\u1f18' && ch <= '\u1f1d' || ch >= '\u1f20' && ch <= '\u1f45' || ch >= '\u1f48' && ch <= '\u1f4d' || ch >= '\u1f50' && ch <= '\u1f57' || ch == '\u1f59' || ch == '\u1f5b' || ch == '\u1f5d' || ch >= '\u1f5f' && ch <= '\u1f7d' || ch >= '\u1f80' && ch <= '\u1fb4' || ch >= '\u1fb6' && ch <= '\u1fbc' || ch == '\u1fbe' || ch >= '\u1fc2' && ch <= '\u1fc4' || ch >= '\u1fc6' && ch <= '\u1fcc' || ch >= '\u1fd0' && ch <= '\u1fd3' || ch >= '\u1fd6' && ch <= '\u1fdb' || ch >= '\u1fe0' && ch <= '\u1fec' || ch >= '\u1ff2' && ch <= '\u1ff4' || ch >= '\u1ff6' && ch <= '\u1ffc' || ch == '\u2126' || ch >= '\u212a' && ch <= '\u212b' || ch == '\u212e' || ch >= '\u2180' && ch <= '\u2182' || ch >= '\u3041' && ch <= '\u3094' || ch >= '\u30a1' && ch <= '\u30fa' || ch >= '\u3105' && ch <= '\u312c' || ch >= '\uac00' && ch <= '\ud7a3';
    }

    private static void fillBaseChars() {
        for (char i = '\u0000'; i < '\ud7a4'; i = (char)(i + '\u0001')) {
            int N = i >> 5;
            if (!Symbols.isBase(i)) continue;
            Symbols.basechars[N] = basechars[N] | 1 << (i & 0x1F);
        }
    }

    public static boolean isLetterOrDigitSimple(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9';
    }

    public static boolean isBaseChar(char ch) {
        if (ch > '\ud7a3') {
            return false;
        }
        return (basechars[ch >> 5] & 1 << (ch & 0x1F)) != 0;
    }

    public static boolean isIdeographic(char ch) {
        return ch >= '\u4e00' && ch <= '\u9fa5' || ch == '\u3007' || ch >= '\u3021' && ch <= '\u3029';
    }

    public static boolean isCombiningChar(char ch) {
        return ch >= '\u0300' && ch <= '\u0345' || ch >= '\u0360' && ch <= '\u0361' || ch >= '\u0483' && ch <= '\u0486' || ch >= '\u0591' && ch <= '\u05a1' || ch >= '\u05a3' && ch <= '\u05b9' || ch >= '\u05bb' && ch <= '\u05bd' || ch == '\u05bf' || ch >= '\u05c1' && ch <= '\u05c2' || ch == '\u05c4' || ch >= '\u064b' && ch <= '\u0652' || ch == '\u0670' || ch >= '\u06d6' && ch <= '\u06dc' || ch >= '\u06dd' && ch <= '\u06df' || ch >= '\u06e0' && ch <= '\u06e4' || ch >= '\u06e7' && ch <= '\u06e8' || ch >= '\u06ea' && ch <= '\u06ed' || ch >= '\u0901' && ch <= '\u0903' || ch == '\u093c' || ch >= '\u093e' && ch <= '\u094c' || ch == '\u094d' || ch >= '\u0951' && ch <= '\u0954' || ch >= '\u0962' && ch <= '\u0963' || ch >= '\u0981' && ch <= '\u0983' || ch == '\u09bc' || ch == '\u09be' || ch == '\u09bf' || ch >= '\u09c0' && ch <= '\u09c4' || ch >= '\u09c7' && ch <= '\u09c8' || ch >= '\u09cb' && ch <= '\u09cd' || ch == '\u09d7' || ch >= '\u09e2' && ch <= '\u09e3' || ch == '\u0a02' || ch == '\u0a3c' || ch == '\u0a3e' || ch == '\u0a3f' || ch >= '\u0a40' && ch <= '\u0a42' || ch >= '\u0a47' && ch <= '\u0a48' || ch >= '\u0a4b' && ch <= '\u0a4d' || ch >= '\u0a70' && ch <= '\u0a71' || ch >= '\u0a81' && ch <= '\u0a83' || ch == '\u0abc' || ch >= '\u0abe' && ch <= '\u0ac5' || ch >= '\u0ac7' && ch <= '\u0ac9' || ch >= '\u0acb' && ch <= '\u0acd' || ch >= '\u0b01' && ch <= '\u0b03' || ch == '\u0b3c' || ch >= '\u0b3e' && ch <= '\u0b43' || ch >= '\u0b47' && ch <= '\u0b48' || ch >= '\u0b4b' && ch <= '\u0b4d' || ch >= '\u0b56' && ch <= '\u0b57' || ch >= '\u0b82' && ch <= '\u0b83' || ch >= '\u0bbe' && ch <= '\u0bc2' || ch >= '\u0bc6' && ch <= '\u0bc8' || ch >= '\u0bca' && ch <= '\u0bcd' || ch == '\u0bd7' || ch >= '\u0c01' && ch <= '\u0c03' || ch >= '\u0c3e' && ch <= '\u0c44' || ch >= '\u0c46' && ch <= '\u0c48' || ch >= '\u0c4a' && ch <= '\u0c4d' || ch >= '\u0c55' && ch <= '\u0c56' || ch >= '\u0c82' && ch <= '\u0c83' || ch >= '\u0cbe' && ch <= '\u0cc4' || ch >= '\u0cc6' && ch <= '\u0cc8' || ch >= '\u0cca' && ch <= '\u0ccd' || ch >= '\u0cd5' && ch <= '\u0cd6' || ch >= '\u0d02' && ch <= '\u0d03' || ch >= '\u0d3e' && ch <= '\u0d43' || ch >= '\u0d46' && ch <= '\u0d48' || ch >= '\u0d4a' && ch <= '\u0d4d' || ch == '\u0d57' || ch == '\u0e31' || ch >= '\u0e34' && ch <= '\u0e3a' || ch >= '\u0e47' && ch <= '\u0e4e' || ch == '\u0eb1' || ch >= '\u0eb4' && ch <= '\u0eb9' || ch >= '\u0ebb' && ch <= '\u0ebc' || ch >= '\u0ec8' && ch <= '\u0ecd' || ch >= '\u0f18' && ch <= '\u0f19' || ch == '\u0f35' || ch == '\u0f37' || ch == '\u0f39' || ch == '\u0f3e' || ch == '\u0f3f' || ch >= '\u0f71' && ch <= '\u0f84' || ch >= '\u0f86' && ch <= '\u0f8b' || ch >= '\u0f90' && ch <= '\u0f95' || ch == '\u0f97' || ch >= '\u0f99' && ch <= '\u0fad' || ch >= '\u0fb1' && ch <= '\u0fb7' || ch == '\u0fb9' || ch >= '\u20d0' && ch <= '\u20dc' || ch == '\u20e1' || ch >= '\u302a' && ch <= '\u302f' || ch == '\u3099' || ch == '\u309a';
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9' || ch >= '\u0660' && ch <= '\u0669' || ch >= '\u06f0' && ch <= '\u06f9' || ch >= '\u0966' && ch <= '\u096f' || ch >= '\u09e6' && ch <= '\u09ef' || ch >= '\u0a66' && ch <= '\u0a6f' || ch >= '\u0ae6' && ch <= '\u0aef' || ch >= '\u0b66' && ch <= '\u0b6f' || ch >= '\u0be7' && ch <= '\u0bef' || ch >= '\u0c66' && ch <= '\u0c6f' || ch >= '\u0ce6' && ch <= '\u0cef' || ch >= '\u0d66' && ch <= '\u0d6f' || ch >= '\u0e50' && ch <= '\u0e59' || ch >= '\u0ed0' && ch <= '\u0ed9' || ch >= '\u0f20' && ch <= '\u0f29';
    }

    public static boolean isExtender(char ch) {
        return ch == '\u00b7' || ch == '\u02d0' || ch == '\u02d1' || ch == '\u0387' || ch == '\u0640' || ch == '\u0e46' || ch == '\u0ec6' || ch == '\u3005' || ch >= '\u3031' && ch <= '\u3035' || ch >= '\u309d' && ch <= '\u309e' || ch >= '\u30fc' && ch <= '\u30fe';
    }

    public static boolean isName(String s) {
        if (s == null || s.length() == 0 || !Symbols.isInitialNameChar(s.charAt(0))) {
            return false;
        }
        char[] a = s.toCharArray();
        for (int i = 1; i < a.length; ++i) {
            if (Symbols.isNameChar(a[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(String s) {
        char[] a = s.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            if (Symbols.isWhitespace(a[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNmtoken(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] a = s.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            if (Symbols.isNameChar(a[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNmtokens(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] a = s.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            if (Symbols.isNameChar(a[i]) || Symbols.isWhitespace(a[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNCName(String s) {
        return Symbols.isName(s) && s.indexOf(58) == -1;
    }

    static {
        basechars = new int[1726];
        Symbols.fillBaseChars();
    }
}

