/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml;

import com.sap.engine.lib.xml.StandardDOMParser;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StandardDOMWriterOpt {
    private BufferedOutputStream out = null;
    private FileWriter fileWriter = null;
    private String dtd;
    private boolean canonical = false;
    private int counter = 0;
    private static int NL = 10;

    public StandardDOMWriterOpt() {
    }

    public StandardDOMWriterOpt(boolean _canonical) {
        this.canonical = _canonical;
    }

    private void print(Node node, String dest) throws IOException {
        this.out = new BufferedOutputStream(new FileOutputStream(dest));
        this.print(node);
        this.out.close();
    }

    private void writeOut(String s) throws IOException {
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            this.writeOut((byte)s.charAt(i));
        }
    }

    private void writeOut(char ch) throws IOException {
        this.writeOut((byte)ch);
    }

    private void writeOut(byte ch) throws IOException {
        this.writeOut((int)ch);
    }

    private void writeOut(int ch) throws IOException {
        if (this.out != null) {
            this.out.write(ch);
        } else if (this.fileWriter != null) {
            this.fileWriter.write(ch);
        }
    }

    private void print(Node node) throws IOException {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                if (!this.canonical) {
                    this.writeOut("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                    this.writeOut(10);
                    if (this.dtd != null) {
                        this.writeOut(this.dtd);
                        this.writeOut(NL);
                    }
                }
                this.print(((Document)node).getDocumentElement());
                this.out.flush();
                break;
            }
            case 1: {
                this.writeOut(NL);
                ++this.counter;
                this.addEmptySpace(this.out, this.counter);
                this.writeOut('<');
                this.writeOut(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                Attr attr = null;
                for (int i = 0; i < attrs.length; ++i) {
                    attr = attrs[i];
                    this.writeOut(' ');
                    this.writeOut(attr.getNodeName());
                    this.writeOut("=\"");
                    this.normalize(attr.getNodeValue());
                    this.writeOut('\"');
                }
                this.writeOut('>');
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    this.print(children.item(i));
                }
                break;
            }
            case 5: {
                if (this.canonical) {
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    for (int i = 0; i < len; ++i) {
                        this.print(children.item(i));
                    }
                    break;
                }
                this.writeOut('&');
                this.writeOut(node.getNodeName());
                this.writeOut(';');
                break;
            }
            case 4: {
                if (this.canonical) {
                    this.normalize(node.getNodeValue());
                    break;
                }
                this.writeOut("<![CDATA[");
                this.writeOut(node.getNodeValue());
                this.writeOut("]]>");
                break;
            }
            case 3: {
                if (StandardDOMParser.isWhiteSpace(node.getNodeValue())) break;
                this.writeOut(NL);
                ++this.counter;
                this.addEmptySpace(this.out, this.counter);
                this.normalize(node.getNodeValue().trim());
                --this.counter;
                break;
            }
            case 7: {
                this.writeOut("<?");
                this.writeOut(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.writeOut(' ');
                    this.writeOut(data);
                }
                this.writeOut("?>");
                break;
            }
        }
        if (type == 1) {
            this.writeOut(NL);
            this.addEmptySpace(this.out, this.counter);
            this.writeOut("</");
            this.writeOut(node.getNodeName());
            this.writeOut('>');
            --this.counter;
        }
    }

    private void addEmptySpace(OutputStream out, int counter) throws IOException {
        for (int i = 0; i < counter; ++i) {
            this.writeOut(' ');
            this.writeOut(' ');
        }
    }

    public void write(Document doc, String dest, String _dtd) throws IOException {
        this.dtd = _dtd;
        this.counter = 0;
        this.out = null;
        this.fileWriter = null;
        this.print(doc, dest);
        this.out.close();
        this.dtd = null;
    }

    public void write(Document doc, OutputStream stream, String _dtd) throws IOException {
        this.dtd = _dtd;
        this.counter = 0;
        this.out = new BufferedOutputStream(stream);
        this.fileWriter = null;
        this.print(doc);
        this.dtd = null;
    }

    public void write(Document doc, FileWriter fw, String _dtd) throws IOException {
        this.dtd = _dtd;
        this.fileWriter = fw;
        this.out = null;
        this.counter = 0;
        this.print(doc);
        this.dtd = null;
    }

    protected void normalize(String s) throws IOException {
        int len = s != null ? s.length() : 0;
        char ch = '\u0000';
        block7: for (int i = 0; i < len; ++i) {
            ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    this.writeOut("&lt;");
                    continue block7;
                }
                case '>': {
                    this.writeOut("&gt;");
                    continue block7;
                }
                case '&': {
                    this.writeOut("&amp;");
                    continue block7;
                }
                case '\"': {
                    this.writeOut("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    if (this.canonical) {
                        this.writeOut("&#");
                        this.writeOut(Integer.toString(ch));
                        this.writeOut(';');
                        continue block7;
                    }
                }
                default: {
                    this.writeOut((int)ch);
                }
            }
        }
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        for (int i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        String name = null;
        int index = -1;
        String curName = null;
        for (int i = 0; i < len - 1; ++i) {
            name = array[i].getNodeName();
            index = i;
            for (int j = i + 1; j < len; ++j) {
                curName = array[j].getNodeName();
                if (curName.compareTo(name) >= 0) continue;
                name = curName;
                index = j;
            }
            if (index == i) continue;
            Attr temp = array[i];
            array[i] = array[index];
            array[index] = temp;
        }
        return array;
    }
}

