/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import java.util.Vector;

class XPathTokenizer {
    private Vector tokensCollector;
    private int index = -1;

    XPathTokenizer(String xPath) {
        this.tokensCollector = new Vector();
        this.initializeCollector(xPath);
        this.index = 0;
    }

    private XPathTokenizer(Vector tokensCollector, int index) {
        this.tokensCollector = tokensCollector;
        this.index = index;
    }

    private void initializeCollector(String xPath) {
        char[] chars = xPath.toCharArray();
        StringBuffer buffer = new StringBuffer();
        block7: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '/': {
                    this.addName(buffer);
                    if (chars[i + 1] == '/') {
                        this.tokensCollector.add("//");
                        ++i;
                        continue block7;
                    }
                    this.tokensCollector.add("/");
                    continue block7;
                }
                case ':': {
                    this.addName(buffer);
                    if (chars[i + 1] == ':') {
                        this.tokensCollector.add("::");
                        ++i;
                        continue block7;
                    }
                    this.tokensCollector.add(":");
                    continue block7;
                }
                case '.': {
                    this.addName(buffer);
                    this.tokensCollector.add(".");
                    continue block7;
                }
                case '*': {
                    this.addName(buffer);
                    this.tokensCollector.add("*");
                    continue block7;
                }
                case '@': {
                    this.addName(buffer);
                    this.tokensCollector.add("@");
                    continue block7;
                }
                default: {
                    buffer.append(chars[i]);
                }
            }
        }
        this.addName(buffer);
    }

    private void addName(StringBuffer buffer) {
        if (buffer.length() != 0) {
            this.tokensCollector.add(buffer.toString());
            buffer.delete(0, buffer.length());
        }
    }

    boolean hasMoreTokens() {
        return this.index != this.tokensCollector.size();
    }

    String nextToken() {
        if (this.hasMoreTokens()) {
            return (String)this.tokensCollector.get(this.index++);
        }
        return (String)this.tokensCollector.get(this.index - 1);
    }

    String previousToken() {
        return (String)this.tokensCollector.get(--this.index);
    }

    public String toString() {
        return this.tokensCollector.toString();
    }

    public Object clone() {
        return new XPathTokenizer(this.tokensCollector, this.index);
    }

    int getIndex() {
        return this.index;
    }

    void setIndex(int index) {
        if (index >= 0 && index < this.tokensCollector.size()) {
            this.index = index;
        }
    }

    int tokensCount() {
        return this.tokensCollector.size();
    }

    String getCurrentToken() {
        return (String)this.tokensCollector.get(this.index);
    }

    public static void main(String[] rags) {
        XPathTokenizer tokenizer = new XPathTokenizer("/child:elem1//elem2::elem3@attrib/./*/elem4");
        while (tokenizer.hasMoreTokens()) {
            System.out.println("token : " + tokenizer.nextToken());
        }
    }
}

