/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.schema.util.SchemaPrefixesMapping;
import com.sap.engine.lib.schema.validator.SchemaValidationException;
import com.sap.engine.lib.schema.validator.StepObject;
import java.util.Properties;
import java.util.Vector;

class XPathObject
implements Cloneable {
    static final String STEP_DELIMITER = "/";
    static final String DESCENDENT_DELIMITER = "//";
    static final String CONTEXTNODE_SELECTOR = ".";
    static final String EVERY_CHILD_SELECTOR = "*";
    static final String URI_START_IDENTIFIER = "{";
    static final String URI_END_IDENTIFIER = "}";
    private Vector stepsCollector = new Vector();
    private String xPathWithURIs = "";
    private String xPathWithoutURIs = "";

    XPathObject() {
    }

    XPathObject(String xPath, SchemaPrefixesMapping prefixesMapping) throws SchemaValidationException {
        this();
        this.init(xPath, prefixesMapping);
    }

    private void init(String xPath, SchemaPrefixesMapping prefixesMapping) throws SchemaValidationException {
        HelperTokenizer tokenizer = new HelperTokenizer(xPath);
        boolean meetDescendent = false;
        boolean hasDescendent = false;
        while (tokenizer.hasMoreTokens()) {
            String stepStr = tokenizer.nextToken();
            if (stepStr.equals("")) {
                if (hasDescendent) {
                    throw new SchemaValidationException("XPath expression " + xPath + " is not supported by schema validation");
                }
                meetDescendent = true;
                continue;
            }
            if (stepStr.equals(CONTEXTNODE_SELECTOR)) continue;
            StepObject stepObj = new StepObject(stepStr, prefixesMapping);
            if (meetDescendent) {
                stepObj.setAxisSpecifier("descendent");
                meetDescendent = false;
            }
            this.addStep(stepObj);
        }
    }

    private void addStep(StepObject stepObj) {
        this.stepsCollector.add(stepObj);
        boolean isDescendent = stepObj.getAxisSpecifier().equals("descendent");
        this.xPathWithURIs = this.xPathWithURIs + (isDescendent ? DESCENDENT_DELIMITER : STEP_DELIMITER) + stepObj.getQNameWithUri();
        this.xPathWithoutURIs = this.xPathWithoutURIs + (isDescendent ? DESCENDENT_DELIMITER : STEP_DELIMITER) + stepObj.getQNameWithPrefix();
    }

    private StepObject removeLastStep() {
        StepObject stepObjToRemove = (StepObject)this.stepsCollector.remove(this.stepsCollector.size() - 1);
        String axisSpecifier = stepObjToRemove.getAxisSpecifier();
        boolean isDescendent = axisSpecifier.equals("descendent");
        boolean isAttribute = axisSpecifier.equals("attribute");
        String lastStepDelimiter = null;
        lastStepDelimiter = isDescendent ? "//{" : (isAttribute ? "/@{" : "/{");
        int indexForXPathWithURIs = this.xPathWithURIs.lastIndexOf(lastStepDelimiter);
        this.xPathWithURIs = this.xPathWithURIs.substring(0, indexForXPathWithURIs);
        int indexForXPathWithoutURIs = this.xPathWithoutURIs.lastIndexOf(isDescendent ? DESCENDENT_DELIMITER : STEP_DELIMITER);
        this.xPathWithoutURIs = this.xPathWithoutURIs.substring(0, indexForXPathWithoutURIs);
        return stepObjToRemove;
    }

    StepObject addStep(String step, String uri) {
        StepObject stepObj = new StepObject(step, uri);
        this.addStep(stepObj);
        return stepObj;
    }

    StepObject addStep(String step, SchemaPrefixesMapping prefixesMapping) throws SchemaValidationException {
        StepObject stepObj = new StepObject(step, prefixesMapping);
        this.addStep(stepObj);
        return stepObj;
    }

    StepObject removeStep() {
        return this.removeLastStep();
    }

    XPathObject addXPathObj(XPathObject xPathObj) {
        StepObject[] steps = xPathObj.getSteps();
        for (int i = 0; i < steps.length; ++i) {
            this.addStep(steps[i]);
        }
        return this;
    }

    StepObject[] getSteps() {
        Object[] result = new StepObject[this.stepsCollector.size()];
        this.stepsCollector.copyInto(result);
        return result;
    }

    String getXPathWithURIs() {
        return this.xPathWithURIs;
    }

    String getXPathWithoutURIs() {
        return this.xPathWithoutURIs;
    }

    public Object clone() {
        XPathObject result = new XPathObject();
        for (int i = 0; i < this.stepsCollector.size(); ++i) {
            StepObject step = (StepObject)this.stepsCollector.get(i);
            result.addStep((StepObject)step.clone());
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        Properties prefixesMapping = new Properties();
        prefixesMapping.put("prefix1", "uri1");
        prefixesMapping.put("prefix2", "uri2");
        prefixesMapping.put("prefix3", "uri3");
        prefixesMapping.put("", "uri");
    }

    private class HelperTokenizer {
        private String stringToTokenize;
        private boolean hasMoreTokens = true;
        private int startIndex = -1;

        private HelperTokenizer(String stringToTokenize) {
            this.stringToTokenize = stringToTokenize;
            this.startIndex = 0;
        }

        private boolean hasMoreTokens() {
            return this.hasMoreTokens;
        }

        private String nextToken() {
            String result = null;
            int endIndex = this.stringToTokenize.indexOf(XPathObject.STEP_DELIMITER, this.startIndex);
            if (endIndex < 0) {
                this.hasMoreTokens = false;
                return this.stringToTokenize.substring(this.startIndex, this.stringToTokenize.length());
            }
            if (endIndex == this.stringToTokenize.length() - 1) {
                this.hasMoreTokens = false;
                return this.stringToTokenize.substring(this.startIndex, this.stringToTokenize.length() - 1);
            }
            if (this.startIndex == 0 && endIndex == 0) {
                this.startIndex = endIndex + 1;
                return this.nextToken();
            }
            result = this.stringToTokenize.substring(this.startIndex, endIndex);
            this.startIndex = endIndex + 1;
            return result;
        }
    }
}

