/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.schema.validator.StepObject;
import com.sap.engine.lib.schema.validator.XPathDispState;
import com.sap.engine.lib.schema.validator.XPathObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class XPathDisperser {
    protected XPathObject xPathObj;
    private XPathDispState firstState;
    private XPathDispState lastState;
    private XPathDispState currentState;

    XPathDisperser(XPathObject xPathObj) {
        this.xPathObj = xPathObj;
        this.init(xPathObj);
    }

    private void init(XPathObject xPathObj) {
        this.currentState = this.firstState = new XPathDispState();
        StepObject[] steps = xPathObj.getSteps();
        XPathDispState hlpState = this.firstState;
        XPathDispState newState = null;
        XPathDispState beforeDescendentState = null;
        XPathDispState descendentState = null;
        String descedentNodeTest = null;
        for (int i = 0; i < steps.length; ++i) {
            StepObject step = steps[i];
            String axisSpecifier = step.getAxisSpecifier();
            String qName = step.getQNameWithoutPosition();
            newState = new XPathDispState();
            if (axisSpecifier.equals("descendent")) {
                hlpState.add(qName, hlpState);
                beforeDescendentState = hlpState;
                descendentState = newState;
                descedentNodeTest = qName;
            }
            hlpState.add(qName, newState);
            if (descendentState != null) {
                newState.add("XPathDispState.Any.Gill", beforeDescendentState);
                newState.add(descedentNodeTest, descendentState);
            }
            hlpState = newState;
        }
        this.lastState = newState;
    }

    boolean switchState(String qName) {
        Hashtable states = this.currentState.getStates();
        if (states.containsKey(qName)) {
            this.currentState = (XPathDispState)states.get(qName);
            return true;
        }
        if (states.containsKey("XPathDispState.Any.Gill")) {
            this.currentState = (XPathDispState)states.get("XPathDispState.Any.Gill");
            return true;
        }
        return false;
    }

    boolean isInFinalState() {
        return this.currentState == this.lastState;
    }

    void display() {
        this.display(this.firstState, new Vector());
        System.out.println("LastState : " + this.lastState);
    }

    private void display(XPathDispState state, Vector displayedStates) {
        System.out.println(state);
        System.out.println();
        displayedStates.add(state);
        Hashtable statesMapping = state.getStates();
        Enumeration states = statesMapping.elements();
        while (states.hasMoreElements()) {
            XPathDispState stateToDispaly = (XPathDispState)states.nextElement();
            if (displayedStates.contains(stateToDispaly)) continue;
            this.display(stateToDispaly, displayedStates);
        }
    }

    void reset() {
        this.currentState = this.firstState;
    }

    public static void main(String[] args) throws Exception {
    }
}

