/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.schema.SchemaException;
import com.sap.engine.lib.schema.components.AttributeDeclaration;
import com.sap.engine.lib.schema.components.AttributeUse;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.ElementDeclaration;
import com.sap.engine.lib.schema.components.Facet;
import com.sap.engine.lib.schema.components.FundamentalFacets;
import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.components.SimpleTypeDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.components.Wildcard;
import com.sap.engine.lib.schema.components.impl0.LoaderImpl;
import com.sap.engine.lib.schema.regular.RegularExpression;
import com.sap.engine.lib.schema.regular.RegularExpressionException;
import com.sap.engine.lib.schema.validator.ComplexTypeDisperser;
import com.sap.engine.lib.schema.validator.DisperserChildMappingStructure;
import com.sap.engine.lib.schema.validator.IdentityConstraintDefsProcessor;
import com.sap.engine.lib.schema.validator.StepObject;
import com.sap.engine.lib.schema.validator.XPathObject;
import com.sap.engine.lib.xml.parser.ActiveXMLParser;
import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.XMLParser;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;

public class Validator {
    private static final String ID_TYPE_DEF_NAME = "ID";
    private static final String IDREF_TYPE_DEF_NAME = "IDREF";
    private static final String IDREFS_TYPE_DEF_NAME = "IDREFS";
    private Hashtable regularExpressionsMapping = new Hashtable();
    private Hashtable dispersersMapping = new Hashtable();
    private Vector validationErrorsCollector = new Vector();
    private XMLParser xmlParser = null;
    private DocHandler docHandler = null;
    private String[] externalSchemaLocations = null;
    private String[] externalSchemaNamespaces = null;
    private String externalNoNamespaceSchemaLocation = null;
    private Schema schema;
    private LoaderImpl loader = new LoaderImpl();

    public void setParser(XMLParser xmlParser) {
        this.xmlParser = xmlParser;
        this.loader.setEntityResolver(xmlParser.getEntityResolver());
    }

    public void setDocHandler(DocHandler docHandler) {
        this.docHandler = docHandler;
    }

    public void setExternalSchemas(String[] namespaces, String[] locations) {
        this.externalSchemaLocations = locations;
        this.externalSchemaNamespaces = namespaces;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setExternalNoNamespaceSchema(String location) {
        this.externalNoNamespaceSchemaLocation = location;
    }

    public boolean validate(InputSource xmlInputSource) throws SchemaException, ParserException {
        Schema schema = this.extractSchema();
        if (this.xmlParser.getActiveParse()) {
            this.xmlParser.finalizeActiveParse();
        }
        return this.validate(xmlInputSource, schema);
    }

    public boolean validate(InputStream xmlInputStream) throws SchemaException, ParserException {
        Schema schema = this.extractSchema();
        return this.validate(xmlInputStream, schema);
    }

    private Schema extractSchema() throws SchemaException, ParserException {
        if (this.schema != null) {
            return this.schema;
        }
        String[] locations = null;
        if (this.externalNoNamespaceSchemaLocation != null) {
            locations = new String[this.externalSchemaLocations.length + 1];
            locations[this.externalSchemaLocations.length] = this.externalNoNamespaceSchemaLocation;
        } else {
            locations = new String[this.externalSchemaLocations.length];
        }
        System.arraycopy(this.externalSchemaLocations, 0, locations, 0, this.externalSchemaLocations.length);
        Schema schema = this.loader.load(locations);
        return schema;
    }

    public boolean validate(String xmlPath, String xsdPath) throws SchemaException, ParserException {
        FileInputStream xmlinputStream = null;
        try {
            xmlinputStream = new FileInputStream(xmlPath);
        }
        catch (FileNotFoundException fileNotFoundExc) {
            throw new IllegalArgumentException("File " + xmlPath + " does not exists.");
        }
        return this.validate((InputStream)xmlinputStream, xsdPath);
    }

    public boolean validate(InputStream xmlInputStream, String xsdPath) throws SchemaException, ParserException {
        if (xsdPath == null) {
            throw new IllegalArgumentException("xsdPath is null");
        }
        Schema schema = this.loader.load(new StreamSource(xsdPath));
        return this.validate(xmlInputStream, schema);
    }

    public boolean validate(InputStream xmlInputStream, Schema schema) throws SchemaException, ParserException {
        if (schema == null) {
            throw new IllegalArgumentException();
        }
        ActiveXMLParser parser = new ActiveXMLParser(xmlInputStream);
        if (this.xmlParser != null) {
            parser.setParser(this.xmlParser);
        }
        if (this.docHandler != null) {
            parser.setDocHandler(this.docHandler);
        }
        parser.setNormalize(true);
        parser.begin();
        boolean result = this.validate(parser, schema);
        return result;
    }

    public boolean validate(InputSource xmlInputSource, Schema schema) throws SchemaException, ParserException {
        if (schema == null) {
            throw new IllegalArgumentException();
        }
        ActiveXMLParser parser = new ActiveXMLParser(xmlInputSource);
        if (this.xmlParser != null) {
            parser.setParser(this.xmlParser);
        }
        if (this.docHandler != null) {
            parser.setDocHandler(this.docHandler);
        }
        parser.setNormalize(true);
        parser.begin();
        boolean result = this.validate(parser, schema);
        return result;
    }

    private boolean validate(ActiveXMLParser parser, Schema schema) throws ParserException, SchemaException {
        IdentityConstraintDefsProcessor identityConstrDefsProcessor = new IdentityConstraintDefsProcessor(schema.getIdentityConstraintDefinitionsArray(), this.validationErrorsCollector);
        Vector idValuesCollector = new Vector();
        Hashtable idrefValuesCollector = new Hashtable();
        Hashtable idrefsListsCollector = new Hashtable();
        Hashtable<String, Boolean> laxableElemsCollector = new Hashtable<String, Boolean>();
        XPathObject xPathObj = new XPathObject();
        int parseCode = -1;
        Stack<Base> elementDeclrStack = new Stack<Base>();
        Stack<ComplexTypeDisperser> dispersersStack = new Stack<ComplexTypeDisperser>();
        Stack<ComplexTypeDisperser> laxableElemsDispersersStack = new Stack<ComplexTypeDisperser>();
        Vector<String> nillableElementsCollector = new Vector<String>();
        ComplexTypeDisperser disperser = null;
        ComplexTypeDisperser laxableElemDisperser = null;
        Base base = null;
        StepObject appendedStep = null;
        StepObject removedStep = null;
        while ((parseCode = parser.next()) != 6) {
            if (parseCode == 1) {
                boolean attributesValidation;
                String localName = parser.getLocalName();
                String qName = parser.getQName();
                String uri = parser.getURI();
                int position = removedStep == null || !removedStep.getLocalName().equals(localName) ? 1 : removedStep.getPositionAsInt() + 1;
                appendedStep = xPathObj.addStep(qName + "[" + position + "]", uri);
                removedStep = null;
                if (laxableElemsCollector.size() != 0) {
                    if (laxableElemDisperser != null) {
                        DisperserChildMappingStructure childMappingStr = laxableElemDisperser.switchState(uri, localName);
                        if (childMappingStr == null) {
                            this.validationErrorsCollector.add("Element " + xPathObj.getXPathWithURIs() + " is not declared in schema.");
                            return false;
                        }
                        base = childMappingStr.getBase();
                    } else {
                        base = schema.getTopLevelElementDeclaration(uri, localName);
                    }
                    laxableElemsCollector.put(xPathObj.getXPathWithoutURIs(), base == null ? Boolean.FALSE : Boolean.TRUE);
                } else if (disperser == null) {
                    base = schema.getTopLevelElementDeclaration(uri, localName);
                    if (base == null) {
                        this.validationErrorsCollector.add("Doc element " + xPathObj.getXPathWithURIs() + " is not declared in schema.");
                        return false;
                    }
                } else {
                    DisperserChildMappingStructure childMappingStr = disperser.switchState(uri, localName);
                    if (childMappingStr == null) {
                        this.validationErrorsCollector.add("Element " + xPathObj.getXPathWithURIs() + " is not declared in schema.");
                        return false;
                    }
                    base = childMappingStr.getBase();
                }
                if (base == null) continue;
                String[] xsiAttributes = null;
                Base elementDeclr = null;
                if (base instanceof ElementDeclaration) {
                    elementDeclr = base;
                } else if (base instanceof Wildcard) {
                    boolean wildcardValidation = this.validateWildcard((Wildcard)base, uri);
                    if (!wildcardValidation) {
                        this.validationErrorsCollector.add("Wildcard associated with element " + xPathObj.getXPathWithURIs() + " is not valid.");
                        return false;
                    }
                    xsiAttributes = this.checkForXsiAttributes(parser);
                    if (((Wildcard)base).isProcessContentsSkip()) {
                        removedStep = xPathObj.removeStep();
                        this.skipAnyElement(parser);
                    } else if (((Wildcard)base).isProcessContentsStrict()) {
                        if (xsiAttributes[0] == null && (elementDeclr = schema.getTopLevelElementDeclaration(uri, localName)) == null) {
                            this.validationErrorsCollector.add("Element " + xPathObj.getXPathWithURIs() + " has no top level element declaration in schema");
                            return false;
                        }
                    } else if (((Wildcard)base).isProcessContentsLax()) {
                        elementDeclr = schema.getTopLevelElementDeclaration(uri, localName);
                        laxableElemsCollector.put(xPathObj.getXPathWithoutURIs(), elementDeclr != null ? Boolean.TRUE : Boolean.FALSE);
                    }
                }
                TypeDefinitionBase typeDefBase = null;
                if (xsiAttributes == null) {
                    xsiAttributes = this.checkForXsiAttributes(parser);
                }
                if (xsiAttributes[0] != null) {
                    typeDefBase = schema.getTopLevelTypeDefinition(xsiAttributes[0], xsiAttributes[1]);
                    if (typeDefBase == null) {
                        this.validationErrorsCollector.add("Element " + xPathObj.getXPathWithURIs() + " has no top level type definition in schema.");
                        return false;
                    }
                } else if (elementDeclr != null) {
                    typeDefBase = elementDeclr.getTypeDefinition();
                }
                if (xsiAttributes[2] != null && xsiAttributes[2].equals("true")) {
                    nillableElementsCollector.add(xPathObj.getXPathWithoutURIs());
                }
                if (elementDeclr == null) continue;
                elementDeclrStack.push(elementDeclr);
                if (!(typeDefBase instanceof ComplexTypeDefinition)) continue;
                IdentityConstraintDefinition[] constraintDefs = elementDeclr.getIdentityConstraintDefinitionsArray();
                for (int i = 0; i < constraintDefs.length; ++i) {
                    IdentityConstraintDefinition identityConstrDef = constraintDefs[i];
                    identityConstrDefsProcessor.activate(identityConstrDef.getTargetNamespace(), identityConstrDef.getName(), xPathObj);
                }
                if (laxableElemsCollector.size() == 0) {
                    if (disperser != null) {
                        dispersersStack.push(disperser);
                    }
                    disperser = this.useDisperser((ComplexTypeDefinition)typeDefBase);
                } else {
                    if (laxableElemDisperser != null) {
                        laxableElemsDispersersStack.push(laxableElemDisperser);
                    }
                    laxableElemDisperser = this.useDisperser((ComplexTypeDefinition)typeDefBase);
                }
                if (attributesValidation = this.validateAttributes((ComplexTypeDefinition)typeDefBase, parser, (XPathObject)xPathObj.clone(), idValuesCollector, idrefValuesCollector, idrefsListsCollector, identityConstrDefsProcessor)) continue;
                this.validationErrorsCollector.add("Attributes associated with element " + xPathObj.getXPathWithURIs() + " are not valid.");
                return false;
            }
            if (parseCode != 2) continue;
            if (!laxableElemsCollector.containsKey(xPathObj.getXPathWithoutURIs()) || ((Boolean)laxableElemsCollector.get(xPathObj.getXPathWithoutURIs())).equals(Boolean.TRUE)) {
                String elementValue = parser.getValue().trim();
                ElementDeclaration elementDeclr = (ElementDeclaration)elementDeclrStack.pop();
                TypeDefinitionBase typeDefBase = elementDeclr.getTypeDefinition();
                boolean hasAttribXsiNill = nillableElementsCollector.contains(xPathObj.getXPathWithoutURIs());
                if (hasAttribXsiNill) {
                    nillableElementsCollector.remove(xPathObj.getXPathWithoutURIs());
                }
                if (typeDefBase instanceof SimpleTypeDefinition) {
                    identityConstrDefsProcessor.addStructure((SimpleTypeDefinition)typeDefBase, elementValue, xPathObj, elementDeclr.isNillable());
                    if (elementDeclr.isNillable() && hasAttribXsiNill) {
                        if (!elementValue.equals("")) {
                            this.validationErrorsCollector.add("Element " + xPathObj.getXPathWithURIs() + " is not valid with respect to it's nillable declaration.");
                            return false;
                        }
                    } else {
                        boolean simpleTypeValidation = this.validateSimpleType((SimpleTypeDefinition)typeDefBase, elementValue, xPathObj);
                        if (!simpleTypeValidation) {
                            this.validationErrorsCollector.add("Element " + xPathObj.getXPathWithURIs() + " is not valid with respect to it's simple type definition.");
                            return false;
                        }
                    }
                } else {
                    SimpleTypeDefinition simpleTypeDef = ((ComplexTypeDefinition)typeDefBase).getContentTypeSimpleTypeDefinition();
                    if (simpleTypeDef != null) {
                        boolean simpleTypeValidation = this.validateSimpleType(simpleTypeDef, elementValue, xPathObj);
                        if (!simpleTypeValidation) {
                            this.validationErrorsCollector.add("Element " + xPathObj.getXPathWithURIs() + " is not valid with respect to it's simple content simple type definition.");
                            return false;
                        }
                        identityConstrDefsProcessor.addStructure(simpleTypeDef, elementValue, xPathObj, elementDeclr.isNillable());
                    } else if (!((ComplexTypeDefinition)typeDefBase).isMixed() && !elementValue.equals("")) {
                        this.validationErrorsCollector.add("Element " + xPathObj.getXPathWithURIs() + " is not valid with respect to it's element declaration. It is not declared to have simple content, but has value '" + elementValue + "'.");
                        return false;
                    }
                    IdentityConstraintDefinition[] constraintDefs = elementDeclr.getIdentityConstraintDefinitionsArray();
                    for (int i = 0; i < constraintDefs.length; ++i) {
                        IdentityConstraintDefinition identityConstrDef = constraintDefs[i];
                        identityConstrDefsProcessor.inactivate(identityConstrDef.getTargetNamespace(), identityConstrDef.getName());
                    }
                    if (elementDeclr.isNillable() && hasAttribXsiNill) {
                        if (!disperser.isInStartingState()) {
                            this.validationErrorsCollector.add("Element " + xPathObj.getXPathWithURIs() + " is not valid with respect to it's nillable declaration.");
                            return false;
                        }
                    } else if (laxableElemsCollector.size() == 0) {
                        if (!disperser.isInFinalState()) {
                            this.validationErrorsCollector.add("Element " + xPathObj.getXPathWithURIs() + " is not valid with respect to it's complex type definition.");
                            return false;
                        }
                    } else {
                        if (!laxableElemDisperser.isInFinalState()) {
                            this.validationErrorsCollector.add("Element " + xPathObj.getXPathWithURIs() + " is not valid with respect to it's complex type definition.");
                            return false;
                        }
                        if (laxableElemsDispersersStack.empty()) {
                            laxableElemDisperser = null;
                        }
                    }
                    if (laxableElemsCollector.size() == 0) {
                        this.reuseDisperser((ComplexTypeDefinition)typeDefBase, disperser);
                        if (!dispersersStack.empty()) {
                            disperser = (ComplexTypeDisperser)dispersersStack.pop();
                        }
                    } else {
                        if (laxableElemDisperser != null) {
                            this.reuseDisperser((ComplexTypeDefinition)typeDefBase, laxableElemDisperser);
                        }
                        if (!laxableElemsDispersersStack.empty()) {
                            laxableElemDisperser = (ComplexTypeDisperser)laxableElemsDispersersStack.pop();
                        }
                    }
                }
            }
            if (laxableElemsCollector.containsKey(xPathObj.getXPathWithoutURIs())) {
                laxableElemsCollector.remove(xPathObj.getXPathWithoutURIs());
            }
            removedStep = xPathObj.removeStep();
        }
        if (!this.validateIdrefValues(idrefValuesCollector, idValuesCollector)) {
            return false;
        }
        if (!this.validateIdrefsLists(idrefsListsCollector, idValuesCollector)) {
            return false;
        }
        return identityConstrDefsProcessor.process();
    }

    private boolean validateIdrefValues(Hashtable idrefValuesCollector, Vector idValuesCollector) {
        boolean result = true;
        Enumeration xPathsEnum = idrefValuesCollector.keys();
        while (xPathsEnum.hasMoreElements()) {
            String xPath = (String)xPathsEnum.nextElement();
            String value = (String)idrefValuesCollector.get(xPath);
            if (idValuesCollector.contains(value)) continue;
            this.validationErrorsCollector.add("Attribute " + xPath + " is not valid with respect to it's simple type definition (IDREF).");
            if (!result) continue;
            result = false;
        }
        return result;
    }

    private boolean validateIdrefsLists(Hashtable idrefsListsCollector, Vector idValuesCollector) {
        boolean result = true;
        Enumeration xPathsEnum = idrefsListsCollector.keys();
        while (xPathsEnum.hasMoreElements()) {
            String xPath = (String)xPathsEnum.nextElement();
            String values = (String)idrefsListsCollector.get(xPath);
            StringTokenizer valuesTokenizer = new StringTokenizer(values);
            while (valuesTokenizer.hasMoreTokens()) {
                String value = valuesTokenizer.nextToken();
                if (idValuesCollector.contains(value)) continue;
                this.validationErrorsCollector.add("Attribute " + xPath + " is not valid with respect to it's simple type definition (IDREFS).");
                if (!result) continue;
                result = false;
            }
        }
        return true;
    }

    private void skipAnyElement(ActiveXMLParser parser) throws ParserException {
        int code = -1;
        while ((code = parser.next()) != 2) {
            if (code != 1) continue;
            this.skipAnyElement(parser);
        }
    }

    private String[] checkForXsiAttributes(ActiveXMLParser parser) {
        String[] result = new String[3];
        Attributes attribs = parser.getAttributes();
        boolean detectAny = false;
        boolean detectNil = false;
        int attribsCount = attribs.getLength();
        for (int i = 0; i < attribsCount; ++i) {
            String localName = attribs.getLocalName(i);
            if (!attribs.getURI(i).equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
            String attribValue = attribs.getValue(i);
            if (localName.equals("any")) {
                String uri;
                String[] prefixAndType = this.getPrefixAndValue(attribValue);
                String prefix = prefixAndType[0];
                result[0] = prefix != null ? ((uri = parser.getURI(prefix)) == null ? "" : uri) : "";
                result[1] = prefixAndType[1];
                detectAny = true;
                if (!detectNil) continue;
                break;
            }
            if (!localName.equals("nil")) continue;
            result[2] = attribValue;
            detectNil = true;
            if (detectAny) break;
        }
        return result;
    }

    private String[] getPrefixAndValue(String value) {
        String[] result = new String[2];
        int index = value.indexOf(":");
        if (index >= 0) {
            result[0] = value.substring(0, index);
            result[1] = value.substring(index + 1);
        } else {
            result[1] = value;
        }
        return result;
    }

    private void reuseDisperser(ComplexTypeDefinition complexTypeDef, ComplexTypeDisperser disperser) {
        disperser.reset();
        this.dispersersMapping.put(complexTypeDef, disperser);
    }

    private ComplexTypeDisperser useDisperser(ComplexTypeDefinition complexTypeDef) {
        ComplexTypeDisperser disperser = null;
        if (this.dispersersMapping.containsKey(complexTypeDef)) {
            disperser = (ComplexTypeDisperser)this.dispersersMapping.get(complexTypeDef);
            this.dispersersMapping.remove(complexTypeDef);
        } else {
            disperser = new ComplexTypeDisperser(complexTypeDef);
        }
        return disperser;
    }

    private boolean validateSimpleType(SimpleTypeDefinition simpleTypeDef, String value, XPathObject xPathObj) throws SchemaException {
        boolean result = true;
        if (simpleTypeDef.isVarietyList()) {
            SimpleTypeDefinition listMememberTypeDef = simpleTypeDef.getItemTypeDefinition();
            StringTokenizer listMemebersTokenizer = new StringTokenizer(value, " ");
            while (listMemebersTokenizer.hasMoreElements()) {
                String listMemeberValue = listMemebersTokenizer.nextToken();
                result = this.validateSimpleType(listMememberTypeDef, listMemeberValue, xPathObj);
                if (result) continue;
                this.validationErrorsCollector.add("Value " + listMemeberValue + " associated with list type definition of element " + xPathObj.getXPathWithURIs() + ", is not valid with respect to this list members simple type definition.");
                return false;
            }
        } else {
            if (simpleTypeDef.isVarietyUnion()) {
                SimpleTypeDefinition unionMemeberTypeDef;
                Vector unionMemebersTypeDefCollector = new Vector();
                simpleTypeDef.getMemberTypeDefinitions(unionMemebersTypeDefCollector);
                for (int i = 0; i < unionMemebersTypeDefCollector.size() && !(result = this.validateSimpleType(unionMemeberTypeDef = (SimpleTypeDefinition)unionMemebersTypeDefCollector.get(i), value, xPathObj)); ++i) {
                }
                if (!result) {
                    this.validationErrorsCollector.add("Value " + value + " is not valid with respect to any simple type definition, associated with union type definition of element " + xPathObj.getXPathWithURIs() + ".");
                }
                return result;
            }
            if (simpleTypeDef.isVarietyAtomic()) {
                Object fundamentalFacetsParseObj = null;
                FundamentalFacets fundamentalFacets = simpleTypeDef.getFundamentalFacets();
                if (fundamentalFacets != null && (fundamentalFacetsParseObj = fundamentalFacets.parse(value)) == null) {
                    this.validationErrorsCollector.add("Value " + value + " of element " + xPathObj.getXPathWithURIs() + " does not belong to lexical space of element simple type definition.");
                    return false;
                }
                Facet[] facets = simpleTypeDef.getFacetsArray();
                boolean patternPresent = false;
                boolean patternValidation = false;
                boolean enumerationPresent = false;
                boolean enumerationValidation = false;
                for (int i = 0; i < facets.length; ++i) {
                    Facet facet = facets[i];
                    String facetValue = facet.getValue();
                    String facetName = facet.getName();
                    if (facetName.equals("pattern")) {
                        if (!patternPresent) {
                            patternPresent = true;
                        }
                        if (!this.validatePattern(facetValue, value)) continue;
                        patternValidation = true;
                        continue;
                    }
                    if (facetName.equals("enumeration")) {
                        if (!enumerationPresent) {
                            enumerationPresent = true;
                        }
                        if (!this.validateEnumeration(fundamentalFacets, facetValue, value)) continue;
                        enumerationValidation = true;
                        continue;
                    }
                    if (facetName.equals("length")) {
                        result = this.validateLength(fundamentalFacetsParseObj, simpleTypeDef.isVarietyList(), facetValue);
                        if (result) continue;
                        this.validationErrorsCollector.add("Facet length with value " + facetValue + " which is associated with element " + xPathObj.getXPathWithURIs() + " is not valid.");
                        return false;
                    }
                    if (facetName.equals("minLength")) {
                        result = this.validateMinLength(fundamentalFacetsParseObj, simpleTypeDef.isVarietyList(), facetValue);
                        if (result) continue;
                        this.validationErrorsCollector.add("Facet minLength with value " + facetValue + " which is associated with element " + xPathObj.getXPathWithURIs() + " is not valid.");
                        return false;
                    }
                    if (facetName.equals("maxLength")) {
                        result = this.validateMaxLength(fundamentalFacetsParseObj, simpleTypeDef.isVarietyList(), facetValue);
                        if (result) continue;
                        this.validationErrorsCollector.add("Facet naxLength with value " + facetValue + " which is associated with element " + xPathObj.getXPathWithURIs() + " is not valid.");
                        return false;
                    }
                    if (facetName.equals("minExclusive")) {
                        result = this.validateMinExclusive(fundamentalFacets, fundamentalFacetsParseObj, facetValue);
                        if (result) continue;
                        this.validationErrorsCollector.add("Facet minExclusive with value " + facetValue + " which is associated with element " + xPathObj.getXPathWithURIs() + " is not valid.");
                        return false;
                    }
                    if (facetName.equals("maxExclusive")) {
                        result = this.validateMaxExclusive(fundamentalFacets, fundamentalFacetsParseObj, facetValue);
                        if (result) continue;
                        this.validationErrorsCollector.add("Facet maxLength with value " + facetValue + " which is associated with element " + xPathObj.getXPathWithURIs() + " is not valid.");
                        return false;
                    }
                    if (facetName.equals("minInclusive")) {
                        result = this.validateMinInclusive(fundamentalFacets, fundamentalFacetsParseObj, facetValue);
                        if (result) continue;
                        this.validationErrorsCollector.add("Facet minInclusive with value " + facetValue + " which is associated with element " + xPathObj.getXPathWithURIs() + " is not valid.");
                        return false;
                    }
                    if (facetName.equals("maxInclusive")) {
                        result = this.validateMaxInclusive(fundamentalFacets, fundamentalFacetsParseObj, facetValue);
                        if (result) continue;
                        this.validationErrorsCollector.add("Facet maxExclusive with value " + facetValue + " which is associated with element " + xPathObj.getXPathWithURIs() + " is not valid.");
                        return false;
                    }
                    if (facetName.equals("totalDigits")) {
                        result = this.validateTotalDigits(facetValue, value);
                        if (result) continue;
                        this.validationErrorsCollector.add("Facet totalDigits with value " + facetValue + " which is associated with element " + xPathObj.getXPathWithURIs() + " is not valid.");
                        return false;
                    }
                    if (facetName.equals("fractionDigits")) {
                        result = this.validateFractionDigits();
                        if (result) continue;
                        this.validationErrorsCollector.add("Facet fractionDigits with value " + facetValue + " which is associated with element " + xPathObj.getXPathWithURIs() + " is not valid.");
                        return false;
                    }
                    if (!facetName.equals("whitespace") || (result = this.validateWhitespace())) continue;
                    this.validationErrorsCollector.add("Facet whitespace with value " + facetValue + " which is associated with element " + xPathObj.getXPathWithURIs() + " is not valid.");
                    return false;
                }
                if (!enumerationValidation && enumerationPresent) {
                    this.validationErrorsCollector.add("Value of the element " + xPathObj.getXPathWithURIs() + " '" + value + "' does not match to any of the enumeration facets defined in it's simple type definition.");
                }
                if (patternPresent && !patternValidation) {
                    this.validationErrorsCollector.add("Value of the element " + xPathObj.getXPathWithURIs() + " '" + value + "' does not match to any of the pattern facets defined in it's simple type definition.");
                }
                result = !(!result || patternPresent && !patternValidation || enumerationPresent && !enumerationValidation);
            }
        }
        return result;
    }

    private boolean validatePattern(String regularExpression, String value) throws RegularExpressionException {
        return this.getRegularExpression(regularExpression).matcher(value).matches();
    }

    private RegularExpression getRegularExpression(String regularExpression) throws RegularExpressionException {
        RegularExpression result = (RegularExpression)this.regularExpressionsMapping.get(regularExpression);
        if (result == null) {
            result = RegularExpression.compile(regularExpression);
            this.regularExpressionsMapping.put(regularExpression, result);
        }
        return result;
    }

    private boolean validateEnumeration(FundamentalFacets fundamentalFacets, String enumerationValue, String value) {
        return fundamentalFacets.equal(fundamentalFacets.parse(enumerationValue), fundamentalFacets.parse(value));
    }

    private int getLengthDependingOnType(Object fundamentalFacetsParseObj, boolean isList) throws SchemaException {
        if (fundamentalFacetsParseObj instanceof byte[] || isList) {
            return ((byte[])fundamentalFacetsParseObj).length;
        }
        return fundamentalFacetsParseObj.toString().length();
    }

    private boolean validateLength(Object fundamentalFacetsParseObj, boolean isList, String facetValue) throws SchemaException {
        return this.getLengthDependingOnType(fundamentalFacetsParseObj, isList) == Integer.parseInt(facetValue);
    }

    private boolean validateMinLength(Object fundamentalFacetsParseObj, boolean isList, String facetValue) throws SchemaException {
        return this.getLengthDependingOnType(fundamentalFacetsParseObj, isList) >= Integer.parseInt(facetValue);
    }

    private boolean validateMaxLength(Object fundamentalFacetsParseObj, boolean isList, String facetValue) throws SchemaException {
        return this.getLengthDependingOnType(fundamentalFacetsParseObj, isList) <= Integer.parseInt(facetValue);
    }

    private boolean validateMinExclusive(FundamentalFacets fundamentalFacets, Object fundamentalFacetsParseObj, String facetValue) {
        if (fundamentalFacets.isNumeric()) {
            return fundamentalFacets.less(fundamentalFacetsParseObj, fundamentalFacets.parse(facetValue));
        }
        return true;
    }

    private boolean validateMaxExclusive(FundamentalFacets fundamentalFacets, Object fundamentalFacetsParseObj, String facetValue) {
        if (fundamentalFacets.isNumeric()) {
            return !fundamentalFacets.less(fundamentalFacetsParseObj, fundamentalFacets.parse(facetValue));
        }
        return true;
    }

    private boolean validateMinInclusive(FundamentalFacets fundamentalFacets, Object fundamentalFacetsParseObj, String facetValue) {
        if (fundamentalFacets.isNumeric()) {
            return fundamentalFacets.less(fundamentalFacetsParseObj, fundamentalFacets.parse(facetValue));
        }
        return true;
    }

    private boolean validateMaxInclusive(FundamentalFacets fundamentalFacets, Object fundamentalFacetsParseObj, String facetValue) {
        if (fundamentalFacets.isNumeric()) {
            return !fundamentalFacets.less(fundamentalFacetsParseObj, fundamentalFacets.parse(facetValue));
        }
        return true;
    }

    private boolean validateTotalDigits(String facetValue, String value) {
        int facetIntValue = Integer.parseInt(facetValue);
        int charCounter = 0;
        int valueLength = value.length();
        for (int i = 0; i < valueLength; ++i) {
            char ch = value.charAt(i);
            if (ch < '0' || ch > '9') continue;
            ++charCounter;
        }
        return charCounter <= facetIntValue;
    }

    private boolean validateFractionDigits() {
        return true;
    }

    private boolean validateWhitespace() {
        return true;
    }

    private boolean validateAttributes(ComplexTypeDefinition complexTypeDef, ActiveXMLParser parser, XPathObject xPathObj, Vector idValuesCollector, Hashtable idrefValuesCollector, Hashtable idrefsListsCollector, IdentityConstraintDefsProcessor processor) throws SchemaException {
        AttributeUse[] attribUses = complexTypeDef.getAttributeUsesArray();
        Attributes attribs = parser.getAttributes();
        int attribsCount = attribs.getLength();
        boolean[] processedAttribs = new boolean[attribsCount];
        for (int i = 0; i < attribUses.length; ++i) {
            int attribIndex;
            AttributeUse attribUse = attribUses[i];
            AttributeDeclaration attribDeclr = attribUse.getAttributeDeclaration();
            String attribUri = attribDeclr.getTargetNamespace();
            String attribName = attribDeclr.getName();
            for (attribIndex = 0; attribIndex < attribsCount; ++attribIndex) {
                if (processedAttribs[attribIndex]) continue;
                String processingAttribUri = attribs.getURI(attribIndex);
                String processingAttribName = attribs.getLocalName(attribIndex);
                if (!processingAttribUri.equals(attribUri) || !processingAttribName.equals(attribName)) continue;
                processedAttribs[attribIndex] = true;
                xPathObj.addStep("@" + processingAttribName, processingAttribUri);
                boolean attribValidationResult = this.validateAttribute(attribDeclr, attribs.getValue(attribIndex), xPathObj, idValuesCollector, idrefValuesCollector, idrefsListsCollector, processor);
                if (!attribValidationResult) {
                    this.validationErrorsCollector.add("Attribute " + xPathObj.getXPathWithURIs() + " is not valid with respect to it's attribute declaration.");
                    return false;
                }
                xPathObj.removeStep();
                break;
            }
            if (attribIndex != attribsCount || !attribUse.isRequired()) continue;
            xPathObj.addStep("@" + attribName, attribUri);
            this.validationErrorsCollector.add("Attribute " + xPathObj.getXPathWithURIs() + " is declared as required, but not defined in xml.");
            return false;
        }
        Wildcard attribWildcard = complexTypeDef.getAttributeWildcard();
        for (int i = 0; i < attribsCount; ++i) {
            String attribQName = attribs.getQName(i);
            String attribLocalName = attribs.getLocalName(i);
            String attribUri = attribs.getURI(i);
            xPathObj.addStep("@" + attribQName, attribUri);
            if (!processedAttribs[i]) {
                if (!("http://www.w3.org/2001/XMLSchema-instance".equals(attribUri) || attribs.getQName(i).startsWith("xml") || attribLocalName.equals("type") || attribLocalName.equals("nil"))) {
                    if (attribWildcard == null) {
                        this.validationErrorsCollector.add("Attribute " + xPathObj.getXPathWithURIs() + " is not declared in schema.");
                        return false;
                    }
                    boolean wildcardValidation = this.validateWildcard(attribWildcard, attribs.getURI(i));
                    if (!wildcardValidation) {
                        this.validationErrorsCollector.add("Wildcard, associated with attribute " + xPathObj.getXPathWithURIs() + ", is not valid.");
                        return false;
                    }
                }
                processedAttribs[i] = true;
            }
            xPathObj.removeStep();
        }
        return true;
    }

    private boolean validateWildcard(Wildcard wildcard, String uri) {
        String constraintNegated = wildcard.getNamespaceConstraintNegated();
        if (constraintNegated != null) {
            if (uri.equals(constraintNegated)) {
                return false;
            }
            return uri.length() != 0;
        }
        String[] namespaceCostrMembers = wildcard.getNamespaceConstraintMembersAsArray();
        if (namespaceCostrMembers != null) {
            boolean uriBelongToCostrMembers = false;
            for (int i = 0; i < namespaceCostrMembers.length; ++i) {
                if (!uri.equals(namespaceCostrMembers[i])) continue;
                uriBelongToCostrMembers = true;
                break;
            }
            if (!uriBelongToCostrMembers) {
                return false;
            }
        }
        return true;
    }

    private boolean validateAttribute(AttributeDeclaration attrDeclr, String value, XPathObject xPathObj, Vector idValuesCollector, Hashtable idrefValuesCollector, Hashtable idrefsListsCollector, IdentityConstraintDefsProcessor processor) throws SchemaException, RegularExpressionException {
        if (attrDeclr == null) {
            this.validationErrorsCollector.add("Attribute " + xPathObj.getXPathWithURIs() + " is not declared in schema.");
            return false;
        }
        SimpleTypeDefinition attributeTypeDef = (SimpleTypeDefinition)attrDeclr.getTypeDefinition();
        if (attributeTypeDef == null) {
            this.validationErrorsCollector.add("Simple type of attribute " + xPathObj.getXPathWithURIs() + " is not defined in schema.");
            return false;
        }
        processor.addStructure(attributeTypeDef, value, xPathObj, false);
        boolean typeValidationResult = this.validateSimpleType(attributeTypeDef, value, xPathObj);
        if (!typeValidationResult) {
            this.validationErrorsCollector.add("Attribute " + xPathObj.getXPathWithURIs() + " is not valid with respect to it's simple type definition.");
            return false;
        }
        String valueConstraintFixed = attrDeclr.getValueConstraintFixed();
        if (valueConstraintFixed != null) {
            FundamentalFacets fundamentalFacets = attributeTypeDef.getFundamentalFacets();
            Object actualValue = fundamentalFacets.parse(value);
            Object fixedValue = fundamentalFacets.parse(valueConstraintFixed);
            if (actualValue == null || !fundamentalFacets.equal(actualValue, fixedValue)) {
                this.validationErrorsCollector.add("Attribute " + xPathObj.getXPathWithURIs() + " is not valid with respect to it's fixed value " + valueConstraintFixed + ".");
                return false;
            }
        }
        if (attributeTypeDef.getName().equals(ID_TYPE_DEF_NAME)) {
            if (idValuesCollector.contains(value)) {
                this.validationErrorsCollector.add("Attribute " + xPathObj.getXPathWithURIs() + " is not valid with respect to it's ID type definition.");
                return false;
            }
            idValuesCollector.add(value);
        }
        if (attributeTypeDef.getName().equals(IDREF_TYPE_DEF_NAME)) {
            idrefValuesCollector.put(xPathObj.getXPathWithoutURIs(), value);
        }
        if (attributeTypeDef.getName().equals(IDREFS_TYPE_DEF_NAME)) {
            idrefsListsCollector.put(xPathObj.getXPathWithoutURIs(), value);
        }
        return true;
    }

    public void displayErrors() {
        for (int i = 0; i < this.validationErrorsCollector.size(); ++i) {
            System.out.println("[Validation Error] : " + this.validationErrorsCollector.get(i));
        }
    }

    public String[] getErrors() {
        Object[] errors = new String[this.validationErrorsCollector.size()];
        this.validationErrorsCollector.copyInto(errors);
        return errors;
    }

    public static void main(String[] args) throws Exception {
        Validator validator = new Validator();
        System.out.println(">>>Validation result : " + validator.validate("D:\\develop\\schema_test\\from_sabine\\Baum.xml", "D:\\develop\\schema_test\\from_sabine\\tml_cmx_xs_schema_clog_02.xsd"));
        validator.displayErrors();
    }
}

