/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.components.impl0.LoaderImpl;
import com.sap.engine.lib.xml.parser.SAXParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidationTester {
    private SAXParser getValidationParser(String[] schemas) throws Exception {
        SAXParser parser = new SAXParser();
        TesterHandler handler = new TesterHandler();
        parser.setErrorHandler(handler);
        parser.setFeature("http://xml.org/sax/features/validation", true);
        parser.setFeature("http://xml.org/sax/features/namespaces", true);
        parser.setFeature("http://apache.org/xml/features/validation/schema", true);
        if (schemas != null) {
            String schemasStr = new String();
            for (int i = 0; i < schemas.length; ++i) {
                schemasStr = schemasStr + schemas[i] + " ";
            }
            schemasStr.trim();
            parser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", schemasStr);
        }
        return parser;
    }

    public static void main(String[] args) throws Exception {
        ValidationTester tester = new ValidationTester();
        String[] schemas = new String[]{"urn:uddi-org:repl D:\\develop\\schema_test\\UDDI\\uddi_v2replication.xsd", "urn:uddi-org:api_v2 D:\\develop\\schema_test\\UDDI\\uddi_v2.xsd", "http://schemas.xmlsoap.org/soap/envelope/ D:\\develop\\schema_test\\UDDI\\soap.xsd", "http://www.w3.org/XML/1998/namespace D:\\develop\\schema_test\\UDDI\\xml.xsd", "urn:uddi-org:api D:\\develop\\schema_test\\UDDI\\uddi_v1.xsd"};
        String[] schemaLocations = new String[]{"D:\\develop\\schema_test\\UDDI\\uddi_v2replication.xsd", "D:\\develop\\schema_test\\UDDI\\uddi_v2.xsd", "D:\\develop\\schema_test\\UDDI\\soap.xsd", "D:\\develop\\schema_test\\UDDI\\xml.xsd", "D:\\develop\\schema_test\\UDDI\\uddi_v1.xsd"};
        SAXParser parser = tester.getValidationParser(schemas);
        LoaderImpl loader = new LoaderImpl();
        Source[] sources = new StreamSource[schemaLocations.length];
        for (int i = 0; i < sources.length; ++i) {
            sources[i] = new StreamSource(new FileInputStream(schemaLocations[i]));
        }
        Schema schema = loader.load(sources);
        parser.setProperty("http://apache.org/xml/properties/schema/schemaObject", schema);
        parser.parse("D:\\develop\\schema_test\\UDDI\\savebasetmodelsv2.xml");
        System.out.println("Validated!!!");
    }

    private static class TesterHandler
    extends DefaultHandler {
        private static final String DESTINATION_DIR = "D:\\develop\\schema_test\\UDDI";
        private static final String HTTP_IDENTIFIER = "http:";
        private static final String FILE_IDENTIFIER = "file:";

        private TesterHandler() {
        }

        public void error(SAXParseException ex) throws SAXException {
            throw ex;
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            this.error(ex);
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            Object fileInput = null;
            if (!systemId.endsWith(".xsd")) {
                return null;
            }
            if (systemId.startsWith(HTTP_IDENTIFIER)) {
                String schemaName = systemId.substring(systemId.lastIndexOf("/") + 1);
                systemId = DESTINATION_DIR + File.separator + schemaName;
            }
            InputStream inputStream = null;
            if (systemId.startsWith(FILE_IDENTIFIER)) {
                try {
                    URL url = new URL(systemId);
                    inputStream = url.openStream();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    return null;
                }
            }
            try {
                inputStream = new FileInputStream(systemId);
            }
            catch (IOException ioExc) {
                ioExc.printStackTrace();
                return null;
            }
            return new InputSource(inputStream);
        }
    }
}

