/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.schema.SchemaException;
import com.sap.engine.lib.schema.canonicalizator.AugmentationProps;
import com.sap.engine.lib.schema.components.Annotation;
import com.sap.engine.lib.schema.components.AttributeDeclaration;
import com.sap.engine.lib.schema.components.AttributeUse;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.ElementDeclaration;
import com.sap.engine.lib.schema.components.Facet;
import com.sap.engine.lib.schema.components.FundamentalFacets;
import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.components.Particle;
import com.sap.engine.lib.schema.components.SimpleTypeDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.components.Wildcard;
import com.sap.engine.lib.schema.regular.RegularExpression;
import com.sap.engine.lib.schema.validator.SchemaValidationException;
import com.sap.engine.lib.schema.validator.SchemaValidator;
import com.sap.engine.lib.xml.dom.AttrImpl;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.dom.ElementImpl;
import com.sap.engine.lib.xml.dom.ElementOnlyNodeListImpl;
import com.sap.engine.lib.xml.dom.NodeImpl;
import com.sap.engine.lib.xml.dom.QNameResolver;
import com.sap.engine.lib.xml.util.ListSplitter;
import java.lang.reflect.Array;
import java.util.Hashtable;
import java.util.Stack;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class ValidationRules
implements AugmentationProps {
    private SchemaValidator owner;
    private Hashtable regular = new Hashtable();
    private Stack stack = new Stack();
    private boolean canonicalizationProcessing = false;
    public static final boolean TRACE = false;

    protected ValidationRules(SchemaValidator owner) {
        this.owner = owner;
    }

    protected void clear() {
        this.stack.clear();
    }

    protected boolean cvcAssessAttr(Attr a, AttributeDeclaration ad) throws SchemaException {
        String local;
        String uri;
        if (ad == null && (ad = this.owner.schema.getTopLevelAttributeDeclaration(uri = (uri = a.getNamespaceURI()) == null ? "" : uri, local = a.getLocalName())) == null) {
            this.owner.con.sicAttrErrorCode(a, "cvc-assess-attr.1", "No declaration could be found for this attribute");
            return false;
        }
        boolean r = this.cvcAttribute(a, ad);
        if (!r) {
            this.owner.con.sicAttrErrorCode(a, "cvc-assess-attr.2", "Attribute not valid with respect to its declaration");
        }
        return r;
    }

    protected boolean cvcAssessElt(Element e, ElementDeclaration ed, boolean skip, TypeDefinitionBase td) throws SchemaException {
        Element eContext = null;
        if (e == null || ed != null && td != null) {
            throw new IllegalArgumentException();
        }
        if (ed == null && !skip && !e.hasAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            String uri = e.getNamespaceURI();
            uri = uri == null ? "" : uri;
            String local = e.getLocalName();
            ed = this.owner.schema.getTopLevelElementDeclaration(uri, local);
        }
        if (ed != null) {
            boolean r = this.cvcElt(e, ed);
            if (!r) {
                this.owner.con.sicEltErrorCode(e, "cvc-assess-elt.1.1.2", "Element not valid with respect to to its declaration");
            }
            this.owner.con.sicEOutcome(e, eContext, r ? "valid" : "invalid", "full");
            return r;
        }
        if (e.hasAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            String s = e.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            String uri = QNameResolver.qnameToURI(s, e);
            String local = QNameResolver.qnameToLocalName(s);
            TypeDefinitionBase tdLocal = this.owner.schema.getTopLevelTypeDefinition(uri, local);
            if (td != null) {
                // empty if block
            }
            td = tdLocal;
        }
        if (td != null) {
            boolean r = this.cvcType(e, td);
            this.owner.con.sicEltErrorCode(e, "cvc-assess-elt.1.2.2", "Element not valid with respect to its type definition");
            this.owner.con.sicEOutcome(e, eContext, r ? "valid" : "invalid", "full");
            return r;
        }
        this.owner.con.sicEltErrorCode(e, "cvc-assess-elt.1", "Could not find a declaration for this element");
        this.owner.con.sicEOutcome(e, eContext, "invalid", "full");
        return false;
    }

    protected boolean cvcAttribute(Attr a, AttributeDeclaration ad) throws SchemaException {
        if (ad == null) {
            this.owner.con.sicAttrErrorCode(a, "cvc-attribute.1", "Missing attribute declaration");
            return false;
        }
        SimpleTypeDefinition std = (SimpleTypeDefinition)ad.getTypeDefinition();
        if (std == null) {
            this.owner.con.sicAttrErrorCode(a, "cvc-attribute.2", "Missing type definition in the attribute declaration");
            return false;
        }
        boolean r = this.cvcSimpleType(a, a.getValue(), std);
        if (!r) {
            this.owner.con.sicAttrErrorCode(a, "cvc-attribute.3", "Attribute not valid against its type definition");
            return false;
        }
        String vcf = ad.getValueConstraintFixed();
        if (vcf != null) {
            FundamentalFacets ff = std.getFundamentalFacets();
            Object actualValue = ff.parse(a.getNodeValue());
            Object fixedValue = ff.parse(vcf);
            if (actualValue == null || !ff.equal(actualValue, fixedValue)) {
                this.owner.con.sicAttrErrorCode(a, "cvc-attribute.4", "Actual value does not match fixed value");
            }
        }
        if (this.canonicalizationProcessing) {
            ((com.sap.engine.lib.xml.dom.Base)((Object)a)).setAugmentation("[attribute declaration]", ad);
            ((com.sap.engine.lib.xml.dom.Base)((Object)a)).setAugmentation("[normalized value]", a.getValue());
            ((com.sap.engine.lib.xml.dom.Base)((Object)a)).setAugmentation("[schema normalized value]", a.getValue());
            Annotation annotation = ad.getAnnotation();
            if (annotation != null) {
                ((com.sap.engine.lib.xml.dom.Base)((Object)a)).setAugmentation("[annotation]", annotation);
            }
        }
        return true;
    }

    protected boolean cvcAU(Attr a, AttributeDeclaration ad) throws SchemaException {
        String vcf = ad.getValueConstraintFixed();
        SimpleTypeDefinition std = (SimpleTypeDefinition)ad.getTypeDefinition();
        if (vcf != null) {
            FundamentalFacets ff = std.getFundamentalFacets();
            Object actualValue = ff.parse(a.getNodeValue());
            Object fixedValue = ff.parse(vcf);
            if (actualValue == null || !ff.equal(actualValue, fixedValue)) {
                this.owner.con.sicAttrErrorCode(a, "cvc-attribute.4", "Actual value does not match fixed value");
                return false;
            }
        }
        return true;
    }

    protected boolean cvcComplexType(Element e, ComplexTypeDefinition td) throws SchemaException {
        if (td == null) {
            throw new IllegalArgumentException();
        }
        if (td.isAbstract()) {
            this.owner.con.sicEltErrorCode(e, "cvc-complex-type.1", "Cannot validate an element with respect to an abstract type");
            return false;
        }
        if (!ValidationRules.isNilled(e)) {
            if (td.isContentTypeEmpty()) {
                if (ValidationRules.hasChildElementsOrContent(e)) {
                    this.owner.con.sicEltErrorCode(e, "cvc-complex-type.2.1", "Element should be empty according to its type definition");
                    return false;
                }
            } else if (td.getContentTypeSimpleTypeDefinition() != null) {
                if (ValidationRules.hasChildElements(e)) {
                    this.owner.con.sicEltErrorCode(e, "cvc-complex-type.2.2", "Element has children, but is of a complex type with simple content");
                    return false;
                }
                if (!this.cvcSimpleType(e, this.getContentOf(e), td.getContentTypeSimpleTypeDefinition())) {
                    this.owner.con.sicEltErrorCode(e, "cvc-complex-type.2.2", "Element not valid with respect to its (simple) type definition");
                    return false;
                }
            } else {
                if (!td.isMixed() && ValidationRules.hasNonWhitespaceContent(e)) {
                    this.owner.con.sicEltErrorCode(e, "cvc-complex-type.2.3", "Element has non-whitespace content but is not declared mixed");
                    return false;
                }
                ElementOnlyNodeListImpl list = new ElementOnlyNodeListImpl(e.getChildNodes());
                Particle particle = td.getContentTypeContentModel();
                boolean r = this.cvcParticle(list, 0, list.getLength(), particle, e);
                if (!r) {
                    this.owner.con.sicEltErrorCode(e, "cvc-complex-type.2.4", "Element's child list is not valid with respect to the respective content model");
                    return false;
                }
                if (this.canonicalizationProcessing) {
                    ((com.sap.engine.lib.xml.dom.Base)((Object)e)).setAugmentation("[type definition]", td);
                }
            }
        }
        NamedNodeMap attrs = e.getAttributes();
        int nAttrs = attrs.getLength();
        boolean[] processed = new boolean[nAttrs];
        int stack0 = this.stack.size();
        td.getAttributeUses(this.stack);
        int stack1 = this.stack.size();
        boolean returnValue = true;
        block0: for (int i = stack0; i < stack1; ++i) {
            Attr attr;
            AttributeUse au = (AttributeUse)this.stack.get(i);
            AttributeDeclaration ad = au.getAttributeDeclaration();
            String uri = ad.getTargetNamespace();
            if (uri != null && uri.length() == 0) {
                uri = null;
            }
            if ((attr = e.getAttributeNodeNS(uri, ad.getName())) == null) {
                if (!au.isRequired()) continue;
                returnValue = false;
                this.owner.con.sicEltErrorCode(e, "cvc-complex-type.4", "A required attribute is missing");
                break;
            }
            returnValue = this.cvcAssessAttr(attr, ad);
            if (!returnValue) {
                this.owner.con.sicEltErrorCode(e, "cvc-complex-type.3.1", "Attribute not valid");
                break;
            }
            for (int j = 0; j < nAttrs; ++j) {
                if (attrs.item(j) != attr) continue;
                processed[j] = true;
                continue block0;
            }
        }
        this.stack.setSize(stack0);
        if (!returnValue) {
            return false;
        }
        Wildcard w = td.getAttributeWildcard();
        for (int i = 0; i < nAttrs; ++i) {
            Attr attr;
            if (processed[i] || "http://www.w3.org/2001/XMLSchema-instance".equals((attr = (Attr)attrs.item(i)).getNamespaceURI()) || attr.getNodeName().startsWith("xml")) continue;
            if (w == null) {
                this.owner.con.sicAttrErrorCode(attr, "cvc-complex-type", "");
                return false;
            }
            boolean r = this.cvcWildcard(attr, w);
            if (r) continue;
            this.owner.con.sicAttrErrorCode(attr, "cvc-complex-type", "Attribute not declared and the wildcard doesn't match it");
            return false;
        }
        return true;
    }

    protected boolean cvcDatatypeValid(Node node, String s, SimpleTypeDefinition td) throws SchemaException {
        if (this.canonicalizationProcessing) {
            ((com.sap.engine.lib.xml.dom.Base)node).setAugmentation("[type definition]", td);
            ((com.sap.engine.lib.xml.dom.Base)node).setAugmentation("[normalized value]", s);
        }
        if (td.isVarietyList()) {
            SimpleTypeDefinition itemTD = td.getItemTypeDefinition();
            if (itemTD == null) {
                return true;
            }
            String[] tokens = ListSplitter.split(s);
            for (int i = 0; i < tokens.length; ++i) {
                boolean b = this.cvcDatatypeValid(node, tokens[i], itemTD);
                if (b) continue;
                return false;
            }
            int stack0 = this.stack.size();
            td.getFacets(this.stack);
            int stack1 = this.stack.size();
            boolean r = true;
            for (int i = stack0; i < stack1; ++i) {
                Facet f = (Facet)this.stack.get(i);
                r = this.cvcFacetValid(node, s, td, f, null, tokens);
                if (r) continue;
                this.owner.con.errorCode(node, "cvc-datatype-valid", "A facet failed for a list");
                break;
            }
            this.stack.setSize(stack0);
            return r;
        }
        if (td.isVarietyUnion()) {
            int stack0 = this.stack.size();
            td.getMemberTypeDefinitions(this.stack);
            int stack1 = this.stack.size();
            this.owner.con.suppressErrors();
            boolean ok = false;
            for (int i = stack0; i < stack1; ++i) {
                SimpleTypeDefinition mtd = (SimpleTypeDefinition)this.stack.get(i);
                if (!this.cvcDatatypeValid(node, s, mtd)) continue;
                ok = true;
                if (!this.canonicalizationProcessing) break;
                ((com.sap.engine.lib.xml.dom.Base)node).setAugmentation("[member type definition]", mtd);
                break;
            }
            this.owner.con.unsuppressErrors();
            this.stack.setSize(stack0);
            if (!ok) {
                this.owner.con.errorCode(node, "cvc-datatype-valid", "Content not valid against its union simple type");
                return false;
            }
            return true;
        }
        if (td.isVarietyAtomic()) {
            Object o = null;
            FundamentalFacets ff = td.getFundamentalFacets();
            if (ff != null && (o = ff.parse(s)) == null) {
                this.owner.con.sicSTErrorCode(node, "cvc-datatype-valid", "Value '" + s + "' does not belong to the lexical space of its primitive type definition");
                return false;
            }
            int stack0 = this.stack.size();
            td.getFacets(this.stack);
            int stack1 = this.stack.size();
            boolean patternPresent = false;
            boolean patternValid = false;
            boolean enumerationPresent = false;
            boolean enumerationValid = false;
            boolean returnValue = true;
            for (int i = stack0; i < stack1; ++i) {
                Facet f = (Facet)this.stack.get(i);
                String fName = f.getName();
                if (fName.equals("pattern")) {
                    patternPresent = true;
                    patternValid = patternValid || this.cvcPatternValid(node, s, td, f);
                    continue;
                }
                if (fName.equals("enumeration")) {
                    enumerationPresent = true;
                    enumerationValid = enumerationValid || this.cvcEnumerationValid(node, s, td, f);
                    continue;
                }
                boolean x = this.cvcFacetValid(node, s, td, f, ff, o);
                if (x) continue;
                returnValue = false;
                break;
            }
            returnValue = !(!returnValue || !patternValid && patternPresent || !enumerationValid && enumerationPresent);
            this.stack.setSize(stack0);
            return returnValue;
        }
        throw new SchemaValidationException("Unknown variety");
    }

    protected boolean cvcElt(Element e, ElementDeclaration ed) throws SchemaException {
        String vc;
        if (ed == null) {
            this.owner.con.sicEltErrorCode(e, "cvc-elt.1", "Missing element declaration");
            return false;
        }
        if (ed.isAbstract()) {
            this.owner.con.sicEltErrorCode(e, "cvc-elt.2", "Cannot validate with respect to an abstract element declaration");
            return false;
        }
        boolean clause32Applied = false;
        if (!ed.isNillable()) {
            if (ValidationRules.hasXsiNil(e)) {
                this.owner.con.sicEltErrorCode(e, "cvc-elt.3.1", "Element has xsi:nil, but is not declared nillable");
                return false;
            }
        } else if (ValidationRules.isNilled(e)) {
            if (ValidationRules.hasChildElementsOrContent(e)) {
                this.owner.con.sicEltErrorCode(e, "cvc-elt.3.2.1", "Nilled elements should have no content");
                return false;
            }
            if (ed.getValueConstraintFixed() != null) {
                this.owner.con.sicEltErrorCode(e, "cvc-elt.3.2.1", "Fixed elements cannot be nilled");
                return false;
            }
            clause32Applied = true;
        }
        TypeDefinitionBase td = ed.getTypeDefinition();
        if (e.hasAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            String local;
            String s = e.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            String uri = QNameResolver.qnameToURI(s, e);
            TypeDefinitionBase tdLocal = this.owner.schema.getTopLevelTypeDefinition(uri, local = QNameResolver.qnameToLocalName(s));
            if (tdLocal == null) {
                this.owner.con.sicEltErrorCode(e, "cvc-elt.4.2", "Could not resolve xsi:type");
                return false;
            }
            td = tdLocal;
        }
        String vcd = ed.getValueConstraintDefault();
        String vcf = ed.getValueConstraintFixed();
        if (vcd == null && vcf == null || ValidationRules.hasChildElementsOrContent(e) || clause32Applied) {
            boolean v = this.cvcType(e, td);
            if (!v) {
                this.owner.con.sicEltErrorCode(e, "cvc-elt.5.2.1", "Element not valid with respect to its type definition");
                return false;
            }
            if (vcf != null && !clause32Applied && ValidationRules.hasChildElements(e)) {
                this.owner.con.sicEltErrorCode(e, "cvc-elt.5.2.2.1", "Element has children, but is declared fixed");
                return false;
            }
        }
        this.owner.con.sicEltDecl(e, ed, clause32Applied);
        String string = vc = vcf == null ? vcd : vcf;
        if (!clause32Applied && vc != null) {
            this.owner.con.sicEltDefault(e, vc);
        }
        if (this.canonicalizationProcessing) {
            String value;
            if (!clause32Applied && vcd == null && (td instanceof SimpleTypeDefinition || td instanceof ComplexTypeDefinition && ((ComplexTypeDefinition)td).getContentTypeSimpleTypeDefinition() != null) && (value = e.getFirstChild().getNodeValue()) != null) {
                ((com.sap.engine.lib.xml.dom.Base)((Object)e)).setAugmentation("[schema normalized value]", value);
            }
            ((com.sap.engine.lib.xml.dom.Base)((Object)e)).setAugmentation("[element declaration]", ed);
            Annotation annotation = ed.getAnnotation();
            if (annotation != null) {
                ((com.sap.engine.lib.xml.dom.Base)((Object)e)).setAugmentation("[annotation]", annotation);
            }
        }
        return true;
    }

    protected boolean cvcEnumerationValid(Node node, String s, SimpleTypeDefinition std, Facet f) throws SchemaException {
        FundamentalFacets ff = std.getFundamentalFacets();
        Object obj0 = ff.parse(f.getValue());
        Object obj1 = ff.parse(s);
        boolean r = ff.equal(obj0, obj1);
        return r;
    }

    protected boolean cvcFacetValid(Node node, String s, SimpleTypeDefinition std, Facet f, FundamentalFacets ff, Object o) throws SchemaException {
        String fName = f.getName();
        boolean r = true;
        if (fName.equals("length")) {
            r = this.cvcLengthValid(node, s, std, f, ff, o);
        } else if (fName.equals("minLength")) {
            r = this.cvcMinLengthValid(node, s, std, f, ff, o);
        } else if (fName.equals("maxLength")) {
            r = this.cvcMaxLengthValid(node, s, std, f, ff, o);
        } else if (fName.equals("minExclusive")) {
            r = this.cvcMinExclusiveValid(node, s, std, f);
        } else if (fName.equals("maxExclusive")) {
            r = this.cvcMaxExclusiveValid(node, s, std, f);
        } else if (fName.equals("minInclusive")) {
            r = this.cvcMinInclusiveValid(node, s, std, f);
        } else if (fName.equals("maxInclusive")) {
            r = this.cvcMaxInclusiveValid(node, s, std, f);
        } else if (fName.equals("totalDigits")) {
            r = this.cvcTotalDigitsValid(node, s, std, f);
        } else if (fName.equals("fractionDigits")) {
            r = this.cvcFractionDigitsValid(node, s, std, f);
        } else if (fName.equals("enumeration")) {
            r = this.cvcEnumerationValid(node, s, std, f);
        } else if (!fName.equals("whitespace") && fName.equals("pattern")) {
            r = this.cvcPatternValid(node, s, std, f);
        }
        if (!r) {
            this.owner.con.errorCode(node, "cvc-facet-valid.1", "A facet did not apply");
        }
        return r;
    }

    protected boolean cvcFractionDigitsValid(Node node, String s, SimpleTypeDefinition std, Facet f) throws SchemaException {
        return true;
    }

    protected boolean cvcId() throws SchemaException {
        return true;
    }

    protected boolean cvcIdentityConstraint() throws SchemaException {
        return true;
    }

    private static int getLengthDependingOnType(Object o, SimpleTypeDefinition std) throws SchemaException {
        if (o instanceof byte[] || std.isVarietyList()) {
            return Array.getLength(o);
        }
        return o.toString().length();
    }

    protected boolean cvcLengthValid(Node node, String s, SimpleTypeDefinition std, Facet f, FundamentalFacets ff, Object o) throws SchemaException {
        boolean r;
        int l = ValidationRules.getLengthDependingOnType(o, std);
        boolean bl = r = l == Integer.parseInt(f.getValue());
        if (!r) {
            this.owner.con.errorCode(node, "cvc-length-valid", "Facet xs:length failed");
        }
        return r;
    }

    protected boolean cvcMinLengthValid(Node node, String s, SimpleTypeDefinition std, Facet f, FundamentalFacets ff, Object o) throws SchemaException {
        boolean r;
        int l = ValidationRules.getLengthDependingOnType(o, std);
        boolean bl = r = l >= Integer.parseInt(f.getValue());
        if (!r) {
            this.owner.con.errorCode(node, "cvc-length-valid", "Facet xs:minLength failed");
        }
        return r;
    }

    protected boolean cvcMaxLengthValid(Node node, String s, SimpleTypeDefinition std, Facet f, FundamentalFacets ff, Object o) throws SchemaException {
        boolean r;
        int l = ValidationRules.getLengthDependingOnType(o, std);
        boolean bl = r = l <= Integer.parseInt(f.getValue());
        if (!r) {
            this.owner.con.errorCode(node, "cvc-length-valid", "Facet xs:maxLength failed");
        }
        return r;
    }

    protected boolean cvcTotalDigitsValid(Node node, String s, SimpleTypeDefinition std, Facet f) throws SchemaException {
        boolean r;
        int v = Integer.parseInt(f.getValue());
        int c = 0;
        int ls = s.length();
        for (int i = 0; i < ls; ++i) {
            char ch = s.charAt(i);
            if (ch < '0' || ch > '9') continue;
            ++c;
        }
        boolean bl = r = c <= v;
        if (!r) {
            this.owner.con.errorCode(node, "cvc-totalDigits-valid.1", "The number of digits in the value must be less than or equal to the limit specified in the totalDigits facet");
        }
        return true;
    }

    protected boolean cvcMaxExclusiveValid(Node node, String s, SimpleTypeDefinition std, Facet f) throws SchemaException {
        FundamentalFacets ff = std.getFundamentalFacets();
        if (ff.isNumeric()) {
            boolean r = ff.less(ff.parse(f.getValue()), ff.parse(s));
            if (!r) {
                this.owner.con.errorCode(node, "cvc-maxInclusive-valid", "Facet xs:maxInclusive failed");
            }
            return r;
        }
        return true;
    }

    protected boolean cvcMaxInclusiveValid(Node node, String s, SimpleTypeDefinition std, Facet f) throws SchemaException {
        FundamentalFacets ff = std.getFundamentalFacets();
        if (ff.isNumeric()) {
            boolean r;
            boolean bl = r = !ff.less(ff.parse(f.getValue()), ff.parse(s));
            if (!r) {
                this.owner.con.errorCode(node, "cvc-maxInclusive-valid", "Facet xs:maxInclusive failed");
            }
            return r;
        }
        return true;
    }

    protected boolean cvcMinExclusiveValid(Node node, String s, SimpleTypeDefinition std, Facet f) throws SchemaException {
        FundamentalFacets ff = std.getFundamentalFacets();
        if (ff.isNumeric()) {
            boolean r = ff.less(ff.parse(s), ff.parse(f.getValue()));
            if (!r) {
                this.owner.con.errorCode(node, "cvc-maxInclusive-valid", "Facet xs:maxInclusive failed");
            }
            return r;
        }
        return true;
    }

    protected boolean cvcMinInclusiveValid(Node node, String s, SimpleTypeDefinition std, Facet f) throws SchemaException {
        FundamentalFacets ff = std.getFundamentalFacets();
        if (ff.isNumeric()) {
            boolean r;
            boolean bl = r = !ff.less(ff.parse(s), ff.parse(f.getValue()));
            if (!r) {
                this.owner.con.errorCode(node, "cvc-minInclusive-valid", "Facet xs:minInclusive failed");
            }
            return r;
        }
        return true;
    }

    protected boolean cvcModelGroup(NodeList list, int start, int end, ModelGroup mg, Element node) throws SchemaException {
        int x = this.iterateGreedilyOneStep(list, start, end, mg, node);
        boolean r = x == end;
        return r;
    }

    protected boolean cvcParticle(NodeList list, int start, int end, Particle p, Element node) throws SchemaException {
        Base term = p.getTerm();
        int minOccurs = p.getMinOccurs();
        int maxOccurs = p.getMaxOccurs();
        int tTerm = term.getTypeOfComponent();
        if (tTerm == 10) {
            if (end - start < minOccurs) {
                this.owner.con.sicEltErrorCode(node, "cvc-particle.1.1", "minOccurs for wildcard is not adhered to");
                return false;
            }
            if (maxOccurs != Integer.MAX_VALUE && end - start > maxOccurs) {
                this.owner.con.sicEltErrorCode(node, "cvc-particle.1.2", "maxOccurs for wildcard is not adhered to");
                return false;
            }
            Wildcard w = (Wildcard)term;
            for (int i = start; i < end; ++i) {
                boolean r = this.cvcWildcard(list.item(i), w);
                if (r) continue;
                this.owner.con.sicEltErrorCode((Element)list.item(i), "cvc-particle.1.3", "Element not valid with respect to the wildcard associated with it");
                return false;
            }
            return true;
        }
        if (tTerm == 3) {
            if (end - start < minOccurs) {
                this.owner.con.sicEltErrorCode(node, "cvc-particle.1.1", "minOccurs for element declaration is not adhered to");
                return false;
            }
            if (maxOccurs != Integer.MAX_VALUE && end - start > maxOccurs) {
                this.owner.con.sicEltErrorCode(node, "cvc-particle.1.2", "maxOccurs for element declaration is not adhered to");
                return false;
            }
            ElementDeclaration ed = (ElementDeclaration)term;
            String uri = ed.getTargetNamespace();
            String local = ed.getName();
            for (int i = start; i < end; ++i) {
                Element e = (Element)list.item(i);
                boolean r = this.cvcAssessElt(e, ed, false, null);
                if (r) continue;
                this.owner.con.sicEltErrorCode(e, "cvc-particle.2.3", "Element not valid with respect to its declaration");
                return false;
            }
            return true;
        }
        if (tTerm == 7) {
            int r = this.iterateGreedily(list, start, end, p, node);
            if (r != end) {
                this.owner.con.sicEltErrorCode(node, "cvc-particle.3", "Element child list not valid with respect to the particle associated with it (Check if the order of elements and minOccurs/maxOccurs are ok)");
                return false;
            }
            return true;
        }
        return true;
    }

    private int iterateGreedily(NodeList list, int start, int end, Particle p, Element node) throws SchemaException {
        int minOccurs = p.getMinOccurs();
        int maxOccurs = p.getMaxOccurs();
        int occurrences = 0;
        Base term = p.getTerm();
        int r;
        while ((r = this.iterateGreedilyOneStep(list, start, end, term, node)) != -1) {
            if (++occurrences > maxOccurs) {
                return start;
            }
            start = r;
        }
        return occurrences >= minOccurs ? start : -1;
    }

    private int iterateGreedilyOneStep(NodeList list, int start, int end, Base term, Element node) throws SchemaException {
        int tTerm = term.getTypeOfComponent();
        if (tTerm == 10) {
            if (start == end) {
                return -1;
            }
            boolean b = this.cvcWildcard(list.item(start), (Wildcard)term);
            return b ? start + 1 : -1;
        }
        if (tTerm == 3) {
            if (start == end) {
                return -1;
            }
            ElementDeclaration ed = (ElementDeclaration)term;
            String uri = ed.getTargetNamespace();
            String local = ed.getName();
            Node e = list.item(start);
            String eUri = e.getNamespaceURI();
            eUri = eUri == null ? "" : eUri;
            String eLocal = e.getLocalName();
            if (local.equals(eLocal) && uri.equals(eUri)) {
                return start + 1;
            }
            return -1;
        }
        if (tTerm == 7) {
            int r;
            ModelGroup mg = (ModelGroup)term;
            int stack0 = this.stack.size();
            mg.getParticles(this.stack);
            int stack1 = this.stack.size();
            if (mg.isCompositorAll()) {
                int i;
                int n = stack1 - stack0;
                boolean[] found = new boolean[n];
                ElementDeclaration[] eds = new ElementDeclaration[n];
                Particle[] particles = new Particle[n];
                String[] edUris = new String[n];
                String[] edLocals = new String[n];
                for (i = 0; i < n; ++i) {
                    particles[i] = (Particle)this.stack.get(stack0 + i);
                    eds[i] = (ElementDeclaration)particles[i].getTerm();
                    edUris[i] = eds[i].getTargetNamespace();
                    edLocals[i] = eds[i].getName();
                }
                block1: while (start < end) {
                    String currentUri;
                    Node currentNode = list.item(start);
                    if (this.canonicalizationProcessing) {
                        ((com.sap.engine.lib.xml.dom.Base)currentNode).setAugmentation("[validating model group all]", term);
                    }
                    currentUri = (currentUri = currentNode.getNamespaceURI()) == null ? "" : currentUri;
                    String currentLocal = currentNode.getLocalName();
                    boolean matched = false;
                    for (int i2 = 0; i2 < n; ++i2) {
                        if (!currentUri.equals(edUris[i2]) || !currentLocal.equals(edLocals[i2])) continue;
                        if (found[i2]) break block1;
                        matched = true;
                        found[i2] = true;
                        boolean b = this.cvcElt((Element)currentNode, eds[i2]);
                        if (b) break;
                        r = -1;
                        this.owner.con.sicEltErrorCode((Element)currentNode, "cvc-particle.3.3", "Element participates in an xs:all group and is invalid");
                        break block1;
                    }
                    if (!matched) break;
                    ++start;
                }
                r = start;
                for (i = 0; i < n; ++i) {
                    if (found[i] || particles[i].getMinOccurs() <= 0) continue;
                    r = -1;
                    this.owner.con.sicEltErrorCode(node, "cvc-particle.3.3", "Element's children are not valid against an xs:all model group - some element declaration in the group has minOccurs = '1', but there is no corresponding element info item among the children");
                    r = -1;
                    break;
                }
            } else if (mg.isCompositorChoice()) {
                r = -1;
                for (int i = stack0; i < stack1; ++i) {
                    Particle p = (Particle)this.stack.get(i);
                    r = this.iterateGreedily(list, start, end, p, node);
                    if (r == -1) continue;
                    boolean rr = this.cvcParticle(list, start, r, p, node);
                    if (!rr) {
                        r = -1;
                    }
                    break;
                }
            } else if (mg.isCompositorSequence()) {
                r = start;
                for (int i = stack0; i < stack1; ++i) {
                    Particle x = (Particle)this.stack.get(i);
                    int r0 = r;
                    if ((r = this.iterateGreedily(list, r, end, x, node)) != -1) {
                        boolean rr = this.cvcParticle(list, r0, r, x, node);
                        if (rr) continue;
                        r = -1;
                    }
                    break;
                }
            } else {
                r = -1;
            }
            this.stack.setSize(stack0);
            return r;
        }
        return -1;
    }

    protected boolean cvcPatternValid(Node node, String s, SimpleTypeDefinition std, Facet f) throws SchemaException {
        boolean r = this.getRegularExpression(f.getValue()).matcher(s).matches();
        if (!r) {
            this.owner.con.errorCode(node, "cvc-pattern-valid", "Value does not match its regular expression");
        }
        return r;
    }

    protected Base cvcResolveInstance(String uri, String local, int t) throws SchemaException {
        return this.owner.schema.getTopLevelComponent(uri, local, t);
    }

    protected boolean cvcSimpleType(Node node, String s, SimpleTypeDefinition std) throws SchemaException {
        boolean r = this.cvcDatatypeValid(node, s, std);
        if (!r) {
            this.owner.con.sicSTErrorCode(node, "cvc-simple-type", "Content not valid");
        }
        if (this.canonicalizationProcessing) {
            ((com.sap.engine.lib.xml.dom.Base)node).setAugmentation("[type definition]", std);
        }
        return r;
    }

    protected boolean cvcType(Element e, TypeDefinitionBase td) throws SchemaException {
        this.owner.con.sicEltType(e, null, td, null);
        if (td == null) {
            this.owner.con.sicEltErrorCode(e, "cvc-type.1", "Missing type definition");
            return false;
        }
        if (td.getTypeOfComponent() == 2) {
            if (ValidationRules.hasSpecialAttributes(e)) {
                // empty if block
            }
            if (ValidationRules.hasChildElements(e)) {
                this.owner.con.sicEltErrorCode(e, "cvc-type.3.1.2", "Element is of a simple type, but has child elements");
                return false;
            }
            String value = this.getContentOf(e);
            boolean r = this.cvcDatatypeValid(e, value, (SimpleTypeDefinition)td);
            if (!r) {
                this.owner.con.sicEltErrorCode(e, "cvc-type.3.1.3", "Content not valid");
                return false;
            }
            return true;
        }
        ComplexTypeDefinition ct = (ComplexTypeDefinition)td;
        if (ct.isAbstract()) {
            this.owner.con.sicEltErrorCode(e, "cvc-type.2", "Cannot validate an element with respect to an abstract type");
            return false;
        }
        boolean r = this.cvcComplexType(e, ct);
        if (!r) {
            this.owner.con.sicEltErrorCode(e, "cvc-type.3.2", "Element not valid with respect to its complex type");
            return false;
        }
        if (this.canonicalizationProcessing) {
            ((com.sap.engine.lib.xml.dom.Base)((Object)e)).setAugmentation("[type definition]", td);
        }
        return true;
    }

    protected boolean cvcWildcard(Node node, Wildcard w) throws SchemaException {
        boolean r = this.cvcWildcardNamespace(node, node.getNamespaceURI(), w);
        if (!r) {
            return false;
        }
        if (w.isProcessContentsLax()) {
            return this.processWildcardNode(node, w.isAttribWildcard(), true);
        }
        if (w.isProcessContentsStrict()) {
            if (w.isAttribWildcard()) {
                return this.cvcAssessAttr((Attr)node, null);
            }
            return this.cvcAssessElt((Element)node, null, false, null);
        }
        if (w.isProcessContentsSkip()) {
            this.processWildcardNode(node, w.isAttribWildcard(), false);
        }
        return true;
    }

    private boolean processWildcardNode(Node node, boolean isAttribWildcard, boolean isLaxContent) throws SchemaException {
        String uri = node.getNamespaceURI();
        if (uri == null) {
            uri = "";
        }
        String localName = node.getLocalName();
        String value = DOM.getNodeValue(node);
        boolean validationAttempted = true;
        if (isLaxContent) {
            if (isAttribWildcard) {
                AttributeDeclaration attribDeclr = this.owner.getSchema().getTopLevelAttributeDeclaration(uri, localName);
                if (attribDeclr != null) {
                    return this.cvcAssessAttr((Attr)node, attribDeclr);
                }
                validationAttempted = false;
            } else {
                ElementDeclaration elemDeclr = this.owner.getSchema().getTopLevelElementDeclaration(uri, localName);
                if (elemDeclr != null) {
                    return this.cvcAssessElt((Element)node, elemDeclr, false, null);
                }
                validationAttempted = false;
            }
        }
        if (this.canonicalizationProcessing) {
            if (value != null) {
                ((NodeImpl)node).setAugmentation("[normalized value]", value);
                ((NodeImpl)node).setAugmentation("[schema normalized value]", value);
            }
            if (!isLaxContent || !validationAttempted) {
                this.setValidationAttemptedAugToFalse(node);
            }
        }
        if (node instanceof Element) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                boolean result;
                Node childNode = nodeList.item(i);
                if (!(childNode instanceof Element) || (result = this.processWildcardNode(childNode, false, isLaxContent))) continue;
                return false;
            }
        }
        return true;
    }

    private void setValidationAttemptedAugToFalse(Node node) {
        Node parent;
        ((NodeImpl)node).setAugmentation("[validation attempted]", Boolean.FALSE);
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                AttrImpl attr = (AttrImpl)namedNodeMap.item(i);
                String value = attr.getValue();
                attr.setAugmentation("[normalized value]", value);
                attr.setAugmentation("[schema normalized value]", value);
                attr.setAugmentation("[validation attempted]", Boolean.FALSE);
            }
        }
        Node node2 = parent = node instanceof Attr ? ((Attr)node).getOwnerElement() : node.getParentNode();
        if (parent != null && !(parent instanceof Document) && !((ElementImpl)parent).hasAugmentation("[validation attempted]")) {
            this.setValidationAttemptedAugToFalse((Element)parent);
        }
    }

    protected boolean cvcWildcardNamespace(Node node, String uri, Wildcard w) throws SchemaException {
        if (w.isNamespaceConstraintAny()) {
            return true;
        }
        uri = uri == null ? "" : uri;
        String neg = w.getNamespaceConstraintNegated();
        if (neg != null) {
            if (uri.equals(neg)) {
                this.owner.con.errorCode(node, "cvc-wildcard-namespace.2.2.2", "The namespace uri of this node is equal to the negated namespace constraint");
                return false;
            }
            if (uri.length() == 0) {
                this.owner.con.errorCode(node, "cvc-wildcard-namespace.2.2.3", "The presence of a negated namespace constraint disallows the null uri");
                return false;
            }
            return true;
        }
        int stack0 = this.stack.size();
        w.getNamespaceConstraintMembers(this.stack);
        int stack1 = this.stack.size();
        boolean r = false;
        for (int i = stack0; i < stack1; ++i) {
            if (!uri.equals(this.stack.get(i))) continue;
            r = true;
            break;
        }
        this.stack.setSize(stack0);
        if (!r) {
            this.owner.con.errorCode(node, "cvc-wildcard-namespace.3", "The namespace uri of this node is not among the members of the namespace constraint");
        }
        return r;
    }

    protected void setCanonicalizationProcessing(boolean canonicalizationProcessing) {
        this.canonicalizationProcessing = canonicalizationProcessing;
    }

    protected boolean getCanonicalizationProcessing() {
        return this.canonicalizationProcessing;
    }

    private static boolean hasSpecialAttributes(Node element) throws SchemaException {
        NamedNodeMap attrs = element.getAttributes();
        int nAttrs = attrs.getLength();
        for (int i = 0; i < nAttrs; ++i) {
            if (ValidationRules.isSpecialAttribute(attrs.item(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isSpecialAttribute(Node attr) throws SchemaException {
        String uri = attr.getNamespaceURI();
        String string = uri = uri == null ? "" : uri;
        if (!"http://www.w3.org/2001/XMLSchema-instance".equals(uri)) {
            return false;
        }
        String local = attr.getLocalName();
        return local.equals("type") || local.equals("nil") || local.equals("null") || local.equals("schemaLocation") || local.equals("noNamespaceSchemaLocation");
    }

    private static boolean hasXsiNil(Node element) throws SchemaException {
        NamedNodeMap attrs = element.getAttributes();
        int nAttrs = attrs.getLength();
        for (int i = 0; i < nAttrs; ++i) {
            if (!ValidationRules.isXsiNil(attrs.item(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isXsiNil(Node attr) throws SchemaException {
        String uri = attr.getNamespaceURI();
        String string = uri = uri == null ? "" : uri;
        if (!"http://www.w3.org/2001/XMLSchema-instance".equals(uri)) {
            return false;
        }
        String local = attr.getLocalName();
        return local.equals("nil") || local.equals("null");
    }

    private static boolean isNilled(Node element) throws SchemaException {
        NamedNodeMap attrs = element.getAttributes();
        int nAttrs = attrs.getLength();
        for (int i = 0; i < nAttrs; ++i) {
            if (!ValidationRules.isXsiNil(attrs.item(i))) continue;
            String v = attrs.item(i).getNodeValue();
            return v.equals("1") || v.equals("true");
        }
        return false;
    }

    private static boolean hasChildElements(Node element) throws SchemaException {
        NodeList children = element.getChildNodes();
        int nChildren = children.getLength();
        for (int i = 0; i < nChildren; ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    private static boolean hasChildElementsOrContent(Node element) throws SchemaException {
        NodeList children = element.getChildNodes();
        int nChildren = children.getLength();
        for (int i = 0; i < nChildren; ++i) {
            short nt = children.item(i).getNodeType();
            if (nt != 1 && nt != 3 && nt != 4) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNonWhitespaceContent(Node element) throws SchemaException {
        NodeList children = element.getChildNodes();
        int nChildren = children.getLength();
        for (int i = 0; i < nChildren; ++i) {
            short nt = children.item(i).getNodeType();
            if (nt != 3 && nt != 4) continue;
            String s = children.item(i).getNodeValue();
            for (int j = 0; j < s.length(); ++j) {
                char ch = s.charAt(j);
                if (ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t') continue;
                return true;
            }
        }
        return false;
    }

    private RegularExpression getRegularExpression(String pattern) throws SchemaException {
        RegularExpression re = (RegularExpression)this.regular.get(pattern);
        if (re == null) {
            re = RegularExpression.compile(pattern);
            this.regular.put(pattern, re);
        }
        return re;
    }

    private String getContentOf(Element e) throws SchemaException {
        NodeList children = e.getChildNodes();
        StringBuffer b = new StringBuffer();
        int nChildren = children.getLength();
        for (int i = 0; i < nChildren; ++i) {
            short nt = children.item(i).getNodeType();
            if (nt != 4 && nt != 3) continue;
            b.append(children.item(i).getNodeValue());
        }
        return b.toString();
    }
}

