/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.schema.components.impl0.LoaderImpl;
import com.sap.engine.lib.schema.validator.PIExtractor;
import com.sap.engine.lib.schema.validator.SchemaValidator;
import com.sap.engine.lib.xml.SystemProperties;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

public final class Tester {
    private static final boolean USE_XSV = true;
    private static final File dir = new File("./files").getAbsoluteFile();
    private static FileWriter out;
    private static final String BG = "black";
    private static final String TEXT = "white";
    private static String filenameXSD;
    private static boolean expectedResult;
    private static PIExtractor piExtractor;
    private static String comment;
    private static final String C_NO_ASSOC = "#666666";
    private static final String C_CONSTRUCTION = "#995555";
    private static final String C_LOADING = "magenta";
    private static final String C_NOT_OK = "red";
    private static final String[] TARGETS;
    private static String[] sa;
    static /* synthetic */ Class class$javax$xml$parsers$DocumentBuilderFactory;
    static /* synthetic */ Class class$com$sap$engine$lib$jaxp$DocumentBuilderFactoryImpl;
    static /* synthetic */ Class class$javax$xml$transform$TransformerFactory;
    static /* synthetic */ Class class$com$sap$engine$lib$jaxp$TransformerFactoryImpl;

    public static void main(String[] args) throws Exception {
        SystemProperties.setProperty((class$javax$xml$parsers$DocumentBuilderFactory == null ? (class$javax$xml$parsers$DocumentBuilderFactory = Tester.class$("javax.xml.parsers.DocumentBuilderFactory")) : class$javax$xml$parsers$DocumentBuilderFactory).getName(), (class$com$sap$engine$lib$jaxp$DocumentBuilderFactoryImpl == null ? (class$com$sap$engine$lib$jaxp$DocumentBuilderFactoryImpl = Tester.class$("com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl")) : class$com$sap$engine$lib$jaxp$DocumentBuilderFactoryImpl).getName());
        SystemProperties.setProperty((class$javax$xml$transform$TransformerFactory == null ? (class$javax$xml$transform$TransformerFactory = Tester.class$("javax.xml.transform.TransformerFactory")) : class$javax$xml$transform$TransformerFactory).getName(), (class$com$sap$engine$lib$jaxp$TransformerFactoryImpl == null ? (class$com$sap$engine$lib$jaxp$TransformerFactoryImpl = Tester.class$("com.sap.engine.lib.jaxp.TransformerFactoryImpl")) : class$com$sap$engine$lib$jaxp$TransformerFactoryImpl).getName());
        piExtractor = new PIExtractor();
        Tester.initResult();
        SchemaValidator validator = new SchemaValidator();
        LoaderImpl loader = new LoaderImpl();
        DocumentBuilderFactory bf = DocumentBuilderFactory.newInstance();
        bf.setNamespaceAware(true);
        DocumentBuilder builder = bf.newDocumentBuilder();
        File[] f = dir.listFiles();
        int successful = 0;
        int total = 0;
        for (int i = 0; i < f.length; ++i) {
            boolean result;
            System.out.println("Processing " + f[i]);
            String filename = f[i].getAbsolutePath();
            if (!Tester.getExtension(filename).equals(".xml")) continue;
            ++total;
            Arrays.fill(sa, null);
            piExtractor.extract(filename, TARGETS, sa);
            if (sa[0] == null || sa[1] == null) {
                Tester.addResult(filename, "There is no associated schema, or no associated result", C_NO_ASSOC);
                continue;
            }
            expectedResult = sa[1].equals("1");
            comment = sa[2] == null ? "" : sa[2];
            try {
                result = validator.validate(filename, new File(dir, sa[0]).toString());
            }
            catch (Exception e) {
                Tester.addResult(filename, "Exception while validating: " + e, C_NOT_OK);
                e.printStackTrace();
                continue;
            }
            System.out.println(f[i]);
            if (expectedResult == result) {
                Tester.addResult(filename, "OK", BG);
                ++successful;
                continue;
            }
            Tester.addResult(filename, "Wrong: should be " + (expectedResult ? "yes" : "no"), C_NOT_OK);
        }
        Tester.finalizeResult(successful, total);
    }

    private static void addResult(String filename, String message, String colour) throws IOException {
        filename = Tester.onlyName(filename);
        String fxsd = filenameXSD == null ? "???" : Tester.onlyName(filenameXSD);
        out.write("<tr>");
        out.write("<td bgcolor='" + colour + "'><font color='" + TEXT + "'>");
        out.write("<a href='file:" + new File(dir, filename) + "'>");
        out.write(filename);
        out.write("</a>");
        out.write("</td>");
        out.write("<td bgcolor='" + colour + "'><font color='" + TEXT + "'>");
        out.write("<a href='file:" + (filenameXSD == null ? "" : filenameXSD) + "'>");
        out.write(filenameXSD == null ? "[unknown]" : filenameXSD);
        out.write("</a>");
        out.write("</td>");
        out.write("<td bgcolor='" + colour + "'><font color='" + TEXT + "'>");
        out.write(comment == null ? "" : comment);
        out.write("</td>");
        out.write("<td bgcolor='" + colour + "'><font color='" + TEXT + "'>");
        out.write(expectedResult ? "yes" : "no");
        out.write("</td>");
        out.write("<td bgcolor='" + colour + "'><font color='" + TEXT + "'>");
        out.write(message);
        out.write("</td>");
        out.write("</tr>");
    }

    private static void addXSVResult(String message, String colour) {
    }

    private static String onlyName(String filename) {
        int p = filename.lastIndexOf(47);
        int p1 = filename.lastIndexOf(92);
        if (p1 > p) {
            p = p1;
        }
        if (p != -1) {
            return filename.substring(p + 1);
        }
        return filename;
    }

    private static void initResult() throws IOException {
        out = new FileWriter(new File(dir, "results.html"));
        out.write("<html><head><title>Schema test results</title></head><body bgcolor=black link='#6666FF' vlink='#6666FF' alink='#6666FF' ><h1 align='center'><font color='white'> Schema test results </font></h1><table bordercolor='#444444' border='1' bgcolor='#444444' align='center'><tr><th bgcolor='black'><font color='white'>XML file</font></th><th bgcolor='black'><font color='white'>Schema file</font></th><th bgcolor='black'><font color='white'>Comment</font></th><th bgcolor='black'><font color='white'>Expected</font></th><th bgcolor='black'><font color='white'>InQMy</font></th><th bgcolor='black'><font color='white'>XSV</font></th></tr>");
    }

    private static void finalizeResult(int successful, int total) throws IOException {
        out.write("</table>");
        out.write("<h1 align=center><font color='white'>Test success: " + 100 * successful / total + "%</font></h1><br><br>");
        out.write("<h3 align='center'><font color='white'>Legend</font></h3>");
        out.write("<table align='center'><font color='white'><tr><td bgcolor='#666666' width='20'>");
        out.write("<td><font color=white>There is no schema associated, or no result associated to the xml file");
        out.write("</tr><tr><td bgcolor='#995555' width='20'>");
        out.write("<td><font color=white>A DOM tree could not be constructed from the xml or xsd file");
        out.write("</tr><tr><td bgcolor='magenta' width='20'>");
        out.write("<td><font color=white>The schema file cound not be loaded (probably a schema representation constraint has been violated)");
        out.write("</tr><tr><td bgcolor='red' width='20'>");
        out.write("<td><font color=white>Test failed (it did not produce the result expected: yes or no)");
        out.write("</tr></font></table>");
        out.write("<h4 align='right'><font color='white'>Nick Nickolov</font></h3>");
        out.write("</body></html>");
        out.close();
        Runtime.getRuntime().exec("cmd /c explorer " + new File(dir, "results.html"));
    }

    private static String getExtension(String s) {
        int p = s.lastIndexOf(46);
        if (p == -1) {
            return "";
        }
        return s.substring(p);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TARGETS = new String[]{"schema", "expected", "comment"};
        sa = new String[3];
    }
}

