/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.schema.util.SchemaPrefixesMapping;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.schema.validator.SchemaValidationException;
import java.util.Properties;

class StepObject
implements Cloneable {
    static final String AXIS_CHILD = "child";
    static final String AXIS_ATTRIBUTE = "attribute";
    static final String AXIS_DESCENDENT = "descendent";
    static final String PREDICATE_START_IDENTIFIER = "[";
    static final String PREDICATE_END_IDENTIFIER = "]";
    static final String ATTRIBUTE_IDENTIFIER = "@";
    private static final String AXIS_DELIMITER = "::";
    private static final String PREFIX_DELIMITER = ":";
    private String axisSpecifier;
    private String qNameWithPrefix;
    private String qNameWithUri;
    private String qNameWithUriWithoutPosition;
    private String uri;
    private String localName;
    private String prefix;
    private String positionStr;
    private int positionInt;

    StepObject(String step, String uri) {
        this.uri = uri;
        this.init(step);
        this.initQName();
    }

    StepObject(String step, SchemaPrefixesMapping prefixesMapping) throws SchemaValidationException {
        this.init(step);
        this.uri = prefixesMapping.getURI(this.prefix, this.axisSpecifier.equals(AXIS_ATTRIBUTE));
        if (this.uri == null) {
            throw new SchemaValidationException("Prefix '" + this.prefix + "' is not mapped to any URI.");
        }
        this.initQName();
    }

    private StepObject(String axisSpecifier, String qNameWithPrefix, String qNameWithUri, String uri, String localName, String prefix, String positionStr, String qNameWithUriWithoutPosition, int positionInt) {
        this.axisSpecifier = axisSpecifier;
        this.qNameWithPrefix = qNameWithPrefix;
        this.qNameWithUri = qNameWithUri;
        this.uri = uri;
        this.localName = localName;
        this.prefix = prefix;
        this.positionStr = positionStr;
        this.positionInt = positionInt;
        this.qNameWithUriWithoutPosition = qNameWithUriWithoutPosition;
    }

    private void init(String step) {
        int index = step.indexOf(AXIS_DELIMITER);
        if (index < 0) {
            if (step.startsWith(ATTRIBUTE_IDENTIFIER)) {
                this.axisSpecifier = AXIS_ATTRIBUTE;
                step = step.substring(1);
            } else {
                this.axisSpecifier = AXIS_CHILD;
            }
        } else {
            this.axisSpecifier = step.substring(0, index);
        }
        String qNameWithPredicate = index < 0 ? step : step.substring(index + 2);
        index = qNameWithPredicate.indexOf(PREDICATE_START_IDENTIFIER);
        this.positionStr = index < 0 ? "" : qNameWithPredicate.substring(index);
        this.positionInt = index < 0 ? -1 : Integer.parseInt(qNameWithPredicate.substring(index + 1, qNameWithPredicate.length() - 1));
        String qName = index < 0 ? qNameWithPredicate : qNameWithPredicate.substring(0, index);
        index = qName.indexOf(PREFIX_DELIMITER);
        this.prefix = index < 0 ? "" : qName.substring(0, index);
        this.localName = index < 0 ? qName : qName.substring(index + 1);
    }

    private void initQName() {
        String attribIdentifier = this.axisSpecifier.equals(AXIS_ATTRIBUTE) ? ATTRIBUTE_IDENTIFIER : "";
        this.qNameWithUri = attribIdentifier + Tools.formatQNameWithUri(this.uri, this.localName) + this.positionStr;
        this.qNameWithPrefix = attribIdentifier + Tools.formatQNameWithPrefix(this.prefix, this.localName) + this.positionStr;
        this.qNameWithUriWithoutPosition = attribIdentifier + Tools.formatQNameWithUri(this.uri, this.localName);
    }

    String getAxisSpecifier() {
        return this.axisSpecifier;
    }

    void setAxisSpecifier(String axisSpecifier) {
        this.axisSpecifier = axisSpecifier;
    }

    String getQNameWithUri() {
        return this.qNameWithUri;
    }

    String getQNameWithPrefix() {
        return this.qNameWithPrefix;
    }

    String getQNameWithoutPosition() {
        return this.qNameWithUriWithoutPosition;
    }

    String getUri() {
        return this.uri;
    }

    String getLocalName() {
        return this.localName;
    }

    String getPositionAsString() {
        return this.positionStr;
    }

    int getPositionAsInt() {
        return this.positionInt;
    }

    public String toString() {
        return this.qNameWithUri;
    }

    public Object clone() {
        return new StepObject(this.axisSpecifier, this.qNameWithPrefix, this.qNameWithUri, this.uri, this.localName, this.prefix, this.positionStr, this.qNameWithUriWithoutPosition, this.positionInt);
    }

    public static void main(String[] args) {
        Properties prefixesMapping = new Properties();
        prefixesMapping.put("", "default_uri");
        prefixesMapping.put("prefix", "uri");
        StepObject stepObj = new StepObject("@prefix:element[1]", "uri");
        System.out.println(stepObj);
        System.out.println("axis specifier : " + stepObj.getAxisSpecifier());
        System.out.println("qname with uri : " + stepObj.getQNameWithUri());
        System.out.println("qname with prefix : " + stepObj.getQNameWithPrefix());
        System.out.println("local name : " + stepObj.getLocalName());
        System.out.println("position as string: " + stepObj.getPositionAsString());
        System.out.println("position as integer: " + stepObj.getPositionAsInt());
    }
}

