/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.jaxp.TransformerFactoryImpl;
import com.sap.engine.lib.schema.SchemaException;
import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.components.impl0.LoaderImpl;
import com.sap.engine.lib.schema.validator.Contributions;
import com.sap.engine.lib.schema.validator.PSVIItem;
import com.sap.engine.lib.schema.validator.SchemaComponentConstraints;
import com.sap.engine.lib.schema.validator.SchemaRepresentationConstraints;
import com.sap.engine.lib.schema.validator.SchemaValidationException;
import com.sap.engine.lib.schema.validator.ValidationRules;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.dom.ElementImpl;
import com.sap.engine.lib.xml.parser.DOMParser;
import com.sap.engine.lib.xml.parser.URLLoader;
import com.sap.engine.lib.xml.util.StringUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class SchemaValidator {
    protected Schema schema;
    protected static final boolean DEBUG = false;
    protected SchemaComponentConstraints scc = new SchemaComponentConstraints(this);
    protected ValidationRules vr = new ValidationRules(this);
    protected SchemaRepresentationConstraints src;
    protected Contributions con = new Contributions(this);
    private LoaderImpl loader;
    private Transformer transformer;

    public boolean validate(Node xml) throws SchemaException {
        return this.validate(xml, (Node)null);
    }

    public boolean validate(String xmlFile, String xsdFile) throws SchemaException {
        return this.validate(new StreamSource(xmlFile), xsdFile == null ? null : new StreamSource(xsdFile));
    }

    public boolean validate(Source xmlSource, Source xsdSource) throws SchemaException {
        return this.validate(this.parseToDOM(xmlSource), this.parseToDOM(xsdSource));
    }

    public boolean validate(Node xml, Node xsd) throws SchemaException {
        return this.validate(xml, (Object)xsd);
    }

    /*
     * WARNING - void declaration
     */
    public boolean validate(Node xmlNode, Object xsdTarget) throws SchemaException {
        Element xmlElement;
        if (xmlNode == null) {
            throw new IllegalArgumentException();
        }
        if (xmlNode instanceof Document) {
            xmlElement = ((Document)xmlNode).getDocumentElement();
        } else if (xmlNode instanceof Element) {
            xmlElement = (Element)xmlNode;
        } else {
            throw new SchemaValidationException("Unable to perform validation, the XML instance Node must be either an Element or a Document");
        }
        if (this.loader == null) {
            this.loader = new LoaderImpl();
        }
        try {
            void var3_3;
            this.createSchema((Node)var3_3, xsdTarget);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new SchemaException(exc.getMessage());
        }
        return this.validate(xmlNode, this.schema);
    }

    /*
     * WARNING - void declaration
     */
    public boolean validate(Node node, Schema schema) throws SchemaException {
        void var3_4;
        Element validationRoot;
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (schema == null) {
            return this.validate(node, (Node)null);
        }
        this.schema = schema;
        short t = node.getNodeType();
        if (t == 9) {
            validationRoot = ((Document)node).getDocumentElement();
        } else if (t == 1) {
            validationRoot = (Element)node;
        } else {
            throw new SchemaValidationException();
        }
        this.con.clear();
        this.vr.clear();
        return this.vr.cvcAssessElt((Element)var3_4, null, false, null);
    }

    public void getPSVIItems(Vector v) {
        this.con.getPSVIItems(v);
    }

    public String getDescriptionOfTheFirstError() {
        Vector psviItems = new Vector();
        this.getPSVIItems(psviItems);
        int n = psviItems.size();
        for (int i = 0; i < n; ++i) {
            PSVIItem item = (PSVIItem)psviItems.get(i);
            if (!item.isErrorDescription()) continue;
            return item.getValue() + " " + DOM.toXPath(item.getLocation());
        }
        return "";
    }

    public String getDescriptionOfTheErrors() {
        String result = "";
        Vector psviItems = new Vector();
        this.getPSVIItems(psviItems);
        for (int i = 0; i < psviItems.size(); ++i) {
            PSVIItem item = (PSVIItem)psviItems.get(i);
            if (!item.isErrorDescription()) continue;
            result = result + item.getValue() + " " + DOM.toXPath(item.getLocation()) + (i == psviItems.size() - 1 ? "" : "; ");
        }
        return result;
    }

    private void ensureTransformer() throws SchemaException {
        if (this.transformer == null) {
            try {
                TransformerFactoryImpl tf = new TransformerFactoryImpl();
                this.transformer = ((TransformerFactory)tf).newTransformer();
            }
            catch (TransformerException te) {
                throw new SchemaException(te);
            }
        }
    }

    public Node parseToDOM(Source source) throws SchemaException {
        if (source == null) {
            return null;
        }
        this.ensureTransformer();
        DOMResult result = new DOMResult();
        try {
            this.transformer.transform(source, result);
            return result.getNode();
        }
        catch (Exception e) {
            throw new SchemaValidationException(e);
        }
    }

    public static String[] getAssociatedSchemaLocations(Element e) {
        if (e.hasAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation")) {
            String[] x = StringUtils.split(e.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"));
            if (x.length == 1) {
                return new String[]{x[0]};
            }
            int l = x.length / 2;
            String[] r = new String[l];
            for (int i = 0; i < l; ++i) {
                r[i] = x[2 * i + 1];
            }
            return r;
        }
        if (e.hasAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation")) {
            return new String[]{e.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation")};
        }
        return new String[0];
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setUriResolver(URIResolver uriResolver) {
        if (this.loader == null) {
            this.loader = new LoaderImpl();
        }
        this.loader.setUriResolver(uriResolver);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        if (this.loader == null) {
            this.loader = new LoaderImpl();
        }
        this.loader.setEntityResolver(entityResolver);
    }

    public void setCanonicalizationProcessing(boolean canonicalizationProcessing) {
        this.vr.setCanonicalizationProcessing(canonicalizationProcessing);
    }

    public boolean getCanonicalizationProcessing() {
        return this.vr.getCanonicalizationProcessing();
    }

    private void createSchema(Node xmlNode, Object schemaTragetObj) throws Exception {
        Element xmlElement = (Element)xmlNode;
        if (this.loader == null) {
            this.loader = new LoaderImpl();
        }
        EntityResolver resolver = this.loader.getEntityResolver();
        URL xmlLocation = DOM.getLocation(xmlNode);
        if (schemaTragetObj == null) {
            String[] associatedSchemas = SchemaValidator.getAssociatedSchemaLocations(xmlElement);
            this.schema = this.createSchema(xmlLocation, associatedSchemas, resolver);
        } else if (schemaTragetObj instanceof String[]) {
            this.schema = this.createSchema(xmlLocation, (String[])schemaTragetObj, resolver);
        } else if (schemaTragetObj instanceof String) {
            this.schema = this.loader.load(this.parseToDOM(this.cerateStreamSrc(resolver, (String)schemaTragetObj)));
        } else if (schemaTragetObj instanceof Node) {
            this.schema = this.loader.load((Node)schemaTragetObj);
        }
    }

    private Schema createSchema(URL xmlLocation, String[] xsdFiles, EntityResolver resolver) throws Exception {
        Node[] xsdNodes = new Node[xsdFiles.length];
        for (int i = 0; i < xsdFiles.length; ++i) {
            try {
                xsdFiles[i] = URLLoader.fileOrURLToURL(xmlLocation, xsdFiles[i]).toExternalForm();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            xsdNodes[i] = this.parseToDOM(this.cerateStreamSrc(resolver, xsdFiles[i]));
        }
        return this.loader.load(xsdFiles, xsdNodes);
    }

    private StreamSource cerateStreamSrc(EntityResolver resolver, String xsdFile) throws Exception {
        StreamSource result = null;
        if (resolver != null) {
            InputSource inputSrc = this.loader.getEntityResolver().resolveEntity("", xsdFile);
            result = new StreamSource();
            result.setSystemId(inputSrc.getSystemId());
            result.setInputStream(inputSrc.getByteStream());
            result.setReader(inputSrc.getCharacterStream());
        } else {
            result = new StreamSource(xsdFile);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        SchemaValidator validator = new SchemaValidator();
        validator.setCanonicalizationProcessing(true);
        String[] schemas = new String[]{"D:\\develop\\schema_test\\canonicalization\\scc14\\run\\xsd\\my-uddi_v3custody.xsd", "D:\\develop\\schema_test\\canonicalization\\scc14\\run\\xsd\\soap.xsd", "D:\\develop\\schema_test\\canonicalization\\scc14\\run\\xsd\\uddi_v1.xsd", "D:\\develop\\schema_test\\canonicalization\\scc14\\run\\xsd\\uddi_v2.xsd", "D:\\develop\\schema_test\\canonicalization\\scc14\\run\\xsd\\uddi_v2custody.xsd", "D:\\develop\\schema_test\\canonicalization\\scc14\\run\\xsd\\uddi_v2replication.xsd", "D:\\develop\\schema_test\\canonicalization\\scc14\\run\\xsd\\uddi_v3.xsd", "D:\\develop\\schema_test\\canonicalization\\scc14\\run\\xsd\\uddi_v3custody.xsd", "D:\\develop\\schema_test\\canonicalization\\scc14\\run\\xsd\\uddi_v3replication.xsd", "D:\\develop\\schema_test\\canonicalization\\scc14\\run\\xsd\\was-uddi_v3custody.xsd", "D:\\develop\\schema_test\\canonicalization\\scc14\\run\\xsd\\xml.xsd", "D:\\develop\\schema_test\\canonicalization\\scc14\\run\\xsd\\xmldsig-core-schema.xsd"};
        LoaderImpl loader = new LoaderImpl();
        Schema schema = loader.load(schemas);
        DOMParser parser = new DOMParser();
        Document doc = parser.parse("D:\\develop\\schema_test\\canonicalization\\scc14\\run\\in\\p_save_tmodel.xml");
        Element elem = doc.getDocumentElement();
        validator.validate((Node)elem, schema);
        SchemaValidator.displayAugs(elem);
        System.out.println("Error : " + validator.getDescriptionOfTheFirstError());
    }

    private static void displayAugs(Element elem) {
        System.out.println("Element : " + elem.getNodeName() + " augs : " + ((ElementImpl)elem).getAugmentationPropsAsString());
        System.out.println();
        NodeList nodeList = elem.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (!(childNode instanceof Element)) continue;
            SchemaValidator.displayAugs((Element)childNode);
        }
    }
}

