/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.xml.dom.DOM;
import org.w3c.dom.Node;

public final class PSVIItem {
    private String outcomeCode;
    private String augmentationName;
    private Node location;
    private Object value;
    private Class valueClass = null;

    protected PSVIItem(String outcomeCode, String augmentationName, Node location, Object value) {
        this.outcomeCode = outcomeCode;
        this.augmentationName = augmentationName;
        this.location = location;
        this.value = value;
    }

    public String getAugmentationName() {
        return this.augmentationName;
    }

    public String getOutcomeCode() {
        return this.outcomeCode;
    }

    public Object getValue() {
        return this.value;
    }

    public Class getValueClass() {
        if (this.valueClass == null) {
            this.valueClass = this.value == null ? null : this.value.getClass();
        }
        return this.valueClass;
    }

    public Node getLocation() {
        return this.location;
    }

    public String getLocationAsXPath() {
        return DOM.toXPath(this.location);
    }

    public boolean isError() {
        return this.augmentationName != null && "[schema error code]".equals(this.augmentationName);
    }

    public boolean isErrorDescription() {
        return this.augmentationName != null && "[inqmy schema error code desciption]".equals(this.augmentationName);
    }
}

