/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.validator.AbstractIdentityConstraintDefProcessor;
import com.sap.engine.lib.schema.validator.FieldsMappingStructure;
import com.sap.engine.lib.schema.validator.SchemaValidationException;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Vector;

class KeyIdentityConstraintDefProcessor
extends AbstractIdentityConstraintDefProcessor {
    KeyIdentityConstraintDefProcessor(IdentityConstraintDefinition identityConstrDef, Vector errorsCollector) throws SchemaValidationException {
        super(identityConstrDef, errorsCollector);
    }

    public boolean process() {
        for (int i = 0; i < this.fieldsMappingStrsCollector.size() - 1; ++i) {
            int j;
            FieldsMappingStructure structure = (FieldsMappingStructure)this.fieldsMappingStrsCollector.get(i);
            for (j = 0; j < structure.structures.length; ++j) {
                if (!structure.structures[j].isNillable) continue;
                this.errorsCollector.add("Element '" + structure.structures[j].xPathObj.getXPathWithoutURIs() + "' is match to selector xpath of key identity constraint definition with uri : " + this.uri + " and name : " + this.name + ", but is declared as nillable.");
                return false;
            }
            if (structure.isInitialized()) {
                for (j = i + 1; j < this.fieldsMappingStrsCollector.size(); ++j) {
                    FieldsMappingStructure structureToMatch = (FieldsMappingStructure)this.fieldsMappingStrsCollector.get(j);
                    if (structureToMatch.isInitialized()) {
                        if (!structure.match(structureToMatch)) continue;
                        this.errorsCollector.add("The combination of the elements " + structureToMatch.getXPathsRepresentation() + " with values " + structureToMatch.getValuesRepresentation() + " has to be unique.");
                        return false;
                    }
                    this.errorsCollector.add("The combination of the elements, which are represented by the key identity constraint definition " + DOM.toXPath(this.identityConstrDef.getAssociatedDOMNode()) + " has to be present.");
                    return false;
                }
                continue;
            }
            this.errorsCollector.add("The combination of the elements, which are represented by the key identity constraint definition " + DOM.toXPath(this.identityConstrDef.getAssociatedDOMNode()) + " has to be present.");
            return false;
        }
        return true;
    }

    boolean contains(FieldsMappingStructure structureToContain) {
        if (!structureToContain.isInitialized()) {
            return false;
        }
        for (int i = 0; i < this.fieldsMappingStrsCollector.size(); ++i) {
            FieldsMappingStructure structure = (FieldsMappingStructure)this.fieldsMappingStrsCollector.get(i);
            if (!structure.isInitialized() || !structureToContain.match(structure)) continue;
            return true;
        }
        return false;
    }
}

