/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.components.SimpleTypeDefinition;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.schema.validator.AbstractIdentityConstraintDefProcessor;
import com.sap.engine.lib.schema.validator.ElementStructure;
import com.sap.engine.lib.schema.validator.KeyIdentityConstraintDefProcessor;
import com.sap.engine.lib.schema.validator.KeyrefIdentityConstraintDefProcessor;
import com.sap.engine.lib.schema.validator.SchemaValidationException;
import com.sap.engine.lib.schema.validator.UniqueIdentityConstraintDefProcessor;
import com.sap.engine.lib.schema.validator.XPathObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class IdentityConstraintDefsProcessor {
    protected Hashtable activeProcessors = new Hashtable();
    protected Hashtable inactiveProcessors = new Hashtable();

    protected IdentityConstraintDefsProcessor(IdentityConstraintDefinition[] identityCostrDefs, Vector errorsCollector) throws SchemaValidationException {
        int i;
        Vector<IdentityConstraintDefinition> keyrefIdentConstrDefsCollector = new Vector<IdentityConstraintDefinition>();
        for (i = 0; i < identityCostrDefs.length; ++i) {
            IdentityConstraintDefinition identityCostrDef = identityCostrDefs[i];
            AbstractIdentityConstraintDefProcessor processor = null;
            if (identityCostrDef.isIdentityConstraintCategoryKey()) {
                processor = new KeyIdentityConstraintDefProcessor(identityCostrDef, errorsCollector);
            } else if (identityCostrDef.isIdentityConstraintCategoryUnique()) {
                processor = new UniqueIdentityConstraintDefProcessor(identityCostrDef, errorsCollector);
            } else {
                IdentityConstraintDefinition referedKeyIdentityConstDef = identityCostrDef.getReferencedKey();
                KeyIdentityConstraintDefProcessor referedKeyIdentityCostrDefProcessor = (KeyIdentityConstraintDefProcessor)this.inactiveProcessors.get(Tools.generateKey(referedKeyIdentityConstDef.getTargetNamespace(), referedKeyIdentityConstDef.getName()));
                if (referedKeyIdentityCostrDefProcessor != null) {
                    processor = new KeyrefIdentityConstraintDefProcessor(identityCostrDef, referedKeyIdentityCostrDefProcessor, errorsCollector);
                } else {
                    keyrefIdentConstrDefsCollector.add(identityCostrDef);
                }
            }
            if (processor == null) continue;
            this.inactiveProcessors.put(Tools.generateKey(processor.uri, processor.name), processor);
        }
        for (i = 0; i < keyrefIdentConstrDefsCollector.size(); ++i) {
            IdentityConstraintDefinition keyrefIdentityCostrDef = (IdentityConstraintDefinition)keyrefIdentConstrDefsCollector.get(i);
            IdentityConstraintDefinition referedKeyIdentityConstDef = keyrefIdentityCostrDef.getReferencedKey();
            KeyIdentityConstraintDefProcessor referedKeyIdentityCostrDefProcessor = (KeyIdentityConstraintDefProcessor)this.inactiveProcessors.get(Tools.generateKey(referedKeyIdentityConstDef.getTargetNamespace(), referedKeyIdentityConstDef.getName()));
            KeyrefIdentityConstraintDefProcessor processor = new KeyrefIdentityConstraintDefProcessor(keyrefIdentityCostrDef, referedKeyIdentityCostrDefProcessor, errorsCollector);
            this.inactiveProcessors.put(Tools.generateKey(processor.uri, processor.name), processor);
        }
    }

    protected void activate(String uri, String name, XPathObject xPathObj) {
        String key = Tools.generateKey(uri, name);
        AbstractIdentityConstraintDefProcessor processor = (AbstractIdentityConstraintDefProcessor)this.inactiveProcessors.get(key);
        if (processor != null) {
            this.inactiveProcessors.remove(key);
            processor.setContextXPathObject(xPathObj);
            this.activeProcessors.put(key, processor);
        }
    }

    protected void inactivate(String uri, String name) {
        String key = Tools.generateKey(uri, name);
        AbstractIdentityConstraintDefProcessor processor = (AbstractIdentityConstraintDefProcessor)this.activeProcessors.get(key);
        if (processor != null) {
            this.activeProcessors.remove(key);
            this.inactiveProcessors.put(key, processor);
        }
    }

    protected void addStructure(SimpleTypeDefinition simpleTypeDef, String value, XPathObject xPathObj, boolean isNillable) {
        Enumeration enumeration = this.activeProcessors.elements();
        while (enumeration.hasMoreElements()) {
            AbstractIdentityConstraintDefProcessor processor = (AbstractIdentityConstraintDefProcessor)enumeration.nextElement();
            processor.addStructure(new ElementStructure(simpleTypeDef, value, (XPathObject)xPathObj.clone(), isNillable));
        }
    }

    protected boolean process() {
        return this.process(this.inactiveProcessors);
    }

    private boolean process(Hashtable collector) {
        Enumeration enumeration = collector.elements();
        while (enumeration.hasMoreElements()) {
            AbstractIdentityConstraintDefProcessor processor = (AbstractIdentityConstraintDefProcessor)enumeration.nextElement();
            if (processor.process()) continue;
            return false;
        }
        return true;
    }
}

