/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.schema.util.SchemaPrefixesMapping;
import com.sap.engine.lib.schema.validator.SchemaValidationException;
import com.sap.engine.lib.schema.validator.StepObject;
import com.sap.engine.lib.schema.validator.XPathDisperser;
import com.sap.engine.lib.schema.validator.XPathObject;
import com.sap.engine.lib.schema.validator.XPathTokenizer;
import com.sap.engine.lib.xml.Symbols;
import java.util.Vector;

class IdentityConstrXPathProcessor {
    protected XPathObject selectorXPathObj;
    protected XPathObject[] fieldsXPathObjs;
    private XPathDisperser[] dispersers;

    IdentityConstrXPathProcessor(String selector, Vector fieldsCollector, SchemaPrefixesMapping prefixesMapping) throws SchemaValidationException {
        if (!this.validatePath(new XPathTokenizer(selector))) {
            throw new SchemaValidationException("XPath expression " + selector + " is not supported by schema validation");
        }
        this.selectorXPathObj = new XPathObject(selector, prefixesMapping);
        this.fieldsXPathObjs = new XPathObject[fieldsCollector.size()];
        this.dispersers = new XPathDisperser[fieldsCollector.size()];
        for (int i = 0; i < fieldsCollector.size(); ++i) {
            if (!this.validatePath(new XPathTokenizer((String)fieldsCollector.get(i)))) {
                throw new SchemaValidationException("XPath expression " + fieldsCollector.get(i) + " is not supported by schema validation");
            }
            this.fieldsXPathObjs[i] = new XPathObject((String)fieldsCollector.get(i), prefixesMapping);
        }
    }

    protected void setContextXPathObject(XPathObject contextXPathObj) {
        XPathObject fieldsContextXPathObj = ((XPathObject)contextXPathObj.clone()).addXPathObj(this.selectorXPathObj);
        for (int i = 0; i < this.dispersers.length; ++i) {
            XPathObject xPathObject = ((XPathObject)fieldsContextXPathObj.clone()).addXPathObj(this.fieldsXPathObjs[i]);
            this.dispersers[i] = new XPathDisperser(xPathObject);
        }
    }

    private boolean validatePath(XPathTokenizer tokenizer) {
        if (!this.validateStep(tokenizer)) {
            return false;
        }
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("/")) {
                if (this.validateStep(tokenizer)) continue;
                return false;
            }
            if (token.equals("//")) {
                if (!this.validateStep(tokenizer)) {
                    return false;
                }
                while (tokenizer.hasMoreTokens()) {
                    if (tokenizer.nextToken().equals("/")) {
                        if (this.validateStep(tokenizer)) continue;
                        return false;
                    }
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean validateStep(XPathTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        if (this.validateAxisSpecifier(tokenizer) && this.validateNodeTest(tokenizer)) {
            return true;
        }
        tokenizer.setIndex(index);
        return this.validateAbbriviatedStep(tokenizer);
    }

    private boolean validateAxisSpecifier(XPathTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        if (this.validateAxisName(tokenizer) && tokenizer.nextToken().equals("::")) {
            return true;
        }
        tokenizer.setIndex(index);
        return this.validateAbbriviatedAxisSpecifier(tokenizer);
    }

    private boolean validateAxisName(XPathTokenizer tokenizer) {
        String token = tokenizer.nextToken();
        return token.equals("attribute") || token.equals("child");
    }

    private boolean validateNodeTest(XPathTokenizer tokenizer) {
        return this.validateNameTest(tokenizer);
    }

    private boolean validateAbbriviatedStep(XPathTokenizer tokenizer) {
        return tokenizer.nextToken().equals(".");
    }

    private boolean validateAbbriviatedAxisSpecifier(XPathTokenizer tokenizer) {
        if (!tokenizer.nextToken().equals("@")) {
            int index = tokenizer.getIndex();
            tokenizer.setIndex(index - 1);
        }
        return true;
    }

    private boolean validateNameTest(XPathTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        String token = tokenizer.nextToken();
        if (token.equals("*")) {
            return true;
        }
        if (this.validateNCName(token) && tokenizer.nextToken().equals(":") && tokenizer.nextToken().equals("*")) {
            return true;
        }
        tokenizer.setIndex(index);
        return this.validateQName(tokenizer);
    }

    private boolean validateQName(XPathTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        if (this.validatePrefix(tokenizer.nextToken()) && tokenizer.nextToken().equals(":") && this.validateLocalPart(tokenizer.nextToken())) {
            return true;
        }
        tokenizer.setIndex(index);
        return this.validateLocalPart(tokenizer.nextToken());
    }

    private boolean validatePrefix(String token) {
        return this.validateNCName(token);
    }

    private boolean validateLocalPart(String token) {
        return this.validateNCName(token);
    }

    private boolean validateNCName(String token) {
        char[] chars = token.toCharArray();
        char firstChar = chars[0];
        if (this.validateLetter(firstChar) || firstChar == '_') {
            for (int i = 1; i < chars.length; ++i) {
                if (this.validateNCNameChar(chars[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean validateNCNameChar(char nCNameChar) {
        return this.validateLetter(nCNameChar) || this.validateDigit(nCNameChar) || nCNameChar == '.' || nCNameChar == '-' || nCNameChar == '_' || this.validateCombiningChar(nCNameChar) || this.validateExtender(nCNameChar);
    }

    private boolean validateLetter(char letterChar) {
        return this.validateBaseChar(letterChar) || this.validateIdeographic(letterChar);
    }

    private boolean validateDigit(char digitChar) {
        return Symbols.isDigit(digitChar);
    }

    private boolean validateCombiningChar(char combiningChar) {
        return Symbols.isCombiningChar(combiningChar);
    }

    private boolean validateExtender(char extenderChar) {
        return Symbols.isExtender(extenderChar);
    }

    private boolean validateBaseChar(char baseChar) {
        return Symbols.isBaseChar(baseChar);
    }

    private boolean validateIdeographic(char ideographicChar) {
        return Symbols.isIdeographic(ideographicChar);
    }

    XPathObject match(XPathObject xPathObj) {
        StepObject[] steps = xPathObj.getSteps();
        for (int i = 0; i < this.dispersers.length; ++i) {
            if (!this.match(steps, this.dispersers[i])) continue;
            return this.fieldsXPathObjs[i];
        }
        return null;
    }

    private boolean match(StepObject[] steps, XPathDisperser disperser) {
        for (int i = 0; i < steps.length; ++i) {
            StepObject step = steps[i];
            String qName = step.getQNameWithoutPosition();
            if (disperser.switchState(qName)) continue;
            disperser.reset();
            return false;
        }
        boolean result = disperser.isInFinalState();
        disperser.reset();
        return result;
    }
}

