/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.schema.validator.ElementStructure;
import com.sap.engine.lib.schema.validator.XPathObject;

public class FieldsMappingStructure {
    protected XPathObject[] fieldsXPathObjs;
    protected ElementStructure[] structures;
    protected int count = -1;
    protected String xPathsRepresentationStr;
    protected String valuesRepresentationStr;

    FieldsMappingStructure(XPathObject[] fieldsXPathObjs) {
        this.fieldsXPathObjs = fieldsXPathObjs;
        this.structures = new ElementStructure[fieldsXPathObjs.length];
        this.count = 0;
    }

    boolean add(XPathObject fieldXPathObj, ElementStructure structure) {
        for (int index = 0; index < this.fieldsXPathObjs.length; ++index) {
            if (this.fieldsXPathObjs[index] != fieldXPathObj) continue;
            if (this.structures[index] != null) {
                return false;
            }
            this.structures[index] = structure;
            ++this.count;
            return true;
        }
        return false;
    }

    boolean match(FieldsMappingStructure structureToMatch) {
        if (this.fieldsXPathObjs.length != structureToMatch.fieldsXPathObjs.length) {
            return false;
        }
        for (int i = 0; i < structureToMatch.fieldsXPathObjs.length; ++i) {
            if (this.structures[i].match(structureToMatch.structures[i])) continue;
            return false;
        }
        return true;
    }

    boolean isInitialized() {
        return this.count == this.fieldsXPathObjs.length;
    }

    private void initXPathsAndValues() {
        this.valuesRepresentationStr = "[";
        this.xPathsRepresentationStr = "[";
        for (int i = 0; i < this.structures.length; ++i) {
            String finalToken = i == this.structures.length - 1 ? "]" : "; ";
            this.xPathsRepresentationStr = this.xPathsRepresentationStr + this.structures[i].xPathObj.getXPathWithURIs() + finalToken;
            this.valuesRepresentationStr = this.valuesRepresentationStr + this.structures[i].value + finalToken;
        }
    }

    String getXPathsRepresentation() {
        if (this.xPathsRepresentationStr == null) {
            this.initXPathsAndValues();
        }
        return this.xPathsRepresentationStr;
    }

    String getValuesRepresentation() {
        if (this.valuesRepresentationStr == null) {
            this.initXPathsAndValues();
        }
        return this.valuesRepresentationStr;
    }
}

