/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ElementDeclaration;
import com.sap.engine.lib.schema.validator.DisperserChildMappingStructure;
import com.sap.engine.lib.schema.validator.DisperserParentMappingStructure;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class DisperserState {
    static final String UNNAMED = "DisperserState.Unnamed.Key";
    static final String ANY = "DisperserState.Any.Key";
    static final String GILL_NS_DELIMITER = ":";
    private Hashtable childrenStatesMapping = new Hashtable();
    private Hashtable parentsMapping = new Hashtable();

    DisperserState() {
    }

    private void registerParent(Base base, DisperserState parentState) {
        if (this.parentsMapping.containsKey(parentState)) {
            ((Vector)this.parentsMapping.get(parentState)).add(new DisperserParentMappingStructure(base));
        } else {
            Vector<DisperserParentMappingStructure> gillsCollector = new Vector<DisperserParentMappingStructure>();
            gillsCollector.add(new DisperserParentMappingStructure(base));
            this.parentsMapping.put(parentState, gillsCollector);
        }
    }

    private void registerParent(String unnamedGill, DisperserState parentState) {
        if (this.parentsMapping.containsKey(parentState)) {
            ((Vector)this.parentsMapping.get(parentState)).add(new DisperserParentMappingStructure(unnamedGill));
        } else {
            Vector<DisperserParentMappingStructure> gillsCollector = new Vector<DisperserParentMappingStructure>();
            gillsCollector.add(new DisperserParentMappingStructure(unnamedGill));
            this.parentsMapping.put(parentState, gillsCollector);
        }
    }

    private void unregisterParent(DisperserState parentState) {
        this.parentsMapping.remove(parentState);
    }

    Enumeration getParents() {
        return this.parentsMapping.keys();
    }

    Vector getParentMappingStructuresCollector(DisperserState parentState) {
        return (Vector)this.parentsMapping.get(parentState);
    }

    void addChild(Base base, DisperserState childState) {
        this.childrenStatesMapping.put(DisperserState.createGill(base), new DisperserChildMappingStructure(base, childState));
        childState.registerParent(base, this);
    }

    void addChild(String unnamedGill, DisperserState childState) {
        this.childrenStatesMapping.put(unnamedGill, new DisperserChildMappingStructure(childState));
        childState.registerParent(unnamedGill, this);
    }

    static String createGill(Base base) {
        return base instanceof ElementDeclaration ? DisperserState.createGill(((ElementDeclaration)base).getTargetNamespace(), ((ElementDeclaration)base).getName()) : ANY;
    }

    static String createGill(String uri, String name) {
        return uri + GILL_NS_DELIMITER + name;
    }

    void removeChild(String elementUri, String elementName) {
        this.removeChild(DisperserState.createGill(elementUri, elementName));
    }

    void removeChild(Base base) {
        this.removeChild(DisperserState.createGill(base));
    }

    void removeChild(String gill) {
        DisperserChildMappingStructure gillStructure = (DisperserChildMappingStructure)this.childrenStatesMapping.get(gill);
        DisperserState childState = gillStructure.getDisperserState();
        this.childrenStatesMapping.remove(gill);
        childState.unregisterParent(this);
    }

    DisperserChildMappingStructure getChildMappingStructure(String elementUri, String elementName) {
        return this.getChildMappingStructure(DisperserState.createGill(elementUri, elementName));
    }

    DisperserChildMappingStructure getChildMappingStructure(String gill) {
        return (DisperserChildMappingStructure)this.childrenStatesMapping.get(gill);
    }

    DisperserState getChild(Base base) {
        return this.getChild(DisperserState.createGill(base));
    }

    DisperserState getChild(String elementUri, String elementName) {
        DisperserChildMappingStructure childMappingStr = this.getChildMappingStructure(elementUri, elementName);
        return childMappingStr == null ? null : childMappingStr.getDisperserState();
    }

    DisperserState getChild(String gill) {
        DisperserChildMappingStructure childMappingStr = this.getChildMappingStructure(gill);
        return childMappingStr == null ? null : childMappingStr.getDisperserState();
    }

    Enumeration getChildrenGills() {
        return this.childrenStatesMapping.keys();
    }

    Enumeration getChildMappingStructures() {
        return this.childrenStatesMapping.elements();
    }

    Hashtable getChildrenStatesMapping() {
        return this.childrenStatesMapping;
    }

    public String toString() {
        String result = "" + this.hashCode() + " [";
        Enumeration enumeration = this.childrenStatesMapping.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            result = result + name + "->" + ((DisperserChildMappingStructure)this.childrenStatesMapping.get(name)).getDisperserState().hashCode() + " ";
        }
        return result + "]";
    }
}

