/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.jaxp.TransformerFactoryImpl;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.ElementDeclaration;
import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.components.Particle;
import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.components.Wildcard;
import com.sap.engine.lib.schema.components.impl0.LoaderImpl;
import com.sap.engine.lib.schema.validator.DisperserChildMappingStructure;
import com.sap.engine.lib.schema.validator.DisperserParentMappingStructure;
import com.sap.engine.lib.schema.validator.DisperserState;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

class ComplexTypeDisperser {
    private ComplexTypeDefinition complexTypeDef;
    private DisperserState firstState;
    private DisperserState currentState;
    private DisperserState lastState;

    ComplexTypeDisperser(ComplexTypeDefinition complexTypeDef) {
        this.complexTypeDef = complexTypeDef;
        this.init();
    }

    private void init() {
        DisperserState state;
        this.firstState = state = new DisperserState();
        this.lastState = state;
        this.currentState = state;
        Particle contentParticle = this.complexTypeDef.getContentTypeContentModel();
        if (contentParticle == null) {
            return;
        }
        this.lastState = new DisperserState();
        DisperserState[] firstAndLastState = new DisperserState[]{this.firstState, this.lastState};
        this.init(firstAndLastState);
        this.firstState = firstAndLastState[0];
        this.lastState = firstAndLastState[1];
        this.currentState = this.firstState;
    }

    private void init(DisperserState[] firstAndLastState) {
        Particle contentParticle = this.complexTypeDef.getContentTypeContentModel();
        Vector<Particle> firstInitialSequenceGroupParticles = new Vector<Particle>();
        firstInitialSequenceGroupParticles.add(contentParticle);
        this.compositorSequenceInit(firstInitialSequenceGroupParticles, firstAndLastState);
    }

    private void modelGroupInit(ModelGroup modelGroup, DisperserState[] firstAndLastState) {
        Vector particlesCollector = new Vector();
        modelGroup.getParticles(particlesCollector);
        if (modelGroup.isCompositorChoice()) {
            this.compositorChoiceInit(particlesCollector, firstAndLastState);
        } else if (modelGroup.isCompositorSequence()) {
            this.compositorSequenceInit(particlesCollector, firstAndLastState);
        } else if (modelGroup.isCompositorAll()) {
            this.compositorAllInit(particlesCollector, firstAndLastState);
        }
    }

    private void particleInit(Particle particle, DisperserState[] firstAndLastState) {
        Base base = particle.getTerm();
        if (base instanceof ElementDeclaration) {
            this.elementDeclarationInit((ElementDeclaration)base, firstAndLastState);
        } else if (base instanceof Wildcard) {
            this.wildcardInit((Wildcard)base, firstAndLastState);
        } else if (base instanceof ModelGroup) {
            this.modelGroupInit((ModelGroup)base, firstAndLastState);
        }
    }

    private void wildcardInit(Wildcard wildcard, DisperserState[] firstAndLastState) {
        firstAndLastState[0].addChild(wildcard, firstAndLastState[1]);
    }

    private void elementDeclarationInit(ElementDeclaration elementDeclaration, DisperserState[] firstAndLastState) {
        firstAndLastState[0].addChild(elementDeclaration, firstAndLastState[1]);
    }

    private void compositorChoiceInit(Vector particlesCollector, DisperserState[] firstAndLastState) {
        for (int i = 0; i < particlesCollector.size(); ++i) {
            Vector collectorForSequenceGen = new Vector();
            collectorForSequenceGen.add(particlesCollector.get(i));
            DisperserState[] states = new DisperserState[]{new DisperserState(), new DisperserState()};
            this.compositorSequenceInit(collectorForSequenceGen, states);
            this.stateAddChildrenStates(states[0], firstAndLastState[0], true);
            this.parentsAddState(states[1], firstAndLastState[1]);
            this.stateAddChildrenStates(states[1], firstAndLastState[1], true);
        }
    }

    private void stateAddChildrenStates(DisperserState srcState, DisperserState dstState, boolean removeFromOldParent) {
        Enumeration gills = srcState.getChildrenGills();
        while (gills.hasMoreElements()) {
            Base base;
            String gill = (String)gills.nextElement();
            DisperserChildMappingStructure gillStructure = srcState.getChildMappingStructure(gill);
            DisperserState childState = gillStructure.getDisperserState();
            if (removeFromOldParent) {
                srcState.removeChild(gill);
            }
            if ((base = gillStructure.getBase()) != null) {
                dstState.addChild(base, childState);
                continue;
            }
            dstState.addChild(gill, childState);
        }
    }

    private void parentsAddState(DisperserState parentsOwnerState, DisperserState stateToAdd) {
        Enumeration parentStates = parentsOwnerState.getParents();
        while (parentStates.hasMoreElements()) {
            DisperserState parentState = (DisperserState)parentStates.nextElement();
            Vector gillsCollector = parentsOwnerState.getParentMappingStructuresCollector(parentState);
            if (parentState == parentsOwnerState) continue;
            for (int i = 0; i < gillsCollector.size(); ++i) {
                DisperserParentMappingStructure parentMappingStructure = (DisperserParentMappingStructure)gillsCollector.get(i);
                String gill = parentMappingStructure.getGill();
                Base base = parentMappingStructure.getBase();
                if (base != null) {
                    parentState.removeChild(base);
                    parentState.addChild(base, stateToAdd);
                    continue;
                }
                parentState.removeChild(gill);
                parentState.addChild(gill, stateToAdd);
            }
        }
    }

    private void compositorSequenceInit(Vector particlesCollector, DisperserState[] firstAndLastState) {
        if (particlesCollector.size() == 0) {
            firstAndLastState[1] = firstAndLastState[0];
            return;
        }
        DisperserState[] states = new DisperserState[2];
        for (int i = 0; i < particlesCollector.size(); ++i) {
            Particle particle = (Particle)particlesCollector.get(i);
            int minOccurs = particle.getMinOccurs();
            int maxOccurs = particle.getMaxOccurs();
            if (minOccurs == 0) {
                states[1] = new DisperserState();
                if (i == 0) {
                    this.addStateToStateWithUnnamedGill(firstAndLastState[0], states[1]);
                } else {
                    this.addStateToStateWithUnnamedGill(states[0], states[1]);
                }
                states[0] = states[1];
            } else {
                for (int minOccursCounter = 0; minOccursCounter < minOccurs; ++minOccursCounter) {
                    states[1] = new DisperserState();
                    if (minOccursCounter == 0 && i == 0) {
                        DisperserState[] hlpStates = new DisperserState[]{firstAndLastState[0], states[1]};
                        this.particleInit(particle, hlpStates);
                        states[1] = hlpStates[1];
                    } else {
                        this.particleInit(particle, states);
                    }
                    states[0] = states[1];
                }
            }
            if (particle.isMaxOccursUnbounded()) {
                states[1] = new DisperserState();
                this.particleInit(particle, states);
                this.addStateToStateWithUnnamedGill(states[1], states[0]);
                states[1] = states[0];
                continue;
            }
            Vector<DisperserState> firsStatesCollector = new Vector<DisperserState>();
            for (int maxOccursCounter = 0; maxOccursCounter < maxOccurs - minOccurs; ++maxOccursCounter) {
                firsStatesCollector.add(states[0]);
                states[1] = new DisperserState();
                this.particleInit(particle, states);
                states[0] = states[1];
            }
            for (int j = 0; j < firsStatesCollector.size(); ++j) {
                this.addStateToStateWithUnnamedGill((DisperserState)firsStatesCollector.get(j), states[1]);
            }
        }
        firstAndLastState[1] = states[1];
    }

    private void addStateToStateWithUnnamedGill(DisperserState parentState, DisperserState childState) {
        if (parentState != childState) {
            parentState.addChild("DisperserState.Unnamed.Key", childState);
        }
    }

    private void compositorAllInit(Vector particlesCollector, DisperserState[] firstAndLastState) {
        this.initStatesWithParticleAll(particlesCollector, firstAndLastState[0], firstAndLastState[1]);
    }

    private void initStatesWithParticleAll(Vector particlesCollector, DisperserState state, DisperserState lastState) {
        if (particlesCollector.size() == 1) {
            Particle particle = (Particle)particlesCollector.get(0);
            ElementDeclaration elementDeclr = (ElementDeclaration)particle.getTerm();
            state.addChild(elementDeclr, lastState);
            if (particle.getMinOccurs() == 0) {
                state.addChild("DisperserState.Unnamed.Key", lastState);
            }
        } else {
            for (int i = 0; i < particlesCollector.size(); ++i) {
                Particle particle = (Particle)particlesCollector.get(i);
                DisperserState newState = new DisperserState();
                state.addChild((ElementDeclaration)particle.getTerm(), newState);
                if (particle.getMinOccurs() == 0) {
                    state.addChild("DisperserState.Unnamed.Key", newState);
                }
                Vector newParticlesCollector = new Vector(particlesCollector);
                newParticlesCollector.remove(particle);
                this.initStatesWithParticleAll(newParticlesCollector, newState, lastState);
            }
        }
    }

    DisperserChildMappingStructure switchState(String elementUri, String elementName) {
        DisperserState switchingState = this.currentState;
        DisperserChildMappingStructure result = this.switchState(DisperserState.createGill(elementUri, elementName), switchingState, new Vector());
        if (result != null) {
            this.currentState = result.getDisperserState();
        }
        return result;
    }

    private DisperserChildMappingStructure switchState(String gill, DisperserState switchingState, Vector unnamedStatesCollector) {
        DisperserChildMappingStructure gillStructure = switchingState.getChildMappingStructure(gill);
        if (gillStructure == null) {
            gillStructure = switchingState.getChildMappingStructure("DisperserState.Any.Key");
            if (gillStructure == null) {
                gillStructure = switchingState.getChildMappingStructure("DisperserState.Unnamed.Key");
                unnamedStatesCollector.add(switchingState);
                if (gillStructure == null) {
                    return null;
                }
                if (unnamedStatesCollector.contains(gillStructure.getDisperserState())) {
                    return null;
                }
                return this.switchState(gill, gillStructure.getDisperserState(), unnamedStatesCollector);
            }
            return gillStructure;
        }
        return gillStructure;
    }

    boolean isInFinalState() {
        return this.isInFinalState(this.currentState);
    }

    boolean isInStartingState() {
        return this.currentState == this.firstState;
    }

    void reset() {
        this.currentState = this.firstState;
    }

    private boolean isInFinalState(DisperserState currentSwitchingState) {
        if (currentSwitchingState != this.lastState) {
            DisperserState childState = currentSwitchingState.getChild("DisperserState.Unnamed.Key");
            return childState == null ? false : this.isInFinalState(childState);
        }
        return true;
    }

    public void display() {
        this.display(this.firstState, new Vector());
        System.out.println("LastState : " + this.lastState);
    }

    private void display(DisperserState state, Vector collector) {
        System.out.println("State : " + state);
        System.out.println();
        if (!collector.contains(state)) {
            collector.add(state);
            Hashtable statesMapping = state.getChildrenStatesMapping();
            Enumeration enumeration = statesMapping.elements();
            while (enumeration.hasMoreElements()) {
                this.display(((DisperserChildMappingStructure)enumeration.nextElement()).getDisperserState(), collector);
            }
        }
    }

    private static Node parseToDOM(Source source) throws Exception {
        Transformer transformer = null;
        TransformerFactoryImpl tf = new TransformerFactoryImpl();
        transformer = ((TransformerFactory)tf).newTransformer();
        DOMResult result = new DOMResult();
        transformer.transform(source, result);
        return result.getNode();
    }

    public static void main(String[] args) throws Exception {
        LoaderImpl loader = new LoaderImpl();
        Schema schema = loader.load(ComplexTypeDisperser.parseToDOM(new StreamSource("D:\\develop\\schema_test\\from chavdar\\test_schema.xsd")));
        ElementDeclaration elementDeclr = schema.getTopLevelElementDeclaration("http://schemas.xmlsoap.org/soap/encoding/", "SecurityRole");
        ComplexTypeDefinition complexTypeDef = (ComplexTypeDefinition)elementDeclr.getTypeDefinition();
        ComplexTypeDisperser disperser = new ComplexTypeDisperser(complexTypeDef);
        disperser.display();
    }
}

