/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.validator.ElementStructure;
import com.sap.engine.lib.schema.validator.FieldsMappingStructure;
import com.sap.engine.lib.schema.validator.IdentityConstrXPathProcessor;
import com.sap.engine.lib.schema.validator.SchemaValidationException;
import com.sap.engine.lib.schema.validator.XPathObject;
import java.util.Vector;

abstract class AbstractIdentityConstraintDefProcessor {
    protected IdentityConstraintDefinition identityConstrDef;
    protected IdentityConstrXPathProcessor xPathProcessor;
    protected Vector fieldsMappingStrsCollector;
    protected Vector errorsCollector;
    protected String uri;
    protected String name;

    AbstractIdentityConstraintDefProcessor(IdentityConstraintDefinition identityConstrDef, Vector errorsCollector) throws SchemaValidationException {
        this.identityConstrDef = identityConstrDef;
        this.uri = identityConstrDef.getTargetNamespace();
        this.name = identityConstrDef.getName();
        this.errorsCollector = errorsCollector;
        this.fieldsMappingStrsCollector = new Vector();
        Vector fieldsCollector = new Vector();
        identityConstrDef.getFields(fieldsCollector);
        String selector = identityConstrDef.getSelector();
        this.xPathProcessor = new IdentityConstrXPathProcessor(selector, fieldsCollector, identityConstrDef.getPrefixesMapping());
    }

    protected void addStructure(ElementStructure structure) {
        XPathObject fieldXPathObj = this.xPathProcessor.match(structure.xPathObj);
        if (fieldXPathObj != null) {
            boolean isAdded = false;
            for (int i = 0; i < this.fieldsMappingStrsCollector.size(); ++i) {
                FieldsMappingStructure filedsMappingStr = (FieldsMappingStructure)this.fieldsMappingStrsCollector.get(i);
                if (!filedsMappingStr.add(fieldXPathObj, structure)) continue;
                isAdded = true;
                break;
            }
            if (!isAdded) {
                FieldsMappingStructure fieldsMappingStr = new FieldsMappingStructure(this.xPathProcessor.fieldsXPathObjs);
                fieldsMappingStr.add(fieldXPathObj, structure);
                this.fieldsMappingStrsCollector.add(fieldsMappingStr);
            }
        }
    }

    protected void setContextXPathObject(XPathObject xPathObj) {
        this.xPathProcessor.setContextXPathObject(xPathObj);
    }

    protected abstract boolean process();

    public String toString() {
        return this.getClass() + " uri : " + this.uri + " name : " + this.name;
    }
}

