/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.util;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import java.util.Vector;

public final class Tools {
    private static final String PREFIX_DELIMITER = ":";

    private Tools() {
    }

    public static String formatQNameWithUri(String uri, String local) {
        return "{" + uri + "}" + PREFIX_DELIMITER + local;
    }

    public static String formatQNameWithPrefix(String prefix, String local) {
        return prefix == null || prefix.equals("") ? local : prefix + PREFIX_DELIMITER + local;
    }

    public static String formatQNameWithUri(String uri, CharArray local) {
        return Tools.formatQNameWithUri(uri, local.toString());
    }

    public static boolean compareBases(Base srcBase, Base dstBase) {
        if (srcBase == dstBase || srcBase.equals(dstBase)) {
            return true;
        }
        if (srcBase == null ^ dstBase == null) {
            return false;
        }
        if (srcBase != null) {
            return srcBase.match(dstBase);
        }
        return true;
    }

    public static boolean compareStringProps(String srcString, String dstString) {
        if (srcString == null ^ dstString == null) {
            return false;
        }
        if (srcString != null) {
            return srcString.equals(dstString);
        }
        return true;
    }

    public static boolean compareUnorderdSetsOfBases(Vector srcBases, Vector dstBases) {
        if (srcBases == null ^ dstBases == null) {
            return false;
        }
        if (srcBases != null) {
            if (srcBases.size() != dstBases.size()) {
                return false;
            }
            boolean[] checked = new boolean[srcBases.size()];
            for (int i = 0; i < srcBases.size(); ++i) {
                Base srcBase = (Base)srcBases.get(i);
                boolean found = false;
                for (int j = 0; j < dstBases.size(); ++j) {
                    Base dstBase;
                    if (checked[j] || srcBase != (dstBase = (Base)dstBases.get(j)) && !srcBase.equals(dstBase) && !srcBase.match(dstBase)) continue;
                    checked[j] = true;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean compareUnorderdSetsOfBases(Base[] srcBases, Base[] dstBases) {
        if (srcBases == null ^ dstBases == null) {
            return false;
        }
        if (srcBases != null) {
            if (srcBases.length != dstBases.length) {
                return false;
            }
            boolean[] checked = new boolean[srcBases.length];
            for (int i = 0; i < srcBases.length; ++i) {
                Base srcBase = srcBases[i];
                boolean found = false;
                for (int j = 0; j < dstBases.length; ++j) {
                    Base dstBase;
                    if (checked[j] || !srcBase.match(dstBase = dstBases[j])) continue;
                    checked[j] = true;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean compareOrderedSetsOfBases(Vector srcBases, Vector dstBases) {
        if (srcBases == null ^ dstBases == null) {
            return false;
        }
        if (srcBases != null) {
            if (srcBases.size() != dstBases.size()) {
                return false;
            }
            for (int i = 0; i < srcBases.size(); ++i) {
                Base dstBase;
                Base srcBase = (Base)srcBases.get(i);
                if (srcBase.match(dstBase = (Base)dstBases.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean compareUnorderedSetsOfStrings(String[] srcArray, String[] dstArray) {
        if (srcArray == null ^ dstArray == null) {
            return false;
        }
        if (srcArray != null) {
            if (srcArray.length != dstArray.length) {
                return false;
            }
            boolean[] checked = new boolean[srcArray.length];
            for (int i = 0; i < srcArray.length; ++i) {
                String srcString = srcArray[i];
                boolean found = false;
                for (int j = 0; j < dstArray.length; ++j) {
                    String dstString;
                    if (checked[j] || !srcString.equals(dstString = dstArray[j])) continue;
                    checked[j] = true;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean compareUnorderedSetsOfStrings(Vector srcStrings, Vector dstStrings) {
        if (srcStrings == null ^ dstStrings == null) {
            return false;
        }
        if (srcStrings != null) {
            if (srcStrings.size() != dstStrings.size()) {
                return false;
            }
            boolean[] checked = new boolean[srcStrings.size()];
            for (int i = 0; i < srcStrings.size(); ++i) {
                String srcString = (String)srcStrings.get(i);
                boolean found = false;
                for (int j = 0; j < dstStrings.size(); ++j) {
                    String dstString;
                    if (checked[j] || !srcString.equals(dstString = (String)dstStrings.get(i))) continue;
                    checked[j] = true;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public static String generateKey(String uri, String name) {
        if (uri == null) {
            uri = "";
        }
        return uri.hashCode() + "-" + name.hashCode();
    }
}

