/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.util;

import com.sap.engine.lib.xml.parser.helpers.CharArray;

public final class NumberParser {
    private String errorMessage;

    public long parseInteger(CharArray v) {
        this.errorMessage = null;
        char[] data = v.getData();
        int i = v.getOffset();
        int end = i + v.length();
        long r = 0L;
        boolean negative = false;
        char ch = data[i];
        if (ch == '-') {
            negative = true;
            ++i;
        } else if (ch == '+') {
            ++i;
        }
        if (i >= end) {
            this.errorMessage = "Empty string or '+' or '-' is not a valid number.";
            return Long.MIN_VALUE;
        }
        while (i < end) {
            ch = data[i];
            if (ch < '0' || ch > '9') {
                this.errorMessage = "Illegal number format";
                return Long.MIN_VALUE;
            }
            long rOld = r;
            r *= 10L;
            if (rOld > (r += (long)(ch - 48))) {
                this.errorMessage = "Overflow!";
                return Long.MIN_VALUE;
            }
            ++i;
        }
        return negative ? -r : r;
    }

    public boolean parseBoolean(CharArray v) {
        this.errorMessage = null;
        if (v.equals("0") || v.equals("false")) {
            return false;
        }
        if (v.equals("1") || v.equals("true")) {
            return true;
        }
        this.errorMessage = "Boolean should be one of '0', '1', 'false', 'true'.";
        return false;
    }

    public double parseDouble(CharArray v) {
        return 0.0;
    }

    public float parseFloat(CharArray v) {
        return 0.0f;
    }

    public boolean ok() {
        return this.errorMessage == null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static void main(String[] args) throws Exception {
        NumberParser np = new NumberParser();
        long x = np.parseInteger(new CharArray("+00000"));
        System.out.println(" x = " + x);
        System.out.println(" err = " + np.getErrorMessage());
    }
}

