/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.util;

import com.sap.engine.lib.xml.parser.helpers.CharArray;

public final class NSSupport {
    private static final String MARK = "[MARK]";
    private String[] prefixes = new String[100];
    private String[] uris = new String[100];
    private int n;

    public void reset() {
        this.n = 0;
        this.push(MARK, null);
    }

    public void pushContext() {
        this.push(MARK, null);
    }

    public void popContext() {
        --this.n;
        while (this.prefixes[this.n] != MARK) {
            --this.n;
        }
    }

    public void declarePrefix(String p, String u) {
        this.push(p, u);
    }

    public String getURI(String p) {
        for (int i = this.n - 1; i >= 0; --i) {
            String temp = this.prefixes[i];
            if (temp == MARK || !p.equals(temp)) continue;
            return this.uris[i];
        }
        return null;
    }

    public void getURI(CharArray p, CharArray u) {
        for (int i = this.n - 1; i >= 0; --i) {
            String temp = this.prefixes[i];
            if (temp == MARK || !p.equals(temp)) continue;
            u.set(this.uris[i]);
            return;
        }
        u.clear();
    }

    public void processName(CharArray name, CharArray u, CharArray l) {
        name.parseNS(u, l);
        this.getURI(u, u);
    }

    private void push(String p, String u) {
        if (this.n >= this.prefixes.length) {
            String[] old = this.prefixes;
            this.prefixes = new String[old.length * 2];
            System.arraycopy(old, 0, this.prefixes, 0, old.length);
            old = this.uris;
            this.uris = new String[old.length * 2];
            System.arraycopy(old, 0, this.uris, 0, old.length);
        }
        this.prefixes[this.n] = p;
        this.uris[this.n] = u;
        ++this.n;
    }
}

