/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.util;

public class Duration {
    public static final int SECONDS_PER_DAY = 86400;
    int years = 0;
    int months = 0;
    int weeks = 0;
    int days = 0;
    int hours = 0;
    int minutes = 0;
    float seconds = 0.0f;
    short precision = 0;
    boolean positive = true;
    boolean hastime = true;
    int maxdays;
    int mindays;
    float daytime;
    boolean validated;
    public static int[] MONTHS_TO_MINIMUM_DAYS = new int[]{28, 59, 89, 120, 150, 181, 212, 242, 273, 303, 334, 365, 393, 424, 454, 485, 515, 546, 577, 607, 638, 668, 699, 730, 758, 789, 819, 850, 880, 911, 942, 972, 1003, 1033, 1064, 1095, 1124, 1155, 1185, 1216, 1246, 1277, 1308, 1338, 1369, 1399, 1430, 1461};
    public static int[] MONTHS_TO_MAXIMUM_DAYS = new int[]{31, 62, 92, 123, 153, 184, 215, 245, 276, 306, 337, 366, 397, 428, 458, 489, 519, 550, 581, 611, 642, 672, 703, 731, 762, 793, 823, 854, 884, 915, 946, 976, 1007, 1037, 1068, 1096, 1127, 1158, 1188, 1219, 1249, 1280, 1311, 1341, 1372, 1402, 1433, 1461};

    public boolean validate(char[] data, int start, int end) {
        int endindex;
        int startindex;
        boolean atleastone = false;
        int dateend = this.searchCharArray(data, 'T', start, end);
        if (dateend == -1) {
            dateend = end;
            this.hastime = false;
        }
        if ((startindex = this.searchCharArray(data, 'P', 0, 1)) != 0 && startindex != 1 && data[start] != '-') {
            return false;
        }
        startindex = 1;
        if (data[start] == '-') {
            this.positive = false;
            ++startindex;
        }
        if ((endindex = this.searchCharArray(data, 'Y', startindex, dateend)) != -1) {
            atleastone = true;
            try {
                this.years = new Integer(new String(data, startindex, endindex - startindex));
                startindex = endindex + 1;
            }
            catch (Exception e) {
                return false;
            }
        }
        if ((endindex = this.searchCharArray(data, 'M', startindex, dateend)) != -1) {
            atleastone = true;
            try {
                this.months = new Integer(new String(data, startindex, endindex - startindex));
                startindex = endindex + 1;
            }
            catch (Exception e) {
                return false;
            }
        }
        if ((endindex = this.searchCharArray(data, 'D', startindex, dateend)) != -1) {
            atleastone = true;
            try {
                this.days = new Integer(new String(data, startindex, endindex - startindex));
            }
            catch (Exception e) {
                return false;
            }
        }
        if (this.hastime) {
            startindex = dateend + 1;
            endindex = this.searchCharArray(data, 'H', startindex, end);
            if (endindex != -1) {
                atleastone = true;
                try {
                    this.hours = new Integer(new String(data, startindex, endindex - startindex));
                    startindex = endindex + 1;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if ((endindex = this.searchCharArray(data, 'M', startindex, end)) != -1) {
                atleastone = true;
                try {
                    this.minutes = new Integer(new String(data, startindex, endindex - startindex));
                    startindex = endindex + 1;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if ((endindex = this.searchCharArray(data, 'S', startindex, end)) != -1) {
                atleastone = true;
                try {
                    this.seconds = new Float(new String(data, startindex, endindex - startindex)).floatValue();
                    startindex = endindex + 1;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        this.maxdays = this.maxDays();
        this.mindays = this.minDays();
        return atleastone;
    }

    private int searchCharArray(char[] data, char ch, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (data[i] != ch) continue;
            return i;
        }
        return -1;
    }

    private boolean containsOnlyDigits(char[] data, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (data[i] >= '0' && data[i] <= '9') continue;
            return false;
        }
        return true;
    }

    public boolean isGreaterThan(Duration d) {
        if (this.mindays > d.maxdays) {
            return true;
        }
        return this.mindays == d.maxdays && this.dayTimeToSeconds() > d.dayTimeToSeconds();
    }

    public boolean isSmallerThan(Duration d) {
        if (this.maxdays < d.mindays) {
            return true;
        }
        return this.maxdays == d.mindays && this.dayTimeToSeconds() < d.dayTimeToSeconds();
    }

    public boolean isEqualTo(Duration d) {
        return this.mindays == d.mindays && this.maxdays == d.maxdays && this.dayTimeToSeconds() == d.dayTimeToSeconds();
    }

    private int maxDays() {
        return (this.years * 12 + this.months) / 48 * 1461 + MONTHS_TO_MAXIMUM_DAYS[(this.years * 12 + this.months) % 48] + this.days;
    }

    private int minDays() {
        return (this.years * 12 + this.months) / 48 * 1461 + MONTHS_TO_MINIMUM_DAYS[(this.years * 12 + this.months) % 48] + this.days;
    }

    private float dayTimeToSeconds() {
        return (float)(this.hours * 3600 + this.minutes * 60) + this.seconds;
    }
}

