/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.regular;

import com.sap.engine.lib.schema.regular.Tools;

public class CompactByteArray {
    public static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 7;
    private static final int BLOCKCOUNT = 128;
    private static final int INDEXSHIFT = 9;
    private static final int INDEXCOUNT = 512;
    private static final int BLOCKMASK = 127;
    private byte[] values;
    private short[] indices;
    private boolean isCompact;
    private int[] hashes;

    public CompactByteArray() {
        this(0);
    }

    public CompactByteArray(byte byte0) {
        this.values = new byte[65536];
        this.indices = new short[512];
        this.hashes = new int[512];
        for (int i = 0; i < 65536; ++i) {
            this.values[i] = byte0;
        }
        for (int j = 0; j < 512; ++j) {
            this.indices[j] = (short)(j << 7);
            this.hashes[j] = 0;
        }
        this.isCompact = false;
    }

    public CompactByteArray(short[] aword0, byte[] abyte0) {
        if (aword0.length != 512) {
            throw new IllegalArgumentException("Index out of bounds!");
        }
        for (int i = 0; i < 512; ++i) {
            short word0 = aword0[i];
            if (word0 >= 0 && word0 < abyte0.length + 128) continue;
            throw new IllegalArgumentException("Index out of bounds!");
        }
        this.indices = aword0;
        this.values = abyte0;
        this.isCompact = true;
    }

    public CompactByteArray(String s, String s1) {
        this(Tools.RLEStringToShortArray(s), Tools.RLEStringToByteArray(s1));
    }

    public byte elementAt(char c) {
        return this.values[(this.indices[c >> 7] & 0xFFFF) + (c & 0x7F)];
    }

    public void setElementAt(char c, byte byte0) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c] = byte0;
        this.touchBlock(c >> 7, byte0);
    }

    public void setElementAt(char c, char c1, byte byte0) {
        if (this.isCompact) {
            this.expand();
        }
        for (int i = c; i <= c1; ++i) {
            this.values[i] = byte0;
            this.touchBlock(i >> 7, byte0);
        }
    }

    public void compact() {
        if (!this.isCompact) {
            int i = 0;
            int j = 0;
            int word0 = -1;
            int k = 0;
            while (k < this.indices.length) {
                this.indices[k] = -1;
                boolean flag = this.blockTouched(k);
                if (!flag && word0 != -1) {
                    this.indices[k] = word0;
                } else {
                    int i1 = 0;
                    int j1 = 0;
                    j1 = 0;
                    while (j1 < i) {
                        if (this.hashes[k] == this.hashes[j1] && CompactByteArray.arrayRegionMatches(this.values, j, this.values, i1, 128)) {
                            this.indices[k] = (short)i1;
                            break;
                        }
                        ++j1;
                        i1 += 128;
                    }
                    if (this.indices[k] == -1) {
                        System.arraycopy(this.values, j, this.values, i1, 128);
                        this.indices[k] = (short)i1;
                        this.hashes[j1] = this.hashes[k];
                        ++i;
                        if (!flag) {
                            word0 = (short)i1;
                        }
                    }
                }
                ++k;
                j += 128;
            }
            int l = i * 128;
            byte[] abyte0 = new byte[l];
            System.arraycopy(this.values, 0, abyte0, 0, l);
            this.values = abyte0;
            this.isCompact = true;
            this.hashes = null;
        }
    }

    static final boolean arrayRegionMatches(byte[] abyte0, int i, byte[] abyte1, int j, int k) {
        int l = i + k;
        int i1 = j - i;
        for (int j1 = i; j1 < l; ++j1) {
            if (abyte0[j1] == abyte1[j1 + i1]) continue;
            return false;
        }
        return true;
    }

    private final void touchBlock(int i, int j) {
        this.hashes[i] = this.hashes[i] + (j << 1) | 1;
    }

    private final boolean blockTouched(int i) {
        return this.hashes[i] != 0;
    }

    public short[] getIndexArray() {
        return this.indices;
    }

    public byte[] getStringArray() {
        return this.values;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompactByteArray compactbytearray = (CompactByteArray)obj;
        for (int i = 0; i < 65536; ++i) {
            if (this.elementAt((char)i) == compactbytearray.elementAt((char)i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int i = 0;
        int j = Math.min(3, this.values.length / 16);
        for (int k = 0; k < this.values.length; k += j) {
            i = i * 37 + this.values[k];
        }
        return i;
    }

    private void expand() {
        if (this.isCompact) {
            this.hashes = new int[512];
            byte[] abyte0 = new byte[65536];
            for (int i = 0; i < 65536; ++i) {
                byte byte0;
                abyte0[i] = byte0 = this.elementAt((char)i);
                this.touchBlock(i >> 7, byte0);
            }
            for (int j = 0; j < 512; ++j) {
                this.indices[j] = (short)(j << 7);
            }
            this.values = null;
            this.values = abyte0;
            this.isCompact = false;
        }
    }

    private byte[] getArray() {
        return this.values;
    }
}

