/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.gui.validator;

import com.sap.engine.lib.schema.SchemaException;
import com.sap.engine.lib.schema.gui.filechooser.XFileChooser;
import com.sap.engine.lib.schema.gui.filechooser.XFileChooserPanel;
import com.sap.engine.lib.schema.gui.sapstyle.SAPStyle;
import com.sap.engine.lib.schema.gui.validator.OutcomeDialog;
import com.sap.engine.lib.schema.validator.SchemaValidator;
import com.sap.engine.lib.xml.dom.DOM;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.stream.StreamSource;

public final class SchemaValidatorPanel {
    private static final ResourceBundle bundle = ResourceBundle.getBundle((class$com$sap$engine$lib$schema$gui$validator$SchemaValidatorPanel == null ? (class$com$sap$engine$lib$schema$gui$validator$SchemaValidatorPanel = SchemaValidatorPanel.class$("com.sap.engine.lib.schema.gui.validator.SchemaValidatorPanel")) : class$com$sap$engine$lib$schema$gui$validator$SchemaValidatorPanel).getPackage().getName().replace('.', '/') + "/res");
    private static final String S_XML_FILE = bundle.getString("xml_file");
    private static final String S_SCHEMA_DOCUMENT = bundle.getString("schema_document");
    private static final String S_PLEASE_SELECT_AN_XML_FILE = bundle.getString("please_select_an_xml_file");
    private static final String S_VALIDATE = bundle.getString("validate");
    private static final String S_XML_SCHEMA_VALIDATOR = bundle.getString("xml_schema_validator");
    private static final FileFilter XML_FILTER = new FileFilter(){

        public boolean accept(File f) {
            return f != null && f.getName().endsWith(".xml");
        }

        public String getDescription() {
            return S_XML_FILE;
        }
    };
    private static final FileFilter XSD_FILTER = new FileFilter(){

        public boolean accept(File f) {
            return f != null && f.getName().endsWith(".xsd");
        }

        public String getDescription() {
            return S_SCHEMA_DOCUMENT;
        }
    };
    private JPanel panel;
    private OutcomeDialog outcomeDialog;
    private XFileChooser chooser;
    private XFileChooserPanel xmlChooserPanel;
    private XFileChooserPanel xsdChooserPanel;
    private Action actionValidate;
    private SchemaValidator validator = new SchemaValidator();
    static /* synthetic */ Class class$com$sap$engine$lib$schema$gui$validator$SchemaValidatorPanel;

    private SchemaValidatorPanel(final JFrame frame) {
        this.actionValidate = new AbstractAction(S_VALIDATE){

            public void actionPerformed(ActionEvent ev) {
                boolean x;
                File xmlFile = SchemaValidatorPanel.this.xmlChooserPanel.getSelectedFile();
                File xsdFile = SchemaValidatorPanel.this.xsdChooserPanel.getSelectedFile();
                if (xmlFile == null) {
                    SAPStyle.showError(frame, S_PLEASE_SELECT_AN_XML_FILE);
                    return;
                }
                try {
                    x = SchemaValidatorPanel.this.validator.validate(new StreamSource(xmlFile), xsdFile == null ? null : new StreamSource(xsdFile));
                }
                catch (SchemaException e) {
                    SAPStyle.showException(frame, e);
                    return;
                }
                new OutcomeDialog(frame, SchemaValidatorPanel.this.validator, x).setVisible(true);
            }
        };
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.chooser = new XFileChooser(frame);
        this.xmlChooserPanel = new XFileChooserPanel(frame, this.chooser, XML_FILTER, null);
        this.xmlChooserPanel.setBorder(BorderFactory.createTitledBorder(S_XML_FILE));
        this.panel.add(this.xmlChooserPanel);
        this.xsdChooserPanel = new XFileChooserPanel(frame, this.chooser, XSD_FILTER, null);
        this.xsdChooserPanel.setBorder(BorderFactory.createTitledBorder(S_SCHEMA_DOCUMENT));
        this.panel.add(this.xsdChooserPanel);
        this.panel.add(new JButton(this.actionValidate));
        this.panel.registerKeyboardAction(this.actionValidate, KeyStroke.getKeyStroke(10, 2), 2);
    }

    public static void main(String[] args) throws Exception {
        DOM.setInQMyJAXP();
        JFrame frame = new JFrame();
        frame.setIconImage(SAPStyle.SAP_LOGO.getImage());
        frame.setTitle(S_XML_SCHEMA_VALIDATOR);
        frame.setContentPane(new SchemaValidatorPanel((JFrame)frame).panel);
        frame.pack();
        frame.setBounds(((int)frame.getToolkit().getScreenSize().getWidth() - frame.getWidth()) / 2, ((int)frame.getToolkit().getScreenSize().getHeight() - frame.getHeight()) / 2, (int)((double)frame.getWidth() * 1.5), frame.getHeight());
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

