/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.gui.filechooser;

import com.sap.engine.lib.schema.gui.filechooser.FileSystemViewTreeModel;
import com.sap.engine.lib.schema.gui.filechooser.XFileChooser;
import com.sap.engine.lib.schema.gui.sapstyle.SAPStyle;
import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.filechooser.FileView;
import javax.swing.tree.TreeCellRenderer;

final class FileViewTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private static final ImageIcon ICON_DRIVE = SAPStyle.getIcon("S_DBTBIN");
    private static final ImageIcon ICON_DIR = SAPStyle.getIcon("S_CLOOBJ");
    private static final ImageIcon ICON_DIR_EXPANDED = SAPStyle.getIcon("S_OPFOLD");
    private static final ImageIcon ICON_FILE = SAPStyle.getIcon("S_B_CREA");
    private XFileChooser owner;
    private FileView fileView;

    public FileViewTreeCellRenderer(XFileChooser owner, FileView fileView) {
        this.owner = owner;
        this.fileView = fileView;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (selected) {
            if (hasFocus) {
                super.setOpaque(true);
                super.setBackground(SAPStyle.BLUE);
                super.setForeground(SAPStyle.ORANGE);
            } else {
                super.setOpaque(true);
                super.setBackground(SAPStyle.BLUE);
                super.setForeground(SAPStyle.WHITE);
            }
        } else if (hasFocus) {
            super.setOpaque(false);
            super.setForeground(SAPStyle.ORANGE);
        } else {
            super.setOpaque(false);
            super.setForeground(SAPStyle.BLUE);
        }
        if (value == FileSystemViewTreeModel.ROOT) {
            this.setText("My Computer");
            this.setIcon(null);
            return this;
        }
        File file = (File)value;
        if (file.isDirectory()) {
            String name = file.getName();
            if (name.length() == 0) {
                name = file.toString();
                super.setIcon(ICON_DRIVE);
            } else {
                super.setIcon(expanded ? ICON_DIR_EXPANDED : ICON_DIR);
            }
            name = '[' + name + ']';
            super.setText(name);
        } else {
            super.setText(file.getName());
            Icon icon = this.fileView == null ? null : this.fileView.getIcon(file);
            super.setIcon(icon == null ? ICON_FILE : icon);
        }
        return this;
    }
}

