/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl0;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.SchemaComponentException;
import com.sap.engine.lib.schema.components.Wildcard;
import com.sap.engine.lib.schema.components.impl0.BaseImpl;
import com.sap.engine.lib.schema.components.impl0.LoaderImpl;
import com.sap.engine.lib.schema.util.Tools;
import java.util.Vector;

public final class WildcardImpl
extends BaseImpl
implements Wildcard {
    public static final int SKIP = 1;
    public static final int LAX = 2;
    public static final int STRICT = 3;
    protected int processContents;
    protected boolean nscAny;
    protected String negated;
    protected String[] members;
    protected boolean isAttribWildcard = false;

    protected WildcardImpl() {
    }

    public int getTypeOfComponent() {
        return 10;
    }

    public boolean isProcessContentsSkip() {
        return this.processContents == 1;
    }

    public boolean isProcessContentsLax() {
        return this.processContents == 2;
    }

    public boolean isProcessContentsStrict() {
        return this.processContents == 3;
    }

    public boolean isNamespaceConstraintAny() {
        return this.nscAny;
    }

    public String getNamespaceConstraintNegated() {
        return this.negated;
    }

    public boolean isAttribWildcard() {
        return this.isAttribWildcard;
    }

    public boolean namespaceConstraintMembersContain(String uri) {
        for (int i = 0; i < this.members.length; ++i) {
            if (!this.members[i].equals(uri)) continue;
            return true;
        }
        return false;
    }

    private void setPC(String s) {
        this.processContents = s == null || s.equals("strict") ? 3 : (s.equals("lax") ? 2 : 1);
    }

    public String[] getNamespaceConstraintMembersAsArray() {
        if (this.members == null) {
            return null;
        }
        String[] r = new String[this.members.length];
        System.arraycopy(this.members, 0, r, 0, this.members.length);
        return r;
    }

    public void getNamespaceConstraintMembers(Vector v) {
        if (this.members != null) {
            int nMembers = this.members.length;
            for (int i = 0; i < nMembers; ++i) {
                v.add(this.members[i]);
            }
        }
    }

    public static Wildcard unite(Wildcard a, Wildcard b) throws SchemaComponentException {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.isNamespaceConstraintAny() || b.isNamespaceConstraintAny()) {
            WildcardImpl c = new WildcardImpl();
            c.setOwnerSchema(a.getOwnerSchema());
            c.nscAny = true;
            c.setProcessContentsLike(a);
            return c;
        }
        String[] aMembers = a.getNamespaceConstraintMembersAsArray();
        String[] bMembers = b.getNamespaceConstraintMembersAsArray();
        if (aMembers != null && bMembers != null) {
            WildcardImpl c = new WildcardImpl();
            c.setOwnerSchema(a.getOwnerSchema());
            c.members = WildcardImpl.uniteArrays(aMembers, bMembers);
            return c;
        }
        String aNegated = a.getNamespaceConstraintNegated();
        String bNegated = b.getNamespaceConstraintNegated();
        if (aNegated != null && bNegated != null) {
            if (aNegated.equals(bNegated)) {
                return a;
            }
            throw new SchemaComponentException("Wildcard union not expressible");
        }
        if (aMembers != null && bNegated != null) {
            if (WildcardImpl.contains(aMembers, aMembers.length, bNegated)) {
                return a;
            }
            WildcardImpl c = new WildcardImpl();
            c.setOwnerSchema(a.getOwnerSchema());
            c.nscAny = true;
            c.setProcessContentsLike(a);
            return c;
        }
        if (bMembers != null && aNegated != null) {
            if (WildcardImpl.contains(bMembers, bMembers.length, aNegated)) {
                return b;
            }
            WildcardImpl c = new WildcardImpl();
            c.setOwnerSchema(a.getOwnerSchema());
            c.nscAny = true;
            c.setProcessContentsLike(a);
            return c;
        }
        WildcardImpl c = new WildcardImpl();
        c.setOwnerSchema(a.getOwnerSchema());
        c.nscAny = true;
        c.setProcessContentsLike(a);
        return c;
    }

    public static Wildcard intersect(Wildcard a, Wildcard b) throws SchemaComponentException {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.isNamespaceConstraintAny()) {
            return b;
        }
        if (b.isNamespaceConstraintAny()) {
            return a;
        }
        String[] aMembers = a.getNamespaceConstraintMembersAsArray();
        String[] bMembers = b.getNamespaceConstraintMembersAsArray();
        String aNegated = a.getNamespaceConstraintNegated();
        String bNegated = b.getNamespaceConstraintNegated();
        if (aMembers != null && bNegated != null) {
            WildcardImpl c = new WildcardImpl();
            c.setOwnerSchema(a.getOwnerSchema());
            c.setProcessContentsLike(a);
            c.members = WildcardImpl.removeFromArray(aMembers, bNegated);
            return c;
        }
        if (bMembers != null && aNegated != null) {
            WildcardImpl c = new WildcardImpl();
            c.setOwnerSchema(a.getOwnerSchema());
            c.setProcessContentsLike(a);
            c.members = WildcardImpl.removeFromArray(bMembers, aNegated);
            return c;
        }
        if (aMembers != null && bMembers != null) {
            WildcardImpl c = new WildcardImpl();
            c.setOwnerSchema(a.getOwnerSchema());
            c.setProcessContentsLike(a);
            c.members = WildcardImpl.uniteArrays(aMembers, bMembers);
            return c;
        }
        if (aNegated != null && bNegated != null) {
            if (aNegated.equals(bNegated)) {
                return a;
            }
            throw new SchemaComponentException("Wildcard intersection not expressible");
        }
        WildcardImpl c = new WildcardImpl();
        c.setOwnerSchema(a.getOwnerSchema());
        c.nscAny = true;
        c.setProcessContentsLike(a);
        return c;
    }

    private static String[] uniteArrays(String[] a, String[] b) throws SchemaComponentException {
        String[] c = new String[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        int nc = a.length;
        for (int i = 0; i < b.length; ++i) {
            if (WildcardImpl.contains(c, nc, b[i])) continue;
            c[nc] = b[i];
            ++nc;
        }
        if (nc == c.length) {
            return c;
        }
        String[] d = new String[nc];
        System.arraycopy(c, 0, d, 0, nc);
        return d;
    }

    private static String[] intersectArrays(String[] a, String[] b) throws SchemaComponentException {
        String[] c = new String[a.length];
        int nc = 0;
        for (int i = 0; i < a.length; ++i) {
            if (!WildcardImpl.contains(b, b.length, a[i])) continue;
            c[nc] = a[i];
            ++nc;
        }
        if (nc == c.length) {
            return c;
        }
        String[] d = new String[nc];
        System.arraycopy(c, 0, d, 0, nc);
        return d;
    }

    private static boolean contains(String[] a, int n, String x) throws SchemaComponentException {
        for (int i = 0; i < n; ++i) {
            if (!a[i].equals(x)) continue;
            return true;
        }
        return false;
    }

    private static String[] removeFromArray(String[] a, String x) throws SchemaComponentException {
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].equals(x)) continue;
            String[] r = new String[a.length - 1];
            System.arraycopy(a, 0, r, 0, i);
            System.arraycopy(a, i + 1, r, i, a.length - i - 1);
            return r;
        }
        return a;
    }

    private void setProcessContentsLike(Wildcard w) {
        this.processContents = w.isProcessContentsLax() ? 2 : (w.isProcessContentsSkip() ? 1 : (w.isProcessContentsStrict() ? 3 : 0));
    }

    protected void accept(Base x, int toWhat, String prop, LoaderImpl loader) throws SchemaComponentException {
        throw new SchemaComponentException();
    }

    public boolean match(Base wildcard) {
        if (!super.match(wildcard)) {
            return false;
        }
        WildcardImpl targetWildcard = (WildcardImpl)wildcard;
        boolean result = this.processContents == targetWildcard.processContents && this.equalNamespaceConstraint(targetWildcard);
        return result;
    }

    private boolean equalNamespaceConstraint(WildcardImpl wildcard) {
        if (this.nscAny != wildcard.nscAny) {
            return false;
        }
        if (!Tools.compareStringProps(this.negated, wildcard.negated)) {
            return false;
        }
        return Tools.compareUnorderedSetsOfStrings(this.members, wildcard.members);
    }
}

