/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl0;

import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.components.SchemaComponentException;
import com.sap.engine.lib.schema.components.SchemaInfo;
import com.sap.engine.lib.schema.components.impl0.LoaderImpl;
import com.sap.engine.lib.schema.components.impl0.SchemaImpl;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.parser.URLLoader;
import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class SchemaInfoImpl
implements SchemaInfo {
    private LoaderImpl loader;
    private Schema owner;
    private SchemaInfoImpl parent;
    private String targetNamespace;
    private String relativeLocation;
    private Source source;
    private String location;
    private Node node;
    private boolean isSuccessfullyResolved;
    private boolean isResolutionAttempted = false;

    SchemaInfoImpl(LoaderImpl loader, SchemaImpl owner, SchemaInfoImpl parent, String targetNamespace, String relativeLocation, Source source) {
        this.loader = loader;
        this.owner = owner;
        this.parent = parent;
        this.targetNamespace = targetNamespace;
        this.relativeLocation = relativeLocation;
        this.source = source;
    }

    public Schema getOwner() {
        return this.owner;
    }

    public String getLocation() {
        return this.location;
    }

    public Node getNode() {
        return this.node;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public boolean isSuccessfullyResolved() {
        return this.isSuccessfullyResolved;
    }

    public boolean isResolutionAttempted() {
        return this.isResolutionAttempted;
    }

    void resolve() throws SchemaComponentException {
        String tns;
        URL url;
        if (this.isResolutionAttempted) {
            return;
        }
        this.isResolutionAttempted = true;
        if (this.source == null) {
            if (this.relativeLocation == null) {
                this.isSuccessfullyResolved = false;
                return;
            }
            URIResolver ur = this.loader.getURIResolver();
            if (ur != null) {
                try {
                    this.source = ur.resolve(this.relativeLocation, this.parent == null ? null : this.parent.getLocation());
                }
                catch (TransformerException te) {
                    // empty catch block
                }
            }
            if (this.source == null) {
                try {
                    URL parentURL = URLLoader.fileOrURLToURL(null, this.parent == null ? null : this.parent.getLocation());
                    this.location = URLLoader.fileOrURLToURL(parentURL, this.relativeLocation).toExternalForm();
                }
                catch (IOException ioe) {
                    this.location = this.relativeLocation;
                }
                EntityResolver entityResolver = this.loader.getEntityResolver();
                if (entityResolver != null) {
                    InputSource inputSource = null;
                    try {
                        inputSource = entityResolver.resolveEntity("", this.location);
                    }
                    catch (Exception exc) {
                        this.isSuccessfullyResolved = false;
                        return;
                    }
                    if (inputSource != null) {
                        this.source = new StreamSource();
                        ((StreamSource)this.source).setSystemId(inputSource.getSystemId());
                        ((StreamSource)this.source).setInputStream(inputSource.getByteStream());
                        ((StreamSource)this.source).setReader(inputSource.getCharacterStream());
                    } else {
                        this.source = new StreamSource(this.location);
                    }
                } else {
                    this.source = new StreamSource(this.location);
                }
            }
        }
        if (this.source instanceof DOMSource) {
            this.node = ((DOMSource)this.source).getNode();
        } else {
            DOMResult dr = new DOMResult();
            try {
                this.loader.getTransformer().transform(this.source, dr);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                this.isSuccessfullyResolved = false;
                return;
            }
            this.node = SchemaInfoImpl.findSchemaElement(dr.getNode());
        }
        if (this.location == null) {
            this.location = this.source.getSystemId();
        }
        if (this.location == null && this.source instanceof DOMSource) {
            url = DOM.getLocation(((DOMSource)this.source).getNode());
            String string = this.location = url == null ? null : url.toExternalForm();
        }
        if (this.location == null) {
            url = DOM.getLocation(this.node);
            String string = this.location = url == null ? null : url.toExternalForm();
        }
        if (this.targetNamespace == null && this.node != null && this.node.getNodeType() == 1 && (tns = ((Element)this.node).getAttribute("targetNamespace")).length() != 0) {
            this.targetNamespace = tns;
        }
        this.isSuccessfullyResolved = true;
    }

    private static Element findSchemaElement(Node node) throws SchemaComponentException {
        Element element;
        NodeList list;
        Element e;
        if (node instanceof Document) {
            e = ((Document)node).getDocumentElement();
        } else if (node instanceof Element) {
            e = (Element)node;
        } else {
            throw new SchemaComponentException();
        }
        if ("definitions".equals(e.getLocalName()) && (list = e.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema")).getLength() != 0) {
            element = (Element)list.item(0);
        }
        return element;
    }

    public String toString() {
        return "sch(location=" + this.location + ",resol=" + this.isResolutionAttempted + ",parent=" + this.parent + ")";
    }

    public Source getSource() {
        return this.source;
    }
}

