/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl0;

import com.sap.engine.lib.schema.components.AttributeDeclaration;
import com.sap.engine.lib.schema.components.AttributeGroupDefinition;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.ElementDeclaration;
import com.sap.engine.lib.schema.components.FundamentalFacets;
import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.components.ModelGroupDefinition;
import com.sap.engine.lib.schema.components.NotationDeclaration;
import com.sap.engine.lib.schema.components.QualifiedBase;
import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.components.SchemaComponentException;
import com.sap.engine.lib.schema.components.SchemaInfo;
import com.sap.engine.lib.schema.components.SimpleTypeDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.components.impl0.BaseImpl;
import com.sap.engine.lib.schema.components.impl0.ComplexTypeDefinitionImpl;
import com.sap.engine.lib.schema.components.impl0.FundamentalFacetsBase64BinaryImpl;
import com.sap.engine.lib.schema.components.impl0.FundamentalFacetsBooleanImpl;
import com.sap.engine.lib.schema.components.impl0.FundamentalFacetsDateTime;
import com.sap.engine.lib.schema.components.impl0.FundamentalFacetsEmptyImpl;
import com.sap.engine.lib.schema.components.impl0.FundamentalFacetsNumericImpl;
import com.sap.engine.lib.schema.components.impl0.FundamentalFacetsStringImpl;
import com.sap.engine.lib.schema.components.impl0.LoaderImpl;
import com.sap.engine.lib.schema.components.impl0.ModelGroupImpl;
import com.sap.engine.lib.schema.components.impl0.ParticleImpl;
import com.sap.engine.lib.schema.components.impl0.SimpleTypeDefinitionImpl;
import com.sap.engine.lib.schema.components.impl0.WildcardImpl;
import com.sap.engine.lib.schema.util.Tools;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Vector;

public final class SchemaImpl
extends BaseImpl
implements Schema {
    private static final int TD = 1;
    private static final int AD = 2;
    private static final int ED = 3;
    private static final int MGD = 4;
    private static final int AGD = 5;
    private static final int ND = 6;
    private static final int ICD = 7;
    private ComplexTypeDefinitionImpl urType;
    private SimpleTypeDefinitionImpl simpleURType;
    private Hashtable h = new Hashtable();
    protected Vector schemaInfos = new Vector();
    private Vector typeDefinitions = new Vector();
    private Vector elementDeclarations = new Vector();
    private Vector attributeDeclarations = new Vector();
    private Vector attributeGroupDefinitions = new Vector();
    private Vector modelGroupDefinitions = new Vector();
    private Vector notationDeclarations = new Vector();
    private Vector identityConstraintDefinitions = new Vector();
    protected Vector components = new Vector();
    private static final String[] BUILT_IN_NAMES = new String[]{"string", "boolean", "decimal", "float", "double", "duration", "dateTime", "time", "date", "gYearMonth", "gYear", "gMonthDay", "gDay", "gMonth", "hexBinary", "base64Binary", "anyURI", "QName", "NOTATION", "normalizedString", "token", "language", "NMTOKEN", "NMTOKENS", "Name", "NCName", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "integer", "nonPositiveInteger", "negativeInteger", "long", "int", "short", "byte", "nonNegativeInteger", "unsignedLong", "unsignedInt", "unsignedShort", "unsignedByte", "positiveInteger"};
    private static final String[] BUILT_IN_BASES = new String[]{"anySimpleType", "anySimpleType", "anySimpleType", "anySimpleType", "anySimpleType", "anySimpleType", "anySimpleType", "anySimpleType", "anySimpleType", "anySimpleType", "anySimpleType", "anySimpleType", "anySimpleType", "anySimpleType", "anySimpleType", "anySimpleType", "anySimpleType", "anySimpleType", "anySimpleType", "string", "normalizedString", "token", "token", "NMTOKEN", "token", "Name", "NCName", "NCName", "IDREF", "NCName", "ENTITY", "decimal", "integer", "nonPositiveInteger", "integer", "long", "int", "short", "integer", "nonNegativeInteger", "unsignedLong", "unsignedInt", "unsignedShort", "nonNegativeInteger"};
    private boolean[] BUILT_IN_DERIVED_BY_LIST = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private boolean[] BUILT_IN_PRIMITIVE = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private final FundamentalFacets[] BUILT_IN_FF = new FundamentalFacets[]{new FundamentalFacetsStringImpl(), new FundamentalFacetsBooleanImpl(), new FundamentalFacetsNumericImpl(false, null, null, null, null, 1), new FundamentalFacetsNumericImpl(true, new Float(Float.MAX_VALUE), new Float(-3.4028235E38f), null, null, 4), new FundamentalFacetsNumericImpl(true, new Double(Double.MAX_VALUE), new Double(-1.7976931348623157E308), null, null, 3), new FundamentalFacetsDateTime(0), new FundamentalFacetsDateTime(1), new FundamentalFacetsDateTime(2), new FundamentalFacetsDateTime(3), new FundamentalFacetsDateTime(4), new FundamentalFacetsDateTime(5), new FundamentalFacetsDateTime(6), new FundamentalFacetsDateTime(7), new FundamentalFacetsDateTime(8), new FundamentalFacetsStringImpl(), new FundamentalFacetsBase64BinaryImpl(), new FundamentalFacetsStringImpl(), new FundamentalFacetsStringImpl(), new FundamentalFacetsStringImpl(), new FundamentalFacetsStringImpl(), new FundamentalFacetsStringImpl(), new FundamentalFacetsStringImpl(), new FundamentalFacetsStringImpl(), new FundamentalFacetsStringImpl(), new FundamentalFacetsStringImpl(), new FundamentalFacetsStringImpl(), new FundamentalFacetsStringImpl(), new FundamentalFacetsStringImpl(), new FundamentalFacetsStringImpl(), new FundamentalFacetsStringImpl(), new FundamentalFacetsStringImpl(), new FundamentalFacetsNumericImpl(false, null, null, null, null, 2), new FundamentalFacetsNumericImpl(false, new Integer(0), null, null, null, 2), new FundamentalFacetsNumericImpl(false, null, null, new Integer(0), null, 2), new FundamentalFacetsNumericImpl(false, new Long(Long.MAX_VALUE), new Long(Long.MIN_VALUE), null, null, 5), new FundamentalFacetsNumericImpl(true, new Integer(Integer.MAX_VALUE), new Integer(Integer.MIN_VALUE), null, null, 5), new FundamentalFacetsNumericImpl(true, new Short(Short.MAX_VALUE), new Short(Short.MIN_VALUE), null, null, 5), new FundamentalFacetsNumericImpl(true, new Short(127), new Short(-128), null, null, 5), new FundamentalFacetsNumericImpl(true, null, new Integer(0), null, null, 5), new FundamentalFacetsNumericImpl(true, new BigInteger("18446744073709551615"), new Integer(0), null, null, 2), new FundamentalFacetsNumericImpl(true, new Long(0xFFFFFFFFL), new Integer(0), null, null, 5), new FundamentalFacetsNumericImpl(true, new Integer(65535), new Integer(0), null, null, 5), new FundamentalFacetsNumericImpl(true, new Integer(255), new Integer(0), null, null, 5), new FundamentalFacetsNumericImpl(false, null, null, null, new Integer(0), 2)};

    public SchemaImpl() {
        this.addBuiltInComponents();
    }

    public ComplexTypeDefinition getURTypeDefinition() {
        return this.urType;
    }

    public SimpleTypeDefinition getSimpleURTypeDefinition() {
        return this.simpleURType;
    }

    public void getTopLevelComponents(Vector v) {
        this.getTopLevelTypeDefinitions(v);
        this.getTopLevelElementDeclarations(v);
        this.getTopLevelAttributeDeclarations(v);
        this.getTopLevelAttributeGroupDefinitions(v);
        this.getTopLevelModelGroupDefinitions(v);
        this.getTopLevelNotationDeclarations(v);
        this.getIdentityConstraintDefinitions(v);
    }

    public int getTypeOfComponent() {
        return 0;
    }

    protected void add(QualifiedBase c) {
        int tc = c.getTypeOfComponent();
        switch (tc) {
            case 4: {
                this.h.put(SchemaImpl.makeKey(c.getTargetNamespace(), c.getName(), 2), c);
                this.attributeDeclarations.add(c);
                break;
            }
            case 3: {
                this.h.put(SchemaImpl.makeKey(c.getTargetNamespace(), c.getName(), 3), c);
                this.elementDeclarations.add(c);
                break;
            }
            case 1: 
            case 2: {
                this.h.put(SchemaImpl.makeKey(c.getTargetNamespace(), c.getName(), 1), c);
                this.typeDefinitions.add(c);
                break;
            }
            case 5: {
                this.h.put(SchemaImpl.makeKey(c.getTargetNamespace(), c.getName(), 5), c);
                this.attributeGroupDefinitions.add(c);
                break;
            }
            case 8: {
                this.h.put(SchemaImpl.makeKey(c.getTargetNamespace(), c.getName(), 4), c);
                this.modelGroupDefinitions.add(c);
                break;
            }
            case 14: {
                this.h.put(SchemaImpl.makeKey(c.getTargetNamespace(), c.getName(), 6), c);
                this.notationDeclarations.add(c);
                break;
            }
            case 13: {
                this.h.put(SchemaImpl.makeKey(c.getTargetNamespace(), c.getName(), 7), c);
                this.identityConstraintDefinitions.add(c);
                break;
            }
            default: {
                System.out.println("DEBUG WARNING unknown type of component in " + this.getClass().getName());
            }
        }
    }

    private static final Object makeKey(Object a, Object b, int c) {
        return new Triplet(a, b, c);
    }

    public IdentityConstraintDefinition getIdentityConstraintDefinition(String uri, String local) {
        IdentityConstraintDefinition r = (IdentityConstraintDefinition)this.h.get(SchemaImpl.makeKey(uri, local, 7));
        return r;
    }

    public TypeDefinitionBase getTopLevelTypeDefinition(String uri, String local) {
        TypeDefinitionBase r = (TypeDefinitionBase)this.h.get(SchemaImpl.makeKey(uri, local, 1));
        return r;
    }

    public AttributeDeclaration getTopLevelAttributeDeclaration(String uri, String local) {
        AttributeDeclaration r = (AttributeDeclaration)this.h.get(SchemaImpl.makeKey(uri, local, 2));
        return r;
    }

    public ElementDeclaration getTopLevelElementDeclaration(String uri, String local) {
        ElementDeclaration r = (ElementDeclaration)this.h.get(SchemaImpl.makeKey(uri, local, 3));
        return r;
    }

    public AttributeGroupDefinition getTopLevelAttributeGroupDefinition(String uri, String local) {
        AttributeGroupDefinition r = (AttributeGroupDefinition)this.h.get(SchemaImpl.makeKey(uri, local, 5));
        return r;
    }

    public ModelGroupDefinition getTopLevelModelGroupDefinition(String uri, String local) {
        ModelGroupDefinition r = (ModelGroupDefinition)this.h.get(SchemaImpl.makeKey(uri, local, 4));
        return r;
    }

    public NotationDeclaration getTopLevelNotationDeclaration(String uri, String local) {
        NotationDeclaration r = (NotationDeclaration)this.h.get(SchemaImpl.makeKey(uri, local, 6));
        return r;
    }

    public Base getTopLevelComponent(String uri, String local, int t) {
        switch (t) {
            case 4: {
                return this.getTopLevelAttributeDeclaration(uri, local);
            }
            case 5: {
                return this.getTopLevelAttributeGroupDefinition(uri, local);
            }
            case 3: {
                return this.getTopLevelElementDeclaration(uri, local);
            }
            case 8: {
                return this.getTopLevelModelGroupDefinition(uri, local);
            }
            case 14: {
                return this.getTopLevelNotationDeclaration(uri, local);
            }
            case 1: 
            case 2: {
                return this.getTopLevelTypeDefinition(uri, local);
            }
            case 13: {
                return this.getIdentityConstraintDefinition(uri, local);
            }
        }
        throw new IllegalArgumentException();
    }

    public void getIdentityConstraintDefinitions(Vector v) {
        v.addAll(this.identityConstraintDefinitions);
    }

    public void getTopLevelTypeDefinitions(Vector v) {
        v.addAll(this.typeDefinitions);
    }

    public void getTopLevelAttributeDeclarations(Vector v) {
        v.addAll(this.attributeDeclarations);
    }

    public void getTopLevelElementDeclarations(Vector v) {
        v.addAll(this.elementDeclarations);
    }

    public void getTopLevelAttributeGroupDefinitions(Vector v) {
        v.addAll(this.attributeGroupDefinitions);
    }

    public void getTopLevelModelGroupDefinitions(Vector v) {
        v.addAll(this.modelGroupDefinitions);
    }

    public void getTopLevelNotationDeclarations(Vector v) {
        v.addAll(this.notationDeclarations);
    }

    public IdentityConstraintDefinition[] getIdentityConstraintDefinitionsArray() {
        IdentityConstraintDefinition[] r = new IdentityConstraintDefinition[this.identityConstraintDefinitions.size()];
        this.identityConstraintDefinitions.toArray(r);
        return r;
    }

    public TypeDefinitionBase[] getTopLevelTypeDefinitionsArray() {
        TypeDefinitionBase[] r = new TypeDefinitionBase[this.typeDefinitions.size()];
        this.typeDefinitions.toArray(r);
        return r;
    }

    public AttributeDeclaration[] getTopLevelAttributeDeclarationsArray() {
        AttributeDeclaration[] r = new AttributeDeclaration[this.attributeDeclarations.size()];
        this.attributeDeclarations.toArray(r);
        return r;
    }

    public ElementDeclaration[] getTopLevelElementDeclarationsArray() {
        ElementDeclaration[] r = new ElementDeclaration[this.elementDeclarations.size()];
        this.elementDeclarations.toArray(r);
        return r;
    }

    public AttributeGroupDefinition[] getTopLevelAttributeGroupDefinitionsArray() {
        AttributeGroupDefinition[] r = new AttributeGroupDefinition[this.attributeGroupDefinitions.size()];
        this.attributeGroupDefinitions.toArray(r);
        return r;
    }

    public ModelGroupDefinition[] getTopLevelModelGroupDefinitionsArray() {
        ModelGroupDefinition[] r = new ModelGroupDefinition[this.modelGroupDefinitions.size()];
        this.modelGroupDefinitions.toArray(r);
        return r;
    }

    public NotationDeclaration[] getTopLevelNotationDeclarationsArray() {
        NotationDeclaration[] r = new NotationDeclaration[this.notationDeclarations.size()];
        this.notationDeclarations.toArray(r);
        return r;
    }

    private void addBuiltInComponents() {
        this.urType = new ComplexTypeDefinitionImpl();
        this.urType.builtIn = true;
        this.urType.name = "anyType";
        this.urType.targetNamespace = "http://www.w3.org/2001/XMLSchema";
        this.urType.baseTypeDefinition = this.urType;
        this.urType.isDerivationMethodExtension = false;
        this.urType.isMixed = true;
        WildcardImpl w = new WildcardImpl();
        w.builtIn = true;
        w.nscAny = true;
        ParticleImpl p0 = new ParticleImpl();
        p0.builtIn = true;
        p0.minOccurs = 0;
        p0.maxOccurs = Integer.MAX_VALUE;
        p0.term = w;
        ModelGroupImpl mg = new ModelGroupImpl();
        mg.builtIn = true;
        mg.compositor = 3;
        mg.particles.add(p0);
        ParticleImpl p1 = new ParticleImpl();
        p1.builtIn = true;
        p1.minOccurs = 1;
        p1.maxOccurs = 1;
        p1.term = mg;
        this.urType.contentTypeContentModel = p1;
        WildcardImpl aw = new WildcardImpl();
        aw.builtIn = true;
        aw.nscAny = true;
        this.urType.attributeWildcard = aw;
        this.add(this.urType);
        this.simpleURType = new SimpleTypeDefinitionImpl();
        this.simpleURType.builtIn = true;
        this.simpleURType.name = "anySimpleType";
        this.simpleURType.targetNamespace = "http://www.w3.org/2001/XMLSchema";
        this.simpleURType.ff = new FundamentalFacetsEmptyImpl();
        this.simpleURType.variety = 1;
        this.add(this.simpleURType);
        this.simpleURType.primitiveTypeDefinition = this.simpleURType;
        this.simpleURType.isPrimitive = true;
        int nBuiltIn = BUILT_IN_NAMES.length;
        for (int i = 0; i < nBuiltIn; ++i) {
            SimpleTypeDefinitionImpl x = new SimpleTypeDefinitionImpl();
            x.builtIn = true;
            x.name = BUILT_IN_NAMES[i];
            x.targetNamespace = "http://www.w3.org/2001/XMLSchema";
            int n = x.variety = this.BUILT_IN_DERIVED_BY_LIST[i] ? 2 : 1;
            if (this.BUILT_IN_PRIMITIVE[i]) {
                x.primitiveTypeDefinition = x;
                x.isPrimitive = true;
            } else {
                x.isPrimitive = false;
            }
            if (this.BUILT_IN_DERIVED_BY_LIST[i]) {
                x.itemTypeDefinition = (SimpleTypeDefinition)this.getTopLevelTypeDefinition(x.targetNamespace, BUILT_IN_BASES[i]);
            } else {
                x.ff = this.BUILT_IN_FF[i];
            }
            this.add(x);
        }
    }

    protected void accept(Base x, int toWhat, String prop, LoaderImpl loader) throws SchemaComponentException {
        throw new SchemaComponentException();
    }

    public void getAllComponents(Vector v) {
        v.addAll(this.components);
    }

    public SchemaInfo[] getSchemaInfos() {
        return this.schemaInfos.toArray(new SchemaInfo[0]);
    }

    public boolean match(Base schemaImpl) {
        Vector targetDefinedTypes;
        if (!super.match(schemaImpl)) {
            return false;
        }
        SchemaImpl targetSchema = (SchemaImpl)schemaImpl;
        Vector definedTypes = this.getDefinedTypes(this.typeDefinitions);
        return Tools.compareUnorderdSetsOfBases(definedTypes, targetDefinedTypes = this.getDefinedTypes(targetSchema.typeDefinitions)) && Tools.compareUnorderdSetsOfBases(this.elementDeclarations, targetSchema.elementDeclarations) && Tools.compareUnorderdSetsOfBases(this.attributeDeclarations, targetSchema.attributeDeclarations) && Tools.compareUnorderdSetsOfBases(this.attributeGroupDefinitions, targetSchema.attributeGroupDefinitions) && Tools.compareUnorderdSetsOfBases(this.modelGroupDefinitions, targetSchema.modelGroupDefinitions) && Tools.compareUnorderdSetsOfBases(this.notationDeclarations, targetSchema.notationDeclarations);
    }

    private Vector getDefinedTypes(Vector toplevelTypeDefinitions) {
        Vector<TypeDefinitionBase> result = new Vector<TypeDefinitionBase>();
        for (int i = 0; i < toplevelTypeDefinitions.size(); ++i) {
            TypeDefinitionBase typeDefBase = (TypeDefinitionBase)toplevelTypeDefinitions.get(i);
            if (typeDefBase.isBuiltIn()) continue;
            result.add(typeDefBase);
        }
        return result;
    }

    private static final class Triplet {
        private Object a;
        private Object b;
        private int c;
        private int hash;

        Triplet(Object a, Object b, int c) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.hash = a.hashCode() ^ b.hashCode() ^ c;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Triplet)) {
                return false;
            }
            Triplet t = (Triplet)obj;
            return this.hash == t.hash && this.a.equals(t.a) && this.b.equals(t.b) && this.c == t.c;
        }
    }
}

