/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl0;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.components.impl0.LoaderImpl;
import com.sap.engine.lib.schema.components.impl0.QualifiedBaseImpl;
import com.sap.engine.lib.schema.util.SchemaPrefixesMapping;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.StringTokenizer;
import java.util.Vector;

public final class IdentityConstraintDefinitionImpl
extends QualifiedBaseImpl
implements IdentityConstraintDefinition {
    public static final int KEY = 1;
    public static final int KEYREF = 2;
    public static final int UNIQUE = 3;
    protected int category;
    protected String selector;
    protected Vector fields = new Vector();
    protected IdentityConstraintDefinition referencedKey;
    protected SchemaPrefixesMapping prefixesMapping;

    protected IdentityConstraintDefinitionImpl() {
    }

    public boolean isIdentityConstraintCategoryKey() {
        return this.category == 1;
    }

    public boolean isIdentityConstraintCategoryKeyref() {
        return this.category == 2;
    }

    public boolean isIdentityConstraintCategoryUnique() {
        return this.category == 3;
    }

    public String getSelector() {
        return this.selector;
    }

    public void getFields(Vector v) {
        v.addAll(this.fields);
    }

    public IdentityConstraintDefinition getReferencedKey() {
        return this.referencedKey;
    }

    public int getTypeOfComponent() {
        return 13;
    }

    public void setPrefixesMapping(SchemaPrefixesMapping prefixesMapping) {
        this.prefixesMapping = prefixesMapping;
    }

    public SchemaPrefixesMapping getPrefixesMapping() {
        return this.prefixesMapping;
    }

    protected void accept(Base x, int toWhat, String prop, LoaderImpl loader) {
        this.referencedKey = (IdentityConstraintDefinition)x;
    }

    protected void setReferencedKey(IdentityConstraintDefinition referencedKey) {
        this.referencedKey = referencedKey;
    }

    public boolean match(Base identityConstrDef) {
        if (!super.match(identityConstrDef)) {
            return false;
        }
        IdentityConstraintDefinitionImpl targetIdentConstrDef = (IdentityConstraintDefinitionImpl)identityConstrDef;
        if (this.category != targetIdentConstrDef.category) {
            return false;
        }
        if (!this.equalXPaths(this.selector, this.prefixesMapping, targetIdentConstrDef.selector, targetIdentConstrDef.prefixesMapping)) {
            return false;
        }
        if (this.fields.size() != targetIdentConstrDef.fields.size()) {
            return false;
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.equalXPaths((String)this.fields.get(i), this.prefixesMapping, (String)targetIdentConstrDef.fields.get(i), targetIdentConstrDef.prefixesMapping)) continue;
            return false;
        }
        return Tools.compareBases(this.referencedKey, targetIdentConstrDef.referencedKey);
    }

    private boolean equalXPaths(String dstXPath, SchemaPrefixesMapping dstPrefixesMapping, String srcXPath, SchemaPrefixesMapping srcPrefixesMapping) {
        StringTokenizer dstTokenizer = new StringTokenizer(dstXPath, "/");
        StringTokenizer srcTokenizer = new StringTokenizer(srcXPath, "/");
        if (dstTokenizer.countTokens() != srcTokenizer.countTokens()) {
            return false;
        }
        while (dstTokenizer.hasMoreTokens()) {
            String dstStep = dstTokenizer.nextToken();
            boolean dstIsAttribute = dstStep.startsWith("@") || dstStep.startsWith("attribute:");
            String dstPrefix = DOM.qnameToPrefix(dstStep);
            String dstUri = dstPrefixesMapping.getURI(dstPrefix, dstIsAttribute);
            String dstLocalName = DOM.qnameToLocalName(dstStep);
            String srcStep = srcTokenizer.nextToken();
            boolean srcIsAttribute = srcStep.startsWith("@") || srcStep.startsWith("attribute:");
            String srcPrefix = DOM.qnameToPrefix(srcStep);
            String srcUri = srcPrefixesMapping.getURI(srcPrefix, srcIsAttribute);
            String srcLocalName = DOM.qnameToLocalName(srcStep);
            if (!(dstIsAttribute ^ srcIsAttribute) && Tools.compareStringProps(dstUri, srcUri) && dstLocalName.equals(srcLocalName)) continue;
            return false;
        }
        return true;
    }
}

