/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl0;

import com.sap.engine.lib.schema.components.impl0.FundamentalFacetsBaseImpl;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class FundamentalFacetsDateTime
extends FundamentalFacetsBaseImpl {
    private Calendar calendar = null;
    private int type = -1;
    public static final int DT_DUR = 0;
    public static final int DT_DT = 1;
    public static final int DT_T = 2;
    public static final int DT_D = 3;
    public static final int DT_GYM = 4;
    public static final int DT_GY = 5;
    public static final int DT_GMD = 6;
    public static final int DT_GD = 7;
    public static final int DT_GM = 8;
    private static final char[] orderDate = new char[]{'P', 'Y', 'M', 'D'};
    private static final char[] orderTime = new char[]{'T', 'H', 'M', 'S'};

    public FundamentalFacetsDateTime(int type) {
        this.type = type;
    }

    public boolean isOrdered() {
        return true;
    }

    public boolean isBounded() {
        return false;
    }

    public boolean isCardinalityFinite() {
        return false;
    }

    public boolean isCardinalityCountablyInfinite() {
        return true;
    }

    public boolean isNumeric() {
        return false;
    }

    public Object parse(String s) {
        String result = s;
        try {
            if (this.type == 0) {
                FundamentalFacetsDateTime.checkDuration(s);
            } else {
                String s1 = FundamentalFacetsDateTime.removeZone(s);
                SimpleDateFormat f = null;
                if (this.type == 3) {
                    f = new SimpleDateFormat("yyyy-MM-dd");
                } else if (this.type == 2) {
                    f = new SimpleDateFormat("HH:mm:ss.SSS");
                } else if (this.type == 1) {
                    f = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                } else if (this.type == 4) {
                    f = new SimpleDateFormat("yyyy-MM");
                } else if (this.type == 5) {
                    f = new SimpleDateFormat("yyyy");
                } else if (this.type == 6) {
                    f = new SimpleDateFormat("--MM-dd");
                } else if (this.type == 7) {
                    f = new SimpleDateFormat("---dd");
                } else if (this.type == 8) {
                    f = new SimpleDateFormat("--MM--");
                }
                f.setLenient(false);
                Date parsed = f.parse(s1, new ParsePosition(0));
                if (parsed == null) {
                    return null;
                }
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public String canonical(Object s) {
        return null;
    }

    public boolean equal(Object a, Object b) {
        return false;
    }

    public boolean less(Object a, Object b) {
        return false;
    }

    public Object getInclusiveUpperBound() {
        return null;
    }

    public Object getExclusiveUpperBound() {
        return null;
    }

    public Object getInclusiveLowerBound() {
        return null;
    }

    public Object getExclusiveLowerBound() {
        return null;
    }

    private static String removeZone(String s) throws IllegalArgumentException {
        char last = s.charAt(s.length() - 1);
        if (last == 'Z') {
            return s.substring(0, s.length() - 1);
        }
        char plusMinus = s.charAt(s.length() - 6);
        char colon = s.charAt(s.length() - 3);
        if (plusMinus != '+' && plusMinus != '-' || colon != ':') {
            return s;
        }
        SimpleDateFormat f = new SimpleDateFormat("HH:mm");
        f.setLenient(false);
        Date d = null;
        try {
            d = f.parse(s.substring(s.length() - 5, s.length()));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.toString());
        }
        if (d == null) {
            throw new IllegalArgumentException();
        }
        return s.substring(0, s.length() - 7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkDuration(String duration) throws IllegalArgumentException {
        char[] dur = duration.toCharArray();
        if (dur[0] == '-') {
            if (dur[1] != 'P') throw new IllegalArgumentException("Illegal Second character of duration: " + dur[1]);
            char[] durUns = new char[dur.length - 1];
            System.arraycopy(dur, 1, durUns, 0, durUns.length);
            FundamentalFacetsDateTime.checkDurationUnsigned(durUns);
            return;
        } else {
            if (dur[0] != 'P') throw new IllegalArgumentException("Illegal First character of duration: " + dur[0]);
            FundamentalFacetsDateTime.checkDurationUnsigned(dur);
        }
    }

    private static final void checkDurationUnsigned(char[] dur) throws IllegalArgumentException {
        int T2 = FundamentalFacetsDateTime.searchCharArray(dur, 'T', 0, dur.length - 1);
        if (T2 == dur.length - 1) {
            throw new IllegalArgumentException();
        }
        if (T2 > -1) {
            char[] date = new char[T2];
            char[] time = new char[dur.length - T2];
            System.arraycopy(dur, 0, date, 0, date.length);
            System.arraycopy(dur, T2, time, 0, time.length);
            FundamentalFacetsDateTime.checkDateOrTime(date, true);
            FundamentalFacetsDateTime.checkDateOrTime(time, false);
        } else {
            char[] date = dur;
            FundamentalFacetsDateTime.checkDateOrTime(date, true);
        }
    }

    private static final void checkDateOrTime(char[] dur, boolean date) throws IllegalArgumentException {
        int nextLetter;
        int start = 0;
        char previousLetter = dur[0];
        while (true) {
            if ((nextLetter = FundamentalFacetsDateTime.searchForLetter(dur, start + 1, dur.length - 1)) < 0) {
                throw new IllegalArgumentException();
            }
            if (nextLetter - start < 2) {
                throw new IllegalArgumentException();
            }
            if (nextLetter == dur.length - 1) break;
            FundamentalFacetsDateTime.checkOrder(previousLetter, dur[nextLetter], date ? orderDate : orderTime);
            FundamentalFacetsDateTime.checkNumbersOnly(dur, start + 1, nextLetter - 1);
            start = nextLetter;
            previousLetter = dur[nextLetter];
        }
        FundamentalFacetsDateTime.checkOrder(previousLetter, dur[nextLetter], date ? orderDate : orderTime);
        FundamentalFacetsDateTime.checkNumbersOnly(dur, start + 1, nextLetter - 1);
    }

    private static final void checkOrder(char a, char b, char[] where) throws IllegalArgumentException {
        int ia = FundamentalFacetsDateTime.searchCharArray(where, a, 0, where.length - 1);
        int ib = FundamentalFacetsDateTime.searchCharArray(where, b, 0, where.length - 1);
        if (ia < 0 || ib < 0 || ib < ia) {
            throw new IllegalArgumentException();
        }
    }

    private static final void checkNumbersOnly(char[] string, int from, int to) throws IllegalArgumentException {
        for (int i = from; i <= to; ++i) {
            if (string[i] >= '0' && string[i] <= '9') continue;
            throw new IllegalArgumentException();
        }
    }

    private static final int searchForLetter(char[] string, int from, int to) {
        for (int i = from; i <= to; ++i) {
            if (string[i] < 'A' || string[i] > 'Z') continue;
            return i;
        }
        return -1;
    }

    private static final int searchCharArray(char[] string, char what, int from, int to) {
        for (int i = from; i <= to; ++i) {
            if (string[i] != what) continue;
            return i;
        }
        return -1;
    }
}

