/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.canonicalizator;

import com.sap.engine.lib.schema.canonicalizator.CanonicalizationException;
import com.sap.engine.lib.schema.canonicalizator.CanonicalizationProcessor;
import com.sap.engine.lib.schema.validator.SchemaValidator;
import com.sap.engine.lib.xml.parser.DOMParser;
import org.w3c.dom.Node;

public class Canonicalizator {
    private SchemaValidator validator = new SchemaValidator();
    private DOMParser parser;

    public Canonicalizator() throws Exception {
        this.validator.setCanonicalizationProcessing(true);
        this.parser = new DOMParser();
    }

    public void canonicalize(String inputXmlFile, String iputXsdFile, String outputXmlFile) throws CanonicalizationException {
        this.canonicalize(inputXmlFile, (Object)iputXsdFile, outputXmlFile);
    }

    public void canonicalize(String inputXmlFile, String[] iputXsdFiles, String outputXmlFile) throws CanonicalizationException {
        this.canonicalize(inputXmlFile, (Object)iputXsdFiles, outputXmlFile);
    }

    public void canonicalize(String inputXmlFile, String outputXmlFile) throws CanonicalizationException {
        this.canonicalize(inputXmlFile, (Object)null, outputXmlFile);
    }

    private void canonicalize(String inputXmlFile, Object xsdTarget, String outputXmlFile) throws CanonicalizationException {
        try {
            Node xmlNode = this.createNode(inputXmlFile);
            if (!this.validator.validate(xmlNode, xsdTarget)) {
                throw new CanonicalizationException("An error occured. The error message is : " + this.validator.getDescriptionOfTheErrors());
            }
            this.normalizeAndSerialize(xmlNode, outputXmlFile);
        }
        catch (Exception exc) {
            if (!(exc instanceof CanonicalizationException)) {
                exc.printStackTrace();
                throw new CanonicalizationException("An error occured. The error message is : " + exc.getMessage());
            }
            throw (CanonicalizationException)exc;
        }
    }

    private Node createNode(String nodeLocation) throws Exception {
        return this.parser.parse(nodeLocation).getDocumentElement();
    }

    private void normalizeAndSerialize(Node inputNode, String outputDst) throws CanonicalizationException {
        CanonicalizationProcessor processor = new CanonicalizationProcessor(inputNode, outputDst);
        processor.process();
    }

    public static void main(String[] args) throws Exception {
        Canonicalizator canonicalizator = new Canonicalizator();
        String[] schemas = new String[]{"D:\\develop\\ats\\630_SP_COR\\j2ee_apps\\dbg\\ats\\tests\\tools\\schema\\canonicalization\\files\\input1.xsd", "D:\\develop\\ats\\630_SP_COR\\j2ee_apps\\dbg\\ats\\tests\\tools\\schema\\canonicalization\\files\\input2.xsd", "D:\\develop\\ats\\630_SP_COR\\j2ee_apps\\dbg\\ats\\tests\\tools\\schema\\canonicalization\\files\\input3.xsd", "D:\\develop\\ats\\630_SP_COR\\j2ee_apps\\dbg\\ats\\tests\\tools\\schema\\canonicalization\\files\\input4.xsd", "D:\\develop\\ats\\630_SP_COR\\j2ee_apps\\dbg\\ats\\tests\\tools\\schema\\canonicalization\\files\\input5.xsd"};
        canonicalizator.canonicalize("D:\\develop\\ats\\630_SP_COR\\j2ee_apps\\dbg\\ats\\tests\\tools\\schema\\canonicalization\\files\\input1.xml", schemas, "D:\\develop\\ats\\630_SP_COR\\j2ee_apps\\dbg\\ats\\tests\\tools\\schema\\canonicalization\\files\\output.xml");
    }
}

