/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.canonicalizator;

import com.sap.engine.lib.schema.canonicalizator.AugmentationProps;
import com.sap.engine.lib.schema.canonicalizator.CanonicalizationException;
import com.sap.engine.lib.schema.canonicalizator.Triple;
import com.sap.engine.lib.schema.components.Annotation;
import com.sap.engine.lib.schema.components.AttributeDeclaration;
import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.ElementDeclaration;
import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.components.SimpleTypeDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.xml.dom.AttrImpl;
import com.sap.engine.lib.xml.dom.Base;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.dom.ElementImpl;
import com.sap.engine.lib.xml.dom.NodeImpl;
import com.sap.engine.lib.xml.parser.handlers.NamespaceHandler;
import com.sap.engine.lib.xsl.xpath.ETBuilder;
import com.sap.engine.lib.xsl.xpath.ETItem;
import com.sap.engine.lib.xsl.xpath.ETLocationStep;
import com.sap.engine.lib.xsl.xpath.ETObject;
import com.sap.engine.lib.xsl.xpath.ETPredicate;
import com.sap.engine.lib.xsl.xpath.ETSlash;
import com.sap.engine.lib.xsl.xslt.NamespaceManager;
import com.sap.engine.lib.xsl.xslt.QName;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class CanonicalizationProcessor
implements AugmentationProps {
    private static final String SCHEMA_INSTANCE_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private static final String SCHEMA_CENTRIC_CANONICALIZATION_NAMESPACE = "urn:uddi-org:schemaCentricC14N:2002-07-10";
    private static final String SCHEMA_LOCATION_ATTR_LOCAL_NAME = "schemaLocation";
    private static final String NO_NAMESPACE_SCHEMA_LOCATION_ATTR_LOCAL_NAME = "noNamespaceSchemaLocation";
    private static final String UR_TYPE_NAME = "anyType";
    private static final String EMBEDDED_LANG_ATTRIB_ATTRIB_NAME = "embeddedLangAttribute";
    private static final String EMBEDDED_LANG_ATTRIB_NAME = "embeddedLang";
    private static final String CASE_MAP_ATTRIB_NAME = "caseMap";
    private static final String CASE_MAP_ATTRIB_ATTRIB_NAME = "caseMapAttribute";
    private static final String CASE_MAP_KIND_ATTRIB_NAME = "caseMapKind";
    private static final String NAMESPACE_ATTRIBS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private ETBuilder builder;
    private NamespaceHandler handler;
    private NamespaceManager manager;
    private Node nodeToProcess;
    private String outputXmlDst;
    private int maxIndex;

    CanonicalizationProcessor(Node nodeToProcess, String outputXmlDst) {
        this.nodeToProcess = nodeToProcess;
        this.outputXmlDst = outputXmlDst;
        this.builder = new ETBuilder();
        this.handler = new NamespaceHandler(null);
        this.manager = new NamespaceManager();
        this.builder.setNamespaceStuff(this.manager, this.handler);
        this.maxIndex = 0;
    }

    private CanonicalizationProcessor() {
    }

    void process() throws CanonicalizationException {
        this.normalize(this.nodeToProcess);
        this.serialize(this.nodeToProcess, this.outputXmlDst);
        this.maxIndex = 0;
    }

    private void normalize(Node node) throws CanonicalizationException {
        Hashtable normalizedNSesCollector = new Hashtable();
        this.normalize(node, normalizedNSesCollector);
    }

    private void normalize(Node node, Hashtable normalizedNSesCollector) throws CanonicalizationException {
        if (node instanceof Element) {
            this.handler.findNamespaceNodes((Element)node, this.manager);
        }
        this.processNormalization(node, normalizedNSesCollector);
        if (node instanceof Element) {
            this.handler.levelUp();
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.normalize(nodeList.item(i), (Hashtable)normalizedNSesCollector.clone());
        }
        if (node instanceof Element) {
            try {
                this.handler.levelDown();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    private void updateAugs(Node node) {
        if (((Base)node).getAugmentation("[omitted]").equals(Boolean.FALSE)) {
            if (node instanceof Element) {
                NodeImpl parent = (NodeImpl)node.getParentNode();
                if (parent != null && !(parent instanceof Document)) {
                    Vector parentInScopeNSes = (Vector)parent.getAugmentation("[in-scope namespaces]");
                    if (parentInScopeNSes != null) {
                        Vector inScopeNSes = new Vector();
                        inScopeNSes.addAll(parentInScopeNSes);
                        ((NodeImpl)node).setAugmentation("[in-scope namespaces]", inScopeNSes);
                    }
                    this.updateElementAug((ElementImpl)parent, node, "[children]");
                }
            } else if (node instanceof Attr) {
                ElementImpl parentOfAttr = (ElementImpl)((Attr)node).getOwnerElement();
                NodeImpl parentOfAttrParent = (NodeImpl)parentOfAttr.getParentNode();
                String namespace = node.getNamespaceURI();
                if (namespace != null && namespace.equals(NAMESPACE_ATTRIBS_NAMESPACE)) {
                    Vector parentInScopeNSAttrs = (Vector)parentOfAttrParent.getAugmentation("[in-scope namespaces]");
                    if (parentInScopeNSAttrs != null) {
                        boolean found = false;
                        for (int i = 0; i < parentInScopeNSAttrs.size(); ++i) {
                            Attr parentInScopeNsAttr = (Attr)parentInScopeNSAttrs.get(i);
                            if (!node.getNodeValue().equals(parentInScopeNsAttr.getValue())) continue;
                            found = true;
                            break;
                        }
                        if (!found || this.wildcarded(parentOfAttr)) {
                            this.updateElementAug(parentOfAttr, node, "[namespace attributes]");
                            this.updateElementAug(parentOfAttr, node, "[in-scope namespaces]");
                        }
                    } else {
                        this.updateElementAug(parentOfAttr, node, "[namespace attributes]");
                        this.updateElementAug(parentOfAttr, node, "[in-scope namespaces]");
                    }
                } else {
                    this.updateElementAug(parentOfAttr, node, "[attributes]");
                }
            }
        }
    }

    private void updateElementAug(ElementImpl element, Node node, String augmentation) {
        Vector<Node> collector = (Vector<Node>)element.getAugmentation(augmentation);
        if (collector == null) {
            collector = new Vector<Node>();
            element.setAugmentation(augmentation, collector);
        }
        if (!collector.contains(node)) {
            collector.add(node);
        }
    }

    private void processNormalization(Node node, Hashtable normalizedNSesCollector) throws CanonicalizationException {
        this.purn(node);
        if (((Base)node).getAugmentation("[omitted]").equals(Boolean.FALSE) && (node instanceof Attr || node instanceof Element)) {
            Node attrNode;
            int i;
            NamedNodeMap attributes;
            Node parent = DOM.getParent(node);
            if (parent instanceof Element) {
                this.updateAugs(node);
            }
            if ((attributes = node.getAttributes()) != null) {
                for (i = 0; i < attributes.getLength(); ++i) {
                    attrNode = attributes.item(i);
                    this.purn(attrNode);
                    this.namespacePrefixDesensitization(attributes.item(i));
                }
            }
            this.namespacePrefixDesensitization(node);
            this.namespaceAttributeNormalization(node, normalizedNSesCollector);
            if (attributes != null) {
                for (i = 0; i < attributes.getLength(); ++i) {
                    attrNode = attributes.item(i);
                    this.namespaceAttributeNormalization(attrNode, normalizedNSesCollector);
                    this.dataTypeCanonicalization(attrNode);
                    this.updateAugs(attrNode);
                }
            }
            this.dataTypeCanonicalization(node);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void serialize(Node node, String outputXmlDst) throws CanonicalizationException {
        FileOutputStream fileOutput = null;
        fileOutput = new FileOutputStream(outputXmlDst);
        this.serialize(node, fileOutput);
        Object var7_4 = null;
        if (fileOutput == null) return;
        try {
            fileOutput.flush();
            fileOutput.close();
            return;
        }
        catch (IOException ioExc) {
            ioExc.printStackTrace();
        }
        return;
        {
            catch (Exception exc) {
                exc.printStackTrace();
                CanonicalizationException canonicalExc = new CanonicalizationException(exc.getMessage());
                canonicalExc.fillInStackTrace();
                throw canonicalExc;
            }
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            if (fileOutput == null) throw throwable;
            try {
                fileOutput.flush();
                fileOutput.close();
                throw throwable;
            }
            catch (IOException ioExc) {
                ioExc.printStackTrace();
            }
            throw throwable;
        }
    }

    private void serialize(Node node, FileOutputStream fileOutput) throws IOException {
        NodeImpl augNode = (NodeImpl)node;
        if (augNode.getAugmentation("[omitted]").equals(Boolean.FALSE)) {
            Node firstChild;
            String prefixAndSchemaNormValue = (String)augNode.getAugmentation("[prefix & schema normalized value]");
            String schemaNormValue = (String)augNode.getAugmentation("[schema normalized value]");
            String normalizedPrefix = (String)augNode.getAugmentation("[normalized prefix]");
            String prefix = node.getPrefix();
            boolean isWildcarded = this.wildcarded(node);
            boolean isWildcardOutputRoot = this.wildcardOutputRoot(node);
            String localName = node.getLocalName();
            String value = null;
            if (node instanceof Attr) {
                value = node.getNodeValue();
            } else if (node instanceof Element && (firstChild = node.getFirstChild()) != null) {
                value = firstChild.getNodeValue();
            }
            if (augNode instanceof Element) {
                this.write(fileOutput, "<");
                if (!isWildcarded) {
                    if (normalizedPrefix != null && !normalizedPrefix.equals("")) {
                        this.write(fileOutput, normalizedPrefix + ":");
                    }
                } else if (prefix != null && !prefix.equals("")) {
                    this.write(fileOutput, prefix + ":");
                }
                this.write(fileOutput, localName);
                Vector normNsAttribsCollector = (Vector)augNode.getAugmentation("[normalized namespace attributes]");
                if (normNsAttribsCollector != null) {
                    this.recurse(normNsAttribsCollector, fileOutput);
                }
                if (isWildcardOutputRoot) {
                    this.processRecurse(node, fileOutput, "[in-scope namespaces]");
                } else if (isWildcarded) {
                    this.processRecurse(node, fileOutput, "[namespace attributes]");
                }
                this.processRecurse(node, fileOutput, "[attributes]");
                this.write(fileOutput, ">");
                boolean containsOmittedTextChild = this.containsOmittedTextChild(node);
                if (prefixAndSchemaNormValue != null) {
                    if (!containsOmittedTextChild) {
                        this.write(fileOutput, this.escape(prefixAndSchemaNormValue));
                    }
                } else if (schemaNormValue != null) {
                    if (!containsOmittedTextChild) {
                        this.write(fileOutput, this.escape(schemaNormValue));
                    }
                } else if (augNode.hasAugmentation("[children]")) {
                    Vector children = this.reorderChildrenIfModelGroupAllIsValidating((Vector)augNode.getAugmentation("[children]"));
                    this.recurse(children, fileOutput);
                }
                this.write(fileOutput, "</");
                if (!isWildcarded) {
                    if (normalizedPrefix != null && !normalizedPrefix.equals("")) {
                        this.write(fileOutput, normalizedPrefix + ":");
                    }
                } else if (prefix != null && !prefix.equals("")) {
                    this.write(fileOutput, prefix + ":");
                }
                this.write(fileOutput, localName);
                this.write(fileOutput, ">");
            } else if (node instanceof Attr) {
                this.write(fileOutput, " ");
                if (!isWildcarded) {
                    if (normalizedPrefix != null && !normalizedPrefix.equals("")) {
                        this.write(fileOutput, normalizedPrefix + ":");
                    }
                } else if (prefix != null && !prefix.equals("")) {
                    this.write(fileOutput, prefix + ":");
                }
                this.write(fileOutput, localName);
                this.write(fileOutput, "=");
                this.write(fileOutput, "\"");
                if (prefixAndSchemaNormValue != null) {
                    this.write(fileOutput, this.escape(prefixAndSchemaNormValue));
                } else if (schemaNormValue != null) {
                    this.write(fileOutput, this.escape(schemaNormValue));
                } else {
                    this.write(fileOutput, this.escape(value));
                }
                this.write(fileOutput, "\"");
            }
        }
    }

    private Vector reorderChildrenIfModelGroupAllIsValidating(Vector children) {
        Vector<NodeImpl> result = new Vector<NodeImpl>();
        ModelGroup lastModelGroup = null;
        int start = 0;
        int end = 0;
        int index = 0;
        for (int i = 0; i < children.size(); ++i) {
            NodeImpl childNode = (NodeImpl)children.get(i);
            ModelGroup modelGroup = (ModelGroup)childNode.getAugmentation("[validating model group all]");
            if (modelGroup == null) {
                index = i;
                if (lastModelGroup != null) {
                    lastModelGroup = null;
                }
            } else {
                if (lastModelGroup == null || !modelGroup.equals(lastModelGroup)) {
                    index = i;
                    start = i;
                    end = i + 1;
                } else {
                    for (int j = start; j < end; ++j) {
                        NodeImpl nodeToCompareWith = (NodeImpl)result.get(j);
                        if (this.isLessOrEqual(nodeToCompareWith, childNode)) {
                            index = j;
                            break;
                        }
                        index = j + 1;
                    }
                    ++end;
                }
                lastModelGroup = modelGroup;
            }
            result.add(index, childNode);
        }
        return result;
    }

    private boolean containsOmittedTextChild(Node node) {
        Vector children = (Vector)((NodeImpl)node).getAugmentation("[children]");
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                Node childNode = (Node)children.get(i);
                if (!(childNode instanceof Text) || !((Boolean)((Base)childNode).getAugmentation("[omitted]")).equals(Boolean.TRUE)) continue;
                return true;
            }
        }
        return false;
    }

    private void processRecurse(Node node, FileOutputStream fileOutput, String augmentation) throws IOException {
        Vector attrsCollector = (Vector)((NodeImpl)node).getAugmentation(augmentation);
        if (attrsCollector != null) {
            this.recurse(this.sort(attrsCollector), fileOutput);
        }
    }

    private boolean wildcardOutputRoot(Node node) {
        block5: {
            Node parent;
            block4: {
                if (this.wildcarded(node)) break block4;
                Vector attribs = (Vector)((NodeImpl)node).getAugmentation("[attributes]");
                if (attribs == null) break block5;
                for (int i = 0; i < attribs.size(); ++i) {
                    if (!this.wildcarded((Node)attribs.get(i))) continue;
                    return true;
                }
                break block5;
            }
            Node node2 = parent = node instanceof Attr ? ((Attr)node).getOwnerElement() : node.getParentNode();
            while (!(parent instanceof Document)) {
                Vector attribs;
                if (!this.wildcarded(parent) && (attribs = (Vector)((NodeImpl)parent).getAugmentation("[attributes]")) != null) {
                    for (int i = 0; i < attribs.size(); ++i) {
                        if (!this.wildcarded((Node)attribs.get(i))) continue;
                        return true;
                    }
                }
                parent = parent.getParentNode();
            }
        }
        return false;
    }

    private void recurse(Vector collector, FileOutputStream fileOutput) throws IOException {
        String concatOfTxtNodes = "";
        for (int i = 0; i < collector.size(); ++i) {
            Node node = (Node)collector.get(i);
            if (node instanceof Text) {
                concatOfTxtNodes = concatOfTxtNodes + node.getFirstChild().getNodeValue();
                continue;
            }
            if (!concatOfTxtNodes.equals("")) {
                this.write(fileOutput, this.escape(concatOfTxtNodes));
                concatOfTxtNodes = "";
            }
            this.serialize(node, fileOutput);
        }
    }

    private String escape(String strToEscape) {
        StringBuffer buffer = new StringBuffer(strToEscape);
        this.escape(buffer, "&", "&amp;");
        this.escape(buffer, "<", "&lt;");
        this.escape(buffer, ">", "&gt;");
        this.escape(buffer, "'", "&quot;");
        this.escape(buffer, "\"", "&apos;");
        return buffer.toString();
    }

    private void escape(StringBuffer buffer, String strToEsc, String strToEscWith) {
        int index = buffer.toString().indexOf(strToEsc);
        if (index != -1) {
            buffer.replace(index, index + 1, strToEscWith);
        }
    }

    private boolean wildcarded(Node node) {
        NodeImpl augNode = (NodeImpl)node;
        return augNode.hasAugmentation("[validation attempted]") && augNode.getAugmentation("[validation attempted]").equals(Boolean.FALSE);
    }

    private Vector sort(Vector nodes) {
        Vector<Node> result = new Vector<Node>();
        for (int i = 0; i < nodes.size(); ++i) {
            Node node;
            int index;
            Node nodeToAdd = (Node)nodes.get(i);
            String uriToAdd = nodeToAdd.getNamespaceURI();
            if (uriToAdd == null) {
                uriToAdd = "";
            }
            String nameToAdd = nodeToAdd.getLocalName();
            for (index = 0; index < result.size() && !this.isLessOrEqual(node = (Node)result.get(index), nodeToAdd); ++index) {
            }
            result.add(index, nodeToAdd);
        }
        return result;
    }

    private boolean isLessOrEqual(Node nodeToCompareWith, Node target) {
        String uriToCompareWith = nodeToCompareWith.getNamespaceURI();
        if (uriToCompareWith == null) {
            uriToCompareWith = "";
        }
        String nameToCompareWith = nodeToCompareWith.getLocalName();
        String uriFromTaregt = target.getNamespaceURI();
        if (uriFromTaregt == null) {
            uriFromTaregt = "";
        }
        String nameFromTraget = target.getLocalName();
        return !uriToCompareWith.equals(uriFromTaregt) ? CanonicalizationProcessor.isLexicographicalLessOrEqual(uriToCompareWith, uriFromTaregt) : CanonicalizationProcessor.isLexicographicalLessOrEqual(nameToCompareWith, nameFromTraget);
    }

    private void write(FileOutputStream fileOutput, String str) throws IOException {
        fileOutput.write(str.getBytes());
    }

    private void purn(Node node) {
        if (!((Base)node).hasAugmentation("[omitted]")) {
            if (node.getNodeType() == 3) {
                ComplexTypeDefinition complTypeDef;
                Node parent = node.getParentNode();
                Object typeDef = ((NodeImpl)parent).getAugmentation("[type definition]");
                if (typeDef instanceof ComplexTypeDefinition && (complTypeDef = (ComplexTypeDefinition)typeDef).getContentTypeSimpleTypeDefinition() == null && !complTypeDef.isMixed()) {
                    ((Base)node).setAugmentation("[omitted]", Boolean.TRUE);
                }
            } else if (node.getNodeType() == 2) {
                String localName = node.getLocalName();
                String uri = this.getURI(node);
                if (uri.equals(SCHEMA_INSTANCE_NAMESPACE) && (localName.equals(NO_NAMESPACE_SCHEMA_LOCATION_ATTR_LOCAL_NAME) || localName.equals(SCHEMA_LOCATION_ATTR_LOCAL_NAME))) {
                    ((Base)node).setAugmentation("[omitted]", Boolean.TRUE);
                }
            } else if (node.getNodeType() == 12 || node.getNodeType() == 8) {
                ((Base)node).setAugmentation("[omitted]", Boolean.TRUE);
            }
            if (!((Base)node).hasAugmentation("[omitted]")) {
                ((Base)node).setAugmentation("[omitted]", Boolean.FALSE);
            }
        }
    }

    private void namespacePrefixDesensitization(Node node) throws CanonicalizationException {
        if (((NodeImpl)node).getAugmentation("[omitted]").equals(Boolean.FALSE) && this.locate(node)) {
            this.annotate(node);
        }
    }

    private boolean locate(Node node) throws CanonicalizationException {
        String embeddedLang = null;
        if (node instanceof ElementImpl) {
            String embeddedLangAttribName;
            ElementImpl element = (ElementImpl)node;
            NamedNodeMap attributes = element.getAttributes();
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    AttrImpl attr = (AttrImpl)attributes.item(i);
                    if (!this.getURI(attr).equals(SCHEMA_CENTRIC_CANONICALIZATION_NAMESPACE) || !attr.getLocalName().equals(EMBEDDED_LANG_ATTRIB_NAME)) continue;
                    embeddedLang = attr.getValue();
                    break;
                }
            }
            if (embeddedLang == null && (embeddedLangAttribName = this.getAnnot(element, SCHEMA_CENTRIC_CANONICALIZATION_NAMESPACE, EMBEDDED_LANG_ATTRIB_ATTRIB_NAME)) != null) {
                if (!element.hasAttribute(embeddedLangAttribName)) {
                    throw new CanonicalizationException("Element " + element.toXPath() + " has no attribute " + embeddedLangAttribName);
                }
                embeddedLang = element.getAttribute(embeddedLangAttribName);
            }
        }
        if (embeddedLang == null) {
            embeddedLang = this.getAnnot(node, SCHEMA_CENTRIC_CANONICALIZATION_NAMESPACE, EMBEDDED_LANG_ATTRIB_NAME);
        }
        if (embeddedLang != null) {
            ((NodeImpl)node).setAugmentation("[embedded language]", embeddedLang);
        }
        return embeddedLang != null;
    }

    private void annotate(Node node) throws CanonicalizationException {
        try {
            String xPathExpression = (String)((NodeImpl)node).getAugmentation("[schema normalized value]");
            ETObject etObj = this.builder.process(xPathExpression);
            Vector triplesCollector = this.generateTriples(etObj);
            if (triplesCollector.size() != 0) {
                ((NodeImpl)node).setAugmentation("[prefix usage locations]", triplesCollector);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new CanonicalizationException("An error occured. The error message is : " + exc.getMessage());
        }
    }

    private Vector generateTriples(ETObject etObj) {
        Vector<Triple> triplesCollector = new Vector<Triple>();
        Vector locationStepsCollector = new Vector();
        this.collectETLocationSteps(etObj.et, locationStepsCollector);
        StringTokenizer stepsTokenizer = new StringTokenizer(etObj.squery, "/");
        int offset = 0;
        for (int i = 0; i < locationStepsCollector.size(); ++i) {
            int localOffset = 0;
            ETLocationStep locationStep = (ETLocationStep)locationStepsCollector.get(i);
            QName qName = locationStep.nodeTest;
            String axisSpec = locationStep.axis;
            String prefix = qName.prefix.getString();
            String uri = qName.uri.getString();
            String locationStepStr = "";
            if (!qName.localname.getString().equals("node()")) {
                locationStepStr = stepsTokenizer.nextToken();
            }
            if (axisSpec.equals("attribute") && locationStepStr.startsWith("@")) {
                localOffset = 1;
            } else if (locationStepStr.indexOf("::") != -1) {
                localOffset = (axisSpec + "::").length();
            }
            triplesCollector.add(new Triple(offset + localOffset, prefix, uri));
            offset += locationStepStr.length() + 1;
        }
        return triplesCollector;
    }

    private void collectETLocationSteps(ETItem etItem, Vector collector) {
        if (etItem instanceof ETLocationStep) {
            collector.add(0, etItem);
        } else if (etItem instanceof ETPredicate) {
            ETPredicate predicate = (ETPredicate)etItem;
            this.collectETLocationSteps(predicate.expression, collector);
        } else if (etItem instanceof ETSlash) {
            ETSlash slash = (ETSlash)etItem;
            this.collectETLocationSteps(slash.right, collector);
            if (slash.left != null) {
                this.collectETLocationSteps(slash.left, collector);
            }
        }
    }

    private String getAnnot(Object target, String attribNamespace, String attribName) {
        String result = null;
        if (target instanceof ElementImpl) {
            ElementImpl element = (ElementImpl)target;
            Object elementDeclrObj = element.getAugmentation("[element declaration]");
            if (elementDeclrObj != null) {
                ElementDeclaration elementDeclr = (ElementDeclaration)elementDeclrObj;
                Annotation annotation = elementDeclr.getAnnotation();
                if (annotation != null) {
                    result = this.getAnnotAttrValue(annotation, attribNamespace, attribName);
                }
                if (result == null) {
                    result = this.getAnnotAttrValue(element, attribNamespace, attribName);
                }
            }
        } else if (target instanceof AttrImpl) {
            AttrImpl attr = (AttrImpl)target;
            Object attrDeclrObj = attr.getAugmentation("[attribute declaration]");
            if (attrDeclrObj != null) {
                AttributeDeclaration attrDeclr = (AttributeDeclaration)attrDeclrObj;
                Annotation annotation = attrDeclr.getAnnotation();
                if (annotation != null) {
                    result = this.getAnnotAttrValue(annotation, attribNamespace, attribName);
                }
                if (result == null) {
                    result = this.getAnnotAttrValue(attr, attribNamespace, attribName);
                }
            }
        } else if (target instanceof ComplexTypeDefinition) {
            TypeDefinitionBase typeDefBase;
            ComplexTypeDefinition complTypeDef = (ComplexTypeDefinition)target;
            Annotation annotation = complTypeDef.getAnnotation();
            if (annotation != null) {
                result = this.getAnnotAttrValue(annotation, attribNamespace, attribName);
            }
            if (result == null && (typeDefBase = complTypeDef.getBaseTypeDefinition()) != null && !typeDefBase.getName().equals(UR_TYPE_NAME)) {
                result = this.getAnnot(typeDefBase, attribNamespace, attribName);
            }
        } else if (target instanceof SimpleTypeDefinition) {
            SimpleTypeDefinition simpleTypeDef = (SimpleTypeDefinition)target;
            Annotation annotation = simpleTypeDef.getAnnotation();
            if (annotation != null) {
                result = this.getAnnotAttrValue(annotation, attribNamespace, attribName);
            }
            if (result == null) {
                TypeDefinitionBase typeDefBase = simpleTypeDef.getBaseTypeDefinition();
                if (simpleTypeDef.isVarietyAtomic()) {
                    if (typeDefBase != null && !typeDefBase.getName().equals(UR_TYPE_NAME)) {
                        result = this.getAnnot(typeDefBase, attribNamespace, attribName);
                    }
                } else if (simpleTypeDef.isVarietyList()) {
                    result = this.getAnnot(simpleTypeDef.getItemTypeDefinition(), attribNamespace, attribName);
                }
            }
        }
        return result;
    }

    private String getAnnotAttrValue(Object target, String attribNamespace, String attribName) {
        String result = null;
        if (target instanceof Annotation) {
            Annotation annotation = (Annotation)target;
            NamedNodeMap attribs = annotation.getAttributes();
            AttrImpl attr = (AttrImpl)attribs.getNamedItemNS(attribNamespace, attribName);
            if (attr != null) {
                result = attr.getNodeValue();
            }
        } else if (target instanceof NodeImpl) {
            NodeImpl node = (NodeImpl)target;
            Object memberTypeDefObj = node.getAugmentation("[member type definition]");
            if (memberTypeDefObj != null) {
                result = this.getAnnot(memberTypeDefObj, attribNamespace, attribName);
            } else {
                Object typeDefObj = node.getAugmentation("[type definition]");
                if (typeDefObj != null) {
                    result = this.getAnnot(typeDefObj, attribNamespace, attribName);
                }
            }
        }
        return result;
    }

    private void namespaceAttributeNormalization(Node node, Hashtable normalizedNSesCollector) throws CanonicalizationException {
        if (((NodeImpl)node).getAugmentation("[omitted]").equals(Boolean.FALSE) && !((NodeImpl)node).hasAugmentation("[validation attempted]")) {
            if (node instanceof Element) {
                int i;
                Vector<AttrImpl> normalizedNSAttribsCollector = new Vector<AttrImpl>();
                Vector visiblyUtilizedNSes = this.getVisibliUtilizedByNodeNSes(node);
                for (i = 0; i < visiblyUtilizedNSes.size(); ++i) {
                    AttrImpl appendedNormNSAttr;
                    int index;
                    String uri = (String)visiblyUtilizedNSes.get(i);
                    if (normalizedNSesCollector.containsKey(uri)) continue;
                    AttrImpl newNormNSAttr = new AttrImpl();
                    newNormNSAttr.init("prefix:value", null, uri);
                    for (index = 0; index != normalizedNSAttribsCollector.size() && !CanonicalizationProcessor.isLexicographicalLessOrEqual((appendedNormNSAttr = (AttrImpl)normalizedNSAttribsCollector.get(index)).getValue(), newNormNSAttr.getValue()); ++index) {
                    }
                    normalizedNSAttribsCollector.add(index, newNormNSAttr);
                }
                for (i = 0; i < normalizedNSAttribsCollector.size(); ++i) {
                    AttrImpl appendedNnormNSAttr = (AttrImpl)normalizedNSAttribsCollector.get(i);
                    String value = appendedNnormNSAttr.getValue();
                    appendedNnormNSAttr.init(NAMESPACE_ATTRIBS_NAMESPACE, "xmlns:n" + this.maxIndex++, null, value);
                    appendedNnormNSAttr.setAugmentation("[normalized prefix]", "xmlns");
                    appendedNnormNSAttr.setAugmentation("[omitted]", Boolean.FALSE);
                    if (normalizedNSesCollector.contains(appendedNnormNSAttr.getValue())) continue;
                    normalizedNSesCollector.put(appendedNnormNSAttr.getValue(), appendedNnormNSAttr);
                }
                ((NodeImpl)node).setAugmentation("[normalized namespace attributes]", normalizedNSAttribsCollector);
            }
            String uri = node.getNamespaceURI();
            String normalizedPrefixValue = "";
            if (uri != null) {
                if (uri.equals(XML_NAMESPACE)) {
                    normalizedPrefixValue = node.getPrefix();
                } else if (!uri.equals("") && !uri.equals(NAMESPACE_ATTRIBS_NAMESPACE)) {
                    AttrImpl normalizedNSAttr = (AttrImpl)normalizedNSesCollector.get(uri);
                    if (normalizedNSAttr == null) {
                        throw new CanonicalizationException("Namespace URI '" + uri + "' of node '" + DOM.toXPath(node) + "' is not declared in any [normalized namespace attributes] property of any self-ancestor of the current node.");
                    }
                    normalizedPrefixValue = normalizedNSAttr.getLocalName();
                }
            }
            ((NodeImpl)node).setAugmentation("[normalized prefix]", normalizedPrefixValue);
            if (((NodeImpl)node).hasAugmentation("[prefix usage locations]")) {
                StringBuffer prefixAndSchemaNormalizedBuffer = new StringBuffer((String)((NodeImpl)node).getAugmentation("[schema normalized value]"));
                Vector triples = (Vector)((NodeImpl)node).getAugmentation("[prefix usage locations]");
                String nodeName = node.getNodeName();
                int helperOffset = 0;
                for (int i = 0; i < triples.size(); ++i) {
                    Triple triple = (Triple)triples.get(i);
                    String normalizedPrefix = this.normalizedPrefixUse(triple, nodeName, normalizedNSesCollector);
                    int offset = triple.offset + helperOffset;
                    int cch = triple.prefix != null ? triple.prefix.length() : 0;
                    int z = triple.prefix != null && !triple.prefix.equals("") && prefixAndSchemaNormalizedBuffer.charAt(offset + cch) == ':' ? 1 : 0;
                    prefixAndSchemaNormalizedBuffer.replace(offset, offset + cch + z, normalizedPrefix);
                    helperOffset -= cch + z - normalizedPrefix.length();
                }
                ((NodeImpl)node).setAugmentation("[prefix & schema normalized value]", prefixAndSchemaNormalizedBuffer.toString());
            }
        }
    }

    private String normalizedPrefixUse(Triple triple, String nodeName, Hashtable normalizedNSesCollector) throws CanonicalizationException {
        String result = "";
        if (!triple.uri.equals("")) {
            AttrImpl normalizedNSAttr = (AttrImpl)normalizedNSesCollector.get(triple.uri);
            if (normalizedNSAttr == null) {
                throw new CanonicalizationException("Namespace URI '" + triple.uri + "' of node '" + nodeName + "' is not declared in any [normalized namespace attributes] property of any self-ancestor of the current node.");
            }
            result = normalizedNSAttr.getLocalName() + ":";
        }
        return result;
    }

    private static boolean isLexicographicalLessOrEqual(String strToCompareWith, String target) {
        strToCompareWith = strToCompareWith.toLowerCase();
        target = target.toLowerCase();
        for (int index = 0; index != strToCompareWith.length() && index != target.length(); ++index) {
            if (strToCompareWith.charAt(index) > target.charAt(index)) {
                return true;
            }
            if (strToCompareWith.charAt(index) >= target.charAt(index)) continue;
            return false;
        }
        return strToCompareWith.length() > target.length();
    }

    private Vector getVisibliUtilizedByNodeNSes(Node node) {
        Vector<String> collector = new Vector<String>();
        Hashtable nsMappingsInScope = this.handler.getNamespaceMappings();
        Enumeration uriEnum = nsMappingsInScope.elements();
        while (uriEnum.hasMoreElements()) {
            String uri = (String)uriEnum.nextElement();
            if (collector.contains(uri) || uri.equals(NAMESPACE_ATTRIBS_NAMESPACE) || uri.equals(XML_NAMESPACE) || !this.isVisiblyUtilizedByNode(node, uri)) continue;
            collector.add(uri);
        }
        return collector;
    }

    private boolean isVisiblyUtilizedByNode(Node node, String uri) {
        NamedNodeMap attributes;
        int i;
        String nodeUri = node.getNamespaceURI();
        if (nodeUri != null && nodeUri.equals(uri)) {
            return true;
        }
        Object prefixUsageLocations = ((Base)node).getAugmentation("[prefix usage locations]");
        if (prefixUsageLocations != null) {
            Vector triplesCollector = (Vector)prefixUsageLocations;
            for (i = 0; i < triplesCollector.size(); ++i) {
                Triple triple = (Triple)triplesCollector.get(i);
                if (!uri.equals(triple.uri)) continue;
                return true;
            }
        }
        if ((attributes = node.getAttributes()) != null) {
            for (i = 0; i < attributes.getLength(); ++i) {
                boolean result;
                NodeImpl attribNode = (NodeImpl)attributes.item(i);
                if (this.getURI(attribNode).equals(NAMESPACE_ATTRIBS_NAMESPACE) || !(result = this.isVisiblyUtilizedByNode(attribNode, uri))) continue;
                return true;
            }
        }
        return false;
    }

    private void dataTypeCanonicalization(Node node) throws CanonicalizationException {
        if (((NodeImpl)node).getAugmentation("[omitted]").equals(Boolean.FALSE)) {
            TypeDefinitionBase typeDefBase = ((NodeImpl)node).hasAugmentation("[member type definition]") ? (TypeDefinitionBase)((NodeImpl)node).getAugmentation("[member type definition]") : (TypeDefinitionBase)((NodeImpl)node).getAugmentation("[type definition]");
            SimpleTypeDefinition simpleTypeDefOfDataToCanonicalize = null;
            if (typeDefBase instanceof SimpleTypeDefinition) {
                simpleTypeDefOfDataToCanonicalize = (SimpleTypeDefinition)typeDefBase;
            } else if (typeDefBase instanceof ComplexTypeDefinition) {
                simpleTypeDefOfDataToCanonicalize = ((ComplexTypeDefinition)typeDefBase).getContentTypeSimpleTypeDefinition();
            }
            if (simpleTypeDefOfDataToCanonicalize != null) {
                this.dataTypeCanonicalization(node, simpleTypeDefOfDataToCanonicalize);
            }
        }
    }

    private void dataTypeCanonicalization(Node node, SimpleTypeDefinition simpleTypeDef) throws CanonicalizationException {
        String typeName = simpleTypeDef.getName();
        if (typeName.equals("dateTime")) {
            this.dateTimeTypeCanonicalization(node);
        } else if (typeName.equals("float") || typeName.equals("double")) {
            this.floatOrDoubleTypeCanonicalization(node);
        } else if (typeName.equals("language")) {
            this.languageTypeCanonicalization(node);
        } else if (typeName.equals("gYearMonth")) {
            this.gYearMonthTypeCanonicalization(node);
        } else if (typeName.equals("gYear")) {
            this.gYearTypeCanonicalization(node);
        } else if (this.isDeriviedFromStringOrAnyUriType(simpleTypeDef)) {
            this.stringOrAnyUriTypeCanonicalization(node);
        } else {
            TypeDefinitionBase baseTypeDef = simpleTypeDef.getBaseTypeDefinition();
            if (baseTypeDef != null && !baseTypeDef.getName().equals(UR_TYPE_NAME)) {
                this.dataTypeCanonicalization(node, (SimpleTypeDefinition)baseTypeDef);
            }
        }
    }

    private boolean isDeriviedFromStringOrAnyUriType(SimpleTypeDefinition simpleTypeDef) {
        String typeDefName = simpleTypeDef.getName();
        if (typeDefName != null) {
            if (simpleTypeDef.isPrimitive()) {
                return simpleTypeDef.isPrimitive() && (typeDefName.equals("string") || typeDefName.equals("anyUri"));
            }
            return this.isDeriviedFromStringOrAnyUriType(simpleTypeDef.getBaseTypeDefinitionSimple());
        }
        return false;
    }

    private void dateTimeTypeCanonicalization(Node node) {
        String dateTimeValue = (String)((NodeImpl)node).getAugmentation("[normalized value]");
        StringBuffer dateTimeValueBuffer = new StringBuffer(dateTimeValue);
        if (dateTimeValue.substring(11, 13).equals("24")) {
            dateTimeValueBuffer.replace(11, 13, "00");
        }
        if (dateTimeValue.length() > 19 && dateTimeValue.charAt(19) != 'Z') {
            dateTimeValueBuffer.delete(19, dateTimeValueBuffer.length());
        }
        if (!dateTimeValueBuffer.toString().equals(dateTimeValue)) {
            ((NodeImpl)node).setAugmentation("[schema normalized value]", dateTimeValueBuffer.toString());
        }
    }

    private void floatOrDoubleTypeCanonicalization(Node node) {
        int index;
        StringBuffer mantissaBuffer;
        String exponent;
        String value = (String)((NodeImpl)node).getAugmentation("[normalized value]");
        String normalizedValue = null;
        int expIndex = value.indexOf("E") + 1 + value.indexOf("e");
        String mantissa = expIndex != -1 ? value.substring(0, expIndex) : value;
        String string = exponent = expIndex != -1 ? value.substring(expIndex + 1) : null;
        if (mantissa.indexOf(".") == -1) {
            mantissa = mantissa + ".0";
        }
        if ((mantissaBuffer = new StringBuffer(mantissa)).charAt(0) == '+') {
            mantissaBuffer.delete(0, 1);
        }
        int n = index = mantissaBuffer.charAt(0) == '-' ? 1 : 0;
        while (mantissaBuffer.charAt(index) == '0' && mantissaBuffer.charAt(index + 1) != '.') {
            mantissaBuffer.delete(index, index + 1);
        }
        index = mantissaBuffer.length() - 1;
        while (mantissaBuffer.charAt(index) == '0' && mantissaBuffer.charAt(index - 1) != '.') {
            mantissaBuffer.delete(index, index + 1);
            --index;
        }
        normalizedValue = mantissaBuffer.toString();
        if (exponent != null) {
            StringBuffer exponentBuffer = new StringBuffer(exponent);
            if (exponentBuffer.charAt(0) == '+') {
                exponentBuffer.delete(0, 1);
            }
            int n2 = index = exponentBuffer.charAt(0) == '-' ? 1 : 0;
            while (exponentBuffer.charAt(index) == '0') {
                exponentBuffer.delete(index, index + 1);
            }
            normalizedValue = normalizedValue + "E" + exponentBuffer.toString();
        }
        if (!normalizedValue.equals(value)) {
            ((NodeImpl)node).setAugmentation("[schema normalized value]", normalizedValue);
        }
    }

    private void languageTypeCanonicalization(Node node) throws CanonicalizationException {
        String value = (String)((NodeImpl)node).getAugmentation("[normalized value]");
        ((NodeImpl)node).setAugmentation("[schema normalized value]", value.toUpperCase());
    }

    private void gYearMonthTypeCanonicalization(Node node) throws CanonicalizationException {
        String value = (String)((NodeImpl)node).getAugmentation("[normalized value]");
        if (value.indexOf("-") != value.lastIndexOf("-")) {
            StringBuffer buffer = new StringBuffer(value);
            while (buffer.charAt(0) == '0') {
                buffer.delete(0, 1);
            }
            ((NodeImpl)node).setAugmentation("[schema normalized value]", buffer.toString());
        }
    }

    private void gYearTypeCanonicalization(Node node) throws CanonicalizationException {
        String value = (String)((NodeImpl)node).getAugmentation("[normalized value]");
        if (value.indexOf("-") != -1) {
            StringBuffer buffer = new StringBuffer(value);
            while (buffer.charAt(0) == '0') {
                buffer.delete(0, 1);
            }
            ((NodeImpl)node).setAugmentation("[schema normalized value]", buffer.toString());
        }
    }

    private void stringOrAnyUriTypeCanonicalization(Node node) throws CanonicalizationException {
        String language = null;
        if (node instanceof ElementImpl) {
            ElementImpl element = (ElementImpl)node;
            String languageAttribName = this.getAnnot(node, SCHEMA_CENTRIC_CANONICALIZATION_NAMESPACE, CASE_MAP_ATTRIB_ATTRIB_NAME);
            if (languageAttribName != null) {
                if (!element.hasAttribute(languageAttribName)) {
                    throw new CanonicalizationException("Element " + element.toXPath() + " has no attribute " + languageAttribName);
                }
                language = element.getAttribute(languageAttribName);
            }
        }
        if (language == null) {
            language = this.getAnnot(node, SCHEMA_CENTRIC_CANONICALIZATION_NAMESPACE, CASE_MAP_ATTRIB_NAME);
        }
        String caseToBeCarriedout = this.getAnnot(node, SCHEMA_CENTRIC_CANONICALIZATION_NAMESPACE, CASE_MAP_KIND_ATTRIB_NAME);
        if (language != null || caseToBeCarriedout != null) {
            ((NodeImpl)node).setAugmentation("[schema normalized value]", this.caseMap((String)((NodeImpl)node).getAugmentation("[normalized value]"), language == null ? "EN" : language, caseToBeCarriedout == null ? "upper" : caseToBeCarriedout));
        }
    }

    private String caseMap(String value, String language, String caseToBeCarriedout) throws CanonicalizationException {
        if (caseToBeCarriedout.equals("upper")) {
            return value.toUpperCase();
        }
        if (caseToBeCarriedout.equals("lower")) {
            return value.toLowerCase();
        }
        if (!caseToBeCarriedout.equals("fold")) {
            throw new CanonicalizationException("The case map kind must be one of 'upper', 'lower' or 'fold'.");
        }
        return value;
    }

    private String getURI(Node node) {
        String result = node.getNamespaceURI();
        return result == null ? "" : result;
    }

    public static void main(String[] args) throws Exception {
        CanonicalizationProcessor processor = new CanonicalizationProcessor();
        System.out.println("Ready");
    }
}

