/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.ejb.svc.kmcoll.bean;

import com.sap.caf.km.da.KMDataAccessBean;
import com.sap.caf.km.da.KMDataAccessException;
import com.sap.caf.km.ejb.data.util.ProxyHelper;
import com.sap.caf.km.ejb.svc.kmcoll.DiscussionException;
import com.sap.caf.km.ejb.svc.kmcoll.DiscussionHeader;
import com.sap.caf.km.ejb.svc.kmcoll.ICollaborationResourceKeys;
import com.sap.caf.km.ejb.svc.kmcoll.RoomHeader;
import com.sap.caf.km.ejb.svc.kmcoll.TopicHeader;
import com.sap.caf.km.proxies.svc.kmcoll.KMCollaborationSvc;
import com.sap.caf.km.proxies.svc.kmcoll.KMCollaborationSvcService;
import com.sap.caf.km.proxies.svc.kmcoll.types.DiscussionItemHeader;
import com.sap.caf.km.proxies.svc.kmcoll.types.DiscussionRoomHeader;
import com.sap.tc.logging.Location;
import java.util.Arrays;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.naming.Context;
import javax.naming.InitialContext;

public class CollaborationBean
extends KMDataAccessBean
implements ICollaborationResourceKeys {
    private transient Context m_initContext = null;
    private static final String JNDI_SERVICE_NAME = "wsclients/proxies/sap.com/caf~km.proxies/KMCollaborationJNDI";
    private transient KMCollaborationSvc m_wsColl = null;
    private transient KMCollaborationSvcService m_wsCollSvc = null;
    private transient InitialContext m_jndiContext = null;
    private static final String APPLICATION = (class$com$sap$caf$km$ejb$svc$kmcoll$bean$CollaborationBean == null ? (class$com$sap$caf$km$ejb$svc$kmcoll$bean$CollaborationBean = CollaborationBean.class$("com.sap.caf.km.ejb.svc.kmcoll.bean.CollaborationBean")) : class$com$sap$caf$km$ejb$svc$kmcoll$bean$CollaborationBean).getName();
    private static final String jARMReqPrefix = "CAF:RT:oal:";
    private static final String JARM_REQUEST = "CAF:RT:oal:" + APPLICATION;
    private static final Location location = Location.getLocation((String)APPLICATION);
    static /* synthetic */ Class class$com$sap$caf$km$ejb$svc$kmcoll$bean$CollaborationBean;
    static /* synthetic */ Class class$com$sap$caf$km$proxies$svc$kmcoll$KMCollaborationSvc;

    public void ejbRemove() {
        this.m_initContext = null;
    }

    public void ejbCreate() throws CreateException {
        String method = JARM_REQUEST + ":ejbCreate()";
        this.enter(method, null);
        if (this.m_jndiContext == null) {
            try {
                this.m_jndiContext = new InitialContext();
                this.m_wsCollSvc = (KMCollaborationSvcService)this.m_jndiContext.lookup(JNDI_SERVICE_NAME);
                this.m_wsColl = (KMCollaborationSvc)this.m_wsCollSvc.getLogicalPort(class$com$sap$caf$km$proxies$svc$kmcoll$KMCollaborationSvc == null ? (class$com$sap$caf$km$proxies$svc$kmcoll$KMCollaborationSvc = CollaborationBean.class$("com.sap.caf.km.proxies.svc.kmcoll.KMCollaborationSvc")) : class$com$sap$caf$km$proxies$svc$kmcoll$KMCollaborationSvc);
                String url = ProxyHelper.getActualUrl((String)this.m_wsColl._getProperty("javax.xml.rpc.service.endpoint.address"));
                this.m_wsColl._setProperty("javax.xml.rpc.service.endpoint.address", (Object)url);
            }
            catch (Exception e) {
                DiscussionException discussEx = new DiscussionException("CANTCREATEEJB", (Throwable)e);
                this.log((KMDataAccessException)discussEx, method, null);
                throw new CreateException(discussEx.getLocalizedMessage());
            }
            finally {
                this.exit(method, null);
            }
        }
    }

    public String createDiscussion(String documentId, String parentFolder, String displayName) throws DiscussionException {
        String method = JARM_REQUEST + ":createDiscussion(String, String, String)";
        this.enter(method, new Object[]{documentId, parentFolder, displayName});
        try {
            DiscussionItemHeader header = new DiscussionItemHeader();
            header.setId(documentId);
            header.setParentId(parentFolder);
            header.setName(displayName);
            String string = this.m_wsColl.createDiscussion(header);
            return string;
        }
        catch (Exception e) {
            DiscussionException discussEx = new DiscussionException((Throwable)e);
            this.log((KMDataAccessException)discussEx, method, null);
            throw discussEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void deleteDiscussion(String boID) throws DiscussionException {
        String method = JARM_REQUEST + ":deleteDiscussion(String)";
        this.enter(method, new Object[]{boID});
        try {
            this.m_wsColl.deleteDiscussion(boID);
        }
        catch (Exception e) {
            DiscussionException discussEx = new DiscussionException((Throwable)e);
            this.log((KMDataAccessException)discussEx, method, null);
            throw discussEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public DiscussionHeader findDiscussion(String rid) throws DiscussionException {
        String method = JARM_REQUEST + ":findDiscussion(String)";
        this.enter(method, new Object[]{rid});
        try {
            DiscussionHeader discussionHeader = this.toDiscussion(this.m_wsColl.findDiscussion(rid));
            return discussionHeader;
        }
        catch (Exception e) {
            DiscussionException discussEx = new DiscussionException((Throwable)e);
            this.log((KMDataAccessException)discussEx, method, null);
            throw discussEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public DiscussionHeader[] findByRoom(String roomId) throws DiscussionException {
        String method = JARM_REQUEST + ":findByRoom(String)";
        this.enter(method, new Object[]{roomId});
        try {
            DiscussionHeader[] result = null;
            DiscussionItemHeader[] headers = this.m_wsColl.findRoomDiscussions(roomId);
            if (headers == null || headers.length < 1) {
                DiscussionHeader[] discussionHeaderArray = null;
                return discussionHeaderArray;
            }
            result = new DiscussionHeader[headers.length];
            for (int i = 0; i < headers.length; ++i) {
                result[i] = this.toDiscussion(headers[i]);
            }
            DiscussionHeader[] discussionHeaderArray = result;
            return discussionHeaderArray;
        }
        catch (Exception e) {
            DiscussionException discussEx = new DiscussionException((Throwable)e);
            this.log((KMDataAccessException)discussEx, method, null);
            throw discussEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public String addDiscussionTopic(String discussionRid, DiscussionItemHeader header) throws DiscussionException {
        String method = JARM_REQUEST + ":addDiscussionTopic(String, DiscussionItemHeader)";
        this.enter(method, new Object[]{discussionRid, header});
        try {
            String string = this.m_wsColl.addTopic(discussionRid, header);
            return string;
        }
        catch (Exception e) {
            DiscussionException discussEx = new DiscussionException((Throwable)e);
            this.log((KMDataAccessException)discussEx, method, null);
            throw discussEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public String addChildTopic(String discussionRid, String topicRid, DiscussionItemHeader header) throws DiscussionException {
        String method = JARM_REQUEST + ":addChildTopic(String, DiscussionItemHeader)";
        this.enter(method, new Object[]{discussionRid, header});
        try {
            String string = this.m_wsColl.addTopic(discussionRid, topicRid, header);
            return string;
        }
        catch (Exception e) {
            DiscussionException discussEx = new DiscussionException((Throwable)e);
            this.log((KMDataAccessException)discussEx, method, null);
            throw discussEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void removeDiscussionTopic(String discussionRid, String topicRid) throws DiscussionException {
        String method = JARM_REQUEST + ":removeDiscussionTopic(String, String)";
        this.enter(method, new Object[]{discussionRid, topicRid});
        try {
            this.m_wsColl.removeTopic(discussionRid, topicRid);
        }
        catch (Exception e) {
            DiscussionException discussEx = new DiscussionException((Throwable)e);
            this.log((KMDataAccessException)discussEx, method, null);
            throw discussEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void removeTopic(String discussionRid, String topicRid) throws DiscussionException {
        this.removeDiscussionTopic(discussionRid, topicRid);
    }

    public String createTopic(String discussionId, String parentFolder, String name, String subject, String text) throws DiscussionException {
        String method = JARM_REQUEST + ":createTopic(String, String, String, String, String)";
        this.enter(method, new Object[]{discussionId, parentFolder, name, subject, text});
        try {
            Object result = null;
            DiscussionItemHeader header = new DiscussionItemHeader();
            header.setDiscussion(discussionId);
            header.setParentId(parentFolder);
            header.setName(name);
            header.setSubject(subject);
            header.setText(text);
            String string = this.m_wsColl.createTopic(header);
            return string;
        }
        catch (Exception e) {
            DiscussionException discussEx = new DiscussionException((Throwable)e);
            this.log((KMDataAccessException)discussEx, method, null);
            throw discussEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public TopicHeader findTopic(String rid) throws DiscussionException {
        String method = JARM_REQUEST + ":findTopic(String)";
        this.enter(method, new Object[]{rid});
        try {
            TopicHeader topicHeader = this.toTopic(this.m_wsColl.findTopic(rid));
            return topicHeader;
        }
        catch (Exception e) {
            DiscussionException discussEx = new DiscussionException((Throwable)e);
            this.log((KMDataAccessException)discussEx, method, null);
            throw discussEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public TopicHeader[] findByDiscussion(String discussionId) throws DiscussionException {
        String method = JARM_REQUEST + ":findByDiscussion(String)";
        this.enter(method, new Object[]{discussionId});
        try {
            TopicHeader[] result = null;
            DiscussionItemHeader[] header = this.m_wsColl.findDiscussionTopics(discussionId);
            if (header == null || header.length < 1) {
                TopicHeader[] topicHeaderArray = null;
                return topicHeaderArray;
            }
            result = new TopicHeader[header.length];
            for (int i = 0; i < header.length; ++i) {
                result[i] = this.toTopic(header[i]);
            }
            TopicHeader[] topicHeaderArray = result;
            return topicHeaderArray;
        }
        catch (Exception e) {
            DiscussionException discussEx = new DiscussionException((Throwable)e);
            this.log((KMDataAccessException)discussEx, method, null);
            throw discussEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public RoomHeader createDiscussionRoom(String name, String description, Collection team, String relatedRid) throws DiscussionException {
        String method = JARM_REQUEST + ":createDiscussionRoom(String, String, Collection)";
        this.enter(method, new Object[]{name, description, team});
        try {
            Object result = null;
            DiscussionRoomHeader header = new DiscussionRoomHeader();
            header.setTitle(name);
            header.setDescription(description);
            header.setRelatedRid(relatedRid);
            if (!team.isEmpty()) {
                header.setTeam(team.toArray(new String[team.size()]));
            }
            DiscussionRoomHeader new_room = this.m_wsColl.createDiscussionRoom(header);
            RoomHeader roomHeader = this.toRoom(new_room);
            return roomHeader;
        }
        catch (Exception e) {
            DiscussionException discussEx = new DiscussionException((Throwable)e);
            this.log((KMDataAccessException)discussEx, method, null);
            throw discussEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void deleteDiscussionRoom(String id) throws DiscussionException {
        String method = JARM_REQUEST + ":deleteDiscussionRoom(String)";
        this.enter(method, new Object[]{id});
        try {
            this.m_wsColl.deleteDiscussionRoom(id);
        }
        catch (Exception e) {
            DiscussionException discussEx = new DiscussionException((Throwable)e);
            this.log((KMDataAccessException)discussEx, method, null);
            throw discussEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public RoomHeader findDiscussionRoom(String id) throws DiscussionException {
        String method = JARM_REQUEST + ":findDiscussionRoom(String)";
        this.enter(method, new Object[]{id});
        try {
            DiscussionRoomHeader header = null;
            header = this.m_wsColl.findDiscussionRoom(id);
            RoomHeader roomHeader = this.toRoom(header);
            return roomHeader;
        }
        catch (Exception e) {
            DiscussionException discussEx = new DiscussionException((Throwable)e);
            this.log((KMDataAccessException)discussEx, method, null);
            throw discussEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public RoomHeader[] findByUser(String userId) throws DiscussionException {
        String method = JARM_REQUEST + ":findByUser(String)";
        this.enter(method, new Object[]{userId});
        try {
            DiscussionRoomHeader[] ws_headers = null;
            ws_headers = this.m_wsColl.findRooms();
            if (ws_headers == null || ws_headers.length < 1) {
                RoomHeader[] roomHeaderArray = null;
                return roomHeaderArray;
            }
            RoomHeader[] rooms = new RoomHeader[ws_headers.length];
            for (int i = 0; i < rooms.length; ++i) {
                rooms[i] = this.toRoom(ws_headers[i]);
            }
            RoomHeader[] roomHeaderArray = rooms;
            return roomHeaderArray;
        }
        catch (Exception e) {
            DiscussionException discussEx = new DiscussionException((Throwable)e);
            this.log((KMDataAccessException)discussEx, method, null);
            throw discussEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void assignUser(String roomId, String userId) throws DiscussionException {
        String method = JARM_REQUEST + ":assignUser(String, String)";
        this.enter(method, new Object[]{roomId, userId});
        try {
            if (roomId != null && userId != null) {
                this.m_wsColl.assignUser(roomId, userId);
            }
        }
        catch (Exception e) {
            DiscussionException discussEx = new DiscussionException((Throwable)e);
            this.log((KMDataAccessException)discussEx, method, null);
            throw discussEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void assignUsers(String roomId, Collection userIds) throws DiscussionException {
        String method = JARM_REQUEST + ":assignUser(String, Collection)";
        this.enter(method, new Object[]{roomId, userIds});
        try {
            if (roomId != null && userIds != null) {
                this.m_wsColl.assignUsers(roomId, userIds.toArray(new String[userIds.size()]));
            }
        }
        catch (Exception e) {
            DiscussionException discussEx = new DiscussionException((Throwable)e);
            this.log((KMDataAccessException)discussEx, method, null);
            throw discussEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void updateDiscussionRoom(String id, String title, String description, String relateObjectRid) throws DiscussionException {
        String method = JARM_REQUEST + ":updateDiscussionRoom(String, String, String)";
        this.enter(method, new Object[]{id, title, description});
        DiscussionRoomHeader header = new DiscussionRoomHeader();
        header.setId(id);
        header.setTitle(title);
        header.setDescription(description);
        header.setRelatedRid(relateObjectRid);
        try {
            this.m_wsColl.updateDiscussionRoom(header);
        }
        catch (Exception e) {
            DiscussionException discussEx = new DiscussionException((Throwable)e);
            this.log((KMDataAccessException)discussEx, method, null);
            throw discussEx;
        }
    }

    public RoomHeader findRoomWithTodayPosts(String id) throws DiscussionException {
        String method = JARM_REQUEST + ":findRoomWithTodayPosts(String)";
        this.enter(method, new Object[]{id});
        try {
            DiscussionRoomHeader header = null;
            header = this.m_wsColl.findRoomWithTodayPosts(id);
            return this.toRoom(header);
        }
        catch (Exception e) {
            DiscussionException discussEx = new DiscussionException((Throwable)e);
            this.log((KMDataAccessException)discussEx, method, null);
            throw discussEx;
        }
    }

    private RoomHeader toRoom(DiscussionRoomHeader header) {
        RoomHeader result = new RoomHeader();
        if (header.getCreatedAt() != null) {
            result.setCreatedAt(header.getCreatedAt().getTime());
        }
        if (header.getLastChangedAt() != null) {
            result.setLastChangedAt(header.getLastChangedAt().getTime());
        }
        result.setCreatedBy(header.getCreatedBy());
        result.setDescription(header.getDescription());
        result.setTitle(header.getTitle());
        result.setId(header.getId());
        result.setParentFolder("");
        result.setLastChangedBy(header.getLastChangedBy());
        result.setRelatedRid(header.getRelatedRid());
        if (header.getTeam() != null) {
            result.setTeam(Arrays.asList(header.getTeam()));
        }
        if (header.getDiscussions() != null) {
            result.setDiscussions(Arrays.asList(header.getDiscussions()));
        }
        result.setTodayPostsCount(header.getTodayPostsCount());
        return result;
    }

    private DiscussionHeader toDiscussion(DiscussionItemHeader header) {
        DiscussionHeader result = new DiscussionHeader();
        if (header.getCreatedAt() != null) {
            result.setCreatedAt(header.getCreatedAt().getTime());
        }
        if (header.getLastChangedAt() != null) {
            result.setLastChangedAt(header.getLastChangedAt().getTime());
        }
        result.setCreatedBy(header.getCreatedBy());
        result.setSize(header.getSize());
        String id = header.getId().substring(header.getId().lastIndexOf("/") + 1);
        String parentFolder = header.getId().substring(0, header.getId().lastIndexOf("/"));
        result.setId(id);
        result.setParentFolder(parentFolder);
        result.setLastChangedBy(header.getLastChangedBy());
        if (header.getTopics() != null) {
            result.setTopics(Arrays.asList(header.getTopics()));
        }
        return result;
    }

    private TopicHeader toTopic(DiscussionItemHeader header) {
        TopicHeader result = new TopicHeader();
        if (header.getCreatedAt() != null) {
            result.setCreatedAt(header.getCreatedAt().getTime());
        }
        if (header.getLastChangedAt() != null) {
            result.setLastChangedAt(header.getLastChangedAt().getTime());
        }
        result.setCreatedBy(header.getCreatedBy());
        result.setLastChangedBy(header.getLastChangedBy());
        result.setName(header.getName());
        String id = header.getId().substring(header.getId().lastIndexOf("/") + 1);
        String parentFolder = header.getId().substring(0, header.getId().lastIndexOf("/"));
        result.setSize(header.getSize());
        result.setId(header.getId());
        result.setParentFolder(parentFolder);
        result.setDiscussion(header.getDiscussion());
        result.setSubject(header.getSubject());
        result.setText(header.getText());
        if (header.getTopics() != null) {
            result.setTopics(Arrays.asList(header.getTopics()));
        }
        return result;
    }

    protected Location getLocation() {
        return location;
    }

    protected String getJARMRequest() {
        return JARM_REQUEST;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

